/*
 * Decompiled with CFR 0.152.
 */
import NormsTools.Sorter;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;

public class ParsedClassByteCodes {
    short cpc;
    ConstantPoolElement[] cpe;
    int clsCnt;
    String this_class;
    String super_class;
    String version;
    short access_flags;
    String[] clsNms;
    int fldCnt;
    String[] fldNms;
    int mthdCnt;
    String[] methodNms;
    int IFmthdCnt;
    String[] IFmethodNms;
    public static final int LengthRecPfx = 4;
    final String fldRecPfx = "<F> ";
    final String mthdRecPfx = "<M> ";
    final String IFmthdRecPfx = "<I> ";
    private final String SortPad = "                        ";
    private final int lenSortPad = "                        ".length() + 1;
    private final String BLANKS = "                                              ";
    private final int MinTypeWidth = 25;

    public String getPackage() {
        int n = this.this_class.lastIndexOf(47);
        if (n < 0) {
            return "";
        }
        return this.this_class.substring(0, n).replace('/', '.');
    }

    public ParsedClassByteCodes() {
        System.out.println("ParsedClassByteCodes null Constructor called");
    }

    public ParsedClassByteCodes(InputStream inputStream) throws InvalidClassFileException, Exception {
        this.parseByteCodes(inputStream);
    }

    private void stripPad(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].substring(2 * this.lenSortPad);
            ++n;
        }
    }

    public String[] getRefdInterfaceMethods() {
        if (this.IFmethodNms != null) {
            return this.IFmethodNms;
        }
        this.IFmethodNms = new String[this.IFmthdCnt];
        this.getRefdMthdOrIF(this.IFmethodNms, "<I> ", 11);
        return this.IFmethodNms;
    }

    public ParsedClassByteCodes parseByteCodes(InputStream inputStream) throws InvalidClassFileException, Exception {
        try {
            short s;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readInt();
            if (n != -889275714) {
                System.err.println("Invalid magic number " + Integer.toHexString(n));
                throw new InvalidClassFileException("Invalid magic number " + Integer.toHexString(n));
            }
            short s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            this.version = Integer.toString(s3) + "." + s2;
            this.cpc = dataInputStream.readShort();
            if (ConstantPoolElement.debug) {
                System.out.println(".  Version is " + this.version + " cPc=" + this.cpc);
            }
            this.cpe = new ConstantPoolElement[this.cpc];
            this.cpe[0] = new CONSTANT_Empty(0);
            this.clsCnt = 0;
            this.fldCnt = 0;
            this.mthdCnt = 0;
            this.IFmthdCnt = 0;
            this.clsNms = null;
            this.fldNms = null;
            this.methodNms = null;
            this.IFmethodNms = null;
            int n2 = 1;
            while (n2 < this.cpc) {
                s = dataInputStream.readByte();
                switch (s) {
                    case 1: {
                        this.cpe[n2] = new CONSTANT_UTF8(dataInputStream, s);
                        break;
                    }
                    case 3: {
                        this.cpe[n2] = new CONSTANT_Integer(dataInputStream, s);
                        break;
                    }
                    case 4: {
                        this.cpe[n2] = new CONSTANT_Float(dataInputStream, s);
                        break;
                    }
                    case 5: {
                        this.cpe[n2] = new CONSTANT_Long(dataInputStream, s);
                        this.cpe[++n2] = new CONSTANT_Empty(0);
                        break;
                    }
                    case 6: {
                        this.cpe[n2] = new CONSTANT_Double(dataInputStream, s);
                        this.cpe[++n2] = new CONSTANT_Empty(0);
                        break;
                    }
                    case 7: {
                        this.cpe[n2] = new CONSTANT_Class(dataInputStream, s);
                        ++this.clsCnt;
                        break;
                    }
                    case 8: {
                        this.cpe[n2] = new CONSTANT_String(dataInputStream, s);
                        break;
                    }
                    case 9: {
                        this.cpe[n2] = new CONSTANT_Fieldref(dataInputStream, s);
                        ++this.fldCnt;
                        break;
                    }
                    case 10: {
                        this.cpe[n2] = new CONSTANT_Methodref(dataInputStream, s);
                        ++this.mthdCnt;
                        break;
                    }
                    case 11: {
                        this.cpe[n2] = new CONSTANT_InterfaceMethodref(dataInputStream, s);
                        ++this.IFmthdCnt;
                        break;
                    }
                    case 12: {
                        this.cpe[n2] = new CONSTANT_NameAndType(dataInputStream, s);
                        break;
                    }
                    default: {
                        System.err.println(" >>>Unknown type " + s + " at " + n2 + " cpc is " + this.cpc);
                        dataInputStream.close();
                        throw new InvalidClassFileException("Unknown Constant pool type " + s);
                    }
                }
                ++n2;
            }
            this.access_flags = dataInputStream.readShort();
            n2 = dataInputStream.readShort();
            this.this_class = this.cpe[this.cpe[n2].getNameIndex()].getString();
            s = dataInputStream.readShort();
            if (s > 0) {
                this.super_class = this.cpe[this.cpe[s].getNameIndex()].getString();
            }
            if (ConstantPoolElement.debug) {
                System.out.println("Access flags: " + Integer.toHexString(this.access_flags) + "\n    this_class='" + this.cpe[this.cpe[n2].getNameIndex()].getString() + "'\n  super_class='" + this.cpe[this.cpe[s].getNameIndex()].getString() + "'");
                System.out.println(" Counts:  Total constants=" + this.cpc + ", classes=" + this.clsCnt + ", fields=" + this.fldCnt + ", methods=" + this.mthdCnt + ", interface=" + this.IFmthdCnt);
            }
            return this;
        }
        catch (Exception exception) {
            System.err.println("parseByteCodes() Got exception " + exception);
            exception.printStackTrace();
            throw exception;
        }
    }

    public String[] getRefdClasses() {
        if (this.clsNms != null) {
            return this.clsNms;
        }
        this.clsNms = new String[this.clsCnt];
        int n = 0;
        int n2 = 1;
        while (n2 < this.cpe.length) {
            if (this.cpe[n2].type == 7) {
                int n3 = this.cpe[n2].getNameIndex();
                if (ConstantPoolElement.debug) {
                    System.out.println("PCBC.getRefdClass: " + this.cpe[n3].getString());
                }
                this.clsNms[n++] = this.cpe[n3].getString();
            }
            ++n2;
        }
        Sorter.sort(this.clsNms);
        return this.clsNms;
    }

    private String getType(String string) {
        if (string == null || string.length() < 1) {
            return "";
        }
        if (string.startsWith("L")) {
            int n;
            if (string.length() < 3) {
                return string;
            }
            if (ConstantPoolElement.debug) {
                System.out.println("Starts with L>" + string + "<");
            }
            if ((n = string.indexOf(";")) == string.length() - 1) {
                int n2 = 1;
                if (string.startsWith("Ljava/lang/")) {
                    n2 = 11;
                }
                return string.substring(n2, string.length() - 1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            boolean bl = true;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.startsWith("L")) break;
                int n3 = 1;
                if (string2.startsWith("Ljava/lang/")) {
                    n3 = 11;
                }
                if (bl) {
                    bl = false;
                    stringBuffer.append(string2.substring(n3));
                } else {
                    stringBuffer.append(", ").append(string2.substring(n3));
                }
                string2 = "";
            }
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + ";" + stringTokenizer.nextToken();
            }
            if (ConstantPoolElement.debug) {
                System.out.println("Start>" + string + "< ending aT=" + string2 + "<   >" + stringBuffer.toString() + "<");
            }
            return stringBuffer.toString() + (!string2.equals("") ? ", " : "") + this.getType(string2);
        }
        if (string.startsWith("B")) {
            if (string.length() == 1) {
                return "byte";
            }
            return "byte, " + this.getType(string.substring(1));
        }
        if (string.startsWith("C")) {
            if (string.length() == 1) {
                return "char";
            }
            return "char, " + this.getType(string.substring(1));
        }
        if (string.startsWith("D")) {
            if (string.length() == 1) {
                return "double";
            }
            return "double, " + this.getType(string.substring(1));
        }
        if (string.startsWith("F")) {
            if (string.length() == 1) {
                return "float";
            }
            return "float, " + this.getType(string.substring(1));
        }
        if (string.startsWith("I")) {
            if (string.length() == 1) {
                return "int";
            }
            return "int, " + this.getType(string.substring(1));
        }
        if (string.startsWith("J")) {
            if (string.length() == 1) {
                return "long";
            }
            return "long, " + this.getType(string.substring(1));
        }
        if (string.startsWith("S")) {
            if (string.length() == 1) {
                return "short";
            }
            return "short, " + this.getType(string.substring(1));
        }
        if (string.startsWith("Z")) {
            if (string.length() == 1) {
                return "boolean";
            }
            return "boolean, " + this.getType(string.substring(1));
        }
        if (string.equals("V")) {
            return "void";
        }
        if (string.startsWith("[")) {
            return this.getType(string.substring(1)) + "[]";
        }
        return string;
    }

    public String[] getRefdFields() {
        if (this.fldNms != null) {
            return this.fldNms;
        }
        String[] stringArray = new String[this.fldCnt];
        int n = 0;
        int n2 = 1;
        while (n2 < this.cpe.length) {
            if (this.cpe[n2].type == 9) {
                int n3 = this.cpe[n2].getClassIndex();
                int n4 = this.cpe[n3].getNameIndex();
                String string = this.cpe[n4].getString();
                int n5 = this.cpe[n2].getNameAndTypeIndex();
                n4 = this.cpe[n5].getNameIndex();
                String string2 = this.cpe[n4].getString();
                n3 = this.cpe[n5].getDescriptorIndex();
                String string3 = this.cpe[n3].getString();
                String string4 = this.getType(string3);
                stringArray[n++] = (string + "                        ").substring(0, this.lenSortPad) + (string2 + "                        ").substring(0, this.lenSortPad) + "<F> " + string4 + (string4.length() >= 25 ? " " : "                                              ".substring(0, 25 - string4.length())) + string + "." + string2;
            }
            ++n2;
        }
        Sorter.sort(stringArray);
        this.stripPad(stringArray);
        return stringArray;
    }

    public String[] getRefdMethods() {
        if (this.methodNms != null) {
            return this.methodNms;
        }
        String[] stringArray = new String[this.mthdCnt];
        this.getRefdMthdOrIF(stringArray, "<M> ", 10);
        if (ConstantPoolElement.debug) {
            System.out.println("PCBC.getRefdM found " + stringArray.length + " methods");
        }
        return stringArray;
    }

    private void getRefdMthdOrIF(String[] stringArray, String string, int n) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.cpe.length) {
            if (this.cpe[n3].type == n) {
                int n4 = this.cpe[n3].getClassIndex();
                int n5 = this.cpe[n4].getNameIndex();
                String string2 = this.cpe[n5].getString();
                int n6 = this.cpe[n3].getNameAndTypeIndex();
                n5 = this.cpe[n6].getNameIndex();
                String string3 = this.cpe[n5].getString();
                n4 = this.cpe[n6].getDescriptorIndex();
                String string4 = this.cpe[n4].getString();
                if (ConstantPoolElement.debug) {
                    System.out.println("PCBC.getRefdMthdOrIF data: " + n2 + " >" + string4 + " " + string2 + "." + string3);
                }
                int n7 = string4.indexOf(")");
                String string5 = this.getType(string4.substring(n7 + 1));
                stringArray[n2++] = (string2 + "                        ").substring(0, this.lenSortPad) + (string3 + "                        ").substring(0, this.lenSortPad) + string + string5 + (string5.length() >= 25 ? " " : "                                              ".substring(0, 25 - string5.length())) + string2 + "." + string3 + "(" + (n7 > 1 ? this.getType(string4.substring(1, n7)) : "") + ")";
                if (ConstantPoolElement.debug) {
                    System.out.println("PCBC.getRefdMthdOrIF saved: " + stringArray[n2 - 1]);
                }
            }
            ++n3;
        }
        Sorter.sort(stringArray);
        this.stripPad(stringArray);
    }
}

