/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import java.util.Vector;

public class Sorter {
    public static Comparer ascii_comparer = new Comparer(){

        public int compare(Object a, Object b) {
            return ((String)a).compareTo((String)b);
        }
    };
    public static Comparer comparable_comparer = new Comparer(){

        public int compare(Object a, Object b) {
            return ((Comparable)a).compareTo(b);
        }
    };

    public static void sortAscii(String[] a, int from, int to, boolean up) {
        Sorter.sort((Object[])a, null, from, to, up, ascii_comparer);
    }

    public static void sort(Vector v) {
        String[] vs = new String[v.size()];
        v.copyInto(vs);
        Sorter.sort(vs, 0, vs.length - 1, true, false, null);
        int i = 0;
        while (i < v.size()) {
            v.setElementAt(vs[i], i);
            ++i;
        }
    }

    public static void sort(String[] a) {
        Sorter.sort(a, 0, a.length - 1, true, false, null);
    }

    public static void sort(String[] a, int from, int to, boolean up, boolean ignorecase, Locale locale) {
        if (a == null || a.length < 2) {
            return;
        }
        Collator c = locale == null ? Collator.getInstance() : Collator.getInstance(locale);
        try {
            c.setStrength(3);
        }
        catch (IllegalArgumentException iae) {
            c.setStrength(2);
        }
        if (ignorecase) {
            c.setStrength(1);
        }
        Object[] b = new CollationKey[a.length];
        int i = 0;
        while (i < a.length) {
            b[i] = c.getCollationKey(a[i]);
            ++i;
        }
        Comparer comp = new Comparer(){

            public int compare(Object a, Object b) {
                return ((CollationKey)a).compareTo((CollationKey)b);
            }
        };
        Sorter.sort(b, a, from, to, up, comp);
    }

    public static void sort(Object[] a, Object[] b, int from, int to, boolean up, Comparer c) {
        if (a == null || a.length < 2) {
            return;
        }
        int i = from;
        int j = to;
        Object center = a[(from + to) / 2];
        do {
            if (up) {
                while (i < to && c.compare(center, a[i]) > 0) {
                    ++i;
                }
                while (j > from && c.compare(center, a[j]) < 0) {
                    --j;
                }
            }
            if (i < j) {
                Object tmp = a[i];
                a[i] = a[j];
                a[j] = tmp;
                if (b != null) {
                    tmp = b[i];
                    b[i] = b[j];
                    b[j] = tmp;
                }
            }
            if (i > j) continue;
            ++i;
            --j;
        } while (i <= j);
        if (from < j) {
            Sorter.sort(a, b, from, j, up, c);
        }
        if (i < to) {
            Sorter.sort(a, b, i, to, up, c);
        }
    }

    public static interface Comparable {
        public int compareTo(Object var1);
    }

    public static interface Comparer {
        public int compare(Object var1, Object var2);
    }
}

