/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import NormsTools.EditableListAdder;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class EditableList
extends Dialog
implements ActionListener {
    private Panel p1 = new Panel();
    private Panel bPanel = new Panel();
    private Button addB = new Button("Add");
    private Button moveUpB = new Button("Move up");
    private Button moveDownB = new Button("Move down");
    Button deleteB = new Button("Remove");
    private Button doneB = new Button("Done");
    private Button cancelB = new Button("Quit");
    private GridBagConstraints gbc;
    private Image saveIcon = null;
    private Color saveColor = null;
    private EditableListAdder ELA;
    private String[] theList = null;
    List shownList;
    static final int NONE_SEL = -1;
    int selIdx = -1;
    private boolean changeMade = false;

    void setMoveButtons() {
        this.moveDownB.setEnabled(this.selIdx != this.shownList.getItemCount() - 1);
        this.moveUpB.setEnabled(this.selIdx != 0);
    }

    private void addGBC(Button button, int n, int n2, int n3, int n4) {
        this.gbc.gridx = n;
        this.gbc.gridy = n2;
        this.gbc.gridwidth = n3;
        this.gbc.gridheight = n4;
        this.bPanel.add((Component)button, this.gbc);
        button.addActionListener(this);
    }

    public EditableList(Frame frame, String string, String[] stringArray, EditableListAdder editableListAdder) {
        super(frame, string, true);
        this.ELA = editableListAdder;
        this.finishUp(string, stringArray);
    }

    public EditableList(Frame frame, String string, Vector vector, EditableListAdder editableListAdder) {
        super(frame, string, true);
        this.ELA = editableListAdder;
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.finishUp(string, (String[])objectArray);
    }

    public String[] getList() {
        return this.shownList.getItems();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addB) {
            String string = this.ELA.addToList();
            if (string == null || string.equals("")) {
                return;
            }
            if (this.selIdx != -1) {
                this.shownList.addItem(string, this.selIdx + 1);
            } else {
                this.shownList.addItem(string, 0);
            }
            this.setMoveButtons();
            this.changeMade = true;
        } else if (object == this.moveUpB) {
            if (this.selIdx > 0) {
                String string = this.shownList.getItem(this.selIdx);
                this.shownList.remove(this.selIdx);
                --this.selIdx;
                this.shownList.add(string, this.selIdx);
                this.shownList.select(this.selIdx);
                this.setMoveButtons();
                this.changeMade = true;
            }
        } else if (object == this.moveDownB) {
            if (this.selIdx != -1 && this.selIdx < this.shownList.getItemCount() - 1) {
                String string = this.shownList.getItem(this.selIdx);
                this.shownList.add(string, this.selIdx + 2);
                this.shownList.remove(this.selIdx);
                ++this.selIdx;
                this.shownList.select(this.selIdx);
                this.setMoveButtons();
                this.changeMade = true;
            }
        } else if (object == this.deleteB) {
            if (this.selIdx != -1) {
                this.shownList.remove(this.selIdx);
                this.selIdx = -1;
                this.changeMade = true;
            }
        } else if (object == this.doneB) {
            this.exitPgm();
        } else if (object == this.cancelB) {
            this.changeMade = false;
            this.exitPgm();
        } else {
            System.err.println("a..P.. Unknown source " + object);
        }
    }

    public Vector getListInVector() {
        this.theList = this.shownList.getItems();
        Vector<String> vector = new Vector<String>(this.theList.length);
        int n = 0;
        while (n < this.theList.length) {
            vector.addElement(this.theList[n]);
            ++n;
        }
        return vector;
    }

    void exitPgm() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public boolean changed() {
        return this.changeMade;
    }

    private void finishUp(String string, String[] stringArray) {
        this.setTitle(string);
        ((Component)this).setSize(600, 400);
        this.setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){
            {
                EditableList.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                EditableList.this.exitPgm();
            }
        });
        this.p1.setLayout(new BorderLayout());
        this.p1.add((Component)new Label(string), "North");
        int n = stringArray.length;
        int n2 = Math.min(10, n + 2);
        this.shownList = new List(n2, false);
        int n3 = 0;
        while (n3 < n) {
            this.shownList.add(stringArray[n3]);
            ++n3;
        }
        this.shownList.addItemListener(new ItemListener(){
            {
                EditableList.this.getClass();
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                List list = (List)itemEvent.getSource();
                if (list == EditableList.this.shownList) {
                    EditableList.this.selIdx = EditableList.this.shownList.getSelectedIndex();
                    if (EditableList.this.selIdx == -1) {
                        return;
                    }
                    if (EditableList.this.shownList.getItemCount() > 1) {
                        EditableList.this.setMoveButtons();
                    }
                    EditableList.this.deleteB.setEnabled(true);
                } else {
                    System.err.println("Unknown item event " + itemEvent);
                }
            }
        });
        this.shownList.requestFocus();
        this.p1.add((Component)this.shownList, "Center");
        this.bPanel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.bPanel.setLayout(gridBagLayout);
        this.gbc = new GridBagConstraints();
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(2, 0, 2, 0);
        int n4 = 0;
        this.addGBC(this.addB, 0, n4++, 1, 1);
        this.addGBC(this.moveUpB, 0, n4++, 1, 1);
        this.moveUpB.setEnabled(false);
        this.addGBC(this.moveDownB, 0, n4++, 1, 1);
        this.moveDownB.setEnabled(false);
        this.addGBC(this.deleteB, 0, n4++, 1, 1);
        this.deleteB.setEnabled(false);
        this.addGBC(this.doneB, 0, n4++, 1, 1);
        this.doneB.setEnabled(true);
        this.addGBC(this.cancelB, 0, n4++, 1, 1);
        this.p1.add((Component)this.bPanel, "East");
        this.add((Component)this.p1, "North");
        if (this.saveColor != null) {
            ((Component)this).setBackground(this.saveColor);
        }
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2);
        ((Component)this).setVisible(true);
    }
}

