/*
 * Decompiled with CFR 0.152.
 */
import NormsTools.Sorter;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class ClassFileFromJar
extends ClassFileSource {
    String jfn;
    Hashtable memNames;
    ZipFile zipf;

    public InputStream getClassBytes(String string) throws ClassNotFoundException {
        String string2;
        if (ConstantPoolElement.debug) {
            System.out.println("CFJ: Checking for class: " + string);
        }
        if (this.memNames.containsKey(string2 = string + (string.endsWith(".class") ? "" : ".class"))) {
            ZipEntry zipEntry = (ZipEntry)this.memNames.get(string2);
            try {
                return this.zipf.getInputStream(zipEntry);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ClassNotFoundException("Error getting InputStream " + exception.getMessage());
            }
        }
        if (ConstantPoolElement.debug) {
            System.err.println("getClassBytes() Name " + string2 + " NOT found in table");
        }
        throw new ClassNotFoundException(string2 + " not found in " + this.jfn);
    }

    public ClassFileFromJar(String string) {
        super(2);
        this.jfn = string;
        this.sourceName = string;
        try {
            ZipEntry zipEntry;
            this.zipf = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = this.zipf.entries();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                ++n;
            }
            this.memNames = new Hashtable(n);
            enumeration = this.zipf.entries();
            n = 1;
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (!zipEntry.isDirectory()) {
                    this.memNames.put(new String(zipEntry.getName()), zipEntry);
                    if (!ConstantPoolElement.debug) continue;
                    System.out.println("Added (fm jar): " + n++ + " " + zipEntry.getName());
                    continue;
                }
                if (!ConstantPoolElement.debug) continue;
                System.out.println("JAR has directory: " + zipEntry.getName());
            }
        }
        catch (ZipException zipException) {
            System.err.println("Error reading jar file: " + string + " " + zipException);
        }
        catch (Exception exception) {
            System.err.println("Zipfile error for " + string);
            exception.printStackTrace();
        }
    }

    public void finalize() {
        if (this.zipf != null) {
            try {
                this.zipf.close();
            }
            catch (Exception exception) {}
        }
    }

    public String[] getFileNames() {
        String[] stringArray = new String[this.memNames.size()];
        Enumeration enumeration = this.memNames.keys();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        Sorter.sort(stringArray);
        return stringArray;
    }
}

