/*
 * Decompiled with CFR 0.152.
 */
import NormsTools.BigTextArea;
import NormsTools.BigTextAreaListener;
import NormsTools.DocumentViewer.ShowDocument;
import NormsTools.EditableList;
import NormsTools.EditableListAdder;
import NormsTools.ErrDialog;
import NormsTools.GetInput;
import NormsTools.MSDosFilename;
import NormsTools.SaveStdOutput;
import NormsTools.ShowListBox;
import NormsTools.ShowMsgBox;
import NormsTools.ShowOptions;
import NormsTools.Sorter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CheckClassRefs
extends Frame
implements ActionListener,
ItemListener,
BigTextAreaListener,
EditableListAdder,
Runnable {
    final String welcome = "Norm's Classes referenced checker  version 1.5  28 Nov 2001";
    final String CmtChar = "#";
    public static final String PkgNmSeparatorS = "/";
    public static final char PkgNmSeparatorC = '/';
    private final String ConsLogFile = "CheckClassRefs.log";
    private final String ourJarNm = "CheckClassRefs.jar";
    private final String helpFN = "CheckClassRefs.html";
    private final String PropFN = "CheckClassRefs.ini";
    Properties ourProps = new Properties();
    String propsDir = "";
    String propsFn = "";
    private boolean foundProps = false;
    private boolean changedProps = false;
    private final String JarsListPNM = "JarsList";
    private String jarsListV = "";
    private final String ClassNamePNM = "ClassName";
    private String classNameV = "";
    private final String JarFilePNM = "JarFile";
    private String jarFileV = "";
    private final String ClassPathNM = "ClassPath";
    private String classPathV = "";
    private final Color BGColor = new Color(130, 230, 50);
    Panel p3 = new Panel();
    private BigTextArea theLog = new BigTextArea(22, 70, 30000);
    private TextField clsNameTF = new TextField(50);
    private TextField jarFNTF = new TextField(50);
    MenuBar mb = new MenuBar();
    Menu fileM = new Menu("File");
    MenuShortcut saveListSC = new MenuShortcut(83);
    MenuItem saveListMI = new MenuItem("Save List...", this.saveListSC);
    MenuItem saveLogMI = new MenuItem("Save log...");
    MenuItem openPropsMI = new MenuItem("Open props file...");
    MenuItem printMI = new MenuItem("Print log...");
    MenuItem closeMI = new MenuItem("Close");
    Menu editM = new Menu("Edit");
    MenuShortcut findSC = new MenuShortcut(70);
    MenuItem findMI = new MenuItem("Find...", this.findSC);
    MenuShortcut findNxtSC = new MenuShortcut(78);
    MenuItem findNextMI = new MenuItem("Find next", this.findNxtSC);
    MenuItem sortListMI = new MenuItem("Sort list");
    MenuItem listUnrefdMI = new MenuItem("List Unreferenced classes");
    Menu optionsM = new Menu("Options");
    CheckboxMenuItem uniqueMI = new CheckboxMenuItem("Show Unique names only");
    CheckboxMenuItem doJavaMI = new CheckboxMenuItem("Show java(x) classes");
    CheckboxMenuItem doAllMI = new CheckboxMenuItem("Show all classes");
    CheckboxMenuItem showSrcMI = new CheckboxMenuItem("Show source");
    MenuItem getIndentMI = new MenuItem("Set indent...");
    MenuItem addToJarListMI = new MenuItem("Add extra jar...");
    MenuItem setClassPathMI = new MenuItem("Set classpath...");
    CheckboxMenuItem debugCB = new CheckboxMenuItem("debug", true);
    MenuItem showRefdMI = new MenuItem("Show referenced F|M|I...");
    Checkbox showRefdFldsCB = new Checkbox("Show referenced fields");
    Checkbox showRefdMthdsCB = new Checkbox("Show referenced methods");
    Checkbox showRefdIFMsCB = new Checkbox("Show referenced Interfaces");
    Checkbox showInnerClsCB = new Checkbox("Show inner clasess");
    private Checkbox[] showOptsCBs = new Checkbox[]{this.showRefdFldsCB, this.showRefdMthdsCB, this.showRefdIFMsCB, this.showInnerClsCB};
    Menu helpM = new Menu("Help");
    MenuItem aboutMI = new MenuItem("About Class checker");
    MenuItem helpMI = new MenuItem("Help Topics");
    Panel topPnl = new Panel();
    Panel btnPnl = new Panel();
    Button chooseCN = new Button("Choose");
    Button chooseJFN = new Button("Choose");
    final String doSearchLbl = " Search ";
    final String stopSearchLbl = "Stop Search";
    Button searchB = new Button(" Search ");
    Button clearB = new Button("Clear log");
    CheckboxGroup cbg = new CheckboxGroup();
    Checkbox useClassPathCB = new Checkbox("Classpath", true, this.cbg);
    Checkbox useJarCB = new Checkbox("Fm jar", false, this.cbg);
    Checkbox useClassFileCB = new Checkbox("Class File", false, this.cbg);
    Panel p3R = new Panel();
    Button goUpB = new Button("Up");
    Button goDownB = new Button("Down");
    ClassFileSource cfs;
    String clsName = "";
    Properties sysProps = System.getProperties();
    private String jarFN = "";
    private String[] jarsList = new String[0];
    private ClassFileSource[] jarCFS = null;
    static boolean doAll = false;
    static boolean doJava = false;
    static boolean uniqueOnly = false;
    static boolean stopSearch = false;
    static boolean showRefd = false;
    static boolean showSource = false;
    static boolean missingClass = false;
    static int nbrMissingCls = 0;
    private static Vector ckdClsNms;
    private Hashtable clsNmSource;
    private static final String PCBC_SFX = "<pcbc>";
    private String findWhat = "";
    private int findWhere = -1;
    static int nestLvl;
    static String blanks;
    static int indent;
    static int svIndent;
    static final String notFndMsg = "   >>>> class NOT found! <<<<";

    private void printLog() {
        System.out.println("Print NOT working on JDK1.2!  Works with jdk1.1.8?");
        Properties properties = new Properties();
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this, "Check Class References log", properties);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                graphics.setFont(new Font("Serif", 0, 12));
                graphics.setColor(Color.black);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = 15;
                int n2 = 20;
                int n3 = 1;
                int n4 = printJob.getPageDimension().height;
                int n5 = printJob.getPageDimension().width;
                int n6 = fontMetrics.getHeight();
                int n7 = 0;
                String string = this.theLog.getText();
                int n8 = 0;
                while (n8 < string.length()) {
                    String string2;
                    int n9;
                    if (graphics == null) {
                        graphics = printJob.getGraphics();
                        graphics.setFont(new Font("Monospaced", 0, 10));
                        graphics.setColor(Color.black);
                    }
                    if ((n9 = string.indexOf("\n", n8)) < 0) {
                        string2 = string.substring(n8);
                        n8 = string.length() + 10;
                    } else {
                        string2 = string.substring(n8, n9);
                        n8 = n9 + 1;
                    }
                    graphics.drawString(string2, n, n2 + fontMetrics.getAscent());
                    if ((n2 += n6) + 4 * n6 <= n4 && ++n7 <= 59) continue;
                    graphics.drawString("Page " + n3, (n5 - 8) / 2, n2 + n6);
                    ++n3;
                    if (ConstantPoolElement.debug) {
                        System.out.println("Starting new page: " + n3 + " lnNbr: " + n7 + " y=" + n2 + " maxLn=" + n4);
                    }
                    if (n3 > 2) break;
                    n2 = 20;
                    n7 = 0;
                    graphics.dispose();
                    graphics = null;
                }
                if (graphics != null) {
                    graphics.dispose();
                }
            } else {
                System.err.println("printLog(): null graphics");
            }
            printJob.end();
        } else {
            System.err.println("printLog(): null PrintJob");
        }
    }

    public void addedSection(int n) {
        if (n == 0) {
            this.p3R.removeAll();
            this.p3R.add(this.goUpB);
            this.p3R.add(this.goDownB);
            this.goUpB.invalidate();
            this.goDownB.invalidate();
            this.goUpB.getParent().validate();
        }
    }

    /*
     * Unable to fully structure code
     */
    public String[] getRefdClassNames(String var1_1) throws ClassNotFoundException, InvalidClassFileException, Exception {
        block12: {
            if (ConstantPoolElement.debug) {
                System.out.println("getRefdCN: Searching for InputStream for class:" + var1_1);
            }
            var2_2 = null;
            try {
                var2_2 = this.cfs.getClassBytes(var1_1);
                this.clsNmSource.put(var1_1, this.cfs.getSource());
                if (ConstantPoolElement.debug) {
                    System.out.println("getRefdCN: Saved " + var1_1 + " with src=" + this.cfs.getSource());
                }
                break block12;
            }
            catch (ClassNotFoundException var3_3) {
                if (this.jarsList.length < 1) {
                    throw var3_3;
                }
                var4_6 = true;
                var5_7 = 0;
                ** while (var5_7 < this.jarsList.length)
            }
lbl-1000:
            // 1 sources

            {
                if (this.jarCFS[var5_7] == null) {
                    this.jarCFS[var5_7] = new ClassFileFromJar(this.jarsList[var5_7]);
                }
                try {
                    var2_2 = this.jarCFS[var5_7].getClassBytes(var1_1);
                    this.clsNmSource.put(var1_1, this.jarCFS[var5_7].getSource());
                    var4_6 = false;
                    break;
                }
                catch (Exception v0) {
                    ++var5_7;
                }
                continue;
            }
lbl28:
            // 2 sources

            if (var4_6) {
                throw var3_3;
            }
        }
        try {
            var3_4 = new ParsedClassByteCodes(var2_2);
            var2_2.close();
            this.clsNmSource.put(var1_1 + "<pcbc>", var3_4);
            return var3_4.getRefdClasses();
        }
        catch (Exception var3_5) {
            System.err.println("getRefdClassNames() ex " + var3_5);
            var2_2.close();
            throw var3_5;
        }
    }

    public static void usage() {
        System.out.println("Usage: java -cp CheckClassRefs.jar;. CheckClassRefs [classname] [-java/] [-debug] [-doAll] [-prop propFN] [-jar jarFN] [-SecSize nnnn]");
        try {
            System.in.read();
        }
        catch (Exception exception) {}
        System.exit(1);
    }

    void appendLog(String string) {
        this.theLog.append(string);
    }

    void exitProgram() {
        this.saveProps();
        SaveStdOutput.stop();
        this.dispose();
        System.exit(0);
    }

    public CheckClassRefs(String[] stringArray) {
        try {
            int n = 0;
            while (n < stringArray.length) {
                int n2;
                if (stringArray[n].equalsIgnoreCase("-doAll")) {
                    doAll = true;
                } else if (stringArray[n].equalsIgnoreCase("-java/")) {
                    doJava = true;
                } else if (stringArray[n].equalsIgnoreCase("-debug")) {
                    ConstantPoolElement.debug = true;
                } else if (stringArray[n].equalsIgnoreCase("-unique")) {
                    uniqueOnly = true;
                    indent = 0;
                } else if (stringArray[n].equalsIgnoreCase("-props")) {
                    if (stringArray.length < n + 1 && stringArray[n + 1].startsWith("-")) {
                        CheckClassRefs.usage();
                    }
                    this.propsFn = stringArray[++n];
                } else if (stringArray[n].equalsIgnoreCase("-jar")) {
                    if (stringArray.length < n + 1 && stringArray[n + 1].startsWith("-")) {
                        CheckClassRefs.usage();
                    }
                    this.jarFN = stringArray[++n];
                    if (this.jarFN.indexOf(126) > 0) {
                        n2 = this.jarFN.lastIndexOf(File.separator);
                        this.jarFN = n2 < 0 ? this.jarFN : this.jarFN.substring(n2 + 1);
                        this.jarFN = MSDosFilename.getExtendedName(this.jarFN);
                        System.out.println("Change jarFN " + stringArray[n] + " to " + this.jarFN);
                    }
                } else if (stringArray[n].equalsIgnoreCase("-SecSize")) {
                    if (stringArray.length < n + 1 && stringArray[n + 1].startsWith("-")) {
                        CheckClassRefs.usage();
                    }
                    n2 = Integer.parseInt(stringArray[++n]);
                    this.theLog.setMaxSectionSize(n2);
                } else if (stringArray[n].startsWith("-")) {
                    CheckClassRefs.usage();
                } else {
                    this.clsName = stringArray[n];
                    if (this.clsName.indexOf(126) > 0) {
                        n2 = this.clsName.lastIndexOf(File.separator);
                        this.clsName = n2 < 0 ? this.clsName : this.clsName.substring(n2 + 1);
                        this.clsName = MSDosFilename.getExtendedName(this.clsName);
                    }
                }
                ++n;
            }
            if (this.propsFn.equals("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.sysProps.getProperty("java.class.path"), ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (!string.endsWith("CheckClassRefs.jar")) continue;
                    this.propsDir = string.substring(0, string.length() - "CheckClassRefs.jar".length());
                    break;
                }
                if (this.propsDir.equals("")) {
                    this.propsDir = this.sysProps.getProperty("user.dir");
                }
                this.propsFn = this.propsDir + File.separator + "CheckClassRefs.ini";
            }
            this.openProps(false);
            if (this.clsName.equals("")) {
                if (this.jarFN.equals("")) {
                    this.jarFN = this.jarFileV;
                    if (this.clsName.equals("")) {
                        this.clsName = this.classNameV;
                    }
                }
                ((TextComponent)this.jarFNTF).setText(this.jarFN);
                this.useJarCB.setState(!this.jarFN.equals(""));
            }
            this.setTitle("Norm's Classes referenced checker  version 1.5  28 Nov 2001");
            this.fileM.add(this.openPropsMI);
            this.openPropsMI.addActionListener(this);
            this.fileM.addSeparator();
            this.fileM.add(this.saveListMI);
            this.saveListMI.addActionListener(this);
            this.saveListMI.setEnabled(false);
            this.fileM.add(this.saveLogMI);
            this.saveLogMI.addActionListener(this);
            this.fileM.add(this.printMI);
            this.printMI.setEnabled(false);
            this.printMI.addActionListener(this);
            this.fileM.addSeparator();
            this.fileM.add(this.closeMI);
            this.closeMI.addActionListener(this);
            this.mb.add(this.fileM);
            this.editM.add(this.findMI);
            this.findMI.addActionListener(this);
            this.findMI.setEnabled(false);
            this.editM.add(this.findNextMI);
            this.findNextMI.addActionListener(this);
            this.findNextMI.setEnabled(false);
            this.editM.addSeparator();
            this.editM.add(this.sortListMI);
            this.sortListMI.addActionListener(this);
            this.sortListMI.setEnabled(false);
            this.editM.add(this.listUnrefdMI);
            this.listUnrefdMI.setEnabled(false);
            this.listUnrefdMI.addActionListener(this);
            this.mb.add(this.editM);
            this.optionsM.add(this.uniqueMI);
            this.uniqueMI.addItemListener(this);
            this.optionsM.add(this.doJavaMI);
            this.doJavaMI.addItemListener(this);
            this.optionsM.add(this.doAllMI);
            this.doAllMI.addItemListener(this);
            this.showRefdFldsCB.addItemListener(this);
            this.optionsM.add(this.showRefdMI);
            this.showRefdMI.addActionListener(this);
            this.optionsM.addSeparator();
            this.optionsM.add(this.showSrcMI);
            this.showSrcMI.addItemListener(this);
            this.optionsM.addSeparator();
            this.optionsM.add(this.getIndentMI);
            this.getIndentMI.addActionListener(this);
            this.optionsM.addSeparator();
            this.optionsM.add(this.addToJarListMI);
            this.addToJarListMI.addActionListener(this);
            this.optionsM.add(this.setClassPathMI);
            this.setClassPathMI.setEnabled(this.useClassFileCB.getState());
            this.setClassPathMI.addActionListener(this);
            if (ConstantPoolElement.debug) {
                this.optionsM.addSeparator();
                this.optionsM.add(this.debugCB);
                this.debugCB.addItemListener(this);
                SaveStdOutput.start("CheckClassRefs.log");
                System.out.println("**** Console log being written to " + "CheckClassRefs.log" + " ****");
            }
            this.mb.add(this.optionsM);
            this.helpM.add(this.aboutMI);
            this.aboutMI.addActionListener(this);
            this.helpM.add(this.helpMI);
            this.helpMI.addActionListener(this);
            this.mb.add(this.helpM);
            this.setMenuBar(this.mb);
            this.setLayout(new BorderLayout());
            this.topPnl.setLayout(new BorderLayout());
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0));
            panel.add(new Label("Class name:"));
            panel.add(this.clsNameTF);
            this.clsNameTF.addActionListener(this);
            ((TextComponent)this.clsNameTF).setText(this.clsName);
            this.chooseCN.addActionListener(this);
            panel.add(this.chooseCN);
            this.topPnl.add((Component)panel, "North");
            Panel panel2 = new Panel();
            panel2.setLayout(new FlowLayout(0));
            panel2.add(new Label("Jar filename:"));
            panel2.add(this.jarFNTF);
            this.chooseJFN.addActionListener(this);
            this.chooseJFN.setEnabled(!this.jarFN.equals(""));
            panel2.add(this.chooseJFN);
            this.topPnl.add((Component)panel2, "Center");
            GridLayout gridLayout = new GridLayout(1, 2);
            this.p3.setLayout(gridLayout);
            Panel panel3 = new Panel();
            panel3.setLayout(gridLayout);
            panel3.add(this.useClassPathCB);
            this.useClassPathCB.addItemListener(this);
            panel3.add(this.useJarCB);
            this.useJarCB.addItemListener(this);
            panel3.add(this.useClassFileCB);
            this.useClassFileCB.addItemListener(this);
            this.p3.add(panel3);
            Panel panel4 = new Panel();
            panel4.add(this.searchB);
            this.searchB.addActionListener(this);
            this.enableSearchB();
            panel4.add(this.clearB);
            this.clearB.addActionListener(this);
            this.p3.add(panel4);
            this.p3R.setLayout(gridLayout);
            this.p3R.add(new Label("             "));
            this.p3.add(this.p3R);
            this.topPnl.add((Component)this.p3, "South");
            this.add((Component)this.topPnl, "North");
            this.theLog.setFont(new Font("Monospaced", 0, 12));
            this.theLog.addBigTextAreaListener(this);
            this.theLog.setButtons(this.goUpB, this.goDownB, true);
            this.add((Component)this.theLog, "Center");
            this.addWindowListener(new WindowAdapter(){
                {
                    CheckClassRefs.this.getClass();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    CheckClassRefs.this.exitProgram();
                }
            });
            ((Component)this).setBackground(this.BGColor);
            ((Component)this).setSize(600, 500);
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2);
            this.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception2) {}
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.setClassPathMI.setEnabled(this.useClassFileCB.getState());
        if (object == this.useClassPathCB) {
            this.chooseJFN.setEnabled(this.useJarCB.getState());
        } else if (object == this.useJarCB) {
            this.chooseJFN.setEnabled(this.useJarCB.getState());
            this.chooseCN.setEnabled(!this.jarFNTF.getText().trim().equals(""));
        } else if (object == this.useClassFileCB) {
            this.setClassPathMI.setEnabled(this.useClassFileCB.getState());
            if (this.useClassFileCB.getState() && this.classPathV.equals("")) {
                new ShowMsgBox((Frame)this, "Need to set classpath value.\n Use Options|Set classpath...");
                return;
            }
        } else if (object == this.doJavaMI) {
            doJava = this.doJavaMI.getState();
        } else if (object == this.uniqueMI) {
            uniqueOnly = this.uniqueMI.getState();
            if (uniqueOnly) {
                svIndent = indent;
                indent = 0;
                this.sortListMI.setEnabled(true);
            } else {
                indent = svIndent;
                this.sortListMI.setEnabled(false);
            }
        } else if (object == this.doAllMI) {
            doAll = this.doAllMI.getState();
        } else if (object == this.showSrcMI) {
            showSource = this.showSrcMI.getState();
        } else if (object == this.debugCB) {
            ConstantPoolElement.debug = this.debugCB.getState();
            if (ConstantPoolElement.debug) {
                try {
                    System.out.println("Starting write of console to log file.");
                    SaveStdOutput.start("CheckClassRefs.log");
                }
                catch (Exception exception) {}
            } else {
                System.out.println("*** Writing of log stopped ***");
                SaveStdOutput.stop();
            }
        } else if (object == this.showRefdFldsCB || object == this.showRefdMthdsCB || object == this.showRefdIFMsCB || object == this.showInnerClsCB) {
            showRefd = this.showRefdFldsCB.getState() || this.showRefdMthdsCB.getState() || this.showRefdIFMsCB.getState();
        } else {
            System.err.println("i..S..C.. unknown source" + object);
        }
    }

    void appendLogNL(String string) {
        this.theLog.append(string + "\n");
    }

    private void enableSearchB() {
        this.searchB.setEnabled(!this.clsNameTF.getText().trim().equals(""));
    }

    String getClsNmSource(String string) {
        if (this.clsNmSource.containsKey(string)) {
            return (String)this.clsNmSource.get(string);
        }
        System.out.println("getClsNmSource() didn't find " + string);
        return "<NO SOURCE in table>";
    }

    public static void main(String[] stringArray) {
        new CheckClassRefs(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clsNameTF) {
            this.enableSearchB();
        } else if (object == this.searchB) {
            Object object2;
            if (this.searchB.getLabel().equals("Stop Search")) {
                stopSearch = true;
                return;
            }
            if (this.clsNameTF.getText().trim().equals("")) {
                new ErrDialog((Frame)this, "Missing class name.  Choose a class filename.");
                this.clsNameTF.requestFocus();
                return;
            }
            this.clsName = this.clsNameTF.getText().trim();
            if (this.clsName.endsWith(".class")) {
                this.clsName = this.clsName.substring(0, this.clsName.length() - 6);
            }
            if (this.useClassPathCB.getState()) {
                this.setFromClassPath(this.clsName);
            } else if (this.useJarCB.getState()) {
                object2 = this.jarFNTF.getText().trim();
                if (((String)object2).equals("")) {
                    new ErrDialog((Frame)this, "Missing jar filename.  Choose a jar to search.");
                    this.jarFNTF.requestFocus();
                    return;
                }
                this.jarFN = object2;
                this.setFromJar(this.jarFN, this.clsName);
            } else if (this.useClassFileCB.getState()) {
                if (this.classPathV.equals("")) {
                    new ShowMsgBox((Frame)this, "Need to set classpath. See Options|Set classpath");
                    return;
                }
                this.cfs = new ClassFileFromClassFile(this.classPathV);
            } else {
                System.err.println("No input source checkbox selected?");
                return;
            }
            object2 = new Thread(this);
            ((Thread)object2).start();
        } else if (object == this.chooseCN) {
            String string = null;
            if (this.useClassPathCB.getState() || this.useClassFileCB.getState()) {
                FileDialog fileDialog = new FileDialog((Frame)this, "Choose starting class file", 0);
                FilenameFilter filenameFilter = new FilenameFilter(){
                    {
                        CheckClassRefs.this.getClass();
                    }

                    public boolean accept(File file, String string) {
                        System.out.println("accept called with " + string);
                        return string.endsWith(".class");
                    }
                };
                fileDialog.setFile("*.class");
                fileDialog.setFilenameFilter(filenameFilter);
                fileDialog.show();
                fileDialog.dispose();
                string = fileDialog.getFile();
                if (string == null || string.equals("")) {
                    return;
                }
            } else if (this.useJarCB.getState()) {
                String string2 = this.jarFNTF.getText().trim();
                if (string2.equals("")) {
                    new ErrDialog((Frame)this, "Missing jar filename.  Choose a jar file to search first.");
                    this.jarFNTF.requestFocus();
                    return;
                }
                this.jarFN = string2;
                this.cfs = new ClassFileFromJar(this.jarFN);
                String[] stringArray = this.cfs.getFileNames();
                ShowListBox showListBox = new ShowListBox("Choose starting class", stringArray, Math.min(20, stringArray.length), (Frame)this);
                string = showListBox.getSelection();
            }
            if (!string.equals("")) {
                ((TextComponent)this.clsNameTF).setText(string);
                this.searchB.setEnabled(true);
            }
        } else if (object == this.chooseJFN) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Choose a jar file to search", 0);
            fileDialog.setFile("*.jar");
            fileDialog.show();
            fileDialog.dispose();
            String string = fileDialog.getFile();
            if (string == null) {
                return;
            }
            if (!string.equals("")) {
                this.jarFN = string;
                ((TextComponent)this.jarFNTF).setText(fileDialog.getDirectory() + string);
                this.enableSearchB();
                this.chooseCN.setEnabled(true);
            }
        } else if (object == this.findMI) {
            GetInput getInput = new GetInput("Find what:", (Frame)this, "Find");
            this.findWhat = getInput.getResponse();
            if (this.findWhat.equals("")) {
                return;
            }
            String string = this.theLog.getText();
            this.findWhere = string.indexOf(this.findWhat);
            if (this.findWhere > 0) {
                this.theLog.select(this.findWhere, this.findWhere + this.findWhat.length());
                this.findNextMI.setEnabled(true);
            } else {
                new ErrDialog((Frame)this, "The string '" + this.findWhat + "' was not found.");
                this.findNextMI.setEnabled(false);
            }
        } else if (object == this.findNextMI) {
            String string = this.theLog.getText();
            this.findWhere = string.indexOf(this.findWhat, this.findWhere + this.findWhat.length());
            if (this.findWhere > 0) {
                this.theLog.select(this.findWhere, this.findWhere + this.findWhat.length());
            } else {
                new ErrDialog((Frame)this, "The string '" + this.findWhat + "' was not found.");
                this.findNextMI.setEnabled(false);
            }
        } else if (object == this.clearB) {
            this.theLog.setText("");
            this.p3R.removeAll();
            this.p3R.invalidate();
            this.p3R.getParent().validate();
            this.findMI.setEnabled(false);
            this.findNextMI.setEnabled(false);
        } else if (object == this.getIndentMI) {
            GetInput getInput = new GetInput((Frame)this, "Enter number of spaces to indent");
            String string = getInput.getResponse();
            if (!string.equals("")) {
                try {
                    indent = new Integer(string);
                }
                catch (Exception exception) {
                    System.err.println("Invalid number of spaces: " + string);
                }
            }
        } else if (object == this.addToJarListMI) {
            EditableList editableList = new EditableList((Frame)this, "Jar search list", this.jarsList, (EditableListAdder)this);
            if (editableList.changed()) {
                this.jarsList = editableList.getList();
                this.jarCFS = new ClassFileSource[this.jarsList.length];
                this.changedProps = true;
            }
        } else if (object == this.setClassPathMI) {
            GetInput getInput = new GetInput((Frame)this, "Enter classpath(s) to use.", 70, false);
            getInput.setField(this.classPathV);
            getInput.showIt();
            String string = getInput.getResponse();
            if (string.equals("")) {
                return;
            }
            this.classPathV = string.endsWith(File.separator) ? string : string + File.separator;
        } else if (object == this.closeMI) {
            this.exitProgram();
        } else if (object == this.openPropsMI) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Choose new Properties file", 0);
            File file = new File(this.propsFn);
            fileDialog.setDirectory(file.getParent());
            fileDialog.setFile(file.getName());
            fileDialog.show();
            fileDialog.dispose();
            String string = fileDialog.getFile();
            if (string == null || string.equals("")) {
                return;
            }
            this.saveProps();
            this.propsFn = fileDialog.getDirectory() + string;
            this.openProps(true);
        } else if (object == this.saveListMI) {
            if (ckdClsNms != null & ckdClsNms.size() < 1) {
                return;
            }
            FileDialog fileDialog = new FileDialog((Frame)this, "Save " + this.clsName + "'s referenced class names in file", 1);
            fileDialog.setFile(this.clsName);
            fileDialog.show();
            fileDialog.dispose();
            String string = fileDialog.getFile();
            if (string == null || string.equals("")) {
                return;
            }
            string = fileDialog.getDirectory() + fileDialog.getFile();
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
                int n = 0;
                while (n < ckdClsNms.size()) {
                    printWriter.println((String)ckdClsNms.elementAt(n));
                    ++n;
                }
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Error writing List " + exception);
            }
        } else if (object == this.saveLogMI) {
            String string = this.theLog.getText();
            if (string.length() < 1) {
                return;
            }
            System.out.println("Log has " + string.length() + " bytes.");
            FileDialog fileDialog = new FileDialog((Frame)this, "Save log in a disk file", 1);
            fileDialog.setFile(this.clsName);
            fileDialog.show();
            fileDialog.dispose();
            String string3 = fileDialog.getFile();
            if (string3 == null || string3.equals("")) {
                return;
            }
            string3 = fileDialog.getDirectory() + fileDialog.getFile();
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(string3));
                printWriter.println(string);
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Error writing List " + exception);
            }
        } else if (object == this.printMI) {
            this.printMI.setEnabled(false);
            this.printLog();
            this.printMI.setEnabled(true);
        } else if (object == this.sortListMI) {
            if (ckdClsNms != null & ckdClsNms.size() < 1) {
                return;
            }
            Sorter.sort(ckdClsNms);
            this.appendLogNL("\n" + "#" + "Sorted list:");
            int n = 0;
            while (n < ckdClsNms.size()) {
                this.appendLogNL((String)ckdClsNms.elementAt(n));
                ++n;
            }
            this.appendLogNL("");
        } else if (object == this.listUnrefdMI) {
            String[] stringArray = this.cfs.getFileNames();
            if (stringArray == null || this.clsNmSource == null) {
                return;
            }
            int n = 0;
            boolean bl = true;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string;
                String string4 = string = stringArray[n2].endsWith(".class") ? stringArray[n2].substring(0, stringArray[n2].length() - 6) : stringArray[n2];
                if (!this.clsNmSource.containsKey(string)) {
                    if (bl) {
                        bl = false;
                        this.appendLogNL("#" + " Following entries not referenced:" + "\n");
                    }
                    ++n;
                    this.appendLogNL(">> " + stringArray[n2]);
                }
                ++n2;
            }
            if (n > 0) {
                this.appendLogNL("\n" + "#" + "  " + n + " unreferenced files found in " + this.cfs.getSource() + "\n");
            }
        } else if (object == this.showRefdMI) {
            new ShowOptions((Frame)this, this.showOptsCBs, "Show referenced Fields, Methods and Interface Options");
            showRefd = this.showRefdFldsCB.getState() || this.showRefdMthdsCB.getState() || this.showRefdIFMsCB.getState();
        } else if (object == this.aboutMI) {
            new ShowMsgBox("About Class reference checker", "Norm's Classes referenced checker  version 1.5  28 Nov 2001" + "\n" + "  written by Norm Radder\n" + " Email:  radder@hotmail.com", this, true);
        } else if (object == this.helpMI) {
            try {
                new ShowDocument("CheckClassRefs.html");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                new ShowMsgBox("Error message", "Error getting help file: " + "CheckClassRefs.html" + "\n" + exception.getMessage(), this, true);
            }
        } else {
            System.err.println("a..P.. unknown source: " + object);
        }
    }

    private void reportRefs(String string, String string2) {
        ParsedClassByteCodes parsedClassByteCodes = (ParsedClassByteCodes)this.clsNmSource.get(string + PCBC_SFX);
        if (parsedClassByteCodes == null) {
            System.err.println("PCBC reference missing for " + string);
        } else {
            String[] stringArray;
            if (this.showRefdFldsCB.getState() && (stringArray = parsedClassByteCodes.getRefdFields()) != null && stringArray.length > 0) {
                this.appendLogMulti(string2, stringArray);
            }
            if (this.showRefdMthdsCB.getState() && (stringArray = parsedClassByteCodes.getRefdMethods()) != null && stringArray.length > 0) {
                this.appendLogMulti(string2, stringArray);
            }
            if (this.showRefdIFMsCB.getState() && (stringArray = parsedClassByteCodes.getRefdInterfaceMethods()) != null && stringArray.length > 0) {
                this.appendLogMulti(string2, stringArray);
            }
        }
    }

    static {
        nestLvl = 0;
        blanks = "                                                                                                                            ";
        indent = 3;
        svIndent = 0;
    }

    private void setFromClassPath(String string) {
        this.appendLogNL("#" + "Searching the classpath for " + string);
        this.appendLogNL("#" + "user.dir is:     " + this.sysProps.getProperty("user.dir"));
        this.appendLogNL("#" + "Using classpath: " + this.sysProps.getProperty("java.class.path") + "\n");
        this.cfs = new ClassFileFromClassPath();
    }

    static void showRefClasses(CheckClassRefs checkClassRefs, String string) {
        if (stopSearch) {
            return;
        }
        if (uniqueOnly && CheckClassRefs.haveCkd(string, false)) {
            return;
        }
        String string2 = blanks.substring(0, nestLvl * indent < blanks.length() ? nestLvl * indent : blanks.length() - 1);
        checkClassRefs.appendLog(string2 + string);
        if (CheckClassRefs.haveCkd(string, true)) {
            checkClassRefs.appendLogNL("");
            return;
        }
        if (string.equals("java/lang/Object") || string.equals("[Ljava/lang/Object;") || string.startsWith("[")) {
            checkClassRefs.appendLogNL("");
            if (string.startsWith("[")) {
                System.out.println("showRefdClasses() - Skipping '" + string + "' from: " + checkClassRefs.getClsNmSource(string));
            }
            return;
        }
        if ((string.startsWith("java/") || string.startsWith("javax/")) && !doAll) {
            checkClassRefs.appendLogNL("");
            return;
        }
        ++nestLvl;
        try {
            String[] stringArray = checkClassRefs.getRefdClassNames(string);
            checkClassRefs.appendLogNL(showSource ? "  <" + checkClassRefs.getClsNmSource(string) + ">" : "");
            if (showRefd) {
                checkClassRefs.reportRefs(string, string2);
            }
            int n = 0;
            while (n < stringArray.length) {
                if (!(string.equals(stringArray[n]) || stringArray[n].startsWith("[") || (stringArray[n].startsWith("java/") || stringArray[n].startsWith("javax/")) && !doJava)) {
                    CheckClassRefs.showRefClasses(checkClassRefs, stringArray[n]);
                }
                ++n;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            checkClassRefs.appendLogNL(notFndMsg);
            missingClass = true;
            ++nbrMissingCls;
        }
        catch (InvalidClassException invalidClassException) {
            checkClassRefs.appendLogNL(notFndMsg);
            missingClass = true;
            ++nbrMissingCls;
        }
        catch (Exception exception) {
            System.err.println("sRC at " + nestLvl + " ex: " + exception);
            exception.printStackTrace();
            checkClassRefs.appendLogNL("");
        }
        nestLvl += -1;
    }

    public String addToList() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Choose a jar file to add to list", 0);
        fileDialog.setFile("*.jar");
        fileDialog.show();
        fileDialog.dispose();
        if (fileDialog.getFile() == null) {
            return null;
        }
        if (fileDialog.getFile().equals("")) {
            return null;
        }
        return fileDialog.getDirectory() + fileDialog.getFile();
    }

    private void setFromJar(String string, String string2) {
        this.appendLogNL("#" + "Searching " + string + " for " + string2);
        this.cfs = new ClassFileFromJar(string);
    }

    static boolean haveCkd(String string, boolean bl) {
        if (ckdClsNms.contains(string)) {
            return true;
        }
        if (bl) {
            ckdClsNms.addElement(string);
        }
        return false;
    }

    public void run() {
        this.clearB.setEnabled(false);
        this.printMI.setEnabled(false);
        missingClass = false;
        nbrMissingCls = 0;
        stopSearch = false;
        this.searchB.setLabel("Stop Search");
        this.searchB.invalidate();
        this.searchB.getParent().validate();
        ckdClsNms = new Vector(200, 100);
        this.clsNmSource = new Hashtable(200);
        CheckClassRefs.showRefClasses(this, this.clsName);
        if (stopSearch) {
            this.appendLogNL("*** Stopping search ***");
        }
        this.searchB.setLabel(" Search ");
        this.searchB.invalidate();
        this.searchB.getParent().validate();
        this.appendLogNL("\n" + "#" + "  Found " + ckdClsNms.size() + " classes.  " + (missingClass ? nbrMissingCls + " NOT found." : "") + "\n");
        this.clearB.setEnabled(true);
        this.findMI.setEnabled(true);
        this.printMI.setEnabled(true);
        this.saveListMI.setEnabled(ckdClsNms.size() > 0);
        this.listUnrefdMI.setEnabled(this.useJarCB.getState());
    }

    private void appendLogMulti(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf("java/", 5);
            int n3 = stringArray[n].indexOf("javax/", 5);
            int n4 = stringArray[n].indexOf("(");
            if ((n2 <= 0 || n2 >= n4 && n4 >= 0 || doJava) && (n3 <= 0 || n3 >= n4 && n4 >= 0 || doJava) && (stringArray[n].indexOf("$") <= 0 || this.showInnerClsCB.getState())) {
                this.appendLogNL(string + blanks.substring(0, indent + 2) + stringArray[n]);
            }
            ++n;
        }
    }

    private void openProps(boolean bl) {
        Object object;
        try {
            object = new FileInputStream(this.propsFn);
            this.ourProps.load((InputStream)object);
            this.foundProps = true;
            ((FileInputStream)object).close();
            if (ConstantPoolElement.debug) {
                System.out.println("Read properties from " + this.propsFn);
                this.ourProps.list(System.out);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Property file NOT found: " + this.propsFn + " It will be created on Exit.");
        }
        catch (Exception exception) {
            System.err.println("Error getting properties " + exception);
        }
        this.jarsListV = this.ourProps.getProperty("JarsList", this.jarsListV);
        this.classNameV = this.ourProps.getProperty("ClassName", this.classNameV);
        this.jarFileV = this.ourProps.getProperty("JarFile", this.jarFileV);
        this.classPathV = this.ourProps.getProperty("ClassPath", this.classPathV);
        if (!this.classPathV.endsWith(File.separator)) {
            this.classPathV = this.classPathV + File.separator;
        }
        if (!this.jarsListV.equals("")) {
            object = new StringTokenizer(this.jarsListV, ";");
            Vector<String> vector = new Vector<String>();
            while (((StringTokenizer)object).hasMoreTokens()) {
                vector.addElement(((StringTokenizer)object).nextToken());
            }
            this.jarsList = new String[vector.size()];
            vector.copyInto(this.jarsList);
            this.jarCFS = new ClassFileSource[this.jarsList.length];
        }
        if (bl) {
            if (!this.classNameV.equals("")) {
                this.clsName = this.classNameV;
                ((TextComponent)this.clsNameTF).setText(this.classNameV);
                this.enableSearchB();
            }
            if (!this.jarFileV.equals("")) {
                ((TextComponent)this.jarFNTF).setText(this.jarFileV);
                this.jarFN = this.jarFileV;
            }
        }
    }

    private void saveProps() {
        Object object;
        if (!this.changedProps && this.clsName.equals(this.classNameV) && this.jarFN.equals(this.jarFileV)) {
            return;
        }
        if (this.jarsList.length == 0) {
            this.jarsListV = "";
        } else {
            object = new StringBuffer(this.jarsList[0]);
            int n = 1;
            while (n < this.jarsList.length) {
                ((StringBuffer)object).append(';').append(this.jarsList[n]);
                ++n;
            }
            this.jarsListV = ((StringBuffer)object).toString();
        }
        ((Hashtable)this.ourProps).put("JarsList", this.jarsListV);
        ((Hashtable)this.ourProps).put("ClassName", this.clsName);
        ((Hashtable)this.ourProps).put("JarFile", this.jarFN);
        ((Hashtable)this.ourProps).put("ClassPath", this.classPathV);
        try {
            object = new FileOutputStream(this.propsFn);
            this.ourProps.save((OutputStream)object, "Check Class References");
            this.changedProps = false;
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            System.err.println("Error saving props " + this.propsFn + "\n  " + exception);
        }
    }
}

