/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import NormsTools.ChoiceOfYesOrNo;
import NormsTools.ErrDialog;
import NormsTools.GetInput;
import NormsTools.GetIntInput;
import NormsTools.MakeFocusLostDoAction;
import NormsTools.ShowMsgBox;
import WayPointApps.CandD;
import WayPointApps.EditWPUpdateListener;
import WayPointApps.EditWayPoint;
import WayPointApps.GPSDevices.GPSInterface2;
import WayPointApps.LoginRecord;
import WayPointApps.PlotWayPoints;
import WayPointApps.Position;
import WayPointApps.Positions;
import WayPointApps.ShowPositions;
import WayPointApps.WPClipboardListener;
import WayPointApps.WPUpdateEvent;
import WayPointApps.WayPointDefs;
import WayPointApps.WayPointsInterface;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;

public class ShowPositions
implements ActionListener,
EditWPUpdateListener,
TextListener,
WPClipboardListener {
    DecimalFormat decForm;
    LoginRecord logInRec;
    WayPointsInterface wpI;
    Image saveIcon = null;
    Color saveColor = null;
    private boolean isWork = false;
    private boolean localFiles = false;
    private boolean changesMade = true;
    private boolean ignoreWPChanges = false;
    private boolean isLocked = false;
    private String reasonForLock = "";
    private Panel p2t;
    private Panel p2b;
    private Panel p3;
    private Panel bPanel;
    private Button editB;
    private Button addWP;
    private Button moveUp;
    private Button moveDown;
    private Button deleteB;
    private Button saveB;
    private Button copyToWork;
    private Button toBrowserB;
    private GridBagConstraints gbc;
    private Label pos1Lab = new Label("Select waypoint in above list and press Set                 ");
    private Label pos2Lab = new Label("Select waypoint in above list and press Set                   ");
    private Label l3a = new Label("Course and distance will be displayed here....................");
    private Button sel1;
    private Button sel2;
    private Button comp;
    private Position selPos;
    private Position pos1;
    private Position pos2;
    static final int NONE_SEL = -1;
    private int selIdx = -1;
    private final int[] NoMultSel = new int[0];
    private int[] multSelIdx = this.NoMultSel;
    private boolean shiftPressed = false;
    private Frame listFrame;
    private List WP_List;
    private TextField showDesc;
    private boolean allowDescUpdateF = false;
    private MenuBar mBar;
    private Menu mF;
    private Menu mSort;
    private Menu mGPS;
    private MenuItem toBrowser;
    private MenuItem plotWP;
    private MenuItem saveAsMI;
    private MenuItem writeWPMI;
    private MenuItem writeRouteMI;
    private MenuItem importWP;
    private MenuItem exportWP;
    private MenuItem exportWP_CAPN;
    private MenuItem exportWP_CMAP;
    private MenuItem exportWP_MTec;
    private MenuItem exitMI;
    private MenuItem copyMI = new MenuItem("Copy", new MenuShortcut(67));
    private MenuItem copyToWorkMI = new MenuItem("Copy to Work", new MenuShortcut(87));
    private MenuItem undoMI = new MenuItem("Undo");
    private MenuItem findMI = new MenuItem("Find...");
    private MenuItem findNextMI = new MenuItem("Find Next");
    private MenuItem cutMI = new MenuItem("Cut", new MenuShortcut(88));
    private MenuItem pasteMI = new MenuItem("Paste", new MenuShortcut(86));
    private MenuItem selectAllMI = new MenuItem("Select All", new MenuShortcut(65));
    private MenuItem addEndLeg = new MenuItem("End Leg");
    private MenuItem showInfoMI = new MenuItem("Show route info");
    private MenuItem markAllPOIMI = new MenuItem("Mark all as POI");
    private MenuItem clearAllPOIMI = new MenuItem("Clear all POI");
    private MenuItem deleteAllPOIMI = new MenuItem("Delete all POI");
    private CheckboxMenuItem allowMultSelCB = new CheckboxMenuItem("Allow multiple selections");
    private MenuItem byNameMI = new MenuItem("By Name");
    private MenuItem byLatMI = new MenuItem("By latitide");
    private MenuItem byLongMI = new MenuItem("By longitude");
    private MenuItem byGPSNameMI = new MenuItem("By GPS name");
    private MenuItem reverseMI = new MenuItem("Reverse");
    private Positions wayPointData;
    private Positions undoWPData;
    private String findWhat = "";
    private int findWhere = 0;
    final String Comma = ",";
    final String MTec_Sep = "|";
    final String Quote = "\"";
    final String UnknownFlag = "1";
    final String CMAP_WP_Hdr1 = " {\n  #NM=";
    final String CMAP_WP_Hdr2 = "\n  #FL=00000000\n  #WP=";
    final String CMAP_WP_Hdr3 = "\n  {\n";
    final String CMAP_WP_Trlr = "  }\n  #SR=0\n }";
    final String CMAP_Rec_Suffix = "|D(0,0,0,0,0)|R(0,0,0,0,0)|\n";

    public ShowPositions(LoginRecord lr, WayPointsInterface wpa, boolean local) {
        this(lr, wpa);
        this.localFiles = local;
        this.writeWPMI = new MenuItem("Write waypoints");
        this.writeWPMI.setEnabled(false);
        this.writeRouteMI = new MenuItem("Write route");
        this.writeRouteMI.setEnabled(false);
        ((GPSInterface2)wpa).addGPSWriteableListener(this);
    }

    public ShowPositions(LoginRecord lr, WayPointsInterface wpa) {
        this.logInRec = lr;
        this.wpI = wpa;
        this.decForm = (DecimalFormat)NumberFormat.getNumberInstance();
        this.decForm.setMaximumFractionDigits(2);
    }

    public void finalize() {
        if (this.listFrame != null) {
            this.closeFrame();
        }
    }

    public void setLock(boolean b) {
        this.isLocked = b;
    }

    public void setReasonForLock(String rfl) {
        this.reasonForLock = rfl;
    }

    public void showList(String title, Positions wpd) {
        this.wayPointData = wpd;
        this.pos2 = null;
        this.pos1 = null;
        this.selPos = null;
        boolean bl = this.isWork = WayPointDefs.workSP == this;
        if (this.listFrame != null) {
            if (WayPointDefs.debug) {
                System.out.println("sL: closing old display");
            }
            this.listFrame.setVisible(false);
            this.listFrame.dispose();
        }
        this.listFrame = new Frame();
        this.listFrame.setTitle("Waypoints: " + title);
        this.listFrame.setSize(600, 400);
        this.listFrame.setLocation(100, 0);
        this.listFrame.setLayout(new BorderLayout());
        this.mBar = new MenuBar();
        this.mF = new Menu("File");
        this.plotWP = new MenuItem("Plot WP");
        this.plotWP.addActionListener(this);
        this.mF.add(this.plotWP);
        this.mF.addSeparator();
        if (!this.localFiles) {
            this.toBrowser = new MenuItem("To Browser");
            this.toBrowser.addActionListener(this);
            this.mF.add(this.toBrowser);
            this.importWP = new MenuItem("Import...");
            this.importWP.setEnabled(true);
            this.importWP.addActionListener(this);
            this.mF.add(this.importWP);
        } else {
            this.saveAsMI = new MenuItem("Save As...");
            this.saveAsMI.addActionListener(this);
            this.mF.add(this.saveAsMI);
            this.mF.addSeparator();
        }
        this.exportWP = new MenuItem("Export NMEA format");
        this.exportWP.addActionListener(this);
        this.mF.add(this.exportWP);
        this.exportWP_CAPN = new MenuItem("Export POI as CAPN Marks");
        this.exportWP_CAPN.addActionListener(this);
        this.mF.add(this.exportWP_CAPN);
        this.exportWP_CMAP = new MenuItem("Export in CMAP format");
        this.exportWP_CMAP.addActionListener(this);
        this.mF.add(this.exportWP_CMAP);
        this.exportWP_MTec = new MenuItem("Export in Maptech format");
        this.exportWP_MTec.addActionListener(this);
        this.mF.add(this.exportWP_MTec);
        this.exitMI = new MenuItem("Exit");
        this.exitMI.addActionListener(this);
        this.mF.add(this.exitMI);
        this.mBar.add(this.mF);
        if (this.localFiles && this.wpI instanceof GPSInterface2 && this.wayPointData.writeableToGPS) {
            this.mGPS = new Menu("GPS");
            this.writeWPMI.addActionListener(this);
            this.mGPS.add(this.writeWPMI);
            this.writeRouteMI.addActionListener(this);
            this.mGPS.add(this.writeRouteMI);
            this.mBar.add(this.mGPS);
        }
        Menu mE = new Menu("Edit");
        this.undoMI.addActionListener(this);
        mE.add(this.undoMI);
        this.undoMI.setEnabled(false);
        this.findMI.addActionListener(this);
        mE.add(this.findMI);
        mE.add(this.findNextMI);
        this.findNextMI.addActionListener(this);
        this.findNextMI.setEnabled(false);
        mE.addSeparator();
        this.cutMI.setEnabled(false);
        this.cutMI.addActionListener(this);
        mE.add(this.cutMI);
        this.copyMI.setEnabled(false);
        this.copyMI.addActionListener(this);
        mE.add(this.copyMI);
        this.pasteMI.setEnabled(WayPointDefs.wpClipboard.hasContents());
        WayPointDefs.wpClipboard.addCBListener(this);
        this.pasteMI.addActionListener(this);
        mE.add(this.pasteMI);
        this.copyToWorkMI.addActionListener(this);
        mE.add(this.copyToWorkMI);
        mE.addSeparator();
        this.selectAllMI.addActionListener(this);
        mE.add(this.selectAllMI);
        mE.add(this.allowMultSelCB);
        mE.addSeparator();
        this.addEndLeg.addActionListener(this);
        mE.add(this.addEndLeg);
        mE.addSeparator();
        this.markAllPOIMI.addActionListener(this);
        mE.add(this.markAllPOIMI);
        this.clearAllPOIMI.addActionListener(this);
        mE.add(this.clearAllPOIMI);
        this.deleteAllPOIMI.addActionListener(this);
        mE.add(this.deleteAllPOIMI);
        this.mBar.add(mE);
        this.allowMultSelCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                ShowPositions.this.WP_List.setMultipleMode(ShowPositions.this.allowMultSelCB.getState());
                ShowPositions.access$202(ShowPositions.this, ShowPositions.this.NoMultSel);
            }
        });
        String jv = System.getProperty("java.version");
        if ("1.2".compareTo(jv) <= 0) {
            this.mSort = new Menu("Sort");
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    Object src = ae.getSource();
                    if (src == ShowPositions.this.byNameMI) {
                        class SortByName
                        implements Comparator {
                            private final /* synthetic */ 2 this$1;

                            SortByName(2 this$1) {
                                this.this$1 = this$1;
                            }

                            public int compare(Object pos1, Object pos2) {
                                return ((Position)pos1).getName().compareTo(((Position)pos2).getName());
                            }
                        }
                        Collections.sort(ShowPositions.this.wayPointData, new SortByName(this));
                        ShowPositions.this.reloadList();
                    } else if (src == ShowPositions.this.byGPSNameMI) {
                        class SortByGPSName
                        implements Comparator {
                            private final /* synthetic */ 2 this$1;

                            SortByGPSName(2 this$1) {
                                this.this$1 = this$1;
                            }

                            public int compare(Object pos1, Object pos2) {
                                return ((Position)pos1).getGPSName().compareTo(((Position)pos2).getGPSName());
                            }
                        }
                        Collections.sort(ShowPositions.this.wayPointData, new SortByGPSName(this));
                        ShowPositions.this.reloadList();
                    } else if (src == ShowPositions.this.byLatMI) {
                        class SortByLat
                        implements Comparator {
                            private final /* synthetic */ 2 this$1;

                            SortByLat(2 this$1) {
                                this.this$1 = this$1;
                            }

                            public int compare(Object pos1, Object pos2) {
                                double pos1Val = ((Position)pos1).decDegLat();
                                pos1Val = ((Position)pos1).directionNorth() ? 90.0 - pos1Val : (pos1Val += 100.0);
                                double pos2Val = ((Position)pos2).decDegLat();
                                pos2Val = ((Position)pos2).directionNorth() ? 90.0 - pos2Val : (pos2Val += 100.0);
                                return (int)(1000.0 * (pos1Val - pos2Val));
                            }
                        }
                        Collections.sort(ShowPositions.this.wayPointData, new SortByLat(this));
                        ShowPositions.this.reloadList();
                    } else if (src == ShowPositions.this.byLongMI) {
                        class SortByLong
                        implements Comparator {
                            private final /* synthetic */ 2 this$1;

                            SortByLong(2 this$1) {
                                this.this$1 = this$1;
                            }

                            public int compare(Object pos1, Object pos2) {
                                double pos1Val = ((Position)pos1).decDegLong();
                                pos1Val = ((Position)pos1).directionWest() ? 180.0 - pos1Val : (pos1Val += 200.0);
                                double pos2Val = ((Position)pos2).decDegLong();
                                pos2Val = ((Position)pos2).directionWest() ? 180.0 - pos2Val : (pos2Val += 200.0);
                                return (int)(1000.0 * (pos1Val - pos2Val));
                            }
                        }
                        Collections.sort(ShowPositions.this.wayPointData, new SortByLong(this));
                        ShowPositions.this.reloadList();
                    } else if (src == ShowPositions.this.reverseMI) {
                        int i = 0;
                        int j = ShowPositions.this.wayPointData.size() - 1;
                        while (i < j) {
                            Object saveIt = ShowPositions.this.wayPointData.elementAt(i);
                            ShowPositions.this.wayPointData.setElementAt(ShowPositions.this.wayPointData.elementAt(j), i);
                            ShowPositions.this.wayPointData.setElementAt(saveIt, j);
                            ++i;
                            --j;
                        }
                        ShowPositions.this.reloadList();
                    } else {
                        System.err.println("unknown ae in Sort " + ae);
                    }
                }
            };
            this.mSort.add(this.byNameMI);
            this.byNameMI.addActionListener(al);
            this.mSort.add(this.byGPSNameMI);
            this.byGPSNameMI.addActionListener(al);
            this.mSort.add(this.byLatMI);
            this.byLatMI.addActionListener(al);
            this.mSort.add(this.byLongMI);
            this.byLongMI.addActionListener(al);
            this.mSort.add(this.reverseMI);
            this.reverseMI.addActionListener(al);
            this.mBar.add(this.mSort);
        }
        Menu infoM = new Menu("Info");
        infoM.add(this.showInfoMI);
        this.showInfoMI.addActionListener(this);
        this.mBar.add(infoM);
        this.listFrame.setMenuBar(this.mBar);
        this.listFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                if (ShowPositions.this.isLocked) {
                    ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(ShowPositions.this.listFrame, "Warning: Window is locked!" + ShowPositions.this.reasonForLock + "\nDo you want to unlock the window?", Color.red);
                    if (cyn.isYes()) {
                        ShowPositions.this.isLocked = false;
                    }
                    return;
                }
                ShowPositions.this.exitProgram();
            }
        });
        Panel p1 = new Panel();
        p1.setLayout(new BorderLayout());
        this.showDesc = new TextField(this.wayPointData.description.trim(), 40);
        this.allowDescUpdate(this.allowDescUpdateF);
        this.showDesc.addActionListener(this);
        if (this.wayPointData.description.trim().equals("") && this.logInRec.loggedIn) {
            this.showDesc.setText("Enter description here");
            this.showDesc.setEditable(true);
        }
        p1.add((Component)this.showDesc, "North");
        int nbrID = this.wayPointData.size();
        int nbrRows = Math.max(10, Math.min(20, nbrID));
        this.WP_List = new List(nbrRows, false);
        int i = 0;
        while (i < nbrID) {
            this.wayPointData.get(i).addEditWPUpdateListener(this);
            this.WP_List.add(this.wayPointData.get(i).toString());
            ++i;
        }
        this.WP_List.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ShowPositions.this.WP_List.isMultipleMode()) {
                    ShowPositions.access$202(ShowPositions.this, ShowPositions.this.WP_List.getSelectedIndexes());
                    if (ShowPositions.this.shiftPressed) {
                        int[] newMultSelIdx = new int[ShowPositions.this.multSelIdx[ShowPositions.this.multSelIdx.length - 1] - ShowPositions.this.multSelIdx[0] + 1];
                        int i = ShowPositions.this.multSelIdx[0];
                        while (i <= ShowPositions.this.multSelIdx[ShowPositions.this.multSelIdx.length - 1]) {
                            ShowPositions.this.WP_List.select(i);
                            newMultSelIdx[i - ((ShowPositions)ShowPositions.this).multSelIdx[0]] = i;
                            ++i;
                        }
                        ShowPositions.access$202(ShowPositions.this, newMultSelIdx);
                    }
                    ShowPositions.this.setEditButtons();
                    return;
                }
                ShowPositions.this.selIdx = ShowPositions.this.WP_List.getSelectedIndex();
                if (ShowPositions.this.selIdx == -1) {
                    return;
                }
                ShowPositions.this.selPos = ShowPositions.this.wayPointData.get(ShowPositions.this.selIdx);
                ShowPositions.this.sel1.setEnabled(true);
                if (WayPointDefs.debug) {
                    System.out.println("Login user: " + ShowPositions.this.logInRec.userid + " vs " + "current owner: " + ((ShowPositions)ShowPositions.this).wayPointData.owner);
                }
                ShowPositions.this.editB.setEnabled(!ShowPositions.this.allowMultSelCB.getState());
                ShowPositions.this.setMoveButtons();
                ShowPositions.this.setEditButtons();
            }
        });
        this.WP_List.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 16) {
                    ShowPositions.this.shiftPressed = true;
                } else if (ke.getKeyCode() == 127 && ShowPositions.this.deleteB.isEnabled()) {
                    System.out.println("deleteing");
                }
            }

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 16) {
                    ShowPositions.this.shiftPressed = false;
                }
            }
        });
        this.WP_List.requestFocus();
        p1.add((Component)this.WP_List, "Center");
        this.bPanel = new Panel();
        GridBagLayout gbl = new GridBagLayout();
        this.bPanel.setLayout(gbl);
        this.gbc = new GridBagConstraints();
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(2, 0, 2, 0);
        int bRow = 0;
        this.editB = new Button("Edit");
        this.addGBC(this.editB, 0, bRow++, 1, 1);
        this.editB.setEnabled(false);
        this.addWP = new Button("New");
        this.addGBC(this.addWP, 0, bRow++, 1, 1);
        this.moveUp = new Button("Move Up");
        this.addGBC(this.moveUp, 0, bRow++, 1, 1);
        this.moveUp.setEnabled(false);
        this.moveDown = new Button("Move down");
        this.addGBC(this.moveDown, 0, bRow++, 1, 1);
        this.moveDown.setEnabled(false);
        this.deleteB = new Button("Delete");
        this.addGBC(this.deleteB, 0, bRow++, 1, 1);
        this.deleteB.setEnabled(false);
        this.saveB = new Button(this.localFiles ? "Save" : "Write");
        this.saveB.setEnabled(false);
        if (this.logInRec.loggedIn) {
            this.addGBC(this.saveB, 0, bRow++, 1, 1);
        }
        this.toBrowserB = new Button("To Browser");
        if (this.isWork && !this.localFiles) {
            this.toBrowser.setEnabled(false);
        }
        this.copyToWork = new Button("Copy to work");
        if (!this.isWork) {
            this.addGBC(this.copyToWork, 0, bRow++, 1, 1);
            this.copyToWork.setEnabled(false);
            this.copyToWorkMI.setEnabled(false);
        }
        p1.add((Component)this.bPanel, "East");
        this.listFrame.add((Component)p1, "North");
        Panel p2 = new Panel();
        p2.setLayout(new BorderLayout());
        this.p2t = new Panel();
        this.p2t.setLayout(new FlowLayout(0));
        this.sel1 = new Button("Set Start");
        this.sel1.setEnabled(false);
        this.sel1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShowPositions.this.pos1Lab.setText(ShowPositions.this.selPos.toString());
                ShowPositions.this.pos1Lab.invalidate();
                ShowPositions.this.pos1 = ShowPositions.this.selPos;
                ShowPositions.this.p2t.validate();
                ShowPositions.this.sel2.setEnabled(true);
                ShowPositions.this.comp.setEnabled(ShowPositions.this.pos1 != ShowPositions.this.pos2 && ShowPositions.this.pos2 != null);
            }
        });
        this.p2t.add((Component)this.sel1, 0);
        this.p2t.add(this.pos1Lab);
        p2.add((Component)this.p2t, "North");
        this.p2b = new Panel();
        this.p2b.setLayout(new FlowLayout(0));
        this.sel2 = new Button("Set End");
        this.sel2.setEnabled(false);
        this.sel2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShowPositions.this.pos2Lab.setText(ShowPositions.this.selPos.toString());
                ShowPositions.this.pos2Lab.invalidate();
                ShowPositions.this.pos2 = ShowPositions.this.selPos;
                ShowPositions.this.p2b.validate();
                ShowPositions.this.comp.setEnabled(ShowPositions.this.pos1 != ShowPositions.this.pos2);
                if (ShowPositions.this.pos1 != ShowPositions.this.pos2) {
                    ShowPositions.this.computeCandD();
                } else {
                    System.out.println("Same positions: " + ShowPositions.this.pos1);
                }
            }
        });
        this.p2b.add((Component)this.sel2, 0);
        this.p2b.add(this.pos2Lab);
        p2.add((Component)this.p2b, "South");
        this.listFrame.add((Component)p2, "Center");
        this.p3 = new Panel();
        this.p3.setLayout(new FlowLayout(0));
        this.comp = new Button("Compute");
        this.comp.setEnabled(false);
        this.comp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ShowPositions.this.computeCandD();
            }
        });
        this.p3.add(this.comp);
        this.l3a.setFont(new Font("Monospaced", 1, 12));
        this.p3.add(this.l3a);
        this.listFrame.add((Component)this.p3, "South");
        if (this.saveIcon != null) {
            this.listFrame.setIconImage(this.saveIcon);
        }
        if (this.saveColor != null) {
            this.listFrame.setBackground(this.saveColor);
        }
        this.listFrame.pack();
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.listFrame.setLocation((ss.width - this.listFrame.getBounds().width) / 2, (ss.height - this.listFrame.getBounds().height) / 2);
        this.listFrame.setVisible(true);
        this.listFrame.show();
    }

    void addGBC(Button b, int x, int y, int w, int h) {
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.gridwidth = w;
        this.gbc.gridheight = h;
        this.bPanel.add((Component)b, this.gbc);
        b.addActionListener(this);
    }

    void resetEditButtons() {
        this.editB.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        this.deleteB.setEnabled(false);
        this.copyMI.setEnabled(false);
        this.cutMI.setEnabled(false);
        this.copyToWork.setEnabled(false);
        this.copyToWorkMI.setEnabled(false);
    }

    void setEditButtons() {
        boolean isOwner = this.logInRec.userid.equals(this.wayPointData.owner);
        this.deleteB.setEnabled(isOwner || this.isWork || this.localFiles);
        this.copyToWork.setEnabled(WayPointDefs.workSP != null);
        this.copyToWorkMI.setEnabled(WayPointDefs.workSP != null);
        this.copyMI.setEnabled(true);
        this.cutMI.setEnabled(true);
    }

    void setMoveButtons() {
        this.moveDown.setEnabled(this.selIdx != this.WP_List.getItemCount() - 1);
        this.moveUp.setEnabled(this.selIdx != 0);
    }

    public void setGPSWriteable(int select, boolean b) {
        if ((select & 1) != 0) {
            this.writeWPMI.setEnabled(b);
        }
        if ((select & 2) != 0) {
            this.writeRouteMI.setEnabled(b);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.editB) {
            EditWayPoint ewp = new EditWayPoint(2);
            ewp.setPosition(this.selPos);
            ewp.addEditWPUpdateListener(this);
        } else if (src == this.addWP) {
            EditWayPoint ewp = new EditWayPoint(1);
            if (this.selPos == null) {
                if (this.wayPointData.size() > 0) {
                    ewp.setPosition(this.wayPointData.get(0));
                } else {
                    ewp.setRoute(this.wayPointData.description);
                }
            } else {
                ewp.setPosition(this.selPos);
            }
            ewp.addEditWPUpdateListener(this);
        } else if (src == this.moveUp) {
            this.setUndo(true);
            if (this.selIdx > 0) {
                this.wayPointData.moveUp(this.selIdx);
                String item = this.WP_List.getItem(this.selIdx);
                this.WP_List.remove(this.selIdx);
                --this.selIdx;
                this.WP_List.add(item, this.selIdx);
                this.WP_List.select(this.selIdx);
                this.setMoveButtons();
                this.saveB.setEnabled(true);
            }
        } else if (src == this.moveDown) {
            this.setUndo(true);
            if (this.selIdx != -1 && this.selIdx < this.WP_List.getItemCount() - 1) {
                this.wayPointData.moveDown(this.selIdx);
                String item = this.WP_List.getItem(this.selIdx);
                this.WP_List.add(item, this.selIdx + 2);
                this.WP_List.remove(this.selIdx);
                ++this.selIdx;
                this.WP_List.select(this.selIdx);
                this.setMoveButtons();
                this.saveB.setEnabled(true);
            }
        } else if (src == this.deleteB) {
            if (!(this.localFiles || this.isWork || this.ckOwner("delete"))) {
                System.out.println("Skipping delete - not allowed");
                return;
            }
            this.setUndo(true);
            if (this.WP_List.isMultipleMode()) {
                if (this.multSelIdx.length > 0) {
                    boolean doReload = this.multSelIdx.length > this.WP_List.getRows();
                    int i = this.multSelIdx.length - 1;
                    while (i >= 0) {
                        this.wayPointData.removeElementAt(this.multSelIdx[i]);
                        if (!doReload) {
                            this.WP_List.remove(this.multSelIdx[i]);
                        }
                        --i;
                    }
                    if (doReload) {
                        this.reloadList();
                    }
                    this.multSelIdx = this.NoMultSel;
                    this.resetEditButtons();
                    this.saveB.setEnabled(true);
                    this.changesMade = true;
                }
                return;
            }
            if (this.selIdx != -1) {
                this.wayPointData.removeElementAt(this.selIdx);
                this.WP_List.remove(this.selIdx);
                this.selIdx = -1;
                this.selPos = null;
                this.resetEditButtons();
                this.saveB.setEnabled(true);
                this.changesMade = true;
            } else {
                System.out.println("Nothing selected to Delete?");
            }
        } else if (src == this.undoMI) {
            this.setUndo(false);
        } else if (src == this.findMI) {
            GetInput gi = new GetInput("Enter string to find:", this.listFrame, 20, "Find");
            this.findWhat = gi.getResponse();
            if (this.findWhat.equals("")) {
                return;
            }
            this.findWhere = 0;
            this.findInList();
        } else if (src == this.findNextMI) {
            this.findInList();
        } else if (src == this.cutMI) {
            this.setUndo(true);
            if (this.multSelIdx.length > 0) {
                Position[] tPos = new Position[this.multSelIdx.length];
                int i = 0;
                while (i < this.multSelIdx.length) {
                    tPos[i] = (Position)this.wayPointData.get(this.multSelIdx[i]).clone();
                    ++i;
                }
                WayPointDefs.wpClipboard.setContents(tPos);
                int i2 = this.multSelIdx.length - 1;
                while (i2 >= 0) {
                    this.wayPointData.removeElementAt(i2);
                    --i2;
                }
                this.multSelIdx = this.NoMultSel;
                this.resetEditButtons();
                this.saveB.setEnabled(true);
                return;
            }
            if (this.selIdx != -1) {
                WayPointDefs.wpClipboard.setContents(new Position[]{(Position)this.wayPointData.get(this.selIdx).clone()});
                this.wayPointData.removeElementAt(this.selIdx);
                this.WP_List.remove(this.selIdx);
                this.selIdx = -1;
                this.selPos = null;
                this.resetEditButtons();
                this.saveB.setEnabled(true);
            } else {
                System.out.println("Nothing selected to Cut?");
            }
        } else if (src == this.copyMI) {
            if (this.multSelIdx.length > 0) {
                Position[] tPos = new Position[this.multSelIdx.length];
                int i = 0;
                while (i < this.multSelIdx.length) {
                    tPos[i] = (Position)this.wayPointData.get(this.multSelIdx[i]).clone();
                    ++i;
                }
                WayPointDefs.wpClipboard.setContents(tPos);
                return;
            }
            if (this.selIdx != -1) {
                WayPointDefs.wpClipboard.setContents(new Position[]{(Position)this.wayPointData.get(this.selIdx).clone()});
            } else {
                System.out.println("Nothing selected to Copy?");
            }
        } else if (src == this.pasteMI) {
            this.setUndo(true);
            Position[] tPos = WayPointDefs.wpClipboard.getContents();
            int i = 0;
            while (i < tPos.length) {
                this.wayPointData.insertElementAt(tPos[i], this.selIdx + 1 + i);
                this.WP_List.add(tPos[i].toString(), this.selIdx + 1 + i);
                ++i;
            }
            this.saveB.setEnabled(true);
        } else if (src == this.addEndLeg) {
            this.setUndo(true);
            Position ELpos = null;
            try {
                ELpos = new Position(WayPointDefs.END_LEG_REC);
            }
            catch (Exception ex) {
                System.err.println("bad End Leg pos??");
            }
            if (this.selIdx == -1) {
                this.WP_List.add(ELpos.toString());
                this.wayPointData.add(ELpos);
            } else {
                this.wayPointData.insertElementAt(ELpos, this.selIdx + 1);
                this.WP_List.add(ELpos.toString(), this.selIdx + 1);
            }
            this.saveB.setEnabled(true);
        } else if (src == this.saveB) {
            if (!this.checkSaveFile()) {
                return;
            }
            if (this.wayPointData.fileName.equals("")) {
                new ErrDialog(this.listFrame, "Need to supply a filename." + (this.localFiles ? "\nUse main window's File|Set Save filename.." : ""));
                return;
            }
            this.saveFile();
            this.saveB.setEnabled(false);
            this.changesMade = false;
        } else if (src == this.saveAsMI) {
            if (!this.checkSaveFile()) {
                return;
            }
            if (!this.wpI.setSaveAsFilename(this.wayPointData, this.listFrame)) {
                return;
            }
            this.saveFile();
            this.changesMade = false;
        } else if (src == this.toBrowser) {
            if (this.isWork) {
                new ErrDialog(this.listFrame, "Sorry, not able to send records to Browser from Work display.\n Use the \"Export Work\" button at bottom of HTML page.");
            } else {
                this.wpI.toBrowser(this.wayPointData.fileName);
            }
        } else if (src == this.plotWP) {
            PlotWayPoints pwp = new PlotWayPoints(this.wayPointData);
            pwp.plotWP();
        } else if (src == this.importWP) {
            this.getImport();
        } else if (src == this.exportWP) {
            this.exportWPs();
        } else if (src == this.exportWP_CAPN) {
            this.exportWPs_CAPN();
        } else if (src == this.exportWP_CMAP) {
            this.exportWPs_CMAP();
        } else if (src == this.exportWP_MTec) {
            this.exportWPs_MTec();
        } else if (src == this.writeWPMI) {
            ((GPSInterface2)this.wpI).writeWayPoints(this.wayPointData);
        } else if (src == this.writeRouteMI) {
            ((GPSInterface2)this.wpI).writeARoute(this.wayPointData);
        } else if (src == this.showInfoMI) {
            CandD cd = CandD.compGreatCircle(this.wayPointData.get(0), this.wayPointData.get(this.wayPointData.size() - 1));
            DecimalFormat decForm1 = new DecimalFormat("000");
            DecimalFormat decForm2 = (DecimalFormat)NumberFormat.getNumberInstance();
            decForm2.setMaximumFractionDigits(2);
            double totalDist = 0.0;
            int i = 0;
            while (i < this.wayPointData.size() - 1) {
                Position p1 = this.wayPointData.get(i);
                Position p2 = this.wayPointData.get(i + 1);
                if (!(p1.isPOI() || p2.isPOI() || p1.isEndOfLeg() || p2.isEndOfLeg())) {
                    CandD cd0 = CandD.compGreatCircle(p1, p2);
                    totalDist += cd0.distance;
                }
                ++i;
            }
            new ShowMsgBox(this.listFrame, "Route information", "Owner = " + this.wayPointData.owner + "\n Filename = " + this.wayPointData.fileName + "\n " + this.wayPointData.size() + " waypoints" + "\n First to last: " + decForm1.format(cd.courseT) + "\u00b0" + "T, " + decForm2.format(cd.distance) + "nm" + "\n Total distance: " + decForm2.format(totalDist) + "nm");
        } else if (src == this.exitMI) {
            this.exitProgram();
        } else if (src == this.selectAllMI) {
            if (this.WP_List.getItemCount() == this.multSelIdx.length) {
                this.multSelIdx = this.NoMultSel;
                int i = 0;
                while (i < this.WP_List.getItemCount()) {
                    this.WP_List.deselect(i);
                    ++i;
                }
                return;
            }
            this.WP_List.setMultipleMode(true);
            this.multSelIdx = new int[this.WP_List.getItemCount()];
            int i = 0;
            while (i < this.WP_List.getItemCount()) {
                this.WP_List.select(i);
                this.multSelIdx[i] = i;
                ++i;
            }
            this.setEditButtons();
            if (!this.isWork) {
                this.enableCopyToWork(this.WP_List.getItemCount() > 0);
            }
        } else if (src == this.markAllPOIMI) {
            boolean doReload;
            this.setUndo(true);
            if (this.multSelIdx.length > 0) {
                int i = 0;
                while (i < this.multSelIdx.length) {
                    Position pos = this.wayPointData.get(this.multSelIdx[i]);
                    if (!pos.isPOI()) {
                        pos.setPOI(true);
                    }
                    ++i;
                }
                return;
            }
            this.ignoreWPChanges = doReload = this.wayPointData.size() > this.WP_List.getRows();
            int i = 0;
            while (i < this.wayPointData.size()) {
                Position pos = this.wayPointData.get(i);
                if (!pos.isPOI()) {
                    pos.setPOI(true);
                }
                ++i;
            }
            if (doReload) {
                this.reloadList();
                this.ignoreWPChanges = false;
            }
        } else if (src == this.clearAllPOIMI) {
            boolean doReload;
            this.setUndo(true);
            if (this.multSelIdx.length > 0) {
                int i = 0;
                while (i < this.multSelIdx.length) {
                    Position pos = this.wayPointData.get(this.multSelIdx[i]);
                    if (pos.isPOI()) {
                        pos.setPOI(false);
                    }
                    ++i;
                }
                this.saveB.setEnabled(true);
                return;
            }
            this.ignoreWPChanges = doReload = this.wayPointData.size() > this.WP_List.getRows();
            int i = 0;
            while (i < this.wayPointData.size()) {
                Position pos = this.wayPointData.get(i);
                if (pos.isPOI()) {
                    pos.setPOI(false);
                }
                ++i;
            }
            if (doReload) {
                this.reloadList();
                this.ignoreWPChanges = false;
            }
            this.saveB.setEnabled(true);
        } else if (src == this.deleteAllPOIMI) {
            boolean doReload;
            if (!(this.localFiles || this.isWork || this.ckOwner("delete"))) {
                System.out.println("Skipping delete - not allowed");
                return;
            }
            this.ignoreWPChanges = doReload = this.wayPointData.size() > this.WP_List.getRows();
            this.setUndo(true);
            boolean poiFnd = false;
            int i = this.wayPointData.size() - 1;
            while (i >= 0) {
                Position pos = this.wayPointData.get(i);
                if (pos.isPOI()) {
                    this.wayPointData.removeElementAt(i);
                    if (!doReload) {
                        this.WP_List.deselect(i);
                        this.WP_List.remove(i);
                    }
                    poiFnd = true;
                }
                --i;
            }
            if (doReload) {
                this.reloadList();
                this.ignoreWPChanges = false;
            }
            this.saveB.setEnabled(poiFnd);
        } else if (src == this.copyToWork || src == this.copyToWorkMI) {
            if (this.WP_List.isMultipleMode()) {
                if (this.multSelIdx.length > 0) {
                    int i = 0;
                    while (i < this.multSelIdx.length) {
                        Position aPos = (Position)this.wayPointData.get(this.multSelIdx[i]).clone();
                        aPos.addEditWPUpdateListener(WayPointDefs.workSP);
                        WayPointDefs.workSP.wpChanged(new WPUpdateEvent(this, 1, aPos));
                        ++i;
                    }
                    this.copyToWork.setEnabled(false);
                    this.copyToWorkMI.setEnabled(false);
                }
                return;
            }
            if (this.selIdx < 0) {
                return;
            }
            if (WayPointDefs.workSP == null) {
                System.err.println("No Work page found!");
                this.copyToWork.setEnabled(false);
                this.copyToWorkMI.setEnabled(false);
                return;
            }
            Position aPos = (Position)this.wayPointData.get(this.selIdx).clone();
            aPos.addEditWPUpdateListener(WayPointDefs.workSP);
            WayPointDefs.workSP.wpChanged(new WPUpdateEvent(this, 1, aPos));
            this.copyToWork.setEnabled(false);
            this.copyToWorkMI.setEnabled(false);
        } else if (src == this.showDesc) {
            this.saveDesc();
        } else {
            System.err.println("ShowPositions.aP() - Unknown action " + ae);
        }
    }

    private boolean checkSaveFile() {
        String desc = this.showDesc.getText().trim();
        if (desc.equals("Select and copy waypoints from other lists to this one using the CopyToWork button.")) {
            new ErrDialog(this.listFrame, "Please change Work's description field");
            return false;
        }
        if (this.wayPointData.size() == 0) {
            new ErrDialog(this.listFrame, "No waypoints found to write.\nPlease add some waypoints.");
            return false;
        }
        this.wayPointData.description = desc.replace(';', '/');
        return true;
    }

    private void setUndo(boolean what) {
        if (what) {
            this.undoWPData = (Positions)this.wayPointData.clone();
            this.undoMI.setEnabled(true);
        } else {
            this.wayPointData = this.undoWPData;
            this.reloadList();
            this.undoWPData = null;
            this.undoMI.setEnabled(false);
        }
    }

    private void saveFile() {
        String recs = "";
        int savedMode = -9;
        if (this.wayPointData.fileName.toUpperCase().endsWith("WPT")) {
            this.wpI.doUpLoad(this.wayPointData);
        } else if (this.wayPointData.fileName.toUpperCase().endsWith("NTEC")) {
            this.wpI.doUpLoad(this.wayPointData);
        } else {
            if (this.wayPointData.fileName.toUpperCase().endsWith("NMEA")) {
                savedMode = Position.setParseMode(2);
            } else {
                if (!this.wayPointData.fileName.toLowerCase().endsWith(".wps")) {
                    this.wayPointData.fileName = this.wayPointData.fileName + ".wps";
                    this.wpI.logMsg("Output filename changed to: " + this.wayPointData.fileName + "\n");
                }
                recs = "# Owner=" + this.wayPointData.owner + "\n";
                recs = recs + "# Description=" + this.wayPointData.description + "\n";
            }
            int i = 0;
            while (i < this.wayPointData.size()) {
                recs = recs + this.wayPointData.get(i).getRecord() + "\r\n";
                ++i;
            }
            if (savedMode != -9) {
                Position.setParseMode(savedMode);
            }
            this.wpI.doUpLoad(this.wayPointData.fileName, recs);
        }
        this.wpI.logMsg((this.localFiles ? "Save" : "Write") + " of '" + this.wayPointData.description + "' (" + this.wayPointData.fileName + ") completed.\n");
        if (!this.localFiles) {
            new ShowMsgBox("File written to server", "Write of '" + this.wayPointData.description + "' (" + this.wayPointData.fileName + ") completed.", this.listFrame, false);
        }
    }

    public void textValueChanged(TextEvent te) {
        this.saveDesc();
    }

    private void saveDesc() {
        if (!this.allowDescUpdateF) {
            return;
        }
        this.wayPointData.description = this.showDesc.getText().trim().replace(';', '/');
    }

    private void reloadList() {
        this.WP_List.setVisible(false);
        this.WP_List.removeAll();
        int i = 0;
        while (i < this.wayPointData.size()) {
            this.WP_List.add(this.wayPointData.get(i).toString());
            ++i;
        }
        this.WP_List.setVisible(true);
    }

    public void WPCBPosted() {
        this.pasteMI.setEnabled(WayPointDefs.wpClipboard.hasContents());
    }

    private void exitProgram() {
        ChoiceOfYesOrNo cyn;
        if (this.saveB.isEnabled() && (this.localFiles || this.logInRec.loggedIn && this.changesMade && this.wayPointData.size() > 0) && !(cyn = new ChoiceOfYesOrNo(this.listFrame, "Do you want to EXIT without saving these waypoints?")).isYes()) {
            return;
        }
        this.listFrame.setVisible(false);
        this.listFrame.dispose();
        this.listFrame = null;
        if (this.isWork) {
            WayPointDefs.workSP = null;
        }
        this.wpI.closingWindow(this.wayPointData);
        if (this.localFiles) {
            ((GPSInterface2)this.wpI).removeGPSWriteableListener(this);
        }
        WayPointDefs.wpClipboard.removeCBListener(this);
    }

    private boolean ckOwner(String cmd) {
        if (!this.logInRec.userid.equals(this.wayPointData.owner)) {
            new ErrDialog(this.listFrame, "Must be owner to " + cmd);
            return false;
        }
        return true;
    }

    private void findInList() {
        int i = this.findWhere;
        while (i < this.WP_List.getItemCount()) {
            String rec = this.WP_List.getItem(i);
            int ix = rec.indexOf(this.findWhat);
            if (ix >= 0) {
                this.WP_List.select(i);
                this.findNextMI.setEnabled(true);
                this.findWhere = i + 1;
                return;
            }
            ++i;
        }
        new ErrDialog(this.listFrame, this.findWhat + " not found");
        this.findNextMI.setEnabled(false);
        this.findWhere = 0;
    }

    private void getImport() {
        String data = this.wpI.getImportedData();
        if (data.equals("")) {
            new ErrDialog(this.listFrame, "No data to import");
            return;
        }
        this.wpI.clearImportedData();
        int svMode = Position.resetParseMode();
        StringTokenizer tok = new StringTokenizer(data, "\r\n");
        boolean cnt = false;
        while (tok.hasMoreTokens()) {
            String rec = tok.nextToken();
            if (rec.startsWith("#")) continue;
            try {
                Position pos = new Position(rec);
                this.WP_List.add(pos.toString());
                this.wayPointData.add(pos);
                this.saveB.setEnabled(true);
            }
            catch (Exception ex) {
                new ErrDialog(this.listFrame, "Error: " + ex.getMessage() + "\n for: " + rec);
            }
        }
        Position.setParseMode(svMode);
    }

    void exportWPs() {
        int savedMode = Position.setParseMode(2);
        String recs = this.getWayPointRecs("\n");
        recs = recs.substring(0, recs.length() - 1);
        Position.setParseMode(savedMode);
        this.bldExportFrame(recs);
    }

    void exportWPs_CAPN() {
        String recs = "";
        int i = 0;
        while (i < this.wayPointData.size()) {
            Position p = this.wayPointData.get(i);
            if (p.isPOI()) {
                recs = recs + p.getName() + "," + (p.directionNorth() ? "" : "-") + p.decDegLat() + "," + (p.directionWest() ? "-" : "") + p.decDegLong() + "," + p.getRoute() + "\n";
            }
            ++i;
        }
        Frame frame = this.bldExportFrame(recs);
    }

    void exportWPs_MTec() {
        GetIntInput gii = new GetIntInput(this.listFrame, "Set Route number from 1 to 99", "Route number", 1, 99, 1);
        int routeNbr = gii.getValue();
        String recs = routeNbr + "|" + "\"" + this.wayPointData.description + "\"" + "|" + this.wayPointData.size() + "|" + "\"Exported from GPSComm pgm\"" + "|" + "1" + "\n";
        int i = 0;
        while (i < this.wayPointData.size()) {
            Position p = this.wayPointData.get(i);
            recs = recs + "\n" + routeNbr + "|" + (i + 1) + "|" + "\"" + p.getName() + "\"" + "|" + "\"" + p.getRoute() + "\"" + "|" + p.getDegLat("00") + p.getMinLat("00.0000") + "|" + p.getDirLat() + "|" + p.getDegLong("000") + p.getMinLong("00.0000") + "|" + p.getDirLong();
            ++i;
        }
        Frame aFrm = this.bldExportFrame(recs);
        new ShowMsgBox("Reminder!", "First line is for the ROUTES.txt file.\nDetail lines from line 3 go in the RWPS.txt file", aFrm, false);
    }

    void exportWPs_CMAP() {
        String recs = " {\n  #NM=" + this.wayPointData.description + "\n  #FL=00000000\n  #WP=" + this.wayPointData.size() + "\n  {\n";
        int i = 0;
        while (i < this.wayPointData.size()) {
            Position p = this.wayPointData.get(i);
            int lat = (int)(1.193046E7 * p.decDegLat()) * (p.directionNorth() ? 1 : -1);
            int lng = (int)(1.193046E7 * p.decDegLong()) * (p.directionWest() ? -1 : 1);
            recs = recs + "   x" + this.padLeft(Integer.toHexString(lng), 8) + "|" + "x" + this.padLeft(Integer.toHexString(lat), 8) + "|" + "#" + (p.hasGPSName() ? p.getGPSName() : "") + "|D(0,0,0,0,0)|R(0,0,0,0,0)|\n";
            ++i;
        }
        Frame aFrm = this.bldExportFrame(recs + "  }\n  #SR=0\n }");
        new ShowMsgBox("Reminder!", "Copy and Paste displayed data to the ROUTES.DAT file.\nCheck for valid name following #NM=\nChange the #RT= if the number of routes change.\nChange the #FL=00000000 to be unique and be sure\nthat there is one #FL=00000001.", aFrm, false);
    }

    String padLeft(String str, int len) {
        return "0000000".substring(0, len - str.length()) + str;
    }

    private Frame bldExportFrame(String recs) {
        final Frame exportFrame = new Frame();
        exportFrame.setTitle(this.listFrame.getTitle() + " in NMEA format");
        int exHt = Math.min(500, (8 + this.wayPointData.size()) * 22);
        exportFrame.setSize(400, exHt);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        exportFrame.setLocation((ss.width - exportFrame.getBounds().width) / 2, (ss.height - exportFrame.getBounds().height) / 2);
        exportFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                exportFrame.setVisible(false);
            }
        });
        TextArea exTA = new TextArea();
        exTA.setFont(new Font("Courier", 0, 14));
        exportFrame.add(exTA);
        exTA.append(recs);
        exportFrame.setVisible(true);
        return exportFrame;
    }

    public String getWayPointRecs(String trlr) {
        String recs = "";
        int i = 0;
        while (i < this.wayPointData.size()) {
            recs = recs + this.wayPointData.get(i).getRecord() + trlr;
            ++i;
        }
        if (recs.equals("")) {
            recs = "There is nothing in Work to export." + trlr;
        }
        return recs;
    }

    public void wpChanged(WPUpdateEvent wude) {
        if (this.ignoreWPChanges) {
            return;
        }
        this.changesMade = true;
        if (wude.getID() == 2) {
            if (this.selPos != null) {
                this.WP_List.replaceItem(this.selPos.toString(), this.selIdx);
            } else if (wude.getPos() != null) {
                System.out.println("update " + wude);
            }
        } else if (wude.getID() == 1) {
            if (this.selIdx == -1) {
                this.WP_List.add(wude.getPos().toString());
                this.wayPointData.add((Position)wude.getPos());
            } else {
                ++this.selIdx;
                this.selPos = (Position)wude.getPos();
                this.wayPointData.insertElementAt(this.selPos, this.selIdx);
                this.WP_List.add(this.selPos.toString(), this.selIdx);
                this.WP_List.select(this.selIdx);
            }
        } else if (wude.getID() == 9) {
            Position cp = (Position)wude.getPos();
            int i = 0;
            while (i < this.wayPointData.size()) {
                if (this.wayPointData.get(i) == cp) {
                    this.WP_List.replaceItem(cp.toString(), i);
                    return;
                }
                ++i;
            }
            System.err.println("wpChanged() Couldn't find pos=" + cp + "\n in >" + this.wayPointData);
            try {
                throw new Exception("who called?");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.err.println("Unknown id " + wude.getID());
            return;
        }
        this.saveB.setEnabled(true);
    }

    public void setSaveButton(boolean b) {
        this.saveB.setEnabled(b);
    }

    public void enableCopyToWork(boolean b) {
        if (!this.isWork && b && WayPointDefs.workSP == null) {
            return;
        }
        this.copyToWork.setEnabled(b);
        this.copyToWorkMI.setEnabled(b);
    }

    public void allowDescUpdate(boolean b) {
        this.allowDescUpdateF = b;
        if (this.showDesc != null) {
            this.showDesc.setEnabled(b);
            this.showDesc.addFocusListener(new MakeFocusLostDoAction());
        }
    }

    public void setChanged(boolean b) {
        this.changesMade = b;
    }

    public void setPasteMI(boolean b) {
        this.pasteMI.setEnabled(b);
    }

    public void toFront() {
        if (this.listFrame != null) {
            this.listFrame.toFront();
        }
    }

    public Frame getFrame() {
        return this.listFrame;
    }

    public void setColor(Color c) {
        this.saveColor = c;
        if (this.listFrame != null) {
            this.listFrame.setBackground(c);
            this.listFrame.repaint();
        }
    }

    public void setIcon(Image img) {
        this.saveIcon = img;
        if (this.listFrame != null) {
            this.listFrame.setIconImage(img);
        }
    }

    public void closeFrame() {
        if (this.listFrame != null) {
            this.listFrame.dispose();
            this.listFrame.setVisible(false);
        }
    }

    void computeCandD() {
        CandD cd = CandD.compGreatCircle(this.pos1, this.pos2);
        this.l3a.setText(cd.toString());
        this.l3a.invalidate();
        this.p3.validate();
    }

    static /* synthetic */ int[] access$202(ShowPositions x0, int[] x1) {
        x0.multSelIdx = x1;
        return x1;
    }
}

