/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import WayPointApps.ScaleBarCntrlr;
import WayPointApps.ScaleBarDisplayItem;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

final class ScaleBar
extends Canvas {
    public static final int WIDTH = 26;
    public static final int HEIGHT = 16;
    public static final int VERTICAL = 11;
    public static final int HORIZONTAL = 12;
    Dimension theSize;
    ScaleBarCntrlr sbc;
    int orientation;
    int value;
    int min;
    int max;
    int asc;
    int hF;
    Color bgColor = new Color(120, 240, 240);
    Color txtColor = Color.blue;

    public ScaleBar(ScaleBarCntrlr sbc, int or) {
        this.sbc = sbc;
        this.min = 0;
        this.max = 100;
        this.orientation = or;
        this.setBackground(this.bgColor);
    }

    public void setValues(int min, int max, int val) {
        this.min = min;
        this.max = max;
        this.value = val;
    }

    public void setValue(int v) {
        this.value = v;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (this.orientation == 11) {
            return new Dimension(26, this.getSize().height);
        }
        return new Dimension(this.getSize().width, 16);
    }

    public void paint(Graphics g) {
        if (this.asc == 0) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.asc = fm.getAscent();
            this.hF = fm.getHeight();
        }
        g.setColor(this.txtColor);
        Dimension d = this.getSize();
        int size = d.width;
        if (this.orientation == 11) {
            size = d.height;
        }
        ScaleBarDisplayItem[] sbdi = this.sbc.setScaleBarVal(this.orientation, size);
        int i = 0;
        while (i < sbdi.length) {
            if (sbdi[i] != null) {
                g.drawString(sbdi[i].str, sbdi[i].pt.x, sbdi[i].pt.y + this.asc);
            }
            ++i;
        }
    }
}

