/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import WayPointApps.BadPositionException;
import WayPointApps.Position;
import WayPointApps.WPFileRecs;
import WayPointApps.WayPointDefs;
import java.util.Vector;

public class Positions
extends Vector {
    public String owner = "";
    public String fileName = "";
    public String description = "";
    public boolean writeableToGPS = true;

    public Position get(int n) {
        return (Position)this.elementAt(n);
    }

    public void set(Position position, int n) {
        this.setElementAt(position, n);
    }

    public Positions(WPFileRecs wPFileRecs) throws BadPositionException {
        super(wPFileRecs.size() > 0 ? wPFileRecs.size() : 1);
        this.owner = wPFileRecs.owner;
        this.fileName = wPFileRecs.filename;
        this.description = wPFileRecs.description;
        int n = 0;
        while (n < wPFileRecs.size()) {
            this.addElement(wPFileRecs.pf.newPosition((String)wPFileRecs.elementAt(n)));
            ++n;
        }
    }

    public Positions(int n) {
        super(n);
    }

    public void add(Position position) {
        if (WayPointDefs.debug) {
            System.out.println("added position: " + position);
        }
        this.addElement(position);
    }

    public void moveUp(int n) {
        if (n > 0 && n < this.size()) {
            Position position = this.get(n);
            this.removeElementAt(n);
            this.insertElementAt(position, n - 1);
        }
    }

    public Position getPosition(String string) {
        int n = 0;
        while (n < this.size()) {
            if (((Position)this.elementAt(n)).getName().equals(string)) {
                return (Position)this.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public Object clone() {
        try {
            Positions positions = (Positions)super.clone();
            int n = 0;
            while (n < this.size()) {
                this.setElementAt(((Position)this.elementAt(n)).clone(), n);
                ++n;
            }
            return positions;
        }
        catch (Exception exception) {
            System.err.println("Error cloning Positions " + exception.getMessage());
            return null;
        }
    }

    public void moveDown(int n) {
        if (n >= 0 && n < this.size() - 1) {
            Position position = this.get(n);
            this.insertElementAt(position, n + 2);
            this.removeElementAt(n);
        }
    }
}

