/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import WayPointApps.BadPositionException;
import WayPointApps.EditWPUpdateListener;
import WayPointApps.MagVariation;
import WayPointApps.WPUpdateEvent;
import WayPointApps.WayPointDefs;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class Position
implements Cloneable {
    static final int PARSE_SETMODE = -1;
    public static final int PARSE_DEFAULT = 0;
    public static final int PARSE_NMEA = 2;
    static final int PARSE_GPSU = 3;
    public static final int PARSE_FIXEDCOL = 1;
    static String thisRoute = "";
    static int parseMode = -1;
    public static final String PtOfInterest = "POI";
    public static final String GPS_HDR = "&GPS=";
    public static final String Nbr_Hdr = "&NBR=";
    public static final int NO_NBR = -1;
    public static final int CHANGED = 9;
    final String NMEA_Prefix = "$";
    final int NMEA_Sent_ID_disp = 3;
    final String NMEA_Sent_ID = "WPL";
    final String NMEA_RecSep = ",";
    final char ReplChar = (char)32;
    static final String GPSU_Field_Seps = " ,";
    static final String[] GPSU_Fields = new String[]{"ID-", "Latitude", "Longitude", "Comment"};
    static int[] tokenPos = new int[]{-1, -1, -1, -1};
    static final int GPSU_ID = 0;
    static final int GPSU_LAT = 1;
    static final int GPSU_LONG = 2;
    static final int GPSU_COMMENT = 3;
    String aRoute = "";
    String wpName = "";
    String gpsName = "";
    String comments = "";
    int degreesLat;
    double minutesLat;
    String directionLat;
    double rectY;
    int degreesLong;
    double minutesLong;
    String directionLong;
    double rectX;
    int gpsSymbol;
    int gpsDisplay;
    int wpIdxNbr = -1;
    double variation;
    boolean getVar = true;
    boolean isPOI = false;
    boolean isEndOfLeg = false;
    EditWPUpdateListener ewpul;
    DecimalFormat decForm;
    DecimalFormat decForm2;
    final double CloseEnuf = 0.001;

    public void setIdxNbr(int i) {
        this.wpIdxNbr = i;
        this.noteUpdate();
    }

    public int getIdxNbr() {
        return this.wpIdxNbr;
    }

    public void clearIdxNbr() {
        this.wpIdxNbr = -1;
        this.noteUpdate();
    }

    public boolean hasWpNbr() {
        return this.wpIdxNbr != -1;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String c) {
        this.comments = c;
        this.noteUpdate();
    }

    public Position(String rec) throws BadPositionException {
        if (rec == null) {
            throw new BadPositionException("null record");
        }
        if (WayPointDefs.debug) {
            System.out.println("Position recd: " + rec);
        }
        if (parseMode == -1) {
            int idx;
            parseMode = rec.startsWith("$") && rec.indexOf("WPL") == 3 ? 2 : ((idx = rec.indexOf("\u00b0")) > 0 ? 1 : 0);
        }
        int degLat = -1;
        int degLong = -1;
        double minLat = -1.0;
        double minLong = -1.0;
        String dirLat = "";
        String dirLong = "";
        if (parseMode == 0) {
            StringTokenizer tok = new StringTokenizer(rec, ";", false);
            if (tok.countTokens() < 8) {
                System.err.println("Invalid record, too few fields. " + tok.countTokens() + " vs 8 for:\n" + rec);
                throw new BadPositionException("Invalid record, too few fields. " + tok.countTokens() + " vs 8");
            }
            this.aRoute = tok.nextToken();
            this.wpName = tok.nextToken();
            this.ckForGPSName();
            degLat = Integer.parseInt(tok.nextToken());
            minLat = Double.valueOf(tok.nextToken());
            dirLat = tok.nextToken();
            degLong = Integer.parseInt(tok.nextToken());
            minLong = Double.valueOf(tok.nextToken());
            dirLong = tok.nextToken();
            if (tok.hasMoreElements()) {
                String temp = tok.nextToken();
                if (temp.equals(PtOfInterest)) {
                    this.isPOI = true;
                } else {
                    this.comments = temp;
                }
            }
            this.setPosition(degLat, minLat, dirLat, degLong, minLong, dirLong);
        } else if (parseMode == 1) {
            try {
                this.aRoute = thisRoute;
                int x = rec.indexOf("\u00b0");
                int y = this.findFirstDigit(rec, x);
                this.wpName = rec.substring(0, y + 1).trim();
                degLat = Integer.parseInt(rec.substring(y + 1, x));
                y = this.findLastDigit(rec, x + 1);
                minLat = Double.valueOf(rec.substring(x + 1, y));
                dirLat = rec.substring(y, y + 1);
                x = rec.indexOf("\u00b0", y + 1);
                y = this.findFirstDigit(rec, x);
                degLong = Integer.parseInt(rec.substring(y + 1, x));
                y = this.findLastDigit(rec, x + 1);
                minLong = Double.valueOf(rec.substring(x + 1, y));
                dirLong = rec.substring(y, y + 1);
                this.comments = rec.substring(y + 1).trim();
            }
            catch (Exception ex) {
                System.err.println("Position FixedCol ex: " + ex);
            }
            if (WayPointDefs.debug) {
                System.out.println("Position: parsed: >" + this.wpName + "< Lat: " + degLat + " " + minLat + dirLat + ", Long: " + degLong + " " + minLong + dirLong);
            }
            this.setPosition(degLat, minLat, dirLat, degLong, minLong, dirLong);
        } else if (parseMode == 2) {
            StringTokenizer tok = new StringTokenizer(rec, ",", false);
            String fld = tok.nextToken();
            if (!fld.startsWith("$") || fld.indexOf("WPL") != 3) {
                throw new BadPositionException("Invalid NMEA Waypoint record: " + rec);
            }
            fld = tok.nextToken();
            degLat = Integer.parseInt(fld.substring(0, 2));
            minLat = Double.valueOf(fld.substring(2));
            dirLat = tok.nextToken();
            fld = tok.nextToken();
            degLong = Integer.parseInt(fld.substring(0, 3));
            minLong = Double.valueOf(fld.substring(3));
            dirLong = tok.nextToken();
            this.wpName = tok.nextToken().replace(";".charAt(0), ' ');
            if (tok.hasMoreTokens()) {
                this.comments = tok.nextToken().trim().replace(";".charAt(0), ' ');
            }
            this.aRoute = this.comments.equals("") ? this.wpName : this.comments;
            this.setPosition(degLat, minLat, dirLat, degLong, minLong, dirLong);
        } else if (parseMode == 3) {
            StringTokenizer st = new StringTokenizer(rec, GPSU_Field_Seps);
            String[] toks = this.parseST(st);
            this.wpName = toks[tokenPos[0]];
            String lat = toks[tokenPos[1]];
            if (lat.endsWith("'")) {
                lat = lat.substring(0, lat.length() - 1);
            }
            dirLat = lat.substring(0, 1);
            degLat = Integer.parseInt(lat.substring(1, 3));
            minLat = Double.valueOf(lat.substring(4));
            String longit = toks[tokenPos[2]];
            if (longit.endsWith("'")) {
                longit = longit.substring(0, longit.length() - 1);
            }
            dirLong = longit.substring(0, 1);
            degLong = Integer.parseInt(longit.substring(1, 4));
            minLong = Double.valueOf(longit.substring(5));
            this.aRoute = toks[tokenPos[3]];
            if (tokenPos[3] < toks.length) {
                int i = tokenPos[3] + 1;
                while (i < toks.length) {
                    this.aRoute = this.aRoute + " " + toks[i];
                    ++i;
                }
            }
            this.setPosition(degLat, minLat, dirLat, degLong, minLong, dirLong);
        } else {
            System.err.println("Position: invalid parseMode: " + parseMode + " " + rec);
        }
    }

    private String[] parseST(StringTokenizer st) {
        String[] s = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            s[i++] = st.nextToken();
        }
        return s;
    }

    String getDirection(String str) {
        return str.substring(0, 1);
    }

    int getDegrees(String str, int len) {
        int ix = 1;
        return Integer.parseInt(str.substring(ix, ix + len));
    }

    double getMinutes(String str, int off) {
        return Double.valueOf(str.substring(off));
    }

    private int findFirstDigit(String rec, int x) {
        int y = x - 1;
        while (y > 0) {
            if (!Character.isDigit(rec.charAt(y))) break;
            --y;
        }
        return y;
    }

    private int findLastDigit(String rec, int x) {
        int y = x;
        while (y < rec.length()) {
            if (!Character.isDigit(rec.charAt(y)) && rec.charAt(y) != '.') break;
            ++y;
        }
        return y;
    }

    private void ckForGPSName() throws BadPositionException {
        int ix = this.wpName.indexOf(GPS_HDR);
        if (ix > 0) {
            this.gpsName = this.wpName.substring(ix + GPS_HDR.length());
            int iy = this.gpsName.indexOf(Nbr_Hdr);
            if (iy > 0) {
                try {
                    String wpn = this.gpsName.substring(iy + Nbr_Hdr.length());
                    this.wpIdxNbr = Integer.parseInt(wpn);
                }
                catch (Exception ex) {
                    throw new BadPositionException("Invalid waypoint number");
                }
                this.gpsName = this.gpsName.substring(0, iy);
            } else if (this.hasWpNbr()) {
                this.wpIdxNbr = -1;
            }
            this.wpName = this.wpName.substring(0, ix);
            if (WayPointDefs.debug) {
                System.out.println("Position.ckForGPSName: wpn:" + this.wpName + ", gn:" + this.gpsName + ", wp#:" + this.wpIdxNbr);
            }
        } else {
            if (this.hasGPSName()) {
                this.gpsName = "";
            }
            if (this.hasWpNbr()) {
                this.wpIdxNbr = -1;
            }
        }
    }

    public Position(int degLat, double minLat, String dirLat, int degLong, double minLong, String dirLong) throws BadPositionException {
        this.setPosition(degLat, minLat, dirLat, degLong, minLong, dirLong);
    }

    public Position(double degLat, String dirLat, double degLong, String dirLong) throws BadPositionException {
        this.setPosition((int)degLat, degLat % 1.0 * 60.0, dirLat, (int)degLong, degLong % 1.0 * 60.0, dirLong);
    }

    public Position(int degLat, String dirLat, int degLong, String dirLong) {
        try {
            this.getVar = false;
            this.setPosition(degLat, 0.0, dirLat, degLong, 0.0, dirLong);
        }
        catch (Exception ex) {
            System.err.println("Invalid position " + ex);
            ex.printStackTrace();
        }
    }

    public Object clone() {
        try {
            Position p = (Position)super.clone();
            p.ewpul = null;
            return p;
        }
        catch (CloneNotSupportedException cns) {
            System.err.println("clone " + cns);
            return null;
        }
    }

    public void setPosition(int degLat, double minLat, String dirLat, int degLong, double minLong, String dirLong) throws BadPositionException {
        if (degLat > 90 || degLong > 180 || degLat < 0 || degLong < 0) {
            throw new BadPositionException("Invalid degrees Lat:" + degLat + ", Long:" + degLong + " for " + this.wpName);
        }
        if (minLat > 90.0 || minLong > 90.0 || minLat < 0.0 || minLong < 0.0) {
            throw new BadPositionException("Invalid minutes Lat: " + minLat + ", Long: " + minLong + " for " + this.wpName);
        }
        if (!dirLat.equals("N") && !dirLat.equals("S") || !dirLong.equals("E") && !dirLong.equals("W")) {
            throw new BadPositionException("Invalid directions: " + dirLat + " " + dirLong + " " + this.wpName);
        }
        this.degreesLat = degLat;
        this.minutesLat = minLat;
        this.directionLat = dirLat;
        this.degreesLong = degLong;
        this.minutesLong = minLong;
        this.directionLong = dirLong;
        this.isEndOfLeg = this.aRoute.equals("End Of Leg");
        if (this.isEndOfLeg) {
            this.wpName = "End Of Leg";
        }
        this.rectX = this.directionWest() ? (double)(180 - this.degreesLong) - this.minutesLong / 60.0 : (double)(180 + this.degreesLong) + this.minutesLong / 60.0;
        this.rectY = this.directionNorth() ? (double)(90 - this.degreesLat) - this.minutesLat / 60.0 : (double)(90 + this.degreesLat) + this.minutesLat / 60.0;
        if (WayPointDefs.debug) {
            System.out.println("setPos: " + this.wpName + " (" + this.aRoute + ")" + " Rect: " + this.rectX + " " + this.rectY);
        }
        this.decForm = (DecimalFormat)NumberFormat.getNumberInstance();
        this.decForm.setMaximumFractionDigits(3);
        this.decForm2 = new DecimalFormat("00.000");
        if (this.getVar) {
            this.variation = MagVariation.getVariation(this);
        }
    }

    public void addEditWPUpdateListener(EditWPUpdateListener l) {
        if (this.ewpul != null && this.ewpul != l) {
            System.err.println("addEditWPUpdateListener() previously called by " + this.ewpul + ", new caller " + l);
        }
        this.ewpul = l;
    }

    private void noteUpdate() {
        if (this.ewpul != null) {
            this.ewpul.wpChanged(new WPUpdateEvent(this, 9, this));
        }
    }

    public static int resetParseMode() {
        thisRoute = "Imported";
        int save = parseMode;
        parseMode = -1;
        return save;
    }

    public static int setParseMode(int p) {
        int savedMode = parseMode;
        parseMode = p;
        return savedMode;
    }

    public boolean isPOI() {
        return this.isPOI;
    }

    public void setPOI(boolean b) {
        this.isPOI = b;
        this.noteUpdate();
    }

    public boolean isEndOfLeg() {
        return this.isEndOfLeg;
    }

    public void setIsEndOfLeg(boolean b) {
        this.isEndOfLeg = b;
        this.noteUpdate();
    }

    public boolean hasGPSName() {
        return !this.gpsName.equals("");
    }

    public void setRoute(String r) {
        this.aRoute = r;
        this.noteUpdate();
    }

    public void setName(String nm) throws BadPositionException {
        this.wpName = nm;
        this.ckForGPSName();
        this.noteUpdate();
    }

    public void setDegLong(double deg) {
        this.degreesLong = (int)deg;
        this.minutesLong = deg % 1.0 * 60.0;
        if (this.minutesLong >= 60.0) {
            ++this.degreesLong;
            this.minutesLong -= 60.0;
        }
        this.rectX = this.directionWest() ? (double)(180 - this.degreesLong) - this.minutesLong / 60.0 : (double)(180 + this.degreesLong) + this.minutesLong / 60.0;
    }

    public void setDegLat(double deg) {
        this.degreesLat = (int)deg;
        this.minutesLat = deg % 1.0 * 60.0;
        if (this.minutesLat >= 60.0) {
            ++this.degreesLat;
            this.minutesLat -= 60.0;
        }
        this.rectY = this.directionNorth() ? (double)(90 - this.degreesLat) - this.minutesLat / 60.0 : (double)(90 + this.degreesLat) + this.minutesLat / 60.0;
    }

    public void setGPSName(String nm) {
        this.gpsName = nm;
        this.noteUpdate();
    }

    public void setGPSSymbol(int s) {
        this.gpsSymbol = s;
    }

    public int getGPSSymbol() {
        return this.gpsSymbol;
    }

    public void setGPSDisplay(int d) {
        this.gpsDisplay = d;
    }

    public int getGPSDisplay() {
        return this.gpsDisplay;
    }

    public boolean samePosition(Position pos) {
        if (WayPointDefs.debug) {
            System.out.println("Comparing: " + this.toString() + "\n   vs      " + pos.toString());
            System.out.println("Cmprs: " + (this.degreesLat == pos.degreesLat) + " " + (Math.abs(this.minutesLat - pos.minutesLat) < 0.001) + " " + this.directionLat.equals(pos.directionLat) + " " + (this.degreesLong == pos.degreesLong) + " " + (Math.abs(this.minutesLong - pos.minutesLong) < 0.001) + " " + this.directionLong.equals(pos.directionLong) + "     " + this.minutesLat + " " + pos.minutesLat);
        }
        return this.degreesLat == pos.degreesLat && Math.abs(this.minutesLat - pos.minutesLat) < 0.001 && this.directionLat.equals(pos.directionLat) && this.degreesLong == pos.degreesLong && Math.abs(this.minutesLong - pos.minutesLong) < 0.001 && this.directionLong.equals(pos.directionLong);
    }

    public String toString() {
        if (this.isEndOfLeg) {
            return this.aRoute;
        }
        return this.aRoute + " " + this.wpName + (this.hasGPSName() ? GPS_HDR + this.gpsName : "") + (this.hasWpNbr() ? Nbr_Hdr + this.wpIdxNbr : "") + " " + this.degreesLat + "\u00b0" + " " + this.decForm.format(this.minutesLat) + "'" + this.directionLat + "  " + this.degreesLong + "\u00b0" + " " + this.decForm.format(this.minutesLong) + "'" + this.directionLong + (this.isPOI ? "; Pt Of Interest" : "");
    }

    public String getRecord() {
        if (this.isEndOfLeg) {
            return this.aRoute;
        }
        if (parseMode == 2) {
            return "$GPWPL," + this.RMC("00" + this.degreesLat, 2) + this.decForm2.format(this.minutesLat) + "," + this.directionLat + "," + this.RMC("000" + this.degreesLong, 3) + this.decForm2.format(this.minutesLong) + "," + this.directionLong + "," + this.wpName;
        }
        return this.aRoute + ";" + this.wpName + (this.hasGPSName() ? GPS_HDR + this.gpsName : "") + (this.hasWpNbr() ? Nbr_Hdr + this.wpIdxNbr : "") + ";" + this.degreesLat + ";" + this.decForm.format(this.minutesLat) + ";" + this.directionLat + ";" + this.degreesLong + ";" + this.decForm.format(this.minutesLong) + ";" + this.directionLong + (this.isPOI ? ";POI" : "");
    }

    private String RMC(String s, int l) {
        return s.substring(s.length() - l);
    }

    public String getDescription() {
        return this.aRoute;
    }

    public String getRoute() {
        return this.aRoute;
    }

    public String getName() {
        return this.wpName;
    }

    public String getGPSName() {
        return this.gpsName;
    }

    public String getDegLat() {
        return "" + this.degreesLat;
    }

    public int getDegLatI() {
        return this.degreesLat;
    }

    public String getDegLat(String pat) {
        DecimalFormat decForm1 = new DecimalFormat(pat);
        return decForm1.format(this.degreesLat);
    }

    public String getLatString() {
        return "" + this.degreesLat + "\u00b0" + " " + this.decForm.format(this.minutesLat) + "'" + this.directionLat;
    }

    public String getMinLat() {
        return this.decForm.format(this.minutesLat);
    }

    public String getMinLat(String pat) {
        DecimalFormat decForm1 = new DecimalFormat(pat);
        return decForm1.format(this.minutesLat);
    }

    public double getMinLatD() {
        return this.minutesLat;
    }

    public String getDirLat() {
        return this.directionLat;
    }

    public String getDegLong() {
        return "" + this.degreesLong;
    }

    public int getDegLongI() {
        return this.degreesLong;
    }

    public String getDegLong(String pat) {
        DecimalFormat decForm1 = new DecimalFormat(pat);
        return decForm1.format(this.degreesLong);
    }

    public String getLongString() {
        return "" + this.degreesLong + "\u00b0" + " " + this.decForm.format(this.minutesLong) + "'" + this.directionLong;
    }

    public String getMinLong() {
        return this.decForm.format(this.minutesLong);
    }

    public String getMinLong(String pat) {
        DecimalFormat decForm1 = new DecimalFormat(pat);
        return decForm1.format(this.minutesLong);
    }

    public String getDirLong() {
        return this.directionLong;
    }

    public double getMinLongD() {
        return this.minutesLong;
    }

    public double decDegLat() {
        return (double)this.degreesLat + this.minutesLat / 60.0;
    }

    public double radDegLat() {
        return this.decDegLat() * (Math.PI / 180);
    }

    public double decDegLong() {
        return (double)this.degreesLong + this.minutesLong / 60.0;
    }

    public double radDegLong() {
        return this.decDegLong() * (Math.PI / 180);
    }

    public double getVariation() {
        return this.variation;
    }

    public boolean directionNorth() {
        return this.directionLat.equals("N");
    }

    public boolean directionWest() {
        return this.directionLong.equals("W");
    }

    Point getNormalPosition(double scale) {
        return new Point((int)(scale * this.rectX), (int)(scale * this.rectY));
    }

    public static void parseGPSU_F_Rec(String rec) {
        parseMode = 3;
        StringTokenizer st = new StringTokenizer(rec, GPSU_Field_Seps);
        int fp = -1;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            ++fp;
            boolean fnd = false;
            int i = 0;
            while (i < tokenPos.length) {
                if (tok.startsWith(GPSU_Fields[i])) {
                    Position.tokenPos[i] = fp;
                    if (WayPointDefs.debug) {
                        System.out.println("Field " + tok + " at position " + fp);
                    }
                    fnd = true;
                    break;
                }
                ++i;
            }
            if (fnd || !WayPointDefs.debug) continue;
            System.out.println("Skipping: >" + tok + "< at " + fp);
        }
    }

    public static Position getPosition(Point p, int scale) {
        int degLat = 0;
        int degLong = 0;
        double minLat = 0.0;
        double minLong = 0.0;
        String dirLat = "N";
        String dirLong = "W";
        try {
            int pX = p.x / scale;
            int pY = p.y / scale;
            minLat = (double)(p.y % scale * 60) / ((double)scale * 1.0);
            if (pY >= 90) {
                dirLat = "S";
                degLat = pY - 90;
            } else {
                degLat = 89 - pY;
                minLat = 60.0 - minLat;
            }
            if (minLat >= 60.0) {
                minLat = 0.0;
                ++degLat;
            }
            minLong = (double)(p.x % scale * 60) / ((double)scale * 1.0);
            if (pX >= 180) {
                degLong = pX - 180;
                dirLong = "E";
            } else {
                degLong = 179 - pX;
                minLong = 60.0 - minLong;
            }
            if (minLong >= 60.0) {
                minLong = 0.0;
                ++degLong;
            }
            if (WayPointDefs.debug) {
                System.out.println("getPos(): " + p + ", " + degLat + " " + minLat + ", " + degLong + " " + minLong + ",  scale:" + scale);
            }
            return new Position(degLat, minLat, dirLat, degLong, minLong, dirLong);
        }
        catch (BadPositionException bpe) {
            System.err.println("Bad position created in getPosition. Point=" + p + " scale=" + scale + "   " + bpe.getMessage());
            return null;
        }
    }
}

