/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import NormsTools.GetInput;
import NormsTools.ShowMsgBox;
import WayPointApps.BadPositionException;
import WayPointApps.CandD;
import WayPointApps.Position;
import WayPointApps.Positions;
import WayPointApps.ScaleBar;
import WayPointApps.ScaleBarCntrlr;
import WayPointApps.ScaleBarDisplayItem;
import WayPointApps.WPUpdateEvent;
import WayPointApps.WayPointDefs;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public final class PlotWayPoints
implements ActionListener,
AdjustmentListener,
ItemListener,
ScaleBarCntrlr {
    static final int MAX_CANVAS_SIZE = 500;
    static final int INSET = 20;
    Positions wayPointData;
    private final int TwoDecDigitMax = 10;
    DecimalFormat wholeForm;
    DecimalFormat wholeLongForm;
    DecimalFormat tenthsForm;
    DecimalFormat hundrethsForm;
    final boolean pwpDebug = false;
    Frame plotFrame;
    String plotFrameTitle = "";
    PlotPanel pp;
    MenuBar mbar = new MenuBar();
    Menu scale = new Menu("Scale");
    Menu view = new Menu("View");
    Menu options = new Menu("Options");
    MenuItem ZoomIn = new MenuItem("ZoomIn");
    MenuItem ZoomOut = new MenuItem("ZoomOut");
    MenuItem clearLabels = new MenuItem("Clear labels");
    MenuItem incrFont = new MenuItem("Incr Font");
    MenuItem decrFont = new MenuItem("Decr Font");
    CheckboxMenuItem showLabels = new CheckboxMenuItem("Show labels");
    CheckboxMenuItem showPOI = new CheckboxMenuItem("Show Points of Interest(POI)");
    CheckboxMenuItem showNames = new CheckboxMenuItem("Show names");
    CheckboxMenuItem showLegs = new CheckboxMenuItem("Show legs", true);
    CheckboxMenuItem showSBCBMI = new CheckboxMenuItem("Use Scrollbars", true);
    CheckboxMenuItem showLLCBMI = new CheckboxMenuItem("Show lat/long lines");
    CheckboxMenuItem showKnots = new CheckboxMenuItem("Show kts for tracklog");
    final String MarkPOIID = "Mark as POI";
    final String ClearPOIID = "Clear POI";
    PopupMenu posDetailsPUM = new PopupMenu("Position Details");
    MenuItem showInfoMI = new MenuItem("Waypoint Info");
    MenuItem copyToWorkMI = new MenuItem("Copy to Work");
    MenuItem markAsPOIMI = new MenuItem("Mark as POI");
    MenuItem chngWPNameMI = new MenuItem("Change WP name");
    Scrollbar hScrollB = new Scrollbar(0);
    Scrollbar vScrollB = new Scrollbar(1);
    ScaleBar hScaleB = new ScaleBar(this, 12);
    ScaleBar vScaleB = new ScaleBar(this, 11);
    Cursor zoomCursor = Cursor.getPredefinedCursor(1);
    Cursor defCursor = Cursor.getPredefinedCursor(0);
    Cursor moveCursor = Cursor.getPredefinedCursor(13);
    Cursor handCursor = Cursor.getPredefinedCursor(12);
    Font dispFont = new Font("Serif", 0, 10);
    int OriginPtX;
    int OriginPtY;
    int ZeroZeroPtX;
    int ZeroZeroPtY;
    final int DegFactor = 10000;
    double scalingFactor;
    int zoomFactor = 1;
    boolean zoomingIn = false;
    boolean zoomingOut = false;
    final int NbrLinesLL = 6;
    double degWidth;
    double degHeight;
    Position topLeftCorner = null;
    int northMostNorm;
    int westMostNorm;

    public PlotWayPoints(Positions wpd) {
        try {
            this.wayPointData = wpd;
            this.pp = new PlotPanel(this.wayPointData.size(), this.hScrollB, this.vScrollB);
            this.tenthsForm = (DecimalFormat)NumberFormat.getNumberInstance();
            this.tenthsForm.setMaximumFractionDigits(1);
            this.hundrethsForm = (DecimalFormat)NumberFormat.getNumberInstance();
            this.hundrethsForm.setMaximumFractionDigits(2);
            this.wholeForm = (DecimalFormat)NumberFormat.getNumberInstance();
            this.wholeForm.setMaximumFractionDigits(0);
            this.wholeLongForm = new DecimalFormat("000");
            this.plotFrame = new Frame();
            this.plotFrameTitle = "Plot of " + this.wayPointData.description;
            this.plotFrame.setTitle(this.plotFrameTitle);
            Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
            this.plotFrame.setSize(ss.width - 200, ss.height - 40);
            this.plotFrame.setLocation(100, 0);
            this.plotFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    PlotWayPoints.this.plotFrame.setVisible(false);
                    PlotWayPoints.this.plotFrame.dispose();
                }
            });
            this.ZoomIn.addActionListener(this);
            this.scale.add(this.ZoomIn);
            this.ZoomOut.setEnabled(false);
            this.ZoomOut.addActionListener(this);
            this.scale.add(this.ZoomOut);
            this.mbar.add(this.scale);
            this.showLabels.addItemListener(this);
            this.view.add(this.showLabels);
            this.showPOI.addItemListener(this);
            this.view.add(this.showPOI);
            this.showNames.addItemListener(this);
            this.view.add(this.showNames);
            this.showLegs.addItemListener(this);
            this.view.add(this.showLegs);
            this.clearLabels.addActionListener(this);
            this.view.add(this.clearLabels);
            this.view.addSeparator();
            this.view.add(this.showSBCBMI);
            this.showSBCBMI.addItemListener(this);
            this.view.add(this.showLLCBMI);
            this.showLLCBMI.addItemListener(this);
            this.mbar.add(this.view);
            this.options.add(this.showKnots);
            this.showKnots.addItemListener(this);
            this.mbar.add(this.options);
            this.plotFrame.setMenuBar(this.mbar);
            this.showInfoMI.addActionListener(this.pp);
            this.posDetailsPUM.add(this.showInfoMI);
            this.copyToWorkMI.addActionListener(this.pp);
            this.posDetailsPUM.add(this.copyToWorkMI);
            this.chngWPNameMI.addActionListener(this.pp);
            this.posDetailsPUM.add(this.chngWPNameMI);
            this.copyToWorkMI.setEnabled(WayPointDefs.workSP != null);
            this.posDetailsPUM.addSeparator();
            this.markAsPOIMI.addActionListener(this.pp);
            this.posDetailsPUM.add(this.markAsPOIMI);
            this.plotFrame.add(this.posDetailsPUM);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.ZoomIn) {
            if (this.zoomingIn) {
                this.pp.setCursor(this.defCursor);
                this.zoomingIn = false;
                this.ZoomIn.setLabel("ZoomIn");
            } else {
                this.pp.setCursor(this.zoomCursor);
                this.zoomingIn = true;
                this.ZoomIn.setLabel("ZoomIn ON");
                this.zoomingOut = false;
                this.ZoomOut.setLabel("ZoomOut");
                if (this.zoomFactor == 1 && this.showSBCBMI.getState()) {
                    this.addScrollBars();
                }
            }
        } else if (src == this.ZoomOut) {
            if (this.zoomingOut) {
                this.zoomingOut = false;
                this.ZoomOut.setLabel("ZoomOut");
                this.pp.setCursor(this.defCursor);
            } else {
                if (this.zoomFactor == 1) {
                    System.err.println(">*>*>*>*>Zoom Out with factor=1 ???");
                    this.removeScrollBars();
                    this.ZoomOut.setEnabled(false);
                    return;
                }
                this.zoomingOut = true;
                this.ZoomOut.setLabel("ZoomOut ON");
                this.zoomingIn = false;
                this.ZoomIn.setLabel("ZoomIn");
                this.pp.setCursor(this.zoomCursor);
            }
        } else if (src == this.incrFont) {
            this.dispFont = new Font(this.dispFont.getName(), this.dispFont.getStyle(), this.dispFont.getSize() + 1);
        } else if (src == this.decrFont) {
            this.dispFont = new Font(this.dispFont.getName(), this.dispFont.getStyle(), this.dispFont.getSize() - 1);
        } else if (src == this.clearLabels) {
            this.showLabels.setState(false);
            this.showPOI.setState(false);
            this.showNames.setState(false);
            this.pp.clearLabels();
        } else {
            System.err.println("Unknown ae " + ae);
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        Object src = ie.getSource();
        if (src == this.showLabels || src == this.showNames || src == this.showLegs || src == this.showPOI) {
            this.pp.repaint();
        } else if (src == this.showSBCBMI) {
            if (this.showSBCBMI.getState()) {
                this.addScrollBars();
            } else {
                this.removeScrollBars();
            }
        } else if (src == this.showLLCBMI) {
            this.pp.repaint();
        } else if (src != this.showKnots) {
            System.err.println("Unknown item event: " + ie);
        }
    }

    void addScrollBars() {
        this.plotFrame.add((Component)this.hScrollB, "South");
        this.hScrollB.addAdjustmentListener(this);
        this.plotFrame.add((Component)this.vScrollB, "East");
        this.vScrollB.addAdjustmentListener(this);
        this.plotFrame.validate();
    }

    void removeScrollBars() {
        this.hScrollB.setValue(0);
        this.vScrollB.setValue(0);
        this.plotFrame.remove(this.hScrollB);
        this.plotFrame.remove(this.vScrollB);
        this.plotFrame.validate();
    }

    public void adjustmentValueChanged(AdjustmentEvent ae) {
        Object src = ae.getSource();
        if (src == this.hScrollB) {
            this.hScaleB.setValue(this.hScrollB.getValue());
        } else if (src == this.vScrollB) {
            this.vScaleB.setValue(this.vScrollB.getValue());
        } else {
            System.out.println("Unknown adjustment" + ae);
        }
        this.pp.sbChanged(this.hScrollB, this.vScrollB);
        if (WayPointDefs.plot_debug) {
            Scrollbar sb = (Scrollbar)ae.getSource();
            System.out.println("Adj SB " + (sb.getOrientation() == 1 ? "ver" : "hor") + " Val=" + sb.getValue() + " Ui=" + sb.getUnitIncrement() + " Bi=" + sb.getBlockIncrement() + " max=" + sb.getMaximum() + " vis=" + sb.getVisibleAmount());
        }
    }

    public ScaleBarDisplayItem[] setScaleBarVal(int or, int size) {
        if (or == 11) {
            ScaleBarDisplayItem[] sbdis = new ScaleBarDisplayItem[4];
            int y = (int)((double)this.vScrollB.getValue() / (this.scalingFactor * (double)this.zoomFactor) + (double)this.OriginPtY);
            if (y < 0) {
                y = 0;
            }
            Position p = Position.getPosition(new Point(0, y), 10000);
            sbdis[0] = new ScaleBarDisplayItem(new Point(0, 0), p.getDegLat() + "\u00b0");
            sbdis[1] = new ScaleBarDisplayItem(new Point(0, 15), p.getMinLat() + "'" + p.getDirLat());
            if (this.vScrollB.getVisibleAmount() == this.vScrollB.getMaximum()) {
                return sbdis;
            }
            int halfWay = this.vScrollB.getVisibleAmount() / 2;
            if (halfWay <= 10) {
                halfWay = this.pp.getSize().height / 2;
            }
            y = (int)((double)(this.vScrollB.getValue() + halfWay) / (this.scalingFactor * (double)this.zoomFactor) + (double)this.OriginPtY);
            p = Position.getPosition(new Point(0, y), 10000);
            sbdis[2] = new ScaleBarDisplayItem(new Point(0, size / 2 - 15), p.getDegLat() + "\u00b0");
            sbdis[3] = new ScaleBarDisplayItem(new Point(0, size / 2), p.getMinLat() + "'" + p.getDirLat());
            return sbdis;
        }
        ScaleBarDisplayItem[] sbdis = new ScaleBarDisplayItem[2];
        int x = (int)((double)this.hScrollB.getValue() / (this.scalingFactor * (double)this.zoomFactor) + (double)this.OriginPtX);
        if (x < 0) {
            x = 0;
        }
        Position p = Position.getPosition(new Point(x, 0), 10000);
        sbdis[0] = new ScaleBarDisplayItem(new Point(0, 0), p.getDegLong() + "\u00b0" + " " + p.getMinLong() + "'" + p.getDirLong());
        if (this.hScrollB.getVisibleAmount() == this.hScrollB.getMaximum()) {
            return sbdis;
        }
        int halfWay = this.hScrollB.getVisibleAmount() / 2;
        if (halfWay <= 10) {
            halfWay = this.pp.getSize().width / 2;
        }
        x = (int)((double)(this.hScrollB.getValue() + halfWay) / (this.scalingFactor * (double)this.zoomFactor) + (double)this.OriginPtX);
        p = Position.getPosition(new Point(x, 0), 10000);
        sbdis[1] = new ScaleBarDisplayItem(new Point(size / 2 - 15, 0), p.getDegLong() + "\u00b0" + " " + p.getMinLong() + "'" + p.getDirLong());
        return sbdis;
    }

    public void plotWP() {
        double factor;
        int wm = 3600000;
        int nm = 1800000;
        int em = 0;
        int sm = 0;
        double northernMostDeg = 0.0;
        double westernMostDeg = 0.0;
        String northernMostDir = "N";
        String westernMostDir = "W";
        Position lastPos = null;
        CandD cd = null;
        Dimension ppSize = this.pp.getSize();
        Enumeration en = this.wayPointData.elements();
        while (en.hasMoreElements()) {
            Position pos = (Position)en.nextElement();
            Point tp = pos.getNormalPosition(10000.0);
            if (WayPointDefs.plot_debug) {
                System.out.println("plotWP() pos: " + pos.getName() + ", normalPos= " + tp + ",  " + Position.getPosition(tp, 10000));
            }
            cd = lastPos != null && !pos.isPOI() ? CandD.compGreatCircle(lastPos, pos) : null;
            this.pp.addPoint(tp, pos, cd);
            if (pos.getName().equals("End Of Leg")) continue;
            if (tp.x < wm) {
                wm = tp.x;
                westernMostDeg = pos.decDegLong();
                westernMostDir = pos.getDirLong();
            }
            if (tp.x > em) {
                em = tp.x;
            }
            if (tp.y < nm) {
                nm = tp.y;
                northernMostDeg = pos.decDegLat();
                northernMostDir = pos.getDirLat();
            }
            if (tp.y > sm) {
                sm = tp.y;
            }
            lastPos = pos;
        }
        try {
            this.topLeftCorner = new Position(northernMostDeg, northernMostDir, westernMostDeg, westernMostDir);
        }
        catch (Exception ex) {
            System.err.println("Error creating topLeftCorner " + ex);
        }
        int xInset = 0;
        int yInset = 0;
        if (sm - nm > em - wm) {
            yInset = 20;
            factor = 1.0 * (double)(ppSize.width - 40) / (double)(sm - nm);
            xInset = (int)((double)ppSize.width - (double)(em - wm) * factor) / 2;
        } else if (em - wm > sm - nm) {
            xInset = 20;
            factor = 1.0 * (double)(ppSize.height - 40) / (double)(em - wm);
            yInset = (int)((double)ppSize.height - (double)(sm - nm) * factor) / 2;
        } else {
            factor = 1.0 * (double)(ppSize.height - 40) / (double)(sm - nm);
            xInset = 20;
            yInset = 20;
        }
        this.OriginPtX = (int)((double)wm - (double)xInset / factor);
        this.OriginPtY = (int)((double)nm - (double)yInset / factor);
        this.ZeroZeroPtX = xInset;
        this.ZeroZeroPtY = yInset;
        if (WayPointDefs.plot_debug) {
            System.out.println("ZeroZero pt=" + this.ZeroZeroPtX + "," + this.ZeroZeroPtY + ", OriginPt= " + this.OriginPtX + "," + this.OriginPtY);
        }
        this.degWidth = (double)(em - wm) / 10000.0;
        this.degHeight = (double)(sm - nm) / 10000.0;
        this.northMostNorm = nm;
        this.westMostNorm = wm;
        if (WayPointDefs.plot_debug) {
            System.out.println("N-S= " + this.degHeight + ", W-E= " + this.degWidth + ", westernMost=" + westernMostDeg + "/" + this.westMostNorm + ", northMost=" + northernMostDeg + "/" + this.northMostNorm + "\n     tLC=" + this.topLeftCorner + ", factor=" + factor);
        }
        this.pp.setScalingFactor(factor);
        this.pp.setOrigins(wm, nm, em, sm, xInset, yInset);
        this.pp.setScale(factor);
        this.plotFrame.add((Component)this.pp, "Center");
        this.plotFrame.show();
        if (WayPointDefs.plot_debug) {
            System.out.println("plotWP() Bounds are: " + nm + " " + sm + " " + wm + " " + em + " Factor=" + factor + ", OriginPt: " + this.OriginPtX + "," + this.OriginPtY + ", Insets: " + xInset + "," + yInset + "\n northMost = " + northernMostDeg + "\n westMost = " + westernMostDeg + "\n     " + this.plotFrame.getInsets() + " " + this.pp.getSize());
        }
    }

    final class PlotPanel
    extends Component
    implements ActionListener {
        final int ZOOM_IN = 1;
        final int ZOOM_OUT = 2;
        Point[] OrigPts;
        Point[] pts;
        String[] wpNames;
        boolean[] isDuplicate;
        boolean[] showLabel;
        Rectangle[] namesRect;
        CandD[] cd;
        String[] cdCourse;
        String[] cdDistance;
        CDRectangle[] cdRect;
        Position[] allPos;
        int idx = 0;
        int tX;
        int tY;
        int posX;
        int posY;
        Scrollbar hSB;
        Scrollbar vSB;
        final int ptDia = 8;
        final int NON_SELECTED = -1;
        int selRect = -1;
        int selCD = -1;
        int selNode = -1;
        int selEndNode = -1;
        int saveSel = -1;
        Point dragPoint = null;
        String selCourse = "";
        String selDistance = "";
        String selSpeed = "";
        Color selColor = Color.red;
        Color connColor = Color.red;
        Color lineColor = Color.black;
        Color LL_lineColor = Color.gray;
        Color dragColor = Color.blue;
        Color nodeRectColor = new Color(250, 220, 100);
        Color nodeColor = Color.cyan;
        Color poiColor = Color.yellow;
        Color cdColor = new Color(200, 200, 80);
        Color cdSelColor = Color.green;
        Color cdConnColor = Color.green;
        boolean overRect = false;
        Rectangle wpBounds;
        int max_X;
        int max_Y;
        int totW;
        int totH;
        Point PopUp_loc;
        MouseEvent PopUp_me;
        int PopUp_i;
        final double[] desiredLines = new double[]{20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.25, 0.16666666666666666, 0.08333333333333333, 0.03333333333333333, 0.016666666666666666, 0.008333333333333333, 0.0033333333333333335, 0.0016666666666666668, 8.333333333333334E-4, 3.333333333333333E-4, 1.6666666666666666E-4, 8.333333333333333E-5};

        public PlotPanel(int x, Scrollbar hSBx, Scrollbar vSBx) {
            this.setSize(500, 500);
            this.totW = 500;
            this.totH = 500;
            this.pts = new Point[x];
            this.OrigPts = new Point[x];
            this.wpNames = new String[x];
            this.namesRect = new Rectangle[x];
            this.isDuplicate = new boolean[x];
            this.showLabel = new boolean[x];
            this.cd = new CandD[x];
            this.cdCourse = new String[x];
            this.cdDistance = new String[x];
            this.cdRect = new CDRectangle[x];
            this.allPos = new Position[x];
            this.hSB = hSBx;
            this.vSB = vSBx;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent me) {
                    if (me.isPopupTrigger() || (me.getModifiers() & 4) != 0) {
                        Point p = new Point(me.getX() - this.this$1.tX, me.getY() - this.this$1.tY);
                        int i = PlotPanel.access$000(this.this$1, p);
                        if (i >= 0) {
                            Component c = (Component)me.getSource();
                            Position aPos = this.this$1.allPos[i];
                            if (aPos.isPOI()) {
                                PlotPanel.access$100((PlotPanel)this.this$1).markAsPOIMI.setLabel("Clear POI");
                            } else {
                                PlotPanel.access$100((PlotPanel)this.this$1).markAsPOIMI.setLabel("Mark as POI");
                            }
                            PlotPanel.access$100((PlotPanel)this.this$1).posDetailsPUM.show(c, me.getX(), me.getY());
                            if (WayPointDefs.plot_debug) {
                                System.out.println("RightClick node:" + i + ", p=" + p + ", " + this.this$1.allPos[i]);
                            }
                            this.this$1.PopUp_loc = this.this$1.getLocationOnScreen();
                            this.this$1.PopUp_me = me;
                            this.this$1.PopUp_i = i;
                        }
                        return;
                    }
                    this.this$1.posX = me.getX();
                    this.this$1.posY = me.getY();
                    Point p = new Point(me.getX() - this.this$1.tX, me.getY() - this.this$1.tY);
                    if (WayPointDefs.plot_debug) {
                        System.out.println("Mouse Pressed at: " + me.getX() + ", " + me.getY() + ", " + p);
                    }
                    int i = this.this$1.namesRect.length - 1;
                    while (i >= 0) {
                        if (this.this$1.namesRect[i] != null && this.this$1.namesRect[i].contains(p) && !this.this$1.isDuplicate[i] && (this.this$1.showLabel[i] || PlotPanel.access$100((PlotPanel)this.this$1).showLabels.getState() || PlotPanel.access$100((PlotPanel)this.this$1).showNames.getState() || PlotPanel.access$100((PlotPanel)this.this$1).showPOI.getState())) {
                            this.this$1.selRect = i;
                            this.this$1.repaint();
                            return;
                        }
                        --i;
                    }
                    int i2 = this.this$1.cdRect.length - 1;
                    while (i2 >= 1) {
                        if (this.this$1.cdRect[i2] != null && this.this$1.cdRect[i2].contains(p)) {
                            this.this$1.selCD = i2;
                            this.this$1.repaint();
                            return;
                        }
                        --i2;
                    }
                    int i3 = PlotPanel.access$000(this.this$1, p);
                    if (i3 >= 0) {
                        if (this.this$1.pts[i3] == null) {
                            return;
                        }
                        this.this$1.saveSel = this.this$1.selNode;
                        this.this$1.selNode = i3;
                        return;
                    }
                    if (PlotPanel.access$100((PlotPanel)this.this$1).zoomingIn) {
                        PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor *= 2;
                        PlotPanel.access$100((PlotPanel)this.this$1).plotFrame.setTitle(PlotPanel.access$100((PlotPanel)this.this$1).plotFrameTitle + " (X" + PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor + ")");
                        if (WayPointDefs.plot_debug) {
                            System.out.println("Zooming In " + me.getX() + " " + me.getY() + " " + p + " zFactor:" + PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor);
                        }
                        this.this$1.setScale((double)PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor * PlotPanel.access$100((PlotPanel)this.this$1).scalingFactor);
                        this.this$1.resetRectangles();
                        this.this$1.setScrollBars(p.x, p.y, 1);
                        PlotPanel.access$100((PlotPanel)this.this$1).ZoomOut.setEnabled(true);
                        this.this$1.repaint();
                    } else if (PlotPanel.access$100((PlotPanel)this.this$1).zoomingOut) {
                        if (PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor == 1) {
                            System.err.println(">>>>*** Zoom out with zf=1");
                            this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).defCursor);
                            PlotPanel.access$100((PlotPanel)this.this$1).ZoomOut.setEnabled(false);
                            PlotPanel.access$100((PlotPanel)this.this$1).zoomingOut = false;
                            PlotPanel.access$100(this.this$1).removeScrollBars();
                            return;
                        }
                        PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor /= 2;
                        if (WayPointDefs.plot_debug) {
                            System.out.println("Zooming Out " + me.getX() + " " + me.getY() + " " + p + " Zfactor:" + PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor);
                        }
                        this.this$1.setScale((double)PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor * PlotPanel.access$100((PlotPanel)this.this$1).scalingFactor);
                        this.this$1.resetRectangles();
                        if (PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor == 1) {
                            this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).defCursor);
                            PlotPanel.access$100((PlotPanel)this.this$1).ZoomOut.setEnabled(false);
                            PlotPanel.access$100((PlotPanel)this.this$1).zoomingOut = false;
                            PlotPanel.access$100(this.this$1).removeScrollBars();
                            this.this$1.setTranslate(0, 0);
                            PlotPanel.access$100((PlotPanel)this.this$1).plotFrame.setTitle(PlotPanel.access$100((PlotPanel)this.this$1).plotFrameTitle);
                        } else {
                            this.this$1.setScrollBars(-p.x / 2, -p.y / 2, 2);
                            PlotPanel.access$100((PlotPanel)this.this$1).plotFrame.setTitle(PlotPanel.access$100((PlotPanel)this.this$1).plotFrameTitle + " (X" + PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor + ")");
                        }
                        this.this$1.repaint();
                    }
                }

                public void mouseReleased(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        return;
                    }
                    Point mp = new Point(me.getX() - this.this$1.tX, me.getY() - this.this$1.tY);
                    if (WayPointDefs.plot_debug) {
                        System.out.println("Mouse Released at " + mp.x + "," + mp.y);
                    }
                    if (PlotPanel.access$100((PlotPanel)this.this$1).zoomingIn || PlotPanel.access$100((PlotPanel)this.this$1).zoomingOut) {
                        this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).zoomCursor);
                    } else {
                        this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).defCursor);
                    }
                    if (this.this$1.selRect == -1 && this.this$1.selCD == -1 && this.this$1.selNode != -1 && this.this$1.dragPoint != null) {
                        int i = PlotPanel.access$000(this.this$1, mp);
                        if (i >= 0 && i != this.this$1.selNode) {
                            this.this$1.dragPoint = this.this$1.pts[i];
                            this.this$1.selEndNode = i;
                            CandD cd = CandD.compGreatCircle(this.this$1.allPos[this.this$1.selNode], this.this$1.allPos[this.this$1.selEndNode]);
                            this.this$1.selCourse = PlotPanel.access$100((PlotPanel)this.this$1).tenthsForm.format(cd.courseT) + "\u00b0" + "T";
                            this.this$1.selDistance = cd.distance > 10.0 ? PlotPanel.access$100((PlotPanel)this.this$1).tenthsForm.format(cd.distance) + "nm" : PlotPanel.access$100((PlotPanel)this.this$1).hundrethsForm.format(cd.distance) + "nm";
                            if (PlotPanel.access$100((PlotPanel)this.this$1).showKnots.getState()) {
                                String wpnm1 = this.this$1.allPos[this.this$1.selNode].getName();
                                String wpnm2 = this.this$1.allPos[this.this$1.selEndNode].getName();
                                double duration = PlotPanel.access$200(this.this$1, wpnm1, wpnm2);
                                this.this$1.selSpeed = PlotPanel.access$100((PlotPanel)this.this$1).tenthsForm.format(cd.distance / duration) + "kts";
                            }
                        } else if (i < 0 || i != this.this$1.selNode && i != this.this$1.selEndNode && this.this$1.selEndNode != -1) {
                            this.this$1.dragPoint = null;
                            this.this$1.selNode = -1;
                            this.this$1.selEndNode = -1;
                        }
                    }
                    this.this$1.selRect = -1;
                    this.this$1.selCD = -1;
                    this.this$1.repaint();
                }

                public void mouseClicked(MouseEvent me) {
                    if (me.isPopupTrigger() || (me.getModifiers() & 4) != 0) {
                        return;
                    }
                    Point mp = new Point(me.getX() - this.this$1.tX, me.getY() - this.this$1.tY);
                    int i = PlotPanel.access$000(this.this$1, mp);
                    if (i >= 0) {
                        this.this$1.selNode = this.this$1.saveSel;
                        this.this$1.showLabel[i] = !this.this$1.showLabel[i];
                        this.this$1.repaint();
                    }
                    if (WayPointDefs.plot_debug) {
                        System.out.println("Mouse clicked at " + mp + " node:" + i + " selNode: " + this.this$1.selNode);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseDragged(MouseEvent me) {
                    Point p = new Point(me.getX() - this.this$1.tX, me.getY() - this.this$1.tY);
                    if (this.this$1.selRect != -1) {
                        this.this$1.namesRect[this.this$1.selRect].x = p.x;
                        this.this$1.namesRect[this.this$1.selRect].y = p.y;
                        this.this$1.repaint();
                        return;
                    }
                    if (this.this$1.selCD != -1) {
                        this.this$1.cdRect[this.this$1.selCD].x = p.x;
                        this.this$1.cdRect[this.this$1.selCD].y = p.y;
                        this.this$1.repaint();
                        return;
                    }
                    if (this.this$1.selNode != -1) {
                        this.this$1.selEndNode = -1;
                        this.this$1.dragPoint = p;
                        this.this$1.repaint();
                    }
                    if (this.this$1.selRect == -1 && this.this$1.selCD == -1 && this.this$1.selNode == -1 && PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor > 1) {
                        this.this$1.posX = me.getX();
                        int dX = this.this$1.posX - this.this$1.posX;
                        this.this$1.posY = me.getY();
                        int dY = this.this$1.posY - this.this$1.posY;
                        Dimension dim = this.this$1.getSize();
                        this.this$1.tX -= dX;
                        if (this.this$1.tX > 0) {
                            this.this$1.tX = 0;
                        }
                        if (this.this$1.tX < -(PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor - 1) * dim.width) {
                            this.this$1.tX = -(PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor - 1) * dim.width;
                        }
                        this.this$1.tY -= dY;
                        if (this.this$1.tY > 0) {
                            this.this$1.tY = 0;
                        }
                        if (this.this$1.tY < -(PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor - 1) * dim.height) {
                            this.this$1.tY = -(PlotPanel.access$100((PlotPanel)this.this$1).zoomFactor - 1) * dim.height;
                        }
                        this.this$1.repaint();
                    }
                }

                public void mouseMoved(MouseEvent me) {
                    Point p = new Point(me.getX() - this.this$1.tX, me.getY() - this.this$1.tY);
                    int i = 0;
                    while (i < this.this$1.namesRect.length) {
                        if (this.this$1.namesRect[i] != null && (PlotPanel.access$100((PlotPanel)this.this$1).showLabels.getState() || this.this$1.showLabel[i] || PlotPanel.access$100((PlotPanel)this.this$1).showNames.getState() || PlotPanel.access$100((PlotPanel)this.this$1).showPOI.getState()) && this.this$1.namesRect[i].contains(p)) {
                            this.this$1.overRect = true;
                            this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).moveCursor);
                            return;
                        }
                        ++i;
                    }
                    int i2 = 1;
                    while (i2 < this.this$1.cdRect.length) {
                        if (this.this$1.cdRect[i2] != null && (PlotPanel.access$100((PlotPanel)this.this$1).showLabels.getState() || this.this$1.showLabel[i2]) && this.this$1.cdRect[i2].contains(p)) {
                            this.this$1.overRect = true;
                            this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).moveCursor);
                            return;
                        }
                        ++i2;
                    }
                    if (PlotPanel.access$000(this.this$1, p) >= 0) {
                        this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).handCursor);
                        return;
                    }
                    if (PlotPanel.access$100((PlotPanel)this.this$1).zoomingIn || PlotPanel.access$100((PlotPanel)this.this$1).zoomingOut) {
                        this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).zoomCursor);
                    } else {
                        this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).defCursor);
                    }
                    if (this.this$1.overRect) {
                        this.this$1.overRect = false;
                        if (PlotPanel.access$100((PlotPanel)this.this$1).zoomingIn || PlotPanel.access$100((PlotPanel)this.this$1).zoomingOut) {
                            this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).zoomCursor);
                        } else {
                            this.this$1.setCursor(PlotPanel.access$100((PlotPanel)this.this$1).defCursor);
                        }
                    }
                }
            });
        }

        private double timeDiff(String wpnm1, String wpnm2) {
            int i = wpnm1.indexOf(":");
            int j = wpnm2.indexOf(":");
            if (i < 1 || j < 0) {
                return 0.0;
            }
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy HH:mm");
                Date date1 = sdf.parse(wpnm1.substring(i - 9, i + 3));
                Date date2 = sdf.parse(wpnm2.substring(j - 9, j + 3));
                double diff = Math.abs(date1.getTime() / 1000L - date2.getTime() / 1000L);
                return diff /= 3600.0;
            }
            catch (Exception ex) {
                System.err.println("ex " + ex);
                return 0.0;
            }
        }

        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == PlotWayPoints.this.showInfoMI) {
                ShowMsgBox smb = new ShowMsgBox(this.allPos[this.PopUp_i].getName() + " info", "Description: " + this.allPos[this.PopUp_i].getDescription() + "\nLatitude: " + this.allPos[this.PopUp_i].getLatString() + "\nLongitude: " + this.allPos[this.PopUp_i].getLongString(), PlotWayPoints.this.plotFrame, false, 180, this.PopUp_loc.x + this.PopUp_me.getX(), this.PopUp_loc.y + this.PopUp_me.getY(), false);
            } else if (src == PlotWayPoints.this.copyToWorkMI) {
                Position aPos = (Position)this.allPos[this.PopUp_i].clone();
                aPos.addEditWPUpdateListener(WayPointDefs.workSP);
                WayPointDefs.workSP.wpChanged(new WPUpdateEvent(this, 1, aPos));
            } else if (src == PlotWayPoints.this.chngWPNameMI) {
                Position aPos = this.allPos[this.PopUp_i];
                GetInput gi = new GetInput("Enter new waypoint name", new Frame(), "Set name", aPos.getName());
                String wpNm = gi.getResponse();
                if (wpNm == "") {
                    return;
                }
                try {
                    aPos.setName(wpNm);
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            } else if (src == PlotWayPoints.this.markAsPOIMI) {
                Position aPos = this.allPos[this.PopUp_i];
                aPos.setPOI(PlotWayPoints.this.markAsPOIMI.getLabel().equals("Mark as POI"));
                this.repaint();
            } else {
                System.out.println("Unknown AE " + ae);
            }
        }

        private int inNode(Point p) {
            int i = 0;
            while (i < this.idx) {
                if (!this.allPos[i].isEndOfLeg && (this.pts[i].x - p.x) * (this.pts[i].x - p.x) + (this.pts[i].y - p.y) * (this.pts[i].y - p.y) < 16) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        void resetRectangles() {
            int i = 0;
            while (i < this.idx) {
                this.namesRect[i] = null;
                this.cdRect[i] = null;
                ++i;
            }
        }

        void clearLabels() {
            int i = 0;
            while (i < this.idx) {
                this.showLabel[i] = false;
                ++i;
            }
            this.dragPoint = null;
            this.selNode = -1;
            this.selEndNode = -1;
            this.repaint();
        }

        void addPoint(Point p, Position pos, CandD cd) {
            this.allPos[this.idx] = pos;
            String n = pos.getName();
            this.isDuplicate[this.idx] = false;
            int i = 0;
            while (i < this.idx) {
                if (this.wpNames[i].equals(n) && this.OrigPts[i].equals(p)) {
                    this.isDuplicate[this.idx] = true;
                    break;
                }
                ++i;
            }
            try {
                this.wpNames[this.idx] = n;
                this.cd[this.idx] = cd;
                if (cd != null) {
                    this.cdCourse[this.idx] = PlotWayPoints.this.tenthsForm.format(cd.courseT) + "\u00b0" + "T";
                    this.cdDistance[this.idx] = cd.distance > 10.0 ? PlotWayPoints.this.tenthsForm.format(cd.distance) + "nm" : PlotWayPoints.this.hundrethsForm.format(cd.distance) + "nm";
                }
                this.OrigPts[this.idx++] = p;
                if (WayPointDefs.plot_debug) {
                    System.out.println("addPoint(): " + p + " for " + pos);
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage() + " for index: " + this.idx);
                ex.printStackTrace();
            }
        }

        void setScalingFactor(double sf) {
            PlotWayPoints.this.scalingFactor = sf;
        }

        void setOrigins(int wm, int nm, int em, int sm, int xIn, int yIn) {
            this.max_X = (int)((double)(em - wm) + (double)(2 * xIn) / PlotWayPoints.this.scalingFactor);
            this.max_Y = (int)((double)(sm - nm) + (double)(2 * yIn) / PlotWayPoints.this.scalingFactor);
            this.wpBounds = new Rectangle(wm - xIn, nm - yIn, this.max_X, this.max_Y);
            if (WayPointDefs.plot_debug) {
                System.out.println("setOrigins() wpBounds: " + this.wpBounds);
            }
            Point svOld = new Point();
            int i = 0;
            while (i < this.idx) {
                svOld = this.OrigPts[i];
                this.OrigPts[i].x -= wm;
                this.OrigPts[i].y -= nm;
                if (WayPointDefs.plot_debug) {
                    System.out.println("Origins reset " + this.wpNames[i] + " fm:" + svOld + " to:" + this.OrigPts[i]);
                }
                ++i;
            }
        }

        void setScale(double factor) {
            int i = 0;
            try {
                i = 0;
                while (i < this.idx) {
                    this.pts[i] = new Point();
                    this.pts[i].x = (int)((double)this.OrigPts[i].x * factor) + PlotWayPoints.this.ZeroZeroPtX;
                    this.pts[i].y = (int)((double)this.OrigPts[i].y * factor) + PlotWayPoints.this.ZeroZeroPtY;
                    if (WayPointDefs.plot_debug) {
                        System.out.println("setScale() Scaled " + this.wpNames[i] + " fm:" + this.OrigPts[i] + " to:" + this.pts[i] + ", factor: " + factor);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                System.err.println("setScale() ex " + i + " " + this.idx);
                ex.printStackTrace();
            }
        }

        public void sbChanged(Scrollbar hSB, Scrollbar vSB) {
            this.tX = -hSB.getValue();
            this.tY = -vSB.getValue();
            this.repaint();
        }

        public void doLayout() {
            super.doLayout();
            System.out.println("doLayout() " + this.getSize());
            this.setScrollBars(0, 0, 0);
        }

        public void setTranslate(int x, int y) {
            this.tX = x;
            this.tY = y;
        }

        void setScrollBars(int cX, int cY, int zoomFlag) {
            int wPP = this.getSize().width;
            int hPP = this.getSize().height;
            int centerX = wPP / 2;
            int centerY = hPP / 2;
            int vValue = this.vSB.getValue();
            int hValue = this.hSB.getValue();
            this.totW = (int)((double)(this.max_X * PlotWayPoints.this.zoomFactor) * PlotWayPoints.this.scalingFactor);
            this.totH = (int)((double)(this.max_Y * PlotWayPoints.this.zoomFactor) * PlotWayPoints.this.scalingFactor);
            if (cX == 0 && cY == 0 && zoomFlag == 0) {
                this.tX = -Math.max(0, Math.min(this.totW - wPP, this.hSB.getValue()));
                this.tY = -Math.max(0, Math.min(this.totH - hPP, this.vSB.getValue()));
            } else {
                if (zoomFlag == 1) {
                    vValue = vValue * 2 + cY;
                    hValue = hValue * 2 + cX;
                } else if (zoomFlag == 2) {
                    vValue /= 2;
                    hValue /= 2;
                } else {
                    System.err.println("Invalid zoomFlag: " + zoomFlag);
                }
                if (PlotWayPoints.this.zoomFactor == 1) {
                    this.tY = 0;
                    this.tX = 0;
                } else {
                    this.tX -= cX;
                    this.tY -= cY;
                }
            }
            this.vSB.setValues(vValue, hPP, this.vSB.getMinimum(), this.totH);
            this.vSB.setBlockIncrement(Math.min(this.totH / 10, hPP));
            this.vSB.setUnitIncrement(Math.min(this.totH / 50, hPP / 5));
            this.hSB.setValues(hValue, wPP, this.hSB.getMinimum(), this.totW);
            this.hSB.setBlockIncrement(Math.min(this.totW / 10, wPP));
            this.hSB.setUnitIncrement(Math.min(this.totW / 50, wPP / 5));
            PlotWayPoints.this.hScaleB.setValue(this.hSB.getValue());
            PlotWayPoints.this.vScaleB.setValue(this.vSB.getValue());
            if (WayPointDefs.plot_debug) {
                System.out.println("setScrollBars()  tX=" + this.tX + " tY=" + this.tY + "   cX=" + cX + " cY=" + cY + " h=" + hPP + " w=" + wPP + " totW=" + this.totW + " totH=" + this.totH);
                this.showSB(this.vSB);
                this.showSB(this.hSB);
            }
        }

        void showSB(Scrollbar sb) {
            System.out.println((sb.getOrientation() == 1 ? "ver" : "hor") + "  Val=" + sb.getValue() + " Max=" + sb.getMaximum() + " Vis=" + sb.getVisibleAmount() + "  UIncr=" + sb.getUnitIncrement() + " BIncr=" + sb.getBlockIncrement());
        }

        public void paint(Graphics bg) {
            int centerY;
            bg.translate(this.tX, this.tY);
            FontMetrics fm = bg.getFontMetrics(this.getFont());
            int asc = fm.getAscent();
            int fmH = fm.getHeight() + 2;
            int lastWPIdx = -1;
            if (PlotWayPoints.this.showLLCBMI.getState()) {
                Position linesStartPos = null;
                double maxDeg = Math.max(PlotWayPoints.this.degWidth, PlotWayPoints.this.degHeight);
                double degBetweenLines = maxDeg / (double)(6 * PlotWayPoints.this.zoomFactor);
                if (WayPointDefs.plot_debug) {
                    System.out.print("initial degBetweenLines=" + degBetweenLines);
                }
                degBetweenLines = this.findDesiredLine(degBetweenLines);
                try {
                    linesStartPos = this.getBoundary(PlotWayPoints.this.topLeftCorner, degBetweenLines);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Dimension plotSize = this.getSize();
                if (WayPointDefs.plot_debug) {
                    System.out.println(", desired degBetweenLines: " + degBetweenLines + ", plotSize:" + plotSize);
                }
                Point topLeft = linesStartPos.getNormalPosition(10000.0);
                Point nextLong = null;
                Point nextLat = null;
                if (WayPointDefs.plot_debug) {
                    System.out.println("topLeft before conversion: " + topLeft);
                }
                topLeft.x = (int)((double)(topLeft.x - PlotWayPoints.this.westMostNorm) * PlotWayPoints.this.scalingFactor) + PlotWayPoints.this.ZeroZeroPtX;
                topLeft.y = (int)((double)(topLeft.y - PlotWayPoints.this.northMostNorm) * PlotWayPoints.this.scalingFactor) + PlotWayPoints.this.ZeroZeroPtY;
                if (WayPointDefs.plot_debug) {
                    System.out.println("linesStartPos:" + linesStartPos + ", topLeft after:" + topLeft);
                }
                bg.setColor(this.LL_lineColor);
                int x = topLeft.x;
                int endX = x + plotSize.width - this.tX;
                int y = topLeft.y;
                int endY = y + plotSize.height - this.tY;
                if (WayPointDefs.plot_debug) {
                    System.out.println("x|endX: " + x + "," + endX + ", y|endY: " + y + "," + endY + ", tX|tY: " + this.tX + "," + this.tY);
                }
                Font svFont = this.getFont();
                bg.setFont(new Font("Monospace", 0, 9));
                String dirLong = "E";
                double changeDir = 1.0;
                if (linesStartPos.directionWest()) {
                    changeDir = -1.0;
                    dirLong = "W";
                }
                int cntr = 0;
                while (cntr++ < 50) {
                    if (x >= topLeft.x - this.tX) {
                        bg.drawLine(x, -this.tY, x, plotSize.height - this.tY);
                        String deg = PlotWayPoints.this.wholeLongForm.format(linesStartPos.getDegLongI());
                        bg.drawString(deg + "\u00b0", x - 20, -this.tY + 10);
                        if (this.getMin(linesStartPos.decDegLong()) > 0.0) {
                            String min = PlotWayPoints.this.tenthsForm.format(this.getMin(linesStartPos.decDegLong()));
                            bg.drawString(min + "'" + dirLong, x + 2, -this.tY + 10);
                        } else {
                            bg.drawString(dirLong, x + 3, -this.tY + 10);
                        }
                    }
                    linesStartPos.setDegLong(linesStartPos.decDegLong() + changeDir * degBetweenLines);
                    if (cntr < 3) {
                        // empty if block
                    }
                    nextLong = linesStartPos.getNormalPosition(10000.0);
                    if (cntr < 3) {
                        // empty if block
                    }
                    x = (int)((double)(nextLong.x - PlotWayPoints.this.westMostNorm) * PlotWayPoints.this.scalingFactor * (double)PlotWayPoints.this.zoomFactor) + PlotWayPoints.this.ZeroZeroPtX;
                    if (cntr >= 3) continue;
                }
                String dirLat = "S";
                changeDir = 1.0;
                if (linesStartPos.directionNorth()) {
                    changeDir = -1.0;
                    dirLat = "N";
                }
                cntr = 0;
                while (y < endY && cntr++ < 50) {
                    if (y >= topLeft.y - this.tY) {
                        bg.drawLine(-this.tX, y, plotSize.width - this.tX, y);
                        String deg = PlotWayPoints.this.wholeForm.format(linesStartPos.getDegLatI());
                        bg.drawString(deg + "\u00b0", -this.tX + 4, y - 1);
                        if (this.getMin(linesStartPos.decDegLat()) > 0.0) {
                            String min = PlotWayPoints.this.tenthsForm.format(this.getMin(linesStartPos.decDegLat()));
                            bg.drawString(min + "'" + dirLat, -this.tX + 4, y + 9);
                        } else {
                            bg.drawString(dirLat, -this.tX + 20, y);
                        }
                    }
                    linesStartPos.setDegLat(linesStartPos.decDegLat() + changeDir * degBetweenLines);
                    if (cntr < 3) {
                        // empty if block
                    }
                    nextLat = linesStartPos.getNormalPosition(10000.0);
                    if (cntr < 3) {
                        // empty if block
                    }
                    y = (int)((double)(nextLat.y - PlotWayPoints.this.northMostNorm) * PlotWayPoints.this.scalingFactor * (double)PlotWayPoints.this.zoomFactor) + PlotWayPoints.this.ZeroZeroPtY;
                    if (cntr >= 3) continue;
                }
                bg.setFont(svFont);
            }
            int i = 0;
            while (i < this.idx) {
                if (this.namesRect[i] == null) {
                    int w = fm.stringWidth(this.wpNames[i]);
                    this.namesRect[i] = new Rectangle(this.pts[i].x, this.pts[i].y, w, fmH - 2);
                }
                if (i > 0 && lastWPIdx >= 0 && !this.wpNames[i - 1].equals("End Of Leg") && !this.wpNames[i].equals("End Of Leg") && !this.allPos[i].isPOI() && PlotWayPoints.this.showLegs.getState()) {
                    bg.setColor(this.lineColor);
                    bg.drawLine(this.pts[lastWPIdx].x, this.pts[lastWPIdx].y, this.pts[i].x, this.pts[i].y);
                    if (PlotWayPoints.this.showLabels.getState() || this.showLabel[i] || this.showLabel[lastWPIdx]) {
                        CDRectangle wr;
                        if (this.cdRect[i] == null) {
                            int centerX = (this.pts[lastWPIdx].x + this.pts[i].x) / 2;
                            centerY = (this.pts[lastWPIdx].y + this.pts[i].y) / 2;
                            int w = Math.max(fm.stringWidth(this.cdCourse[i]), fm.stringWidth(this.cdDistance[i]));
                            this.cdRect[i] = new CDRectangle(centerX - w / 2, centerY - fmH / 2, w, 2 * fmH - 9, centerX, centerY);
                            if (WayPointDefs.plot_debug) {
                                System.out.println("filled cdRect " + this.cdRect[i]);
                            }
                        }
                        if ((wr = this.cdRect[i]).moved()) {
                            bg.setColor(this.cdConnColor);
                            bg.drawLine(wr.x + wr.width / 2, wr.y + wr.height / 2, wr.connX, wr.connY);
                        }
                        if (i == this.selCD) {
                            bg.setColor(this.cdSelColor);
                        } else {
                            bg.setColor(this.cdColor);
                        }
                        bg.fillRect(wr.x, wr.y, wr.width, wr.height);
                        bg.setColor(Color.black);
                        bg.drawString(this.cdCourse[i], wr.x, wr.y + asc);
                        bg.drawString(this.cdDistance[i], wr.x, wr.y + asc + fmH - 6);
                    }
                }
                if (!this.allPos[i].isPOI() && !this.allPos[i].isEndOfLeg()) {
                    lastWPIdx = i;
                }
                if (!this.wpNames[i].equals("End Of Leg") && !this.isDuplicate[i]) {
                    bg.setColor(Color.black);
                    bg.drawOval(this.pts[i].x - 4, this.pts[i].y - 4, 8, 8);
                    if (this.allPos[i].isPOI()) {
                        bg.setColor(this.poiColor);
                    } else {
                        bg.setColor(this.nodeColor);
                    }
                    bg.fillOval(this.pts[i].x - 4 + 1, this.pts[i].y - 4 + 1, 6, 6);
                    if (PlotWayPoints.this.showLabels.getState() || PlotWayPoints.this.showNames.getState() || this.showLabel[i] || PlotWayPoints.this.showPOI.getState() && this.allPos[i].isPOI()) {
                        Rectangle r = this.namesRect[i];
                        if (r.x != this.pts[i].x && r.y != this.pts[i].y) {
                            bg.setColor(this.connColor);
                            bg.drawLine(this.pts[i].x, this.pts[i].y, r.x + r.width / 2, r.y + r.height / 2);
                        }
                        if (i == this.selRect) {
                            bg.setColor(this.selColor);
                        } else if (this.allPos[i].isPOI()) {
                            bg.setColor(this.poiColor);
                        } else {
                            bg.setColor(this.nodeRectColor);
                        }
                        bg.fillRect(r.x, r.y, r.width, r.height);
                        bg.setColor(Color.black);
                        bg.drawString(this.wpNames[i], r.x, r.y + asc);
                    }
                }
                ++i;
            }
            if (this.selNode != -1 && this.dragPoint != null) {
                bg.setColor(this.dragColor);
                bg.drawLine(this.pts[this.selNode].x, this.pts[this.selNode].y, this.dragPoint.x, this.dragPoint.y);
                if (this.selEndNode != -1) {
                    int centerX = (this.pts[this.selNode].x + this.pts[this.selEndNode].x) / 2;
                    centerY = (this.pts[this.selNode].y + this.pts[this.selEndNode].y) / 2;
                    int w = Math.max(fm.stringWidth(this.selCourse), fm.stringWidth(this.selDistance));
                    CDRectangle wr = new CDRectangle(centerX - w / 2, centerY - fmH / 2, w, 2 * fmH - 9, centerX, centerY);
                    bg.setColor(this.cdColor);
                    int xHt = 0;
                    if (PlotWayPoints.this.showKnots.getState()) {
                        xHt = 12;
                    }
                    bg.fillRect(wr.x, wr.y, wr.width, wr.height + xHt);
                    bg.setColor(Color.black);
                    bg.drawString(this.selCourse, wr.x, wr.y + asc);
                    bg.drawString(this.selDistance, wr.x, wr.y + asc + fmH - 6);
                    if (PlotWayPoints.this.showKnots.getState()) {
                        bg.drawString(this.selSpeed, wr.x, wr.y + asc + fmH + 6);
                    }
                }
            }
        }

        private double getMin(double deg) {
            double min = deg - (double)((int)deg);
            return min *= 60.0;
        }

        Position getBoundary(Position pos, double deltaDeg) throws BadPositionException {
            int WorkFactor = 60240;
            int WorkDegBL = (int)(deltaDeg * 60240.0);
            int northMostLineLatI = (int)(pos.decDegLat() * 60240.0) + (pos.directionWest() ? WorkDegBL - 1 : 0);
            int work1 = northMostLineLatI / WorkDegBL * WorkDegBL;
            double northMostLineLat = (double)work1 * 1.0 / 60240.0;
            int westMostLineLongI = (int)(pos.decDegLong() * 60240.0) + (pos.directionNorth() ? WorkDegBL - 1 : 0);
            int work2 = westMostLineLongI / WorkDegBL * WorkDegBL;
            double westMostLineLong = (double)work2 * 1.0 / 60240.0;
            return new Position(northMostLineLat, pos.getDirLat(), westMostLineLong, pos.getDirLong());
        }

        double findDesiredLine(double degs) {
            int i = 0;
            while (i < this.desiredLines.length) {
                if (1.25 * degs >= this.desiredLines[i]) {
                    return this.desiredLines[i];
                }
                ++i;
            }
            System.err.println("*** didn't find Desired Line for " + degs);
            return degs;
        }

        static /* synthetic */ int access$000(PlotPanel x0, Point x1) {
            return x0.inNode(x1);
        }

        static /* synthetic */ PlotWayPoints access$100(PlotPanel x0) {
            return x0.PlotWayPoints.this;
        }

        static /* synthetic */ double access$200(PlotPanel x0, String x1, String x2) {
            return x0.timeDiff(x1, x2);
        }

        class CDRectangle
        extends Rectangle {
            int originX;
            int originY;
            public int connX;
            public int connY;

            public CDRectangle(int x, int y, int w, int h, int cx, int cy) {
                super(x, y, w, h);
                this.originX = x;
                this.originY = y;
                this.connX = cx;
                this.connY = cy;
            }

            public boolean moved() {
                return this.originX != this.x || this.originY != this.y;
            }
        }
    }
}

