/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.NavSoftwareInterfaces;

import NormsTools.ErrDialog;
import WayPointApps.BadPositionException;
import WayPointApps.NobeltecPositionFactory;
import WayPointApps.Position;
import WayPointApps.Positions;
import WayPointApps.WPFileRecs;
import WayPointApps.WayPointDefs;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;

public class Nobeltec {
    public static final String Nobeltec_Ext = ".NTEC";
    public static final String Route = "RT";
    public static final String Track = "TR";
    public static String type = "RT";
    static final String FileHdr = "[{{FileHeader}}]";
    static final String VersionID = "Version = ";
    static final String GroupHdr = "[";
    static final String IDBegins = "++";
    static final String GroupHdrEnd = "++]";
    static final String NameRec = "Name = ";
    static final String TypeRec = "Type = ";
    static final String MarkID = "Mark";
    static final String RouteID = "Route";
    static final String TrackID = "Track";
    static final String RangeBrID = "RangeBearing";
    static final String LatLonRec = "LatLon = ";
    static final String MarksRec = "Marks = ";
    static final String TrackMarksBeg = "TrackMarks = {{";
    static final String TrackMarksEnd = "}}";
    private static int lineNbr = 0;
    private static String owner = "?";
    public static Hashtable nbltecRtes;
    public static Hashtable nbltecTrks;
    static final String EndLine = "\r\n";
    static final String Header = "[{{FileHeader}}]\r\nVersion = 4.1.353\r\nAuthor = Nobeltec Corporation\r\nDesc = Automatic Export of objects from Nobeltec Visual Mariner\r\n\r\n";
    static final String RouteRecs = "Type = Route\r\nCreateTime = 2001-08-13 21:13:18Z\r\nHidden = TRUE\r\nLocked = TRUE\r\nDesc = \r\nColor = 0x000000\r\nDisplayLegRangeBearing = TRUE\r\nCollShowDirectionArrows = FALSE\r\nActiveColor = 0x30ff00\r\nInactiveColor = 0x000000\r\nActiveVesselObjRef = 00000000-0000-0000-0000-000000000000\r\nMarks = ";
    static final String MarkRec1 = "Type = Mark\r\nCreateTime = 1999-10-30 10:22:12Z\r\nHidden = TRUE\r\nLocked = FALSE\r\nDesc =\r\nColor = 0x000000\r\nLatLon = ";
    static final String MarkRec2 = "BmpIdx = 2\r\nActiveVesselObjRef = 00000000-0000-0000-0000-000000000000\r\nArrivalCircleRadius = 0.050 nm\r\nNameOffset = -55,10\r\nDescOffset = -15,20\r\nShowName = TRUE\r\nShowDescription = FALSE\r\nRangeCircleColor = 0xff0000\r\nRangeCircleDisplay Count = 0\r\nRangeCirclePen Width = 1\r\nBoundaryCircleOffLimits = None\r\nRangeCircleRadius = 0.500 nm\r\nRangeCircleBindToArrivalCircle = FALSE\r\nMarkRenamed = TRUE\r\nExistsOutsideCollection = TRUE\r\nPlanningLegSOG = 5.0 kts\r\nNameDisplayMoved = FALSE\r\nAssociatedTrack = 00000000-0000-0000-0000-000000000000\r\nTDChain1 =\r\nTDChain2 =\r\nAllowDrivingTheAutopilot = TRUE\r\n";
    static final String TrackRecs = "Type = Track\r\nCreateTime = 1999-12-07 10:59:19Z\r\nHidden = TRUE\r\nLocked = FALSE\r\nDesc =\r\nColor = 0x0000ff\r\nActiveVesselObjRef = 00000000-0000-0000-0000-000000000000\r\nTrackingByTimeInterval = TRUE\r\nTrackingTimeIntervalSeconds = 300\r\nTrackingByDistanceInterval = TRUE\r\nTrackingDistanceInterval = 0.500 nm\r\nTrackingByCourseChange = TRUE\r\nTrackingCourseChangeDegrees = 10.000000\r\nTrackingWakeEnabled = FALSE\r\nTrackingWakeTimeoutSeconds = 600\r\nNumberOfTrackMarks = ";
    private static Random ranNbr;
    private static char[] hexValue;

    public static void readNobeltec(BufferedReader in, WPFileRecs lines) throws IOException, BadPositionException {
        boolean debug = false;
        lineNbr = 0;
        nbltecTrks = null;
        nbltecRtes = null;
        String inputLine = Nobeltec.inReadLine(in);
        if (!inputLine.equals(FileHdr)) {
            new ErrDialog(new Frame(), "Invalid Nobeltec file, first record not: [{{FileHeader}}]\n >" + inputLine + "<");
            return;
        }
        inputLine = Nobeltec.inReadLine(in);
        if (!inputLine.startsWith(VersionID)) {
            new ErrDialog(new Frame(), "Invalid Nobeltec file, second record not: Version = \n >" + inputLine + "<");
            return;
        }
        String version = inputLine.substring(VersionID.length());
        Hashtable<String, Position> svMarks = new Hashtable<String, Position>();
        Hashtable<String, String> svRoutes = new Hashtable<String, String>();
        int trkIdx = 0;
        while ((inputLine = Nobeltec.inReadLine(in)) != null) {
            if (!inputLine.startsWith(GroupHdr)) continue;
            String name = null;
            int hdrIdx = inputLine.indexOf(IDBegins);
            if (hdrIdx > 1) {
                name = inputLine.substring(1, hdrIdx);
            }
            String grpIdx = inputLine.substring(hdrIdx, inputLine.length() - 1);
            String temp = Nobeltec.inReadLine(in);
            if (temp.startsWith(NameRec)) {
                name = temp.substring(NameRec.length());
                temp = Nobeltec.inReadLine(in);
            }
            if (temp.startsWith(TypeRec)) {
                String type;
                if (name == null) {
                    name = MarkID + lineNbr;
                }
                if ((type = temp.substring(TypeRec.length())).equals(MarkID)) {
                    boolean fndLatLon = false;
                    while ((inputLine = Nobeltec.inReadLine(in)) != null) {
                        if (!inputLine.startsWith(LatLonRec)) continue;
                        String aRec = name + "|" + inputLine.substring(LatLonRec.length());
                        lines.addElement(aRec);
                        svMarks.put(grpIdx, lines.pf.newPosition(aRec));
                        fndLatLon = true;
                        break;
                    }
                    if (fndLatLon) continue;
                    System.err.println("LatLon =  not found at line " + lineNbr);
                    continue;
                }
                if (type.equals(RouteID)) {
                    boolean fndMarksRec = false;
                    while ((inputLine = Nobeltec.inReadLine(in)) != null) {
                        if (!inputLine.startsWith(MarksRec)) continue;
                        svRoutes.put(name, inputLine.substring(MarksRec.length()));
                        fndMarksRec = true;
                        break;
                    }
                    if (fndMarksRec) continue;
                    System.err.println("Marks =  not found at line " + lineNbr);
                    continue;
                }
                if (type.equals(TrackID)) {
                    if (nbltecTrks == null) {
                        nbltecTrks = new Hashtable();
                    }
                    ++trkIdx;
                    int wpIdx = 0;
                    block3: while ((inputLine = Nobeltec.inReadLine(in)) != null) {
                        if (!inputLine.equals(TrackMarksBeg)) continue;
                        WPFileRecs wpfRecs = new WPFileRecs();
                        wpfRecs.setPositionFactory(lines.pf);
                        wpfRecs.description = name;
                        wpfRecs.owner = owner;
                        wpfRecs.filename = "Nobeltec_Track" + trkIdx + Nobeltec_Ext;
                        while ((inputLine = Nobeltec.inReadLine(in)) != null) {
                            if (inputLine.equals(TrackMarksEnd)) {
                                nbltecTrks.put(name, wpfRecs);
                                break block3;
                            }
                            String wpNm = "T" + trkIdx + "W" + wpIdx++;
                            String aRec = wpNm + "|" + inputLine;
                            wpfRecs.addElement(aRec);
                        }
                        break block3;
                    }
                    if (wpIdx != 0) continue;
                    System.err.println("TrackMarks = {{ not found at line " + lineNbr);
                    continue;
                }
                if (type.equals(RangeBrID)) {
                    if (!WayPointDefs.debug) continue;
                    System.out.println("Ignoring: " + type);
                    continue;
                }
                System.out.println("Unknown type: " + type);
                continue;
            }
            new ErrDialog(new Frame(), "Invalid record type: " + temp + "\n at line:" + lineNbr);
            return;
        }
        if (svRoutes.size() > 0) {
            nbltecRtes = new Hashtable();
            Enumeration en = svRoutes.keys();
            while (en.hasMoreElements()) {
                String rtNm = (String)en.nextElement();
                String marks = (String)svRoutes.get(rtNm);
                StringTokenizer st = new StringTokenizer(marks, ",");
                Positions pos = new Positions(st.countTokens());
                pos.description = rtNm;
                pos.owner = owner;
                pos.fileName = "Nobeltec_Route.NTEC";
                int wpCnt = 0;
                while (st.hasMoreTokens()) {
                    String markId = st.nextToken();
                    if (!markId.startsWith(IDBegins)) {
                        int ix = markId.indexOf(IDBegins);
                        markId = markId.substring(ix);
                    }
                    Position p = (Position)svMarks.get(markId);
                    pos.add(p);
                    ++wpCnt;
                }
                nbltecRtes.put(rtNm, pos);
            }
        }
        in.close();
    }

    private static String inReadLine(BufferedReader in) throws IOException {
        ++lineNbr;
        return in.readLine();
    }

    public static void writeFile(Positions pos) {
        System.out.println("writing Nobeltec file: " + type + " to " + pos.fileName + ", contains: " + pos.size() + " waypoints");
        if (type.equals(Route)) {
            ranNbr = new Random(System.currentTimeMillis());
            PrintWriter pw = null;
            DecimalFormat decForm1 = new DecimalFormat("00.00000");
            String[] uids = new String[pos.size()];
            int i = 0;
            while (i < pos.size()) {
                uids[i] = Nobeltec.getUID();
                ++i;
            }
            try {
                pw = new PrintWriter(new FileOutputStream(pos.fileName));
                pw.print(Header);
                pw.print("[++" + Nobeltec.getUID() + GroupHdrEnd + EndLine);
                pw.print(NameRec + pos.description + EndLine);
                pw.print(RouteRecs);
                int i2 = 0;
                while (i2 < uids.length) {
                    pw.print(IDBegins + uids[i2] + IDBegins);
                    if (i2 < uids.length - 1) {
                        pw.print(",");
                    }
                    ++i2;
                }
                pw.print(EndLine);
                int i3 = 0;
                while (i3 < pos.size()) {
                    Position posD = (Position)pos.elementAt(i3);
                    pw.print("[++" + uids[i3] + GroupHdrEnd + EndLine);
                    pw.print(NameRec + posD.getName() + EndLine);
                    pw.print(MarkRec1);
                    pw.print(posD.getDegLat() + " " + decForm1.format(posD.getMinLatD()) + " " + posD.getDirLat() + " " + posD.getDegLong() + " " + decForm1.format(posD.getMinLongD()) + " " + posD.getDirLong() + EndLine);
                    pw.print(MarkRec2);
                    ++i3;
                }
            }
            catch (Exception ex) {
                new ErrDialog(new Frame(), "Error writing Nobeltec file: " + ex.getMessage());
                ex.printStackTrace();
            }
            if (pw != null) {
                pw.close();
            }
        } else if (type.equals(Track)) {
            ranNbr = new Random(System.currentTimeMillis());
            PrintWriter pw = null;
            DecimalFormat decForm1 = new DecimalFormat("00.00000");
            try {
                pw = new PrintWriter(new FileOutputStream(pos.fileName));
                pw.print(Header);
                pw.print(GroupHdr + pos.description + IDBegins + Nobeltec.getUID() + GroupHdrEnd + EndLine);
                pw.print(TrackRecs);
                pw.print(pos.size() + EndLine + TrackMarksBeg + EndLine);
                int i = 0;
                while (i < pos.size()) {
                    Position posD = (Position)pos.elementAt(i);
                    pw.print(posD.getDegLat() + " " + decForm1.format(posD.getMinLatD()) + " " + posD.getDirLat() + " " + posD.getDegLong() + " " + decForm1.format(posD.getMinLongD()) + " " + posD.getDirLong() + " 1999-12-07 04:59:19Z" + EndLine);
                    ++i;
                }
                pw.print("}}\r\n");
            }
            catch (Exception ex) {
                new ErrDialog(new Frame(), "Error writing Nobeltec file: " + ex.getMessage());
                ex.printStackTrace();
            }
            if (pw != null) {
                pw.close();
            }
        } else {
            System.err.println("writeFile: unknown type: " + type);
        }
    }

    private static String getUID() {
        byte[] ranBytes = new byte[16];
        ranNbr.nextBytes(ranBytes);
        StringBuffer sb = new StringBuffer(ranBytes.length * 2 + 4);
        sb.setLength(ranBytes.length * 2 + 4);
        int j = 0;
        int i = 0;
        while (i < ranBytes.length) {
            int ix = ranBytes[i] & 0xFF;
            sb.setCharAt(j++, hexValue[ix >> 4]);
            sb.setCharAt(j++, hexValue[ix & 0xF]);
            if (j == 8 || j == 13 || j == 18 || j == 23) {
                sb.setCharAt(j++, '-');
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] wpRecs = new String[]{"For Testing Plot;UPPER LEFT&GPS=UPPRLE;29;30;N;89;30;W;POI", "For Testing Plot;Lower right&GPS=LOWERRI;25;0;N;85;0;W", "For Testing Plot;Lower left&GPS=LOWERLE;25;0;N;86;0;W", "For Testing Plot;Upper left&GPS=UPPERLE;26;0;N;86;0;W", "For Testing Plot;Upper right&GPS=UPPERRI;26;0;N;85;0;W", "For Testing Plot;lower right (dup)&GPS=UPPER;25;0;N;85;0;W", "For Testing Plot;LOWER RIGHT&GPS=LWERRI;20;0;N;80;0;W;POI"};
        Positions pos = new Positions(wpRecs.length);
        pos.description = "Test route/track";
        pos.fileName = "Testing_Nobeltec.NTEC";
        int i = 0;
        while (i < wpRecs.length) {
            try {
                pos.add(new Position(wpRecs[i]));
            }
            catch (Exception ex) {
                System.err.println(ex + "  adding " + wpRecs[i]);
            }
            ++i;
        }
        type = Route;
        Nobeltec.writeFile(pos);
        try {
            BufferedReader br = new BufferedReader(new FileReader(pos.fileName));
            WPFileRecs lines = new WPFileRecs();
            lines.setPositionFactory(new NobeltecPositionFactory());
            Nobeltec.readNobeltec(br, lines);
            if (type == Route) {
                System.out.println("Read " + nbltecRtes.size() + " route\n" + nbltecRtes);
            } else {
                System.out.println("Read " + nbltecTrks.size() + " track\n" + nbltecTrks);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    static {
        hexValue = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

