/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.NavSoftwareInterfaces;

import NormsTools.GetInput;
import WayPointApps.Position;
import WayPointApps.Positions;
import WayPointApps.WPFileRecs;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class MaxSea {
    static final byte[] WaypointHdr = new byte[]{2, 15, -5, -41, 1, -41, 38, 0, 0, 0, 0, 0};
    static final byte[] WaypointEnd = new byte[]{80, 104, 53, -71, 6, 0, 3, 0, 0, 0, 0, 0};
    public static final int MaxSeaHdrLen = 512;
    public static final int DispNameLen = 4;
    public static final int DispDegLat = 12;
    public static final int DispLatDirFlag = 15;
    public static final int DispDegLong = 16;
    public static final int DispLongDirFlag = 19;
    public static final int MaxSeaWPRecLen = 32;
    public static final byte DirFlagMask = -128;
    public static final byte StripFlagMask = 127;
    public static final float OneDeg = (float)Math.PI / 180;
    static final String MaxSeaSepChar = "|";
    public static final String MaxSea_Ext = ".WPT";
    static final byte[] Header1 = new byte[]{76, 48, 48, 56, 26, 76, 105, 118, 105, 110, 103, 115, 116, 111, 110, 32, 45, 32, 83, 97, 112, 111, 100, 105, 108, 108, 97, 46, 87, 80, 84, 16, 19, 110, 124, 0, 45, 110, 124, 0, 84, -15, 7, 1, 2, 0, 7, 1, 1, 0, 64, 0, 0, 0, 0, 0, 1, 0, 126, 0, 44, 110, 124, 0, 12, -21, 7, 1, -41, -111, 102, -68, -41, -111, 102, -68, 0, -22, 7, 1, -20, 44, 1, 16, 67, 0, 0, 0, 84, -15, 7, 1, 2, 0, 7, 1, 1, 0, 64, 0, 67, 58, 0, 16, -44, -81, 126, 0, -34, -22, 7, 1, 16, -20, 7, 1, 54, -123, 125, 0, 0, 0, 0, 0, 52, -22, 7, 1, -34, -22, 7, 1, 16, -20, 7, 1, 54, -123, 125, 0, 0, 0, 7, 1, 6, 0};
    static final byte[] Header2 = new byte[512 - Header1.length];

    private MaxSea() {
    }

    public static void readMaxSea(String fn, WPFileRecs lines) throws IOException {
        String fName;
        FileInputStream fis = new FileInputStream(fn);
        byte[] header = new byte[512];
        byte[] record = new byte[32];
        byte[] degWork = new byte[4];
        int len = fis.read(header, 0, 512);
        if (len != 512) {
            System.err.println("Error reading header, only read " + len);
        }
        byte nmLen = header[4];
        lines.filename = fName = new String(header, 5, (int)nmLen);
        if (fName.endsWith(MaxSea_Ext)) {
            fName = fName.substring(0, fName.length() - MaxSea_Ext.length());
        }
        lines.description = fName;
        GetInput gi = new GetInput("Waypoint name prefix", new Frame(), "Set prefix", "WP_");
        String wpNmPrefix = gi.getResponse();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(degWork));
        dis.mark(4);
        int wpNbr = 0;
        while ((len = fis.read(record, 0, 32)) >= 32) {
            ++wpNbr;
            int i = 0;
            while (i < 4) {
                degWork[i] = record[15 - i];
                ++i;
            }
            degWork[0] = (byte)(degWork[0] & 0x7F);
            dis.reset();
            float degLat = dis.readFloat() / ((float)Math.PI / 180);
            int i2 = 0;
            while (i2 < 4) {
                degWork[i2] = record[19 - i2];
                ++i2;
            }
            degWork[0] = (byte)(degWork[0] & 0x7F);
            dis.reset();
            float degLong = dis.readFloat() / ((float)Math.PI / 180);
            String dirLat = (record[15] & 0xFFFFFF80) == 0 ? "N" : "S";
            String dirLong = (record[19] & 0xFFFFFF80) == 0 ? "E" : "W";
            String wpRec = fName + MaxSeaSepChar + wpNmPrefix + wpNbr + MaxSeaSepChar + degLat + MaxSeaSepChar + dirLat + MaxSeaSepChar + degLong + MaxSeaSepChar + dirLong;
            lines.addElement(wpRec);
        }
        fis.close();
        dis.close();
    }

    public static void writeFile(Positions pos) {
        String fn = pos.fileName;
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            fos.write(Header1);
            fos.write(Header2);
            byte[] degWork = new byte[4];
            byte[] reverse = new byte[4];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
            DataOutputStream dos = new DataOutputStream(baos);
            int i = 0;
            while (i < pos.size()) {
                fos.write(WaypointHdr);
                Position p = pos.get(i);
                float lat = (float)p.decDegLat() * ((float)Math.PI / 180);
                baos.reset();
                dos.writeFloat(lat);
                degWork = baos.toByteArray();
                if (!p.directionNorth()) {
                    degWork[0] = (byte)(degWork[0] | 0xFFFFFF80);
                }
                fos.write(MaxSea.reverse(degWork));
                float lng = (float)p.decDegLong() * ((float)Math.PI / 180);
                baos.reset();
                dos.writeFloat(lng);
                degWork = baos.toByteArray();
                if (p.directionWest()) {
                    degWork[0] = (byte)(degWork[0] | 0xFFFFFF80);
                }
                fos.write(MaxSea.reverse(degWork));
                fos.write(WaypointEnd);
                ++i;
            }
            fos.close();
            System.out.println("MaxSea file: " + fn + " written");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static byte[] reverse(byte[] b) {
        byte[] work = new byte[b.length];
        int i = 0;
        while (i < b.length) {
            work[i] = b[b.length - 1 - i];
            ++i;
        }
        return work;
    }
}

