/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import NormsTools.ErrDialog;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public final class MinInputField
extends TextField
implements FocusListener {
    static final String blanks = "                    ";
    Frame errF = null;
    double value;
    int nbrChar;
    int lastPos;
    double minValue = 0.0;
    double maxValue = 60.0;
    boolean haveWarned = false;
    boolean dataChanged = false;

    public MinInputField(Frame frame, int n) {
        super(blanks.substring(0, n), n + 1);
        this.errF = frame;
        this.nbrChar = n;
        this.addFocusListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                MinInputField.this.haveWarned = false;
                MinInputField.this.dataChanged = true;
                if (('0' > c || c > '9') && c != '.' && !Character.isISOControl(c) || MinInputField.this.getText().trim().length() >= MinInputField.this.nbrChar && !Character.isISOControl(c)) {
                    keyEvent.consume();
                } else {
                    MinInputField.this.lastPos = MinInputField.this.getCaretPosition();
                }
            }
        });
        this.value = 0.0;
    }

    public double getValue() {
        this.checkValue();
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
        super.setText("" + d);
    }

    public void setMinMax(double d, double d2) {
        this.minValue = d;
        this.maxValue = d2;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public void setText(String string) {
        super.setText(string);
        this.value = string.equals("") ? 0.0 : Double.valueOf(string.trim());
    }

    public void setErrFrame(Frame frame) {
        this.errF = frame;
    }

    public void setHaveWarned(boolean bl) {
        this.haveWarned = bl;
    }

    public boolean ckValid() {
        if (this.getText().trim().equals("")) {
            if (this.errF != null) {
                new ErrDialog(this.errF, "missing Minutes value", false);
            } else {
                System.err.println("missing Minutes value");
            }
            this.requestFocus();
            return false;
        }
        return this.checkValue();
    }

    private boolean checkValue() {
        if (this.getText().trim().equals("")) {
            return true;
        }
        try {
            double d = Double.valueOf(this.getText().trim());
            if (d > this.maxValue || d < this.minValue) {
                if (this.errF != null) {
                    new ErrDialog(this.errF, d + " Minutes out of range: " + this.minValue + ":" + this.maxValue, false);
                } else {
                    System.err.println(d + " Minutes out of range: " + this.minValue + ":" + this.maxValue);
                }
                this.requestFocus();
                return false;
            }
            this.value = d;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.setText("" + this.value);
            this.setCaretPosition(this.lastPos);
            return false;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        if (focusEvent.getComponent() == this) {
            if (this.getText().trim().equals("") && !this.haveWarned) {
                this.haveWarned = true;
                if (this.errF != null) {
                    new ErrDialog(this.errF, "missing Minutes value", false);
                } else {
                    System.err.println("missing Minutes value");
                }
                this.requestFocus();
            } else if (!this.haveWarned && !this.checkValue()) {
                this.haveWarned = true;
                this.requestFocus();
            }
        } else {
            System.err.println("Unknown focusLost: " + focusEvent);
        }
    }
}

