/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import NormsTools.ErrDialog;
import NormsTools.ShowMsgBox;
import WayPointApps.IndexFileRec;
import WayPointApps.WPFileRecs;
import java.awt.Frame;
import java.util.Vector;

public class IndexFileRecs
extends Vector {
    public String filename;
    public String owner;
    public String description = "";
    public boolean changed = false;

    public IndexFileRec get(int n) {
        try {
            return (IndexFileRec)this.elementAt(n);
        }
        catch (Exception exception) {
            System.err.println("IndexFileRecs.get() idx OOB at " + n + " vs " + this.size());
            return new IndexFileRec();
        }
    }

    public void set(IndexFileRec indexFileRec, int n) {
        this.changed = true;
        this.setElementAt(indexFileRec, n);
    }

    public IndexFileRecs(WPFileRecs wPFileRecs, String string) {
        super(wPFileRecs.size() > 0 ? wPFileRecs.size() : 1);
        this.filename = string;
        this.owner = wPFileRecs.owner;
        this.description = wPFileRecs.description;
        if (wPFileRecs.size() == 0) {
            if (wPFileRecs.isNew) {
                new ShowMsgBox(new Frame(), "New Index file", "Enter Route/Waypoint references for this new file");
            } else {
                new ErrDialog(new Frame(), "File was not found: " + string);
            }
        } else {
            int n = 0;
            while (n < wPFileRecs.size()) {
                this.addElement(new IndexFileRec((String)wPFileRecs.elementAt(n)));
                ++n;
            }
        }
    }

    public void add(IndexFileRec indexFileRec) {
        this.changed = true;
        this.addElement(indexFileRec);
    }

    public void moveUp(int n) {
        if (n > 0 && n < this.size()) {
            IndexFileRec indexFileRec = this.get(n);
            this.removeElementAt(n);
            this.insertElementAt(indexFileRec, n - 1);
        }
    }

    public void moveDown(int n) {
        if (n >= 0 && n < this.size() - 1) {
            IndexFileRec indexFileRec = this.get(n);
            this.insertElementAt(indexFileRec, n + 2);
            this.removeElementAt(n);
        }
    }
}

