/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices;

import NormsTools.ErrDialog;
import NormsTools.Evaluator;
import WayPointApps.DegInputField;
import WayPointApps.MinInputField;
import WayPointApps.WPFileRecs;
import WayPointApps.WayPointDefs;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NobeltecEval
extends Evaluator {
    Hashtable routeRecs;
    int count = 0;
    double fromLat;
    double toLat;
    double fromLong;
    double toLong;
    boolean testLat = false;
    boolean testLong = false;

    public NobeltecEval(Hashtable rtes) {
        this.routeRecs = rtes;
        if (WayPointDefs.debug) {
            System.out.println("NTeval routes:" + rtes.getClass());
        }
        GetBndsDialog getBndsDialog = new GetBndsDialog(new Frame());
    }

    public int evaluate(Object obj) {
        this.count = 0;
        if (obj instanceof WPFileRecs) {
            WPFileRecs wps = (WPFileRecs)obj;
            int i = 0;
            while (i < wps.size()) {
                String line = (String)wps.elementAt(i);
                int ix = line.indexOf("|");
                StringTokenizer st = new StringTokenizer(line.substring(ix + 1), " ");
                int degLatI = Integer.parseInt(st.nextToken());
                double minLat = Double.parseDouble(st.nextToken());
                double degLat = (double)degLatI + minLat / 60.0;
                String dirLat = st.nextToken();
                int degLongI = Integer.parseInt(st.nextToken());
                double minLong = Double.parseDouble(st.nextToken());
                double degLong = (double)degLongI + minLong / 60.0;
                String dirLong = st.nextToken();
                if (!(this.testLat && (degLat > this.fromLat || degLat < this.toLat) || this.testLong && (degLong > this.fromLong || degLong < this.toLong))) {
                    ++this.count;
                }
                ++i;
            }
        } else {
            System.err.println("evaluate unable to process this object: " + obj.getClass());
        }
        return this.count;
    }

    public String toString() {
        return "Nobeltec Evaluator. From " + this.fromLat + " to " + this.toLat;
    }

    public static void main(String[] args) {
        NobeltecEval nte = new NobeltecEval(null);
        System.exit(0);
    }

    class GetBndsDialog
    extends Dialog
    implements ActionListener {
        Frame frm;
        Button searchBtn = new Button("Search");
        Button cancel = new Button("Cancel");
        DegInputField degFromLat;
        MinInputField minFromLat;
        DegInputField degToLat;
        MinInputField minToLat;
        DegInputField degFromLong;
        MinInputField minFromLong;
        DegInputField degToLong;
        MinInputField minToLong;
        TextField dirFromLat;
        TextField dirToLat;
        TextField dirFromLong;
        TextField dirToLong;
        private boolean done = false;

        GetBndsDialog(Frame frm) {
            super(frm, "Enter bounds for search (From | To)", true);
            this.setResizable(false);
            this.frm = frm;
            Panel p1 = new Panel(new FlowLayout(0));
            p1.add(new Label("Lat: "));
            this.degFromLat = new DegInputField(frm, 2);
            this.degFromLat.setMinMax(0, 89);
            p1.add(this.degFromLat);
            this.minFromLat = new MinInputField(frm, 4);
            p1.add(this.minFromLat);
            this.dirFromLat = new TextField("N", 1);
            p1.add(this.dirFromLat);
            p1.add(new Label(" To:"));
            this.degToLat = new DegInputField(frm, 2);
            this.degToLat.setMinMax(0, 89);
            p1.add(this.degToLat);
            this.minToLat = new MinInputField(frm, 4);
            p1.add(this.minToLat);
            this.dirToLat = new TextField("N", 1);
            p1.add(this.dirToLat);
            this.add((Component)p1, "North");
            Panel p2 = new Panel(new FlowLayout(0));
            p2.add(new Label("Long:"));
            this.degFromLong = new DegInputField(frm, 2);
            this.degFromLong.setMinMax(0, 89);
            p2.add(this.degFromLong);
            this.minFromLong = new MinInputField(frm, 4);
            p2.add(this.minFromLong);
            this.dirFromLong = new TextField("W", 1);
            p2.add(this.dirFromLong);
            p2.add(new Label(" To:"));
            this.degToLong = new DegInputField(frm, 2);
            this.degToLong.setMinMax(0, 89);
            p2.add(this.degToLong);
            this.minToLong = new MinInputField(frm, 4);
            p2.add(this.minToLong);
            this.dirToLong = new TextField("W", 1);
            p2.add(this.dirToLong);
            this.add((Component)p2, "Center");
            Panel p3 = new Panel();
            p3.add(this.searchBtn);
            this.searchBtn.addActionListener(this);
            this.cancel.addActionListener(this);
            p3.add(this.cancel);
            this.add((Component)p3, "South");
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ GetBndsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowClosing(WindowEvent we) {
                    GetBndsDialog.access$000((GetBndsDialog)this.this$1).cancelled = true;
                    this.this$1.dispose();
                    this.this$1.setVisible(false);
                }
            });
            this.setSize(410, 120);
            Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((ss.width - this.getBounds().width) / 2, (ss.height - this.getBounds().height) / 2);
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == this.searchBtn) {
                if (!(this.degFromLat.ckValid() && this.minFromLat.ckValid() && this.ckDir(this.dirFromLat, "Nn") && this.degToLat.ckValid() && this.minToLat.ckValid() && this.ckDir(this.dirToLat, "Nn"))) {
                    return;
                }
                NobeltecEval.this.fromLat = (double)this.degFromLat.getValue() + this.minFromLat.getValue() / 60.0;
                NobeltecEval.this.toLat = (double)this.degToLat.getValue() + this.minToLat.getValue() / 60.0;
                double temp = Math.max(NobeltecEval.this.fromLat, NobeltecEval.this.toLat);
                NobeltecEval.this.toLat = Math.min(NobeltecEval.this.fromLat, NobeltecEval.this.toLat);
                NobeltecEval.this.fromLat = temp;
                boolean bl = NobeltecEval.this.testLat = NobeltecEval.this.toLat != 0.0 || NobeltecEval.this.fromLat != 0.0;
                if (WayPointDefs.debug) {
                    System.out.println("NTeval Lat set to From: " + NobeltecEval.this.fromLat + " to: " + NobeltecEval.this.toLat);
                }
                if (!(this.degFromLong.ckValid() && this.minFromLong.ckValid() && this.ckDir(this.dirFromLong, "Ww") && this.degToLong.ckValid() && this.minToLong.ckValid() && this.ckDir(this.dirToLong, "Ww"))) {
                    return;
                }
                NobeltecEval.this.fromLong = (double)this.degFromLong.getValue() + this.minFromLong.getValue() / 60.0;
                NobeltecEval.this.toLong = (double)this.degToLong.getValue() + this.minToLong.getValue() / 60.0;
                temp = Math.max(NobeltecEval.this.fromLong, NobeltecEval.this.toLong);
                NobeltecEval.this.toLong = Math.min(NobeltecEval.this.fromLong, NobeltecEval.this.toLong);
                NobeltecEval.this.fromLong = temp;
                boolean bl2 = NobeltecEval.this.testLong = NobeltecEval.this.toLong != 0.0 || NobeltecEval.this.fromLong != 0.0;
                if (WayPointDefs.debug) {
                    System.out.println("NTeval Long set to From: " + NobeltecEval.this.fromLong + " to: " + NobeltecEval.this.toLong);
                }
                this.done = true;
                this.setVisible(false);
                this.dispose();
            } else if (src == this.cancel) {
                NobeltecEval.this.cancelled = true;
                this.setVisible(false);
                this.dispose();
            } else {
                System.out.println("Unknown ae " + ae);
            }
        }

        boolean ckDir(TextField tf, String choices) {
            String dir = tf.getText().trim();
            if (dir.length() != 1) {
                new ErrDialog(this.frm, "Missing/invalid direction value: " + dir);
                tf.requestFocus();
                return false;
            }
            if (choices.indexOf(dir) < 0) {
                new ErrDialog(this.frm, "Invalid direction value: " + dir);
                tf.requestFocus();
                return false;
            }
            return true;
        }

        static /* synthetic */ NobeltecEval access$000(GetBndsDialog x0) {
            return x0.NobeltecEval.this;
        }
    }
}

