/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices.Micrologic;

import NormsTools.ChoiceOfYesOrNo;
import NormsTools.ErrDialog;
import NormsTools.GetInput;
import NormsTools.ShowCounters;
import NormsTools.ShowMsgBox;
import SerialComm.SerialConnection;
import SerialComm.SerialConnectionException;
import SerialComm.SerialParameters;
import WayPointApps.BadPositionException;
import WayPointApps.GPSDevices.GPSInterface;
import WayPointApps.GPSDevices.InvalidDataException;
import WayPointApps.GPSDevices.SerialCommException;
import WayPointApps.Position;
import WayPointApps.Positions;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class MicrologicGPSInterface
extends GPSInterface
implements ActionListener {
    static final byte StartChar = 36;
    static final byte CkSumChar = 42;
    static final String CkSumCharC = "*";
    static final byte SepChar = 44;
    static final char SepCharC = ',';
    static final String SepCharS = ",";
    static final byte CRChar = 13;
    static final byte LFChar = 10;
    final String KeySepStr = " - ";
    final int WaitTime = 200;
    final int StartTime = 40000;
    static final String MCLWP_Prefix = "$PMCLF";
    static final String MCLRTE_Prefix = "$PMCLK";
    static final String MCLWP_Hdr = "$GPWPL";
    final String GPSDownLoadFN = "GPSDownLoad.wps";
    final String GPSDownLoadDesc = "These waypoints were downloaded from GPS ";
    public static final int MaxNbrWPs = 500;
    static final int MaxNbrRoutes = 30;
    static final int MaxWPPerRoute = 50;
    final int IdentLength = 7;
    final int MaxWPNbrsPerRouteRec = 11;
    final int TrackLogID = 503;
    final boolean debug = false;
    private SerialParameters parameters = new SerialParameters();
    private SerialConnection connection;
    Frame mainFrm;
    ShowMsgBox smb;
    DecimalFormat minForm;
    boolean fndWPs = false;
    Positions wpPos;
    Positions tlPos;
    Hashtable usedNames;
    Hashtable routes;
    Vector routesUsed;
    boolean[] wpNbrTbl;
    Hashtable byWPNbr;
    int writeDelay = 3000;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm,ddMMyy");
    Menu ourM = new Menu("Micrologic");
    MenuItem listWPNbrsMI = new MenuItem("List used waypoint numbers");
    MenuItem assignWPNbrsMI = new MenuItem("Assign waypoint numbers");
    MenuItem setWPNbrsMI = new MenuItem("Set waypoint numbers...");
    MenuItem changeWPNbrsMI = new MenuItem("Change waypoint name, etc for matching position");
    MenuItem clearWPNbrsMI = new MenuItem("Clear waypoint numbers");
    private String wpDate;
    private String wpTime;
    private String wpIcon;
    private String wpTimeDate;
    private byte[] readBytes = new byte[4000];
    private int wrtPtr = 0;
    private int rdPtr = 0;
    final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    static char[] hexValue = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MicrologicGPSInterface() {
        this.minForm = (DecimalFormat)NumberFormat.getNumberInstance();
        this.minForm.applyPattern("00.000");
    }

    public Menu addMenu() {
        this.ourM.add(this.listWPNbrsMI);
        this.listWPNbrsMI.setEnabled(false);
        this.listWPNbrsMI.addActionListener(this);
        this.ourM.add(this.assignWPNbrsMI);
        this.assignWPNbrsMI.setEnabled(false);
        this.assignWPNbrsMI.addActionListener(this);
        this.ourM.add(this.changeWPNbrsMI);
        this.changeWPNbrsMI.addActionListener(this);
        this.changeWPNbrsMI.setEnabled(false);
        this.ourM.add(this.setWPNbrsMI);
        this.setWPNbrsMI.setEnabled(true);
        this.setWPNbrsMI.addActionListener(this);
        this.ourM.add(this.clearWPNbrsMI);
        this.clearWPNbrsMI.addActionListener(this);
        this.clearWPNbrsMI.setEnabled(true);
        return this.ourM;
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.listWPNbrsMI) {
            new ShowMsgBox("Note:", "List not implemented yet", new Frame(), false);
            return;
        }
        if (src == this.assignWPNbrsMI) {
            if (this.wpNbrTbl == null) {
                new ShowMsgBox("Error:", "Need to read waypoints from GPS first.", new Frame(), false);
                System.err.println("No wpNbrTbl found, try again to use the test table!!!");
                this.wpNbrTbl = new boolean[501];
                this.wpNbrTbl[1] = true;
                return;
            }
            Positions ptc = this.wpif.getPositions();
            if (ptc == null) {
                new ShowMsgBox("Error:", "Need to open a waypoints file.", new Frame(), false);
                return;
            }
            ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(new Frame(), "Do you want to assign the " + ptc.size() + " waypoint numbers for " + ptc.description + "?");
            if (!cyn.isYes()) {
                return;
            }
            this.appendLogNL("Assigning waypoint numbers starting with " + this.nextWPNbr(1));
            this.assignWPN(ptc);
        } else if (src == this.setWPNbrsMI) {
            Positions pxx = this.wpif.getPositions();
            if (pxx == null) {
                new ShowMsgBox("Error:", "Need to open a waypoints file.", new Frame(), false);
                return;
            }
            int wpn = 0;
            Frame f = new Frame();
            ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(f, "Do you want to set the " + pxx.size() + " waypoint numbers\n for " + pxx.description + "?");
            if (!cyn.isYes()) {
                return;
            }
            while (true) {
                GetInput gi;
                String wpNbr;
                if ((wpNbr = (gi = new GetInput("Enter waypoint number to use: 1 to 500", f, 3, "Set waypoint nbrs")).getResponse()).equals("")) {
                    return;
                }
                try {
                    wpn = new Integer(wpNbr);
                    if (wpn >= 1 && wpn <= 500) {
                        break;
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                new ErrDialog(f, "Invalid waypoint nbr: " + wpNbr + ". Must be numeric and from 1 to " + 500);
            }
            int startWPN = wpn;
            int i = 0;
            while (i < pxx.size()) {
                Position p = pxx.get(i);
                p.setIdxNbr(wpn++);
                ++i;
            }
            this.appendLogNL("Set " + pxx.size() + " waypoint nbrs  from " + startWPN + " to " + --wpn + " for " + pxx.description);
        } else if (src == this.changeWPNbrsMI) {
            Positions ptc = this.wpif.getPositions();
            if (ptc == null) {
                new ShowMsgBox("Error:", "Need to open a waypoints file.", new Frame(), false);
                return;
            }
            ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(new Frame(), "Do you want to change the " + ptc.size() + " waypoint names,etc for " + ptc.description + "?");
            if (!cyn.isYes()) {
                return;
            }
            this.appendLogNL("Searching for matching positions for " + ptc.description);
            int i = 0;
            while (i < ptc.size()) {
                Position p = ptc.get(i);
                boolean found = false;
                int j = 0;
                while (j < this.wpPos.size()) {
                    Position gpsWP = this.wpPos.get(j);
                    if (gpsWP.samePosition(p)) {
                        found = true;
                        if (!gpsWP.getGPSName().equals(p.getGPSName()) || p.hasWpNbr() && gpsWP.getIdxNbr() != p.getIdxNbr()) {
                            cyn = new ChoiceOfYesOrNo(new Frame(), "Do you want to change " + p.getGPSName() + "(" + p.getIdxNbr() + ") to " + gpsWP.getGPSName() + "(" + gpsWP.getIdxNbr() + ")?");
                            if (!cyn.isYes()) break;
                            this.appendLogNL("  changed " + p.getGPSName() + " to " + gpsWP.getGPSName() + ", nbr:" + gpsWP.getIdxNbr() + ", " + gpsWP.getRoute());
                            p.setGPSName(gpsWP.getGPSName());
                            p.setIdxNbr(gpsWP.getIdxNbr());
                            p.setRoute(gpsWP.getRoute());
                        }
                    }
                    ++j;
                }
                if (!found) {
                    this.appendLogNL("No position match found for " + p.getGPSName());
                }
                ++i;
            }
        } else if (src == this.clearWPNbrsMI) {
            Positions ptc = this.wpif.getPositions();
            if (ptc == null) {
                new ShowMsgBox("Error:", "Need to open a waypoints file.", new Frame(), false);
                return;
            }
            ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(new Frame(), "Do you want to clear the " + ptc.size() + " waypoint numbers for " + ptc.description + "?");
            if (!cyn.isYes()) {
                return;
            }
            int i = 0;
            while (i < ptc.size()) {
                Position p = ptc.get(i);
                p.clearIdxNbr();
                ++i;
            }
            this.appendLogNL("Cleared " + ptc.size() + " waypoint numbers for " + ptc.description);
        } else {
            System.err.println("Unknown ae:" + ae);
        }
    }

    private int nextWPNbr(int nxtWPNbr) {
        while (nxtWPNbr <= 500 && this.wpNbrTbl[nxtWPNbr]) {
            ++nxtWPNbr;
        }
        return nxtWPNbr;
    }

    private void assignWPN(Positions ptc) {
        int cnt = 0;
        int set = 0;
        int nxtWPNbr = this.nextWPNbr(1);
        System.out.println("next available is " + nxtWPNbr);
        int i = 0;
        while (i < ptc.size()) {
            Position pi = ptc.get(i);
            int wpn = pi.getIdxNbr();
            if (wpn < 1) {
                ++cnt;
                pi.setIdxNbr(nxtWPNbr++);
                nxtWPNbr = this.nextWPNbr(nxtWPNbr);
            } else {
                ++set;
            }
            ++i;
        }
        this.appendLogNL("Waypoint numbers assigned to " + cnt + " waypoints. " + set + " already had numbers.");
    }

    public void openGPS(Frame f, String portNm, String baudRt) throws SerialCommException {
        this.mainFrm = f;
        this.parameters.setPortName(portNm);
        this.parameters.setBaudRate(baudRt);
        this.connection = new SerialConnection(f, this.parameters);
        try {
            this.connection.openConnection();
            byte[] aRequest = new byte[]{36, 80, 77, 67, 76, 81, 44, 87, 80, 88, 44, 48, 53, 48, 51, 13, 10};
            this.connection.writeBytes(aRequest);
            String rec = this.getNextRecord();
            if (!rec.startsWith(MCLWP_Prefix)) {
                throw new SerialCommException("openGPS: Invalid waypoint record: " + rec);
            }
        }
        catch (SerialConnectionException ex) {
            System.err.println("Open port error: " + ex + "\n on port: " + this.parameters.getPortName());
            this.connection.closeConnection();
            throw new SerialCommException("openGPS: open port error, " + ex);
        }
    }

    public Positions downLoadWpts(Frame f) {
        this.smb = new ShowMsgBox("Note:", "Start the GPS in WPxUPLOAD format\n Enter: (SETUPS | SERIAL I/O | Serial 1: OFF).\n Program will wait for 40 seconds before exiting.\n Reading of waypoints can take over 2 minutes.", f, false);
        this.fndWPs = false;
        RunGPSJob rgj = new RunGPSJob(){

            public void run() {
                try {
                    Thread.sleep(40000L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (MicrologicGPSInterface.this.smb != null) {
                    MicrologicGPSInterface.this.smb.dispose();
                    MicrologicGPSInterface.this.smb = null;
                }
            }
        };
        this.wpPos = new Positions(500);
        this.tlPos = new Positions(500);
        this.wpNbrTbl = new boolean[501];
        this.byWPNbr = new Hashtable();
        this.routes = new Hashtable();
        this.routesUsed = new Vector();
        Cursor[] preCursor = this.setWaitCursor(f);
        int cnt = 0;
        int skips = 0;
        ShowCounters sc = new ShowCounters("Reading progress", new String[]{"Waypoints:", "Track log positions:", "Routes:", "Skipped:"}, new int[]{3, 3, 2, 3});
        boolean WPCnt = false;
        boolean TLCnt = true;
        int RteCnt = 2;
        int SkipCnt = 3;
        while (true) {
            if (this.abortXfer) {
                this.abortXfer = false;
                System.out.println("Aborting reading after " + cnt);
                if (rgj == null) break;
                rgj.interrupt();
                break;
            }
            String rec = this.getNextRecord();
            if (rec == null) {
                if (this.fndWPs) {
                    System.out.println("downLoadWpts >>> exiting loop after " + cnt + " Waypoints" + ", skipped " + skips);
                    break;
                }
                if (this.smb != null) continue;
                break;
            }
            if (rec.startsWith(MCLWP_Prefix)) {
                this.fndWPs = true;
                if (this.smb != null) {
                    this.smb.dispose();
                    this.smb = null;
                    rgj.interrupt();
                }
                try {
                    Position p = this.parseWPRec(rec);
                    int wpNbr = p.getIdxNbr();
                    if (wpNbr > 0 && wpNbr <= 500) {
                        this.wpPos.add(p);
                        this.wpNbrTbl[wpNbr] = true;
                        this.byWPNbr.put(new Integer(wpNbr), p);
                        sc.setValue(0, ++cnt);
                        continue;
                    }
                    if (wpNbr == 503) {
                        p.setRoute(this.wpDate + " " + this.wpTime);
                        this.tlPos.add(p);
                        sc.setValue(1, this.tlPos.size());
                        continue;
                    }
                    sc.setValue(3, skips);
                    ++skips;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("Error " + ex.getMessage() + " with record: " + rec);
                    sc.setValue(3, ++skips);
                }
                continue;
            }
            if (rec.startsWith(MCLRTE_Prefix)) {
                this.parseRouteRec(rec);
                sc.setValue(2, this.routes.size());
                continue;
            }
            sc.setValue(3, ++skips);
        }
        sc.setTimeOut(5000);
        this.wpPos.owner = this.getOwner();
        if (this.getOwner().equals("")) {
            GetInput gi = new GetInput("Please enter owner name for these waypoints", f, 15, "Set owner");
            this.wpPos.owner = gi.getResponse();
        }
        this.wpPos.description = "These waypoints were downloaded from GPS " + new Date();
        this.wpPos.fileName = "GPSDownLoad.wps";
        this.tlPos.description = "Tracklog downloaded from GPS";
        this.tlPos.fileName = "GPSTracks.wps";
        this.tlPos.owner = this.wpPos.owner;
        Hashtable<String, Position> ht = new Hashtable<String, Position>(this.wpPos.size());
        int i = 0;
        while (i < this.wpPos.size()) {
            String gpsName = this.buildGPSName(this.wpPos.get(i).getGPSName());
            ht.put(gpsName, this.wpPos.get(i));
            ++i;
        }
        this.usedNames = ht;
        this.assignWPNbrsMI.setEnabled(true);
        this.changeWPNbrsMI.setEnabled(true);
        this.resetCursor(f, preCursor);
        return this.wpPos;
    }

    private Position parseWPRec(String rec) throws BadPositionException {
        String comments = "";
        StringTokenizer tok = new StringTokenizer(rec, ",*", false);
        String fld = tok.nextToken();
        if (!fld.equals(MCLWP_Prefix)) {
            throw new BadPositionException("Invalid MCL record: " + rec);
        }
        fld = tok.nextToken();
        int degLat = Integer.parseInt(fld.substring(0, 2));
        double minLat = Double.valueOf(fld.substring(2));
        String dirLat = tok.nextToken();
        fld = tok.nextToken();
        int degLong = Integer.parseInt(fld.substring(0, 3));
        double minLong = Double.valueOf(fld.substring(3));
        String dirLong = tok.nextToken();
        String idx = tok.nextToken();
        String wpName = tok.nextToken().trim();
        this.wpTime = tok.nextToken();
        this.wpDate = tok.nextToken();
        this.wpIcon = tok.nextToken();
        comments = tok.nextToken().trim();
        if ((comments = comments.replace('_', ' ').trim()).length() == 0) {
            comments = wpName;
        }
        Position p = new Position(degLat, minLat, dirLat, degLong, minLong, dirLong);
        p.setName(wpName + " " + this.wpDate + " " + this.wpTime);
        if (comments.equals("End Of Leg")) {
            p.setIsEndOfLeg(true);
            p.setName("End Of Leg");
        }
        p.setIdxNbr(Integer.parseInt(idx));
        p.setGPSName(wpName);
        p.setRoute(comments);
        p.setComments(comments);
        return p;
    }

    private void parseRouteRec(String rec) {
        int ix = rec.indexOf(42);
        StringTokenizer st = new StringTokenizer(rec.substring(0, ix), SepCharS);
        if (st.countTokens() < 7) {
            return;
        }
        String tok = st.nextToken();
        String rtNm = st.nextToken();
        tok = st.nextToken();
        tok = st.nextToken();
        tok = st.nextToken();
        if (!tok.equalsIgnoreCase("c")) {
            return;
        }
        String rtNbr = st.nextToken().substring(1);
        String rtKey = rtNbr + " - " + rtNm;
        Positions rtWps = (Positions)this.routes.get(rtKey);
        if (rtWps == null) {
            rtWps = new Positions(50);
            rtWps.description = rtNm;
            rtWps.fileName = "GPSRoute" + rtNbr + ".wps";
            rtWps.owner = this.getOwner();
            this.routesUsed.add(rtNbr);
        }
        while (st.hasMoreTokens()) {
            tok = st.nextToken();
            Position p = (Position)this.byWPNbr.get(new Integer(tok));
            rtWps.addElement(p.clone());
        }
        this.routes.put(rtKey, rtWps);
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkWpts(Positions ptc, Frame f) throws InvalidDataException {
        if (this.wpNbrTbl == null || this.usedNames == null || this.wpPos == null) {
            throw new InvalidDataException("No waypoints read from GPS. Read waypoints first.");
        }
        this.appendLogNL("Starting check of waypoints in " + ptc.description);
        this.checkPositions(this.wpPos, ptc);
        results = true;
        dupNbrs = false;
        errorFnd = false;
        newOnes = new boolean[501];
        ht = new Hashtable<String, Integer>(ptc.size());
        i = 0;
        while (i < ptc.size()) {
            block16: {
                pos = ptc.get(i);
                gpsName = pos.getGPSName();
                wpNbr = pos.getIdxNbr();
                if (gpsName.length() < 1 || gpsName.length() > 7 || !this.ckValidName(gpsName)) {
                    errorFnd = true;
                    this.appendLogNL(" >>>Invalid GPS name: >" + gpsName + "<, maximum length is " + 7 + ".");
                }
                if (!this.usedNames.containsKey(gpsName)) break block16;
                results = false;
                this.appendLogNL(" >>>GPS has waypoint: " + gpsName + " at line " + (i + 1) + ". Their positions are " + (pos.samePosition((Position)this.usedNames.get(gpsName)) != false ? "the same." : "different."));
                ** GOTO lbl-1000
            }
            if (pos.isEndOfLeg()) {
                this.appendLogNL(" >>>'End of Leg' record found at line: " + (i + 1));
                errorFnd = true;
            } else lbl-1000:
            // 2 sources

            {
                if (ht.containsKey(gpsName)) {
                    errorFnd = true;
                    this.appendLogNL(">>> You have a duplicate name: " + gpsName + " at " + (i + 1) + ". Matches line " + ((Integer)ht.get(gpsName) + 1));
                } else {
                    ht.put(gpsName, new Integer(i));
                }
                if (wpNbr != -1 && (wpNbr < 1 || wpNbr > 500)) {
                    errorFnd = true;
                    this.appendLogNL(" >>>Invalid Waypoint number: " + wpNbr + " for " + gpsName);
                } else if (wpNbr > 0 && this.wpNbrTbl != null) {
                    if (this.wpNbrTbl[wpNbr]) {
                        p = (Position)this.byWPNbr.get(new Integer(wpNbr));
                        this.appendLogNL(" >>>Waypoint number: " + wpNbr + " for " + gpsName + " already in use by " + p.getGPSName());
                        dupNbrs = true;
                    } else if (newOnes[wpNbr]) {
                        results = false;
                        this.appendLogNL(" >>>Waypoint number: " + wpNbr + " for " + gpsName + " previously used.");
                    } else {
                        newOnes[wpNbr] = true;
                    }
                }
            }
            ++i;
        }
        if (errorFnd) {
            throw new InvalidDataException("Fatal Errors found in waypoints. See log>>>");
        }
        if (dupNbrs && !(cyn = new ChoiceOfYesOrNo(f, "Found Waypoints with same number(s) as on GPS. See log >>>\n Do you want to Write these " + ptc.size() + " waypoints?")).isYes()) {
            throw new InvalidDataException("User cancelled write of waypoints.");
        }
        return results;
    }

    public void upLoadWpts(Frame f, Positions ptul) {
        Cursor[] preCursor = this.setWaitCursor(f);
        ShowCounters sc = new ShowCounters("Writing progress", new String[]{"Waypoints:"}, new int[]{3});
        boolean WPCnt = false;
        this.wpTimeDate = this.sdf.format(new Date());
        try {
            int nxtWPNbr = 1;
            int i = 0;
            while (i < ptul.size()) {
                Position p = ptul.get(i);
                if (!p.hasWpNbr()) {
                    nxtWPNbr = this.nextWPNbr(nxtWPNbr);
                    p.setIdxNbr(nxtWPNbr);
                    this.wpNbrTbl[nxtWPNbr] = true;
                }
                byte[] rec = this.buildWPRec(p);
                sc.setValue(0, i + 1);
                this.connection.writeBytes(rec);
                if (i + 1 >= ptul.size() || this.abortXfer) {
                    if (this.abortXfer) {
                        this.abortXfer = false;
                        System.out.println("Aborting upload after " + i);
                    }
                    break;
                }
                Thread.sleep(this.writeDelay);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.appendLogNL("Error: " + ex.getMessage() + " writing waypoints");
        }
        sc.setTimeOut(5000);
        this.resetCursor(f, preCursor);
    }

    private byte[] buildWPRec(Position p) {
        byte[] rec = new byte[120];
        int os = 0;
        GPSInterface.storString(MCLWP_Hdr, rec, 0, MCLWP_Hdr.length());
        os = MCLWP_Hdr.length();
        rec[os++] = 44;
        double d = Double.valueOf(p.getMinLat());
        String temp = this.RMC("00" + p.getDegLat(), 2) + this.minForm.format(d);
        GPSInterface.storString(temp, rec, os, temp.length());
        os += temp.length();
        rec[os++] = 44;
        GPSInterface.storString(p.getDirLat(), rec, os++, 1);
        rec[os++] = 44;
        d = Double.valueOf(p.getMinLong());
        temp = this.RMC("000" + p.getDegLong(), 3) + this.minForm.format(d);
        GPSInterface.storString(temp, rec, os, temp.length());
        os += temp.length();
        rec[os++] = 44;
        GPSInterface.storString(p.getDirLong(), rec, os++, 1);
        rec[os++] = 44;
        String idx = this.RMC("000" + p.getIdxNbr(), 4);
        GPSInterface.storString(idx, rec, os, 4);
        os += 4;
        rec[os++] = 44;
        String nm = p.getGPSName();
        GPSInterface.storString(nm, rec, os, nm.length());
        os += nm.length();
        rec[os++] = 44;
        temp = this.wpTimeDate + SepCharS + "10//0";
        GPSInterface.storString(temp, rec, os, temp.length());
        os += temp.length();
        String cmt = p.getRoute().replace(',', ' ');
        if (cmt.length() > 1) {
            rec[os++] = 44;
            GPSInterface.storString(cmt, rec, os, cmt.length());
            os += cmt.length();
        }
        rec[os++] = 13;
        rec[os++] = 10;
        byte[] rec2 = new byte[os];
        System.arraycopy(rec, 0, rec2, 0, os);
        return rec2;
    }

    private String RMC(String s, int l) {
        return s.substring(s.length() - l);
    }

    public Hashtable downLoadRtes(Frame f) {
        if (this.routes != null) {
            return this.routes;
        }
        new ShowMsgBox("Note:", "No downloaded routes available. Routes are read with waypoints.", f, true);
        return null;
    }

    public boolean checkRoute(String rtNm, Positions ptc, Frame f) throws InvalidDataException {
        if (this.wpNbrTbl == null || this.usedNames == null) {
            throw new InvalidDataException(" >>>No waypoints read from GPS. Read waypoints first.");
        }
        boolean results = true;
        boolean errFnd = false;
        if (this.routes != null && this.routesUsed != null && this.routesUsed.contains(rtNm)) {
            this.appendLogNL(" >>>Route " + rtNm + " currently on GPS.");
            results = false;
        }
        int i = 0;
        while (i < ptc.size()) {
            Position p = ptc.get(i);
            String gpsName = p.getGPSName();
            if (gpsName.length() < 1 || gpsName.length() > 7 || !this.ckValidName(gpsName)) {
                errFnd = true;
                this.appendLogNL(" >>>Invalid GPS name: >" + gpsName + "<, maximum length is " + 7 + ".");
                System.err.println(">>" + gpsName + " len:" + gpsName.length() + " ck=" + this.ckValidName(gpsName));
            } else if (!p.hasWpNbr()) {
                Position p1 = (Position)this.usedNames.get(p.getGPSName());
                if (p1 != null && p1.samePosition(p)) {
                    p.setIdxNbr(p1.getIdxNbr());
                    this.appendLogNL("   >>>Set waypoint number to: " + p1.getIdxNbr() + " for waypoint: " + p.getGPSName() + " at line " + (i + 1));
                } else {
                    this.appendLogNL(" >>>Error: Waypoint: " + p.getGPSName() + " not on GPS.");
                    errFnd = true;
                }
            } else {
                int wpn = p.getIdxNbr();
                if (wpn < 1 || wpn > 500) {
                    throw new InvalidDataException("Invalid waypoint: " + p.getName() + ", number: " + wpn + " in waypoint at line " + (i + 1));
                }
                if (!this.wpNbrTbl[wpn]) {
                    this.appendLogNL(" >>>Error: Waypoint: " + p.getGPSName() + ", number " + p.getIdxNbr() + " not on GPS.");
                    errFnd = true;
                } else {
                    Position gpsPos = (Position)this.byWPNbr.get(new Integer(wpn));
                    if (gpsPos == null) {
                        this.appendLogNL(" >>>Error: Null position for wpn= " + wpn);
                        errFnd = true;
                    } else {
                        if (!gpsPos.getGPSName().equals(p.getGPSName())) {
                            this.appendLogNL(" >>>Different waypoint name:" + gpsPos.getGPSName() + " on GPS vs route: " + p.getGPSName() + ", both have number:" + wpn);
                            results = false;
                        }
                        if (!p.samePosition(gpsPos)) {
                            this.appendLogNL(" >>>Different positions for " + gpsPos.getGPSName() + " on GPS vs route: " + p.getGPSName() + ", both have number:" + wpn);
                            results = false;
                        }
                    }
                }
            }
            ++i;
        }
        if (errFnd) {
            throw new InvalidDataException("Fatal Errors found in waypoints. See log>>>");
        }
        return results;
    }

    public void upLoadRte(Frame f, Positions rtw, String rtNm) {
        int nbrRecs = rtw.size() / 11 + 1;
        int thisRec = 1;
        String aRoutePfx = "$PMCLK," + (rtw.description + "                ").substring(0, 16) + SepCharS + this.RMC("0" + nbrRecs, 2) + SepCharS;
        int i = 0;
        while (i < rtw.size()) {
            String aRoute = aRoutePfx + this.RMC("0" + thisRec, 2) + SepCharS + "c" + SepCharS + this.RMC("00" + rtNm, 3);
            int j = 0;
            while (j < 11 && i < rtw.size()) {
                aRoute = aRoute + SepCharS;
                if (!rtw.get(i).hasWpNbr()) {
                    System.err.println("Missing waypoint number for " + rtw.get(i).getGPSName());
                }
                int wpn = rtw.get(i).getIdxNbr();
                aRoute = aRoute + this.RMC("000" + wpn, 4);
                ++i;
                ++j;
            }
            --i;
            aRoute = aRoute + CkSumCharC + this.NMEACheckSumer(aRoute) + "CL";
            byte[] aRt = aRoute.getBytes();
            System.out.println("Writing route>" + new String(aRt) + "<");
            aRt[aRt.length - 2] = 13;
            aRt[aRt.length - 1] = 10;
            try {
                this.connection.writeBytes(aRt);
                if (thisRec < nbrRecs) {
                    Thread.sleep(this.writeDelay);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.appendLogNL("Error : " + ex.getMessage() + " writing route " + rtNm);
            }
            ++thisRec;
            ++i;
        }
    }

    public Positions readTrackLog(Frame f) {
        if (this.tlPos == null) {
            new ShowMsgBox("Note:", "No Track log available", f, true);
            return null;
        }
        return this.tlPos;
    }

    public void writeTrackLog(Frame f, Positions px) {
        new ShowMsgBox("Note:", "No write of Track log available", f, true);
    }

    public String getARouteNm(Frame f) {
        String rtNm = "";
        int rv = 0;
        while (true) {
            GetInput gi;
            if ((rtNm = (gi = new GetInput("Enter route number to use: 1 to 30", f, 2, "Write rte")).getResponse()).equals("")) {
                return rtNm;
            }
            try {
                rv = new Integer(rtNm);
                if (rv >= 1 && rv <= 30) {
                    break;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            new ErrDialog(f, "Invalid route id: " + rtNm + ". Must be numeric and from 1 to " + 30);
        }
        return (rv < 10 ? "0" : "") + rtNm;
    }

    public int getMaxWPperRoute() {
        return 50;
    }

    public void closeGPS() {
        this.connection.closeConnection();
        this.wpNbrTbl = null;
        this.usedNames = null;
        this.routes = null;
        this.tlPos = null;
    }

    public String NMEACheckSumer(String rec) {
        int ckSum = 0;
        int i = 1;
        while (i < rec.length()) {
            ckSum ^= rec.charAt(i);
            ++i;
        }
        String res = Integer.toHexString(ckSum).toUpperCase();
        if (ckSum < 16) {
            res = "0" + res;
        }
        return res;
    }

    private int getNbrBytes() {
        return this.connection.getNbrBytes() + this.wrtPtr - this.rdPtr;
    }

    public String getNextRecord() {
        int ix = -1;
        int iy = -1;
        byte[] rec = null;
        try {
            block18: {
                if (this.rdPtr >= this.wrtPtr) {
                    int svPtr = this.wrtPtr;
                    int lpCnt = 0;
                    do {
                        this.wrtPtr = this.connection.getBytes(this.readBytes, this.wrtPtr);
                        if (svPtr < this.wrtPtr) break block18;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    } while (lpCnt++ * 200 <= this.timeOutms);
                    return null;
                }
            }
            boolean found = false;
            ix = this.rdPtr;
            while (ix < this.wrtPtr) {
                if (this.readBytes[ix] == 36) {
                    found = true;
                    break;
                }
                ++ix;
            }
            if (found) {
                found = false;
                iy = ix + 1;
                while (iy < this.wrtPtr) {
                    if (this.readBytes[iy] == 13 && this.readBytes[iy + 1] == 10) {
                        found = true;
                        break;
                    }
                    ++iy;
                }
                if (found) {
                    rec = new byte[iy - ix];
                    long ckSum = 0L;
                    int i = 0;
                    while (i < rec.length) {
                        rec[i] = this.readBytes[ix + i];
                        if (rec[i] == 42) {
                            // empty if block
                        }
                        ckSum += (long)rec[i];
                        ++i;
                    }
                    this.rdPtr = iy + 2;
                    if (this.rdPtr >= this.wrtPtr) {
                        this.wrtPtr = 0;
                        this.rdPtr = 0;
                    } else {
                        try {
                            System.arraycopy(this.readBytes, this.rdPtr, this.readBytes, 0, this.wrtPtr - this.rdPtr);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.out.println("  arraycopy rd=" + this.rdPtr + ", wrt=" + this.wrtPtr + ", length=" + (this.wrtPtr - this.rdPtr));
                        }
                        this.wrtPtr -= this.rdPtr;
                        this.rdPtr = 0;
                    }
                    return new String(rec);
                }
                System.err.println("getNxtRec: no (CR|LF) found. wrt=" + this.wrtPtr);
                System.out.println(">> " + MicrologicGPSInterface.showBytes(this.readBytes, this.wrtPtr) + "\n >" + new String(this.readBytes, 0, this.wrtPtr) + "<");
                this.wrtPtr = this.connection.getBytes(this.readBytes, this.wrtPtr);
                return null;
            }
            System.err.println("getNxtRec: no leading $ found. wrt=" + this.wrtPtr);
            this.wrtPtr = this.connection.getBytes(this.readBytes, this.wrtPtr);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("getNxtRec() ex  wrt=" + this.wrtPtr + " rd=" + this.rdPtr + (rec == null ? " null" : " " + MicrologicGPSInterface.showBytes(this.readBytes, this.wrtPtr - this.rdPtr + 1)) + " ix=" + ix + " iy=" + iy + "\n  ex:" + ex);
            return null;
        }
    }

    public String buildGPSName(String nm) {
        char[] retC = new char[7];
        char[] charS = nm.toCharArray();
        int j = 0;
        int i = 0;
        while (i < charS.length) {
            if (Character.isLetterOrDigit(charS[i]) || charS[i] == '-') {
                retC[j++] = Character.toUpperCase(charS[i]);
            }
            if (j >= 7) break;
            ++i;
        }
        while (j < 7) {
            retC[j] = 32;
            ++j;
        }
        return new String(retC).trim();
    }

    private final Cursor[] setWaitCursor(Frame f) {
        Component[] cmpts = f.getComponents();
        Cursor[] csrs = new Cursor[cmpts.length + 1];
        csrs[0] = f.getCursor();
        int i = 1;
        while (i < csrs.length) {
            csrs[i] = cmpts[i - 1].getCursor();
            cmpts[i - 1].setCursor(this.waitCursor);
            ++i;
        }
        f.setCursor(this.waitCursor);
        return csrs;
    }

    private final void resetCursor(Frame f, Cursor[] crsrs) {
        f.setCursor(crsrs[0]);
        Component[] cmpts = f.getComponents();
        int i = 1;
        while (i < crsrs.length) {
            cmpts[i - 1].setCursor(crsrs[i]);
            ++i;
        }
    }

    public static String showBytes(byte[] rec, int length) {
        if (rec == null) {
            System.out.println("showBytes called with null record");
            return "";
        }
        StringBuffer sb = new StringBuffer(length * 2 + length / 4);
        sb.setLength(length * 2 + length / 4);
        int j = 0;
        try {
            int i = 0;
            while (i < length) {
                int ix = rec[i] & 0xFF;
                sb.setCharAt(j++, hexValue[ix >> 4]);
                sb.setCharAt(j++, hexValue[ix & 0xF]);
                if (i % 4 == 3) {
                    sb.setCharAt(j++, ' ');
                }
                ++i;
            }
        }
        catch (Exception ex) {
            System.err.println("showBytes() Error " + ex + "\n j=" + j + " " + sb.length() + ",  rec.length=" + rec.length + ", length=" + length);
            ex.printStackTrace();
        }
        return sb.toString();
    }

    class RunGPSJob
    extends Thread {
        RunGPSJob() {
            this.start();
        }

        public void run() {
        }
    }
}

