/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices.Magellan;

import NormsTools.ShowMsgBox;
import WayPointApps.GPSDevices.GPSInterface;
import WayPointApps.GPSDevices.Magellan.BadCheckSumException;
import WayPointApps.Positions;
import java.awt.Frame;
import java.util.Hashtable;

public class MagellanGPSInterface
extends GPSInterface {
    public static final int PR_LenHdr = 3;
    public static final int PR_DLE = 0;
    public static final int PR_StartCS = 1;
    public static final int PR_Pid = 1;
    public static final int PR_Size = 2;
    public static final int PR_Data = 3;
    public static final int PR_LenTrlr = 3;
    public static final byte PR_CheckSumHere = -52;
    public static final int PR_CheckSumConstant = 256;
    public static final byte DLEChar = 16;
    public static final byte ETX = 3;
    public static final long SEMI_CIRCLE_FCTR = 0x80000000L;
    public static final double SC_180Degrees = 180.0;
    public static final double DegToSCFctr = 1.1930464711111112E7;
    public static final double SCToDegFctr = 8.381903171539307E-8;
    public static final byte PidAckByte = 6;
    public static final byte PidNakByte = 21;
    public static final byte PidProtocolArray = -3;
    public static final byte PidProductRqst = -2;
    public static final byte PidProductData = -1;
    public static final byte PidCommandData = 10;
    public static final byte PidXferCmplt = 12;
    public static final byte PidDateTimeData = 14;
    public static final byte PidPositionData = 17;
    public static final byte PidPrxWptData = 19;
    public static final byte PidRecords = 27;
    public static final byte PidRteHdr = 29;
    public static final byte PidRteWptData = 30;
    public static final byte PidAlmanacData = 31;
    public static final byte PidTrkData = 34;
    public static final byte PidWptData = 35;
    public static final byte PidRteLinkData = 98;
    public static final byte PidTrkHdr = 99;
    public static final byte CmndAbortTransfer = 0;
    public static final byte CmndTransferAlm = 1;
    public static final byte CmndTransferPosn = 2;
    public static final byte CmndTransferPrx = 3;
    public static final byte CmndTransferRte = 4;
    public static final byte CmndTransferTime = 5;
    public static final byte CmndTransferTrk = 6;
    public static final byte CmndTransferWpt = 7;
    public static final byte CmndTurnOffPwr = 8;
    public static final byte CmndStartPvtData = 49;
    public static final byte CmndStopPvtData = 50;

    public void openGPS(Frame frame, String string, String string2) {
    }

    public Positions readTrackLog(Frame frame) {
        return null;
    }

    public void writeTrackLog(Frame frame, Positions positions) {
    }

    public MagellanGPSInterface() {
        new ShowMsgBox("Warning", "Sorry, the interface for Magellan is not done", new Frame(), true);
    }

    public void upLoadRte(Frame frame, Positions positions, String string) {
    }

    public static byte[] ckInputPacket(byte[] byArray) throws BadCheckSumException {
        int n = 0;
        int n2 = 1;
        while (n2 < byArray.length - 3) {
            if (byArray[n2] == 16) {
                ++n;
            }
            ++n2;
        }
        byte[] byArray2 = new byte[byArray.length - n / 2];
        byArray2[0] = byArray[0];
        int n3 = 1;
        long l = 0L;
        int n4 = 0;
        n4 = 1;
        while (n4 < byArray.length - 3) {
            byArray2[n3++] = byArray[n4];
            l += (long)byArray[n4];
            if (byArray[n4] == 16 && byArray[n4 + 1] == 16) {
                ++n4;
            }
            ++n4;
        }
        byArray2[n3++] = byArray[n4];
        l &= 0xFFL;
        if ((l = 256L - l) != (long)(byArray[n4] & 0xFF)) {
            System.err.println("Bad checksum: " + byArray[n4] + " computed: " + l + " " + n4);
            throw new BadCheckSumException("Computed: " + l + " vs " + byArray[n4]);
        }
        byArray2[n3++] = 16;
        byArray2[n3] = 3;
        return byArray2;
    }

    public String getARouteNm(Frame frame) {
        return "XXXXXX";
    }

    public static byte[] buildACK(byte by) {
        byte[] byArray = new byte[6];
        byArray[0] = 16;
        byArray[1] = 6;
        byArray[2] = 1;
        byArray[4] = 16;
        byArray[5] = 3;
        byte[] byArray2 = byArray;
        byArray2[3] = by;
        return byArray2;
    }

    public Hashtable downLoadRtes(Frame frame) {
        return null;
    }

    public int getMaxWPperRoute() {
        return 0;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            // empty if block
        }
    }

    public static byte[] genCheckSum(byte[] byArray) {
        int n = 0;
        int n2 = 1;
        while (n2 < byArray.length - 3) {
            if (byArray[n2] == 16) {
                ++n;
            }
            ++n2;
        }
        byte[] byArray2 = new byte[byArray.length + n];
        long l = 0L;
        int n3 = 1;
        byArray2[0] = byArray[0];
        int n4 = 1;
        while (n4 < byArray.length - 3) {
            l += (long)byArray[n4];
            byArray2[n3] = byArray[n4];
            if (byArray[n4] == 16) {
                byArray2[++n3] = 16;
            }
            ++n4;
            ++n3;
        }
        l &= 0xFFL;
        l = 256L - l;
        byArray2[n3++] = (byte)l;
        byArray2[n3++] = 16;
        byArray2[n3] = 3;
        return byArray2;
    }

    public Positions downLoadWpts(Frame frame) {
        return null;
    }

    public void closeGPS() {
    }

    public String buildGPSName(String string) {
        return string.substring(0, 6).toUpperCase();
    }

    public void upLoadWpts(Frame frame, Positions positions) {
    }

    public static byte[] buildPacket(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[6 + (byArray == null ? 0 : byArray.length)];
        byArray2[0] = 16;
        byArray2[1] = by;
        byArray2[2] = (byte)(byArray == null ? 0 : byArray.length);
        int n = 3;
        if (byArray != null) {
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray2[n] = byArray[n2];
                ++n2;
                ++n;
            }
        }
        byArray2[n++] = -52;
        byArray2[n++] = 16;
        byArray2[n] = 3;
        return byArray2;
    }
}

