/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices.Garmin;

import WayPointApps.GPSDevices.GPSInterface;
import WayPointApps.GPSDevices.Garmin.GarminDataParser;
import WayPointApps.Position;
import java.util.Date;

class ParseD103D201
extends GarminDataParser {
    boolean useD100 = false;
    final int maxRtes = 20;
    private final String NewTrkHdr = "&NTRK=";
    final int D103IdentS = 0;
    final int D103IdentL = 6;
    final int D103SCLatS = 6;
    final int D103SCLongS = 10;
    final int D103Unused = 14;
    final int D103CmntS = 18;
    final int D103CmntL = 40;
    final int D100Length = 58;
    final int D103SmblS = 58;
    final int D103DsplS = 59;
    final int D103Length = 60;
    final int MaxCmntLng = 16;
    final int D201RtNbrS = 0;
    final int D201CmntS = 1;
    final int D201CmntL = 20;
    final int D201Length = 21;
    final int D300SCLatS = 0;
    final int D300SCLongS = 4;
    final int D300TimeS = 8;
    final int D300NewTrkSeg = 12;
    final int D300Length = 13;
    final long MSBefore12311989 = 631090800000L;

    ParseD103D201() {
    }

    public int getMaxRoutes() {
        return 20;
    }

    public Position parseDataRec(byte[] ba, int os) {
        String id = GPSInterface.ckNoNulls(new String(ba, os + 0, 6));
        long lat = GPSInterface.loadLongLSB(ba, os + 6);
        long lng = GPSInterface.loadLongLSB(ba, os + 10);
        String cmnt = GPSInterface.ckNoNulls(new String(ba, os + 18, 40));
        if (this.debug) {
            System.out.println("parseDR() id=" + id + " Cmnt>" + cmnt + "<");
            System.out.println("lat= " + lat + " " + Long.toHexString(lat) + " long= " + lng + " " + Long.toHexString(lng));
        }
        String dirLat = "N";
        String dirLong = "E";
        if (lat < 0L) {
            lat *= -1L;
            dirLat = "S";
        }
        if (lng < 0L) {
            lng *= -1L;
            dirLong = "W";
        }
        double latD = 8.381903171539307E-8 * (double)lat;
        double longD = 8.381903171539307E-8 * (double)lng;
        Position px = null;
        try {
            px = new Position(latD, dirLat, longD, dirLong);
            String route = cmnt.trim();
            if (route.length() == 0) {
                route = " ";
            }
            px.setRoute(route);
            px.setName(id.trim() + "&GPS=" + id.trim());
            if (!this.useD100) {
                px.setGPSSymbol(ba[os + 58]);
                px.setGPSDisplay(ba[os + 59]);
            }
        }
        catch (Exception ex) {
            System.err.println("D103 Position record error " + ex);
        }
        return px;
    }

    public byte[] buildWptRecord(Position pos) {
        byte[] rec = new byte[this.useD100 ? 58 : 60];
        GPSInterface.storString(pos.getGPSName(), rec, 0, 6);
        long lat = (long)(pos.decDegLat() * 1.1930464711111112E7);
        if (pos.getDirLat().equals("S")) {
            lat *= -1L;
        }
        GPSInterface.storIntLSB(rec, 6, lat);
        long lng = (long)(pos.decDegLong() * 1.1930464711111112E7);
        if (pos.getDirLong().equals("W")) {
            lng *= -1L;
        }
        GPSInterface.storIntLSB(rec, 10, lng);
        GPSInterface.storString(pos.getRoute().toUpperCase(), rec, 18, 40);
        if (!this.useD100) {
            rec[58] = (byte)pos.getGPSSymbol();
            rec[59] = (byte)pos.getGPSDisplay();
        }
        return rec;
    }

    public int parseRouteHdr(byte[] ba, int os) {
        if (this.debug && ba.length >= os + 1 + 20) {
            String cmt = GPSInterface.ckNoNulls(new String(ba, os + 1, 20));
            System.out.println("Rte Hdr comment: >" + cmt + "<");
        }
        return ba[os + 0];
    }

    public String parseRouteHdrCmnt(byte[] ba, int os) {
        String cmt = "";
        if (ba.length >= os + 1 + 20) {
            cmt = GPSInterface.ckNoNulls(new String(ba, os + 1, 20));
            if (this.debug) {
                System.out.println("Rte Hdr comment: >" + cmt + "<");
            }
        }
        return cmt;
    }

    public byte[] buildRteHdr(String rtNm) {
        byte[] ba = new byte[21];
        ba[0] = (byte)new Integer(rtNm).intValue();
        if (this.rtePos == null) {
            GPSInterface.storString("UPLOADED RTE " + rtNm, ba, 1, 20);
        } else {
            GPSInterface.storString(this.rtePos.description.toUpperCase(), ba, 1, 20);
        }
        return ba;
    }

    public Position parseTrackLogRec(byte[] ba, int os) {
        long lat = GPSInterface.loadLongLSB(ba, os + 0);
        long lng = GPSInterface.loadLongLSB(ba, os + 4);
        long time = GPSInterface.loadLongLSB(ba, os + 8);
        byte new_trk = ba[os + 12];
        if (this.debug) {
            System.out.println("parseTLR() time=" + time + "    newTrk=" + new_trk);
            System.out.println("lat= " + lat + " " + Long.toHexString(lat) + " long= " + lng + " " + Long.toHexString(lng));
        }
        String dirLat = "N";
        String dirLong = "E";
        if (lat < 0L) {
            lat *= -1L;
            dirLat = "S";
        }
        if (lng < 0L) {
            lng *= -1L;
            dirLong = "W";
        }
        double latD = 8.381903171539307E-8 * (double)lat;
        double longD = 8.381903171539307E-8 * (double)lng;
        Position px = null;
        try {
            px = new Position(latD, dirLat, longD, dirLong);
            px.setRoute("GPS Track log");
            Date when = new Date(time * 1000L + 631090800000L);
            px.setName(when.toString() + "&NTRK=" + new_trk);
        }
        catch (Exception ex) {
            System.err.println("D300 track log Position record error " + ex);
        }
        return px;
    }

    public byte[] buildTrackLogRec(Position pos) {
        byte[] rec = new byte[13];
        long lat = (long)(pos.decDegLat() * 1.1930464711111112E7);
        if (pos.getDirLat().equals("S")) {
            lat *= -1L;
        }
        GPSInterface.storIntLSB(rec, 0, lat);
        long lng = (long)(pos.decDegLong() * 1.1930464711111112E7);
        if (pos.getDirLong().equals("W")) {
            lng *= -1L;
        }
        GPSInterface.storIntLSB(rec, 4, lng);
        String nm = pos.getName();
        int ix = nm.indexOf("&NTRK=");
        try {
            rec[12] = (byte)Integer.parseInt(nm.substring(ix + "&NTRK=".length()));
        }
        catch (Exception ex) {}
        return rec;
    }
}

