/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices.Garmin;

import NormsTools.ChoiceOfYesOrNo;
import NormsTools.ErrDialog;
import NormsTools.GetInput;
import NormsTools.ShowMsgBox;
import SerialComm.SerialConnection;
import SerialComm.SerialConnectionException;
import SerialComm.SerialParameters;
import WayPointApps.GPSDevices.GPSInterface;
import WayPointApps.GPSDevices.Garmin.BadCheckSumException;
import WayPointApps.GPSDevices.Garmin.GarminDataParser;
import WayPointApps.GPSDevices.InvalidDataException;
import WayPointApps.GPSDevices.SerialCommException;
import WayPointApps.GPSDevices.TransferAbortedException;
import WayPointApps.Position;
import WayPointApps.Positions;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Date;
import java.util.Hashtable;

public class GarminGPSInterface
extends GPSInterface {
    final String GPSDownLoadFN = "GPSDownLoad.wps";
    final String GPSTrackLogFN = "GPSTrackLog.wps";
    final String GPSDownLoadDesc = "Waypoints downloaded from Garmin GPS ";
    public final int IdentLength = 6;
    public final int MAXWPperRoute = 30;
    public final int MAXNbrRoutes = 20;
    public final int MAXNbrWPs = 500;
    final int WaitTime = 50;
    public static final int PR_LenHdr = 3;
    public static final int PR_DLE = 0;
    public static final int PR_StartCS = 1;
    public static final int PR_Pid = 1;
    public static final int PR_Size = 2;
    public static final int PR_Data = 3;
    public static final int PR_LenTrlr = 3;
    public static final byte PR_CheckSumHere = -52;
    public static final int PR_CheckSumConstant = 256;
    public static final int MIN_PACKET_Len = 6;
    public static final byte DLEChar = 16;
    public static final byte ETX = 3;
    public static final long SEMI_CIRCLE_FCTR = 0x80000000L;
    public static final double SC_180Degrees = 180.0;
    public static final double DegToSCFctr = 1.1930464711111112E7;
    public static final double SCToDegFctr = 8.381903171539307E-8;
    public static final byte PidAckByte = 6;
    public static final byte PidNakByte = 21;
    public static final byte PidProtocolArray = -3;
    public static final byte PidProductRqst = -2;
    public static final byte PidProductData = -1;
    public static final byte PidCommandData = 10;
    public static final byte PidXferCmplt = 12;
    public static final byte PidDateTimeData = 14;
    public static final byte PidPositionData = 17;
    public static final byte PidPrxWptData = 19;
    public static final byte PidRecords = 27;
    public static final byte PidRteHdr = 29;
    public static final byte PidRteWptData = 30;
    public static final byte PidAlmanacData = 31;
    public static final byte PidTrkData = 34;
    public static final byte PidWptData = 35;
    public static final byte PidRteLinkData = 98;
    public static final byte PidTrkHdr = 99;
    static final int PD_ProductID = 0;
    static final int PD_SoftwareVersion = 2;
    static final int PD_ProdDesc = 4;
    public static final byte CmndAbortTransfer = 0;
    public static final byte CmndTransferAlm = 1;
    public static final byte CmndTransferPosn = 2;
    public static final byte CmndTransferPrx = 3;
    public static final byte CmndTransferRte = 4;
    public static final byte CmndTransferTime = 5;
    public static final byte CmndTransferTrk = 6;
    public static final byte CmndTransferWpt = 7;
    public static final byte CmndTurnOffPwr = 8;
    public static final byte CmndStartPvtData = 49;
    public static final byte CmndStopPvtData = 50;
    private SerialParameters parameters = new SerialParameters();
    private SerialConnection connection;
    private int productId = -1;
    private int swVersion = -1;
    private String protocolArray = "";
    private GarminDataParser gdp;
    Hashtable usedNames;
    boolean[] rtNbrs;
    Positions wpPos;
    final String KeySepStr = " - ";
    static final boolean debug = false;
    final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private byte[] readBytes = new byte[1000];
    private int wrtPtr = 0;
    private int rdPtr = 0;

    public int getMaxWPperRoute() {
        return 30;
    }

    public void openGPS(Frame f, String portNm, String baudRt) throws SerialCommException {
        Cursor[] preCursor;
        block10: {
            preCursor = this.setWaitCursor(f);
            this.parameters.setPortName(portNm);
            this.parameters.setBaudRate(baudRt);
            this.connection = new SerialConnection(f, this.parameters);
            try {
                this.connection.openConnection();
            }
            catch (SerialConnectionException ex) {
                System.err.println("Open port error " + ex + "\n on port: " + this.parameters.getPortName());
                this.resetCursor(f, preCursor);
                throw new SerialCommException("openGPS: open port error, " + ex);
            }
            byte[] rec = GarminGPSInterface.buildPacket((byte)-2, null);
            rec = GarminGPSInterface.genCheckSum(rec);
            try {
                this.connection.writeBytes(rec);
                rec = this.getNextRecord();
                if (rec == null) {
                    System.err.println("openGPS: read null rec from " + this.parameters.getPortName());
                    this.resetCursor(f, preCursor);
                    throw new SerialCommException("openGPS read null record");
                }
                if (rec[0] == 6) {
                    rec = this.getNextRecord();
                    if (rec[0] == -1) {
                        this.productId = GPSInterface.loadIntLSB(rec, 1);
                        this.swVersion = GPSInterface.loadIntLSB(rec, 3);
                        this.setProductData("Product id: " + this.productId + " Software version: " + this.swVersion + " Product description: " + GPSInterface.getNTString(rec, 5) + "\n More comments: " + GPSInterface.getNTString(rec, GPSInterface.getNTString(rec, 5).length() + 1 + 1 + 4));
                        this.connection.writeBytes(GarminGPSInterface.buildACK((byte)-1));
                        this.gdp = GarminDataParser.getRecordParser(this.productId, this.swVersion);
                        if (this.getNbrBytes() >= 6) {
                            rec = this.getNextRecord();
                            System.out.println("openGPS() extra record: " + GPSInterface.showBytes(rec));
                        }
                        break block10;
                    }
                    System.err.println("openGPS() Unknown record type:  rec=" + GPSInterface.showBytes(rec));
                    this.resetCursor(f, preCursor);
                    throw new SerialCommException("openGPS received unknown record " + (rec[0] & 0xFF));
                }
                System.out.println("openGPS() didn't get ACK. Got " + (rec[0] & 0xFF) + " rec=" + GPSInterface.showBytes(rec));
                this.resetCursor(f, preCursor);
                throw new SerialCommException("openGPS received unknown record " + (rec[0] & 0xFF));
            }
            catch (SerialConnectionException ex) {
                System.err.println("openGPS() error " + ex);
                this.resetCursor(f, preCursor);
                throw new SerialCommException(ex.getMessage());
            }
            catch (SerialCommException ex) {
                this.resetCursor(f, preCursor);
                throw ex;
            }
            catch (Exception ex) {
                System.err.println("openGPS() error2 rec=" + (rec != null ? GPSInterface.showBytes(rec) : "null") + "\n" + ex);
                ex.printStackTrace();
            }
        }
        this.resetCursor(f, preCursor);
    }

    private final Cursor[] setWaitCursor(Frame f) {
        Component[] cmpts = f.getComponents();
        Cursor[] csrs = new Cursor[cmpts.length + 1];
        csrs[0] = f.getCursor();
        int i = 1;
        while (i < csrs.length) {
            csrs[i] = cmpts[i - 1].getCursor();
            cmpts[i - 1].setCursor(this.waitCursor);
            ++i;
        }
        f.setCursor(this.waitCursor);
        return csrs;
    }

    private final void resetCursor(Frame f, Cursor[] crsrs) {
        f.setCursor(crsrs[0]);
        Component[] cmpts = f.getComponents();
        int i = 1;
        while (i < crsrs.length) {
            cmpts[i - 1].setCursor(crsrs[i]);
            ++i;
        }
    }

    int getNbrBytes() {
        return this.connection.getNbrBytes() + this.wrtPtr - this.rdPtr;
    }

    byte[] getNextRecord() throws BadCheckSumException {
        int ix = -1;
        int iy = -1;
        byte[] rec = null;
        try {
            block15: {
                if (this.rdPtr >= this.wrtPtr) {
                    int svPtr = this.wrtPtr;
                    int lpCnt = 0;
                    do {
                        this.wrtPtr = this.connection.getBytes(this.readBytes, this.wrtPtr);
                        if (svPtr < this.wrtPtr) break block15;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    } while (lpCnt++ * 50 <= this.timeOutms);
                    System.err.println("getNextRecord(): no data after " + lpCnt * 50 + "ms,  svPtr=" + svPtr + ", wrtPtr=" + this.wrtPtr);
                    return null;
                }
            }
            boolean found = false;
            ix = this.rdPtr;
            while (ix < this.wrtPtr) {
                if (this.readBytes[ix] == 16 && this.readBytes[ix + 1] != 16 && this.readBytes[ix + 1] != 3) {
                    found = true;
                    break;
                }
                ++ix;
            }
            if (found) {
                found = false;
                iy = ix + 1;
                while (iy < this.wrtPtr) {
                    if (this.readBytes[iy] == 16 && this.readBytes[iy + 1] == 3) {
                        found = true;
                        break;
                    }
                    ++iy;
                }
                if (found) {
                    rec = new byte[iy - ix - 3];
                    rec[0] = this.readBytes[ix + 1];
                    long ckSum = 0L;
                    int i = 1;
                    while (i < rec.length) {
                        rec[i] = this.readBytes[ix + 3 + i - 1];
                        ckSum += (long)rec[i];
                        if (rec[i] == 16 && this.readBytes[ix + 3 + i] == 16) {
                            ++ix;
                        }
                        ++i;
                    }
                    this.rdPtr = iy + 2;
                    if (this.rdPtr >= this.wrtPtr) {
                        this.wrtPtr = 0;
                        this.rdPtr = 0;
                    }
                    return rec;
                }
                System.err.println("getNxtRec: no (DLE|ETX) found");
                return null;
            }
            System.err.println("getNxtRec: no leading DLE found");
            return null;
        }
        catch (Exception ex) {
            System.err.println("getNxtRec() ex  wrt=" + this.wrtPtr + " rd=" + this.rdPtr + (rec == null ? " null" : " " + GPSInterface.showBytes(rec)) + " ix=" + ix + " iy=" + iy + "\n  ex:" + ex);
            return null;
        }
    }

    public void closeGPS() {
        if (this.connection == null) {
            System.err.println("closeGPS with null connection");
            return;
        }
        this.connection.closeConnection();
    }

    public Positions downLoadWpts(Frame f) throws SerialCommException, TransferAbortedException {
        Cursor[] preCursor;
        Positions px;
        block14: {
            new ShowMsgBox("Note:", "Set the GPS to Interface GRMN/GRMN\n Access via SETUP MENU | INTERFACE\n Should display: HOST and WAITING...", f, false);
            px = null;
            preCursor = this.setWaitCursor(f);
            int nbrPos = 1;
            this.flushBuffers();
            byte[] rec = GarminGPSInterface.buildCmnd((byte)7);
            try {
                this.connection.writeBytes(rec);
                rec = this.getNextRecord();
                if (rec[0] == -3) {
                    this.saveProtocols(rec);
                    rec = this.getNextRecord();
                }
                if (rec[0] == 12) {
                    rec = this.getNextRecord();
                    System.out.println("DL recvd1b: " + GPSInterface.showBytes(rec));
                }
                if (rec[0] == 6) {
                    rec = this.getNextRecord();
                } else {
                    System.out.println("DL didn't get ACK. Got " + (rec[0] & 0xFF));
                    rec = this.getNextRecord();
                    System.out.println("DL recvd2a: " + GPSInterface.showBytes(rec));
                }
                if (rec[0] == 27) {
                    nbrPos = GPSInterface.loadIntLSB(rec, 1);
                    this.connection.writeBytes(GarminGPSInterface.buildACK((byte)27));
                    rec = this.getNextRecord();
                    this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                    px = new Positions(nbrPos);
                    int i = 0;
                    while (i < nbrPos) {
                        if (this.abortXfer) {
                            this.abortXfer = false;
                            throw new TransferAbortedException("Reading waypoints aborted after " + i);
                        }
                        Position p = this.gdp.parseDataRec(rec, 1);
                        px.add(p);
                        rec = this.getNextRecord();
                        this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                        if (rec == null) {
                            System.out.println("DL read pos loop got null rec at " + i);
                            break;
                        }
                        if (rec[0] == 12) break;
                        if (rec[0] != 35) {
                            System.err.println("DL read non WptData record " + GPSInterface.showBytes(rec));
                        }
                        ++i;
                    }
                    if (this.getNbrBytes() >= 6) {
                        rec = this.getNextRecord();
                        this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                        System.out.println("DL extra records: " + GPSInterface.showBytes(rec));
                    }
                    break block14;
                }
                System.out.println("DL didn't get PidRecords. Got " + (rec[0] & 0xFF));
                this.resetCursor(f, preCursor);
                return null;
            }
            catch (Exception ex) {
                System.err.println("downLoadWpts() Error: " + ex);
                System.out.println("DL ex rec: " + GPSInterface.showBytes(rec));
                this.resetCursor(f, preCursor);
                return null;
            }
        }
        this.resetCursor(f, preCursor);
        px.owner = this.getOwner();
        if (this.getOwner().equals("")) {
            GetInput gi = new GetInput("Please enter owner name for these waypoints", f, 15, "Set owner");
            px.owner = gi.getResponse();
        }
        Hashtable<String, Position> ht = new Hashtable<String, Position>(px.size());
        int i = 0;
        while (i < px.size()) {
            String gpsName = this.buildGPSName(px.get(i).getGPSName());
            ht.put(gpsName, px.get(i));
            ++i;
        }
        this.usedNames = ht;
        px.description = "Waypoints downloaded from Garmin GPS " + new Date();
        px.fileName = "GPSDownLoad.wps";
        this.wpPos = px;
        return px;
    }

    public Hashtable downLoadRtes(Frame f) throws SerialCommException, TransferAbortedException {
        Hashtable<String, Positions> routes;
        Cursor[] preCursor;
        block17: {
            preCursor = this.setWaitCursor(f);
            this.flushBuffers();
            routes = new Hashtable<String, Positions>();
            String rtNm = "";
            Positions px = null;
            boolean nbrRtes = false;
            int rtNbr = 0;
            this.rtNbrs = new boolean[21];
            byte[] rec = GarminGPSInterface.buildCmnd((byte)4);
            try {
                this.connection.writeBytes(rec);
                rec = this.getNextRecord();
                if (rec[0] == -3) {
                    this.saveProtocols(rec);
                    rec = this.getNextRecord();
                }
                if (rec[0] == 6) {
                    rec = this.getNextRecord();
                } else {
                    System.err.println("DLRte didn't get ACK. Got " + (rec[0] & 0xFF));
                }
                if (rec[0] == 27) {
                    int nbrRecs = GPSInterface.loadIntLSB(rec, 1);
                    this.connection.writeBytes(GarminGPSInterface.buildACK((byte)27));
                    String owner = this.getOwner();
                    if (owner.equals("")) {
                        GetInput gi = new GetInput("Please enter owner name for these waypoints", f, 15, "Set owner");
                        owner = gi.getResponse();
                    }
                    int idx = 0;
                    idx = 0;
                    while (idx < nbrRecs) {
                        if (this.abortXfer) {
                            this.abortXfer = false;
                            throw new TransferAbortedException("Reading routes aborted after " + idx);
                        }
                        rec = this.getNextRecord();
                        if (rec == null) {
                            System.out.println("DLRte read pos loop got null rec at " + idx);
                            break;
                        }
                        this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                        if (rec[0] == 29 || rec[0] == 12) {
                            if (px != null) {
                                routes.put((rtNbr < 10 ? "0" : "") + Integer.toString(rtNbr) + " - " + rtNm, px);
                            }
                            if (rec[0] == 12) break;
                            rtNbr = this.gdp.parseRouteHdr(rec, 1);
                            this.rtNbrs[rtNbr] = true;
                            rtNm = this.gdp.parseRouteHdrCmnt(rec, 1);
                            px = new Positions(30);
                            px.description = rtNm.equals("") ? "Route number " + rtNbr : rtNm;
                            px.fileName = "Route" + rtNbr + ".wps";
                            px.owner = owner;
                        } else if (rec[0] == 30) {
                            Position p = this.gdp.parseDataRec(rec, 1);
                            px.add(p);
                        } else {
                            System.err.println("DLRte got unknown rec type: " + (rec[0] & 0xFF));
                        }
                        ++idx;
                    }
                    if (idx == nbrRecs) {
                        routes.put((rtNbr < 10 ? "0" : "") + Integer.toString(rtNbr) + " - " + rtNm, px);
                    }
                    if (this.getNbrBytes() >= 6) {
                        rec = this.getNextRecord();
                        this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                        System.out.println("DLRte extra record: " + GPSInterface.showBytes(rec));
                    }
                    break block17;
                }
                this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                System.err.println("DLRte didn't get PidRecords. Got " + (rec[0] & 0xFF));
                this.resetCursor(f, preCursor);
                return null;
            }
            catch (Exception ex) {
                System.err.println("DLRte: ex " + ex);
                throw new SerialCommException(ex.getMessage());
            }
        }
        this.resetCursor(f, preCursor);
        return routes;
    }

    public Positions readTrackLog(Frame frm) throws SerialCommException, TransferAbortedException {
        Cursor[] preCursor;
        Positions px;
        block13: {
            px = null;
            preCursor = this.setWaitCursor(frm);
            int nbrPos = 1;
            this.flushBuffers();
            byte[] rec = GarminGPSInterface.buildCmnd((byte)6);
            try {
                this.connection.writeBytes(rec);
                rec = this.getNextRecord();
                if (rec[0] == -3) {
                    this.saveProtocols(rec);
                    rec = this.getNextRecord();
                }
                if (rec[0] == 12) {
                    rec = this.getNextRecord();
                    System.out.println("RTL recvd1b: " + GPSInterface.showBytes(rec));
                }
                if (rec[0] == 6) {
                    rec = this.getNextRecord();
                } else {
                    System.out.println("RTL didn't get ACK. Got " + (rec[0] & 0xFF));
                    rec = this.getNextRecord();
                    System.out.println("RTL recvd2a: " + GPSInterface.showBytes(rec));
                }
                if (rec[0] == 27) {
                    nbrPos = GPSInterface.loadIntLSB(rec, 1);
                    this.connection.writeBytes(GarminGPSInterface.buildACK((byte)27));
                    rec = this.getNextRecord();
                    this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                    px = new Positions(nbrPos);
                    int i = 0;
                    while (i < nbrPos) {
                        if (this.abortXfer) {
                            this.abortXfer = false;
                            throw new TransferAbortedException("Reading track logs aborted after " + i);
                        }
                        Position p = this.gdp.parseTrackLogRec(rec, 1);
                        px.add(p);
                        rec = this.getNextRecord();
                        this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                        if (rec == null) {
                            System.out.println("RTL read pos loop got null rec at " + i);
                            break;
                        }
                        if (rec[0] == 12) break;
                        if (rec[0] != 34) {
                            System.err.println("RTL read non TrackLog record " + GPSInterface.showBytes(rec));
                        }
                        ++i;
                    }
                    if (this.getNbrBytes() >= 6) {
                        rec = this.getNextRecord();
                        this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                        System.out.println("RTL extra records: " + GPSInterface.showBytes(rec));
                    }
                    break block13;
                }
                System.out.println("RTL didn't get PidRecords. Got " + (rec[0] & 0xFF));
                this.resetCursor(frm, preCursor);
                return null;
            }
            catch (Exception ex) {
                System.err.println("readTrackLog() Error: " + ex);
                System.out.println("RTL ex rec: " + GPSInterface.showBytes(rec));
                this.resetCursor(frm, preCursor);
                return null;
            }
        }
        this.resetCursor(frm, preCursor);
        px.owner = this.getOwner();
        if (this.getOwner().equals("")) {
            GetInput gi = new GetInput("Please enter owner name for the tracklog waypoints", frm, 15, "Set owner");
            px.owner = gi.getResponse();
        }
        px.description = "Waypoints downloaded from Garmin GPS " + new Date();
        px.fileName = "GPSTrackLog.wps";
        return px;
    }

    public void upLoadWpts(Frame f, Positions posx) throws SerialCommException, TransferAbortedException {
        Cursor[] preCursor = this.setWaitCursor(f);
        this.gdp.setPositions(posx);
        this.flushBuffers();
        byte[] rec = GarminGPSInterface.buildPacket((byte)27, GPSInterface.storIntLSB(new byte[2], 0, posx.size()));
        rec = GarminGPSInterface.genCheckSum(rec);
        try {
            this.connection.writeBytes(rec);
            rec = this.getNextRecord();
            if (rec[0] == 6) {
                // empty if block
            }
            int i = 0;
            while (i < posx.size()) {
                if (this.abortXfer) {
                    this.abortXfer = false;
                    throw new TransferAbortedException("Writing waypoints aborted after " + i);
                }
                rec = GarminGPSInterface.buildPacket((byte)30, this.gdp.buildWptRecord(posx.get(i)));
                rec = GarminGPSInterface.genCheckSum(rec);
                this.connection.writeBytes(rec);
                rec = this.getNextRecord();
                ++i;
            }
            rec = GarminGPSInterface.buildPacket((byte)12, GPSInterface.storIntLSB(new byte[2], 0, 7));
            rec = GarminGPSInterface.genCheckSum(rec);
            this.connection.writeBytes(rec);
            rec = this.getNextRecord();
        }
        catch (Exception ex) {
            System.err.println("upLoadWpts() exception " + ex);
            this.resetCursor(f, preCursor);
            throw new SerialCommException("upLoadWpts had ex " + ex.getMessage());
        }
        this.resetCursor(f, preCursor);
    }

    public void writeTrackLog(Frame f, Positions posx) throws SerialCommException, TransferAbortedException {
        Cursor[] preCursor = this.setWaitCursor(f);
        this.gdp.setPositions(posx);
        this.flushBuffers();
        byte[] rec = GarminGPSInterface.buildPacket((byte)27, GPSInterface.storIntLSB(new byte[2], 0, posx.size()));
        rec = GarminGPSInterface.genCheckSum(rec);
        try {
            this.connection.writeBytes(rec);
            rec = this.getNextRecord();
            if (rec[0] == 6) {
                // empty if block
            }
            int i = 0;
            while (i < posx.size()) {
                if (this.abortXfer) {
                    this.abortXfer = false;
                    throw new TransferAbortedException("Writing tracklog points aborted after " + i);
                }
                rec = GarminGPSInterface.buildPacket((byte)34, this.gdp.buildTrackLogRec(posx.get(i)));
                rec = GarminGPSInterface.genCheckSum(rec);
                this.connection.writeBytes(rec);
                rec = this.getNextRecord();
                ++i;
            }
            rec = GarminGPSInterface.buildPacket((byte)12, GPSInterface.storIntLSB(new byte[2], 0, 6));
            rec = GarminGPSInterface.genCheckSum(rec);
            this.connection.writeBytes(rec);
            rec = this.getNextRecord();
        }
        catch (Exception ex) {
            System.err.println("writeTrackLog() exception " + ex);
            this.resetCursor(f, preCursor);
            throw new SerialCommException("writeTrackLog had ex " + ex.getMessage());
        }
        this.resetCursor(f, preCursor);
    }

    public void upLoadRte(Frame f, Positions posx, String rtNm) throws SerialCommException, TransferAbortedException {
        Cursor[] preCursor = this.setWaitCursor(f);
        this.gdp.setPositions(posx);
        this.flushBuffers();
        byte[] rec = GarminGPSInterface.buildPacket((byte)27, GPSInterface.storIntLSB(new byte[2], 0, posx.size() + 1));
        rec = GarminGPSInterface.genCheckSum(rec);
        try {
            this.connection.writeBytes(rec);
            rec = this.getNextRecord();
            if (rec[0] == 6) {
                // empty if block
            }
            rec = GarminGPSInterface.buildPacket((byte)29, this.gdp.buildRteHdr(rtNm));
            rec = GarminGPSInterface.genCheckSum(rec);
            this.connection.writeBytes(rec);
            rec = this.getNextRecord();
            int i = 0;
            while (i < posx.size()) {
                if (this.abortXfer) {
                    this.abortXfer = false;
                    throw new TransferAbortedException("Writing routes aborted after " + i);
                }
                rec = GarminGPSInterface.buildPacket((byte)30, this.gdp.buildWptRecord(posx.get(i)));
                rec = GarminGPSInterface.genCheckSum(rec);
                this.connection.writeBytes(rec);
                rec = this.getNextRecord();
                ++i;
            }
            rec = GarminGPSInterface.buildPacket((byte)12, GPSInterface.storIntLSB(new byte[2], 0, 4));
            rec = GarminGPSInterface.genCheckSum(rec);
            this.connection.writeBytes(rec);
            rec = this.getNextRecord();
        }
        catch (Exception ex) {
            System.err.println("upLoadRte() exception " + ex);
            this.resetCursor(f, preCursor);
            throw new SerialCommException("upLoadRte had ex " + ex.getMessage());
        }
        this.resetCursor(f, preCursor);
    }

    public boolean checkWpts(Positions ptc, Frame f) throws InvalidDataException {
        ChoiceOfYesOrNo cyn;
        if (this.usedNames == null || this.wpPos == null) {
            throw new InvalidDataException("Must read GPS waypoints (to allow checks) before writing.");
        }
        this.appendLogNL("Starting check of waypoints in " + ptc.description);
        this.checkPositions(this.wpPos, ptc);
        boolean results = true;
        boolean errorFnd = false;
        boolean matchedName = false;
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>(ptc.size());
        int i = 0;
        while (i < ptc.size()) {
            Position pos = ptc.get(i);
            String gpsName = pos.getGPSName();
            if (gpsName.length() < 1 || gpsName.length() > 6 || !this.ckValidName(gpsName)) {
                errorFnd = true;
                this.appendLogNL(" >>>Invalid length GPS name: >" + gpsName + "< maximum length is " + 6 + ".");
            }
            if (ht.containsKey(gpsName)) {
                errorFnd = true;
                this.appendLogNL(">>> You have a duplicate name: " + gpsName + " at " + (i + 1) + ". Matches line " + ((Integer)ht.get(gpsName) + 1));
            } else {
                ht.put(gpsName, new Integer(i));
            }
            if (this.usedNames.containsKey(gpsName)) {
                matchedName = true;
                this.appendLogNL(" >>>GPS has waypoint: " + gpsName + " at line " + (i + 1) + ". Their positions are " + (pos.samePosition((Position)this.usedNames.get(gpsName)) ? "the same." : "different."));
            } else if (pos.isEndOfLeg()) {
                this.appendLogNL(" >>>'End of Leg' record found at: " + (i + 1));
                errorFnd = true;
            }
            ++i;
        }
        if (errorFnd) {
            throw new InvalidDataException("Fatal Errors found in waypoints. See log>>>");
        }
        if (matchedName && !(cyn = new ChoiceOfYesOrNo(f, "Waypoints with same name(s) found on GPS. See log >>>\n Do you want to Write these " + ptc.size() + " waypoints?")).isYes()) {
            throw new InvalidDataException("User cancelled write of waypoints.");
        }
        return results;
    }

    public boolean checkRoute(String rtNm, Positions ptc, Frame f) throws InvalidDataException {
        ChoiceOfYesOrNo cyn;
        if (this.usedNames == null) {
            throw new InvalidDataException("Must read GPS waypoints (to allow checks) before writing.");
        }
        boolean results = true;
        if (this.rtNbrs != null && this.rtNbrs[Integer.parseInt(rtNm)]) {
            this.appendLogNL(">>> Route " + rtNm + " is currently used.");
            results = false;
        }
        boolean matchedName = false;
        int i = 0;
        while (i < ptc.size()) {
            if (this.usedNames.containsKey(ptc.get(i).getGPSName())) {
                matchedName = true;
                this.appendLogNL(" >>>GPS has waypoint: " + ptc.get(i).getGPSName() + ".  " + " Their positions are " + (ptc.get(i).samePosition((Position)this.usedNames.get(ptc.get(i).getGPSName())) ? "the same." : "different."));
            }
            ++i;
        }
        if (matchedName && !(cyn = new ChoiceOfYesOrNo(f, "Waypoints in this route are currently in the GPS. See log >>>.\nDo you want to write this route?")).isYes()) {
            throw new InvalidDataException("User cancelled write of route " + rtNm + ".");
        }
        return results;
    }

    private void flushBuffers() {
        while (this.getNbrBytes() >= 6) {
            try {
                byte[] rec = this.getNextRecord();
                this.connection.writeBytes(GarminGPSInterface.buildACK(rec[0]));
                if (rec[0] == -3) {
                    this.saveProtocols(rec);
                    continue;
                }
                System.out.println("Flushed extra record: " + GPSInterface.showBytes(rec));
            }
            catch (Exception ex) {
                System.err.println("Error flushing ex: " + ex);
            }
        }
    }

    private void saveProtocols(byte[] rec) {
        int i = 1;
        while (i < rec.length) {
            String tag = new String(rec, i, 1);
            int data = GPSInterface.loadIntLSB(rec, i + 1);
            this.protocolArray = this.protocolArray + tag + data + " ";
            i += 3;
        }
    }

    public String getProtocols() {
        return this.protocolArray;
    }

    public String getARouteNm(Frame f) {
        String rtNm = "";
        int rv = 0;
        while (true) {
            GetInput gi;
            if ((rtNm = (gi = new GetInput("Enter route number to use:", f, 2, "Write rte")).getResponse()).equals("")) {
                return rtNm;
            }
            try {
                rv = new Integer(rtNm);
                if (rv >= 0 && rv < this.gdp.getMaxRoutes()) {
                    break;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            new ErrDialog(f, "Invalid route id: " + rtNm + ". Must be numeric and from 0 to " + (this.gdp.getMaxRoutes() - 1));
        }
        return (rv < 10 && rtNm.length() == 1 ? "0" : "") + rtNm;
    }

    public static byte[] buildPacket(byte pid, byte[] data) {
        byte[] retPckt = new byte[6 + (data == null ? 0 : data.length)];
        retPckt[0] = 16;
        retPckt[1] = pid;
        retPckt[2] = (byte)(data == null ? 0 : data.length);
        int i = 3;
        if (data != null) {
            int j = 0;
            while (j < data.length) {
                retPckt[i] = data[j];
                ++j;
                ++i;
            }
        }
        retPckt[i++] = -52;
        retPckt[i++] = 16;
        retPckt[i] = 3;
        return retPckt;
    }

    public static byte[] buildCmnd(byte cmnd) {
        byte[] retPckt = GarminGPSInterface.buildPacket((byte)10, GPSInterface.storIntLSB(new byte[2], 0, cmnd));
        return GarminGPSInterface.genCheckSum(retPckt);
    }

    public static byte[] buildACK(byte pid) {
        byte[] retPckt = new byte[]{16, 6, 1, pid, -52, 16, 3};
        return GarminGPSInterface.genCheckSum(retPckt);
    }

    public static byte[] genCheckSum(byte[] packet) {
        int dleCnt = 0;
        int i = 1;
        while (i < packet.length - 3) {
            if (packet[i] == 16) {
                ++dleCnt;
            }
            ++i;
        }
        byte[] retPckt = new byte[packet.length + dleCnt];
        long chkSum = 0L;
        int j = 1;
        retPckt[0] = packet[0];
        int i2 = 1;
        while (i2 < packet.length - 3) {
            chkSum += (long)packet[i2];
            retPckt[j] = packet[i2];
            if (packet[i2] == 16) {
                retPckt[++j] = 16;
            }
            ++i2;
            ++j;
        }
        chkSum &= 0xFFL;
        chkSum = 256L - chkSum;
        retPckt[j++] = (byte)chkSum;
        retPckt[j++] = 16;
        retPckt[j] = 3;
        return retPckt;
    }

    public static byte[] ckInputPacket(byte[] packet) throws BadCheckSumException {
        int dleCnt = 0;
        int i = 1;
        while (i < packet.length - 3) {
            if (packet[i] == 16) {
                ++dleCnt;
            }
            ++i;
        }
        byte[] retPckt = new byte[packet.length - dleCnt / 2];
        retPckt[0] = packet[0];
        int j = 1;
        long chkSum = 0L;
        int i2 = 0;
        i2 = 1;
        while (i2 < packet.length - 3) {
            retPckt[j++] = packet[i2];
            chkSum += (long)packet[i2];
            if (packet[i2] == 16 && packet[i2 + 1] == 16) {
                ++i2;
            }
            ++i2;
        }
        retPckt[j++] = packet[i2];
        chkSum &= 0xFFL;
        if ((chkSum = 256L - chkSum) != (long)(packet[i2] & 0xFF)) {
            System.err.println("Bad checksum: " + (packet[i2] & 0xFF) + " computed: " + chkSum + " " + i2 + "\n Bytes: " + GPSInterface.showBytes(packet));
            throw new BadCheckSumException("Computed: " + chkSum + " vs " + packet[i2]);
        }
        retPckt[j++] = 16;
        retPckt[j] = 3;
        return retPckt;
    }

    public String buildGPSName(String nm) {
        char[] retC = new char[6];
        char[] charS = nm.toCharArray();
        int j = 0;
        int i = 0;
        while (i < charS.length) {
            if (Character.isLetterOrDigit(charS[i]) || charS[i] == '-') {
                retC[j++] = Character.toUpperCase(charS[i]);
            }
            if (j >= 6) break;
            ++i;
        }
        while (j < 6) {
            retC[j] = 32;
            ++j;
        }
        return new String(retC).trim();
    }
}

