/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices.Garmin;

import NormsTools.ShowMsgBox;
import WayPointApps.GPSDevices.Garmin.ParseD103D201;
import WayPointApps.Position;
import WayPointApps.Positions;
import java.awt.Frame;

public abstract class GarminDataParser {
    Positions rtePos = null;
    boolean debug = false;

    public abstract Position parseDataRec(byte[] var1, int var2);

    public abstract int parseRouteHdr(byte[] var1, int var2);

    public abstract String parseRouteHdrCmnt(byte[] var1, int var2);

    public abstract Position parseTrackLogRec(byte[] var1, int var2);

    public abstract byte[] buildTrackLogRec(Position var1);

    public abstract byte[] buildRteHdr(String var1);

    public abstract byte[] buildWptRecord(Position var1);

    public abstract int getMaxRoutes();

    public void setPositions(Positions ps) {
        this.rtePos = ps;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public static GarminDataParser getRecordParser(int pId, int swVersion) {
        switch (pId) {
            case 73: 
            case 87: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 105: 
            case 106: {
                return new ParseD103D201();
            }
            case 77: {
                ParseD103D201 gdp = new ParseD103D201();
                if (swVersion < 301) {
                    gdp.useD100 = true;
                }
                return gdp;
            }
            case 41: 
            case 47: 
            case 55: 
            case 59: 
            case 61: 
            case 62: 
            case 74: {
                ParseD103D201 gdp = new ParseD103D201();
                gdp.useD100 = true;
                return gdp;
            }
        }
        System.err.println("GarminDataParser - unknown Product Id " + pId);
        new ShowMsgBox("Warning", "Unknown Garmin product id: " + pId, new Frame(), true);
        return null;
    }
}

