/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices;

import WayPointApps.GPSDevices.InvalidDataException;
import WayPointApps.GPSDevices.SerialCommException;
import WayPointApps.GPSDevices.TransferAbortedException;
import WayPointApps.Position;
import WayPointApps.Positions;
import WayPointApps.WayPointsInterface;
import java.awt.Frame;
import java.awt.Menu;
import java.util.Hashtable;

public abstract class GPSInterface {
    static final int byteMask = 255;
    public static boolean debug = false;
    String productData = "";
    String owner = "";
    public WayPointsInterface wpif;
    public boolean abortXfer = false;
    public int timeOutms = 1000;
    static String blanks = "                                                                                                      ";
    static char[] hexValue = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void abortTransfer() {
        this.abortXfer = true;
    }

    public Menu addMenu() {
        return null;
    }

    public static final String ckNoNulls(String string) {
        char c = '\u0000';
        if (string.indexOf(c) >= 0) {
            return string.replace(c, ' ');
        }
        return string;
    }

    public abstract void upLoadRte(Frame var1, Positions var2, String var3) throws SerialCommException, TransferAbortedException;

    public abstract String getARouteNm(Frame var1);

    public static final String getNTString(byte[] byArray, int n) {
        if (n >= byArray.length) {
            return "";
        }
        int n2 = n;
        n2 = n;
        while (n2 < byArray.length) {
            if (byArray[n2] == 0) break;
            ++n2;
        }
        return new String(byArray, n, n2 - n);
    }

    public boolean ckValidName(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isLetterOrDigit(cArray[n]) && cArray[n] != '-' || Character.isLowerCase(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean checkWpts(Positions positions, Frame frame) throws InvalidDataException {
        return true;
    }

    public static final long loadLongLSB(byte[] byArray, int n) {
        return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8 | (0xFF & byArray[n + 2]) << 16 | byArray[n + 3] << 24;
    }

    public abstract int getMaxWPperRoute();

    public String buildGPSName(String string) {
        System.out.println("GPSInterface.buildGPSName for " + string);
        if (string.length() > 6) {
            return string.substring(0, 6).toUpperCase();
        }
        return string.toUpperCase();
    }

    public abstract void upLoadWpts(Frame var1, Positions var2) throws SerialCommException, TransferAbortedException;

    public static String showBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2 + byArray.length / 4);
        stringBuffer.setLength(byArray.length * 2 + byArray.length / 4);
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = byArray[n2] & 0xFF;
                stringBuffer.setCharAt(n++, hexValue[n3 >> 4]);
                stringBuffer.setCharAt(n++, hexValue[n3 & 0xF]);
                if (n2 % 4 == 3) {
                    stringBuffer.setCharAt(n++, ' ');
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("showBytes() Error " + exception + "\n j=" + n + " " + stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    public void setDebug(boolean bl) {
        debug = bl;
    }

    public abstract void openGPS(Frame var1, String var2, String var3) throws SerialCommException;

    public void checkPositions(Positions positions, Positions positions2) {
        int n = 0;
        while (n < positions2.size()) {
            Position position = positions2.get(n);
            String string = position.getGPSName();
            int n2 = 0;
            while (n2 < positions.size()) {
                Position position2 = positions.get(n2);
                String string2 = position2.getGPSName();
                if (position.samePosition(position2) && !string.equals(string2)) {
                    this.appendLogNL(" >>>Matching positions for new: " + string + " and  GPS: " + string2);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setProductData(String string) {
        this.productData = string;
    }

    public String getProductData() {
        return this.productData;
    }

    public void setInterface(WayPointsInterface wayPointsInterface) {
        this.wpif = wayPointsInterface;
    }

    public static final byte[] storIntLSB(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        return byArray;
    }

    public abstract Positions readTrackLog(Frame var1) throws SerialCommException, TransferAbortedException;

    public abstract void writeTrackLog(Frame var1, Positions var2) throws SerialCommException, TransferAbortedException;

    public boolean checkRoute(String string, Positions positions, Frame frame) throws InvalidDataException {
        return true;
    }

    public static final byte[] storIntLSB(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        return byArray;
    }

    public static final int loadIntLSB(byte[] byArray, int n) {
        return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8;
    }

    public static final byte[] storString(String string, byte[] byArray, int n, int n2) {
        byte[] byArray2 = (string + blanks).getBytes();
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3] = byArray2[n3];
            ++n3;
        }
        return byArray;
    }

    public static final byte[] toNTString(String string) {
        byte[] byArray = (string + " ").getBytes();
        byArray[byArray.length - 1] = 0;
        return byArray;
    }

    public static final byte[] toNTString(String string, int n) {
        byte[] byArray = (string + blanks).substring(0, n + 1).getBytes();
        byArray[byArray.length - 1] = 0;
        return byArray;
    }

    public void appendLogNL(String string) {
        this.wpif.logMsg(string + "\n");
    }

    public abstract Hashtable downLoadRtes(Frame var1) throws SerialCommException, TransferAbortedException;

    public void setTimeOut(int n) {
        this.timeOutms = n;
    }

    public abstract void closeGPS();

    public abstract Positions downLoadWpts(Frame var1) throws SerialCommException, TransferAbortedException;
}

