/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices;

import NormsTools.ChoiceOfYesOrNo;
import NormsTools.DocumentViewer.ShowDocument;
import NormsTools.ErrDialog;
import NormsTools.GetInput;
import NormsTools.MSDosFilename;
import NormsTools.SaveStdOutput;
import NormsTools.SearchFor;
import NormsTools.ShowListBox;
import NormsTools.ShowMsgBox;
import NormsTools.ShowOptions;
import WayPointApps.CMAPPositionFactory;
import WayPointApps.GPSDevices.DisplayNMEA;
import WayPointApps.GPSDevices.GPSDeviceCommunicator;
import WayPointApps.GPSDevices.GPSDeviceFactory;
import WayPointApps.GPSDevices.GPSInterface;
import WayPointApps.GPSDevices.GPSInterface2;
import WayPointApps.GPSDevices.InvalidDataException;
import WayPointApps.GPSDevices.NobeltecEval;
import WayPointApps.GPSDevices.SerialCommException;
import WayPointApps.LoginRecord;
import WayPointApps.MaxSeaPositionFactory;
import WayPointApps.NavSoftwareInterfaces.MaxSea;
import WayPointApps.NavSoftwareInterfaces.Nobeltec;
import WayPointApps.NobeltecPositionFactory;
import WayPointApps.Position;
import WayPointApps.Positions;
import WayPointApps.ShowPositions;
import WayPointApps.WPFileRecs;
import WayPointApps.WayPointDefs;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class GPSDeviceCommunicator
extends Frame
implements ActionListener,
ItemListener,
GPSInterface2 {
    static final String Welcome = "Norm's GPS Communicator  Version 1.15  23 May 2004";
    private String helpFN = "GPSCommunicator.html";
    boolean Testing = false;
    boolean debug = false;
    final String PropFN = "GPSDeviceCommunicator.ini";
    Properties ourProps;
    private boolean createPropFile = false;
    final String ConsLogFile = "GPSDeviceCommunicator.log";
    boolean writeCons = false;
    boolean allowMultOpen = false;
    final String mtString = "";
    int timeOutms = 1000;
    int nbrBest = 9;
    final String GPSBrandPNM = "GPSBrand";
    String gpsBrand = "Garmin";
    final String SerialPortPNM = "SerialPort";
    String serialPort = "1";
    final String[] SerialPorts = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    final String AllowUpLoadPNM = "AllowUpLoad";
    String allowUpLoad = "No";
    final String BaudRatePNM = "BaudRate";
    String baudRate = "9600";
    final String[] BaudRates = new String[]{"2400", "4800", "9600", "19200", "38400"};
    final String OwnerPNM = "Owner";
    String owner = "";
    final String ShowMsgsOnLogPNM = "ShowMsgsOnLog";
    String showMsgsOnLogV = "No";
    final String TimeOutMSNM = "TimeOutMS";
    String timeOutMSV = "1000";
    final String WPDirPNM = "WaypointsDir";
    String wpDirV = "";
    MenuBar mb = new MenuBar();
    Menu fileM = new Menu("File");
    MenuItem newMI = new MenuItem("New Waypoints File...");
    MenuItem openMI = new MenuItem("Open Waypoints File...");
    MenuItem crtWorkMI = new MenuItem("Create Waypoints Work file");
    MenuItem selectActWindMI = new MenuItem("Select Active window...");
    MenuItem displayMI = new MenuItem("Display Waypoints File");
    MenuItem saveAsMI = new MenuItem("Set Save filename...");
    MenuItem editNotesMI = new MenuItem("Edit ReminderNotes...");
    MenuItem exitMI = new MenuItem("Exit");
    Menu gpsM = new Menu("GPS");
    MenuItem openGPSMI = new MenuItem("Open GPS");
    MenuItem displayNMEAMI = new MenuItem("Display NMEA input...");
    MenuItem downLoadWptsMI = new MenuItem("Read Waypoints from GPS");
    MenuItem displayWptsMI = new MenuItem("Display Waypoints");
    MenuItem downLoadRteMI = new MenuItem("Read Routes from GPS");
    MenuItem displayRteMI = new MenuItem("Display Route...");
    MenuItem readTrackMI = new MenuItem("Read tracklog from GPS");
    MenuItem writeTrackMI = new MenuItem("Write tracklog to GPS");
    MenuItem upLoadWptsMI = new MenuItem("Write Waypoints to GPS");
    MenuItem upLoadRteMI = new MenuItem("Write Route to GPS...");
    MenuItem abortXferMI = new MenuItem("Abort transfer");
    MenuItem closeGPSMI = new MenuItem("Close GPS");
    MenuItem[] gpsJobs = new MenuItem[]{this.openGPSMI, this.displayNMEAMI, this.displayWptsMI, this.downLoadWptsMI, this.upLoadWptsMI, this.downLoadRteMI, this.upLoadRteMI, this.readTrackMI, this.writeTrackMI, this.closeGPSMI};
    boolean[] savedGPSMI = new boolean[this.gpsJobs.length];
    Menu optionsM = new Menu("Options");
    CheckboxMenuItem allowWriteMI = new CheckboxMenuItem("Allow Write to GPS");
    CheckboxMenuItem autoCrMI = new CheckboxMenuItem("AutoCreate GPS names");
    MenuItem setTypeMI = new MenuItem("Set GPS...");
    MenuItem setCOMMMI = new MenuItem("Set COMM port ...");
    MenuItem setBaudMI = new MenuItem("Set baud rate ...");
    MenuItem setTimeoutMI = new MenuItem("Set timeout(ms) ...");
    MenuItem clearLogMI = new MenuItem("Clear Log");
    MenuItem convertMI = new MenuItem("Convert: copy WPName to Route");
    CheckboxMenuItem savePropsMI = new CheckboxMenuItem("Save .ini on exit");
    CheckboxMenuItem debugMI = new CheckboxMenuItem("Debug");
    CheckboxMenuItem allowMultOpenCB = new CheckboxMenuItem("Allow multiple files open");
    CheckboxMenuItem setSaveConsMI = new CheckboxMenuItem("Save console to file", false);
    Menu helpM = new Menu("Help");
    MenuItem aboutMI = new MenuItem("About GPSCommunicator");
    MenuItem helpMI = new MenuItem("Help Topics");
    Menu routesM = new Menu("GPSU");
    MenuItem displayRte2MI = new MenuItem("Display Route...");
    Menu deviceM = null;
    TextArea theLog = new TextArea();
    boolean showMsgsOnLog = false;
    boolean doingUpLoad = false;
    boolean usingJVIEW = false;
    String rtNm = "";
    Frame errMsgFrm = new Frame();
    LoginRecord loginRec = new LoginRecord("Anonymous");
    WPFileRecs wpfr;
    GPSInterface gpsIF;
    ShowPositions showWPPos;
    Hashtable gpsRtes;
    Hashtable gpsuRtes;
    Hashtable nmeaRtes;
    Hashtable cmapRtes;
    Hashtable nbltecRtes;
    Hashtable nbltecTrks;
    final String ConvFlagKey = "*Converted*";
    Positions filePos;
    Positions gpsWpts;
    Positions aRtePos;
    Positions trackLog;
    Positions workPos;
    final String WorkTitle = "Waypoint 'Work' window. Use 'CopyToWork' to add waypoints.";
    Vector openWindows = new Vector();
    ShowPositionWindow activeWindow = null;
    final Color FILE_WPTS_COLOR = new Color(180, 230, 255);
    final Color GPS_WPTS_COLOR = new Color(255, 255, 255);
    final Color GPS_RTE_COLOR = new Color(0, 235, 50);
    final String FILE_WPTS_ICON = "FileWptsIcon.jpg";
    final String GPS_WPTS_ICON = "GPSWptsIcon.jpg";
    final String GPS_RTE_ICON = "GPSRteIcon.jpg";
    String wpFileDir = "";
    String wpFileName = "";
    final String GPSU_Ext = ".GPSU";
    final String GPSU_FieldRec = "F";
    final String GPSU_WP_Rec = "W";
    final String GPSU_Rte_Rec = "R";
    final String NMEA_Ext = ".NMEA";
    final String NMEA_WP_Prefix = "$";
    final int NMEA_WP_Sent_ID_disp = 3;
    final String NMEA_WP_Sent_ID = "WPL";
    final String NMEA_Rte_Prefix = "$GPRTE";
    static final byte CkSumChar = 42;
    static final String SepCharS = ",";
    final int MaxWPPerRoute = 50;
    final String CMAP_Ext = ".DAT";
    final String Nobeltec_Ext = ".NTEC";
    MenuItem displayRte3MI = new MenuItem("Display Route...");
    MenuItem displayTrkMI = new MenuItem("Display Track...");
    MenuItem findTrkMI = new MenuItem("Find Track...");
    MenuItem clearFndRtesMI = new MenuItem("Clear found tracks");
    Hashtable fndRtes;
    Vector GPSWriteableListeners = new Vector();
    final String CMAP_FileHdr = "ROUTES PLANNING";
    final String CMAP_SectionHdr = "{";
    final String CMAP_SectionTrlr = "}";
    final String CMAP_RouteCount = "#RT=";
    final String CMAP_RouteName = "#NM=";
    final String CMAP_WPCount = "#WP=";
    final String CMAP_WP_Prefix = "x";

    private void usage() {
        System.out.println("Usage: java WayPointApps.GPSDevices.GPSCommunicator  [-Debug] [-MsgsOnLog] [-WrtCons] [-JVIEW] [?] [<wpfile>] [-AllowMultOpen]");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        System.exit(0);
    }

    public GPSDeviceCommunicator(String[] args) {
        super(Welcome);
        FontMetrics fm;
        int i = 0;
        while (i < args.length) {
            if (this.debug) {
                System.out.println("Next arg: " + args[i]);
            }
            if (args[i].equalsIgnoreCase("-Debug")) {
                this.debug = true;
            } else if (args[i].equalsIgnoreCase("-Test")) {
                this.Testing = true;
                System.out.println("Testing flag set");
            } else if (!args[i].endsWith("XX")) {
                if (args[i].equalsIgnoreCase("-JVIEW")) {
                    this.usingJVIEW = true;
                } else if (args[i].equalsIgnoreCase("-MsgsOnLog")) {
                    this.showMsgsOnLog = true;
                } else if (args[i].equalsIgnoreCase("-WrtCons")) {
                    this.writeCons = true;
                } else if (args[i].equals("-AllowMultOpen")) {
                    this.allowMultOpen = true;
                } else if (args[i].equals("?") || args[i].equalsIgnoreCase("-help")) {
                    this.usage();
                } else {
                    String wpFn = args[i];
                    if (wpFn.indexOf("~") > 0) {
                        wpFn = MSDosFilename.getExtendedName(wpFn);
                    }
                    if (wpFn.toLowerCase().endsWith(".wps") || wpFn.toUpperCase().endsWith(".NMEA") || wpFn.toUpperCase().endsWith(".GPSU") || wpFn.toUpperCase().endsWith(".DAT") || wpFn.toUpperCase().endsWith(".WPT") || wpFn.toUpperCase().endsWith(".NTEC")) {
                        int ix = wpFn.lastIndexOf(File.separator);
                        if (ix > 0) {
                            this.wpFileDir = wpFn.substring(0, ix + 1);
                            this.wpFileName = wpFn.substring(ix + 1);
                        } else {
                            this.wpFileName = wpFn;
                        }
                    } else {
                        System.err.println("Unknown program arg: " + args[i]);
                        this.usage();
                    }
                }
            }
            ++i;
        }
        if (this.writeCons) {
            try {
                SaveStdOutput.start("GPSDeviceCommunicator.log");
                System.out.println("**** Console log being written to GPSDeviceCommunicator.log **** " + new Date());
                Properties props = System.getProperties();
                System.out.println("Current directory: " + props.getProperty("user.dir") + ",  java.class.path: " + props.getProperty("java.class.path"));
            }
            catch (Exception ex) {
                System.err.println("Error starting Console log " + ex);
            }
        }
        this.ourProps = new Properties();
        try {
            FileInputStream sf = new FileInputStream("GPSDeviceCommunicator.ini");
            this.ourProps.load(sf);
        }
        catch (FileNotFoundException fnf) {
            this.createPropFile = true;
            System.err.println("Property file NOT found: GPSDeviceCommunicator.ini It will be created on Exit.");
        }
        catch (Exception ex) {
            System.err.println("Error getting properties " + ex);
        }
        this.gpsBrand = this.ourProps.getProperty("GPSBrand", this.gpsBrand);
        this.serialPort = this.ourProps.getProperty("SerialPort", this.serialPort);
        this.allowUpLoad = this.ourProps.getProperty("AllowUpLoad", this.allowUpLoad);
        this.baudRate = this.ourProps.getProperty("BaudRate", this.baudRate);
        this.owner = this.ourProps.getProperty("Owner", this.owner);
        this.showMsgsOnLogV = this.ourProps.getProperty("ShowMsgsOnLog", this.showMsgsOnLogV);
        this.timeOutMSV = this.ourProps.getProperty("TimeOutMS", this.timeOutMSV);
        this.wpDirV = this.ourProps.getProperty("WaypointsDir", this.wpDirV);
        try {
            this.timeOutms = Integer.parseInt(this.timeOutMSV);
            if (this.timeOutms < 1000) {
                System.out.println("Timeout value less than 1 second! " + this.timeOutms);
            }
        }
        catch (Exception ex) {
            System.out.println("Invalid timeoutMS value; " + this.timeOutMSV);
            this.timeOutMSV = "" + this.timeOutms;
        }
        if (this.showMsgsOnLogV.equalsIgnoreCase("YES")) {
            this.showMsgsOnLog = true;
        }
        if (this.wpDirV != null && !this.wpDirV.equals("") && this.wpFileDir.equals("")) {
            this.wpFileDir = this.wpDirV;
        }
        if (this.debug) {
            this.setDebug(this.debug);
        }
        WayPointDefs.GPS_Type = this.gpsBrand;
        this.appendLogNL("GPS is " + this.gpsBrand + " at serial port " + this.serialPort + " at baud rate: " + this.baudRate);
        System.out.println("'.ini' settings: " + this.ourProps);
        if (this.allowMultOpen) {
            System.out.println("Allowing multiple opens");
        }
        if ((fm = this.getFontMetrics(new Font("monspaced", 1, 12))).toString().indexOf("com.ms.awt.") >= 0) {
            this.usingJVIEW = true;
            System.out.println("Using JView.exe program");
        }
        this.gpsIF = GPSDeviceFactory.getDeviceIF(this.gpsBrand);
        this.gpsIF.setDebug(this.debug);
        this.gpsIF.setOwner(this.owner);
        this.gpsIF.setTimeOut(this.timeOutms);
        this.gpsIF.setInterface(this);
        this.loginRec.setLoggedIn(true);
        this.fileM.add(this.newMI);
        this.newMI.addActionListener(this);
        this.fileM.add(this.openMI);
        this.openMI.addActionListener(this);
        this.fileM.add(this.crtWorkMI);
        this.crtWorkMI.addActionListener(this);
        this.fileM.add(this.selectActWindMI);
        this.selectActWindMI.setEnabled(false);
        this.selectActWindMI.addActionListener(this);
        this.fileM.add(this.saveAsMI);
        this.saveAsMI.setEnabled(false);
        this.saveAsMI.addActionListener(this);
        this.fileM.addSeparator();
        this.fileM.add(this.editNotesMI);
        this.editNotesMI.addActionListener(this);
        this.fileM.addSeparator();
        this.fileM.add(this.exitMI);
        this.exitMI.addActionListener(this);
        this.mb.add(this.fileM);
        this.gpsM.add(this.openGPSMI);
        this.openGPSMI.addActionListener(this);
        this.gpsM.add(this.displayNMEAMI);
        this.displayNMEAMI.addActionListener(this);
        this.gpsM.addSeparator();
        this.gpsM.add(this.downLoadWptsMI);
        this.downLoadWptsMI.setEnabled(false);
        this.downLoadWptsMI.addActionListener(this);
        this.gpsM.add(this.displayWptsMI);
        this.displayWptsMI.setEnabled(false);
        this.displayWptsMI.addActionListener(this);
        this.gpsM.add(this.downLoadRteMI);
        this.downLoadRteMI.setEnabled(false);
        this.downLoadRteMI.addActionListener(this);
        this.gpsM.add(this.displayRteMI);
        this.displayRteMI.setEnabled(false);
        this.displayRteMI.addActionListener(this);
        this.gpsM.add(this.readTrackMI);
        this.readTrackMI.setEnabled(false);
        this.readTrackMI.addActionListener(this);
        if (this.allowUpLoad.equalsIgnoreCase("YES")) {
            this.gpsM.addSeparator();
            this.gpsM.add(this.upLoadWptsMI);
            this.upLoadWptsMI.setEnabled(false);
            this.upLoadWptsMI.addActionListener(this);
            this.gpsM.add(this.upLoadRteMI);
            if (!this.Testing) {
                this.upLoadRteMI.setEnabled(false);
            }
            this.upLoadRteMI.addActionListener(this);
            this.gpsM.add(this.writeTrackMI);
            this.writeTrackMI.setEnabled(false);
            this.writeTrackMI.addActionListener(this);
        }
        this.gpsM.addSeparator();
        this.gpsM.add(this.abortXferMI);
        this.abortXferMI.addActionListener(this);
        this.abortXferMI.setEnabled(false);
        this.gpsM.add(this.closeGPSMI);
        this.closeGPSMI.addActionListener(this);
        this.closeGPSMI.setEnabled(false);
        this.mb.add(this.gpsM);
        this.optionsM.add(this.autoCrMI);
        this.autoCrMI.addItemListener(this);
        if (this.allowUpLoad.equalsIgnoreCase("YES")) {
            this.optionsM.add(this.allowWriteMI);
            this.allowWriteMI.addItemListener(this);
        }
        this.optionsM.addSeparator();
        this.optionsM.add(this.setTypeMI);
        this.setTypeMI.addActionListener(this);
        this.mb.add(this.optionsM);
        this.setCOMMMI.addActionListener(this);
        this.optionsM.add(this.setCOMMMI);
        this.setBaudMI.addActionListener(this);
        this.optionsM.add(this.setBaudMI);
        this.setTimeoutMI.addActionListener(this);
        this.optionsM.add(this.setTimeoutMI);
        this.optionsM.addSeparator();
        this.optionsM.add(this.clearLogMI);
        this.clearLogMI.addActionListener(this);
        this.optionsM.add(this.savePropsMI);
        this.allowMultOpenCB.addItemListener(this);
        this.allowMultOpenCB.setState(this.allowMultOpen);
        this.optionsM.add(this.allowMultOpenCB);
        if (this.debug) {
            this.optionsM.add(this.debugMI);
            this.debugMI.setState(true);
            this.debugMI.addActionListener(this);
            this.debugMI.addItemListener(this);
        }
        if (this.writeCons) {
            this.optionsM.add(this.setSaveConsMI);
            this.setSaveConsMI.addItemListener(this);
            this.setSaveConsMI.addActionListener(this);
            this.setSaveConsMI.setState(true);
        }
        if (this.Testing) {
            this.optionsM.addSeparator();
            this.optionsM.add(this.convertMI);
            this.convertMI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    Positions wkPos = GPSDeviceCommunicator.this.activeWindow.getPositions();
                    int i = 0;
                    while (i < wkPos.size()) {
                        Position p = wkPos.get(i);
                        p.setRoute(p.getName());
                        ++i;
                    }
                }
            });
        }
        this.routesM.add(this.displayRte2MI);
        this.displayRte2MI.addActionListener(this);
        this.displayRte3MI.addActionListener(this);
        this.displayTrkMI.addActionListener(this);
        this.findTrkMI.addActionListener(this);
        this.clearFndRtesMI.addActionListener(this);
        this.helpM.add(this.aboutMI);
        this.aboutMI.addActionListener(this);
        this.helpM.add(this.helpMI);
        this.helpMI.addActionListener(this);
        this.mb.setHelpMenu(this.helpM);
        this.deviceM = this.gpsIF.addMenu();
        if (this.deviceM != null) {
            this.mb.add(this.deviceM);
        }
        this.setMenuBar(this.mb);
        this.setLayout(new BorderLayout());
        Panel p1 = new Panel();
        p1.add(new Label("Status log:"));
        this.add((Component)p1, "North");
        this.theLog.setEditable(false);
        this.add((Component)this.theLog, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                GPSDeviceCommunicator.this.exitProgram();
            }
        });
        this.setSize(650, 400);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((ss.width - this.getBounds().width) / 2, (ss.height - this.getBounds().height) / 2);
        this.show();
        this.appendLogNL("Write to GPS is " + (this.allowWriteMI.getState() ? "enabled." : "disabled.") + "  Use Options|Allow Write switch to " + (this.allowWriteMI.getState() ? "disable." : "enable."));
        this.appendLogNL("Ready ..." + (this.debug ? " >>Debug output ON<<" : ""));
        if (!this.wpFileName.equals("")) {
            this.readWPSFile();
        }
    }

    public void finalize() {
        System.out.println("finalize() called");
    }

    private void exitProgram() {
        ChoiceOfYesOrNo cyn;
        if (this.doingUpLoad && (cyn = new ChoiceOfYesOrNo((Frame)this, "Write to GPS in progress. Do you want to let it finish?")).isYes()) {
            return;
        }
        this.dispose();
        this.saveProps();
        if (this.gpsIF != null && this.closeGPSMI.isEnabled()) {
            this.gpsIF.abortTransfer();
            this.gpsIF.closeGPS();
        }
        if (this.setSaveConsMI.isEnabled()) {
            SaveStdOutput.stop();
        }
        System.exit(0);
    }

    void setDebug(boolean b) {
        this.debug = b;
        if (this.gpsIF != null) {
            this.gpsIF.setDebug(b);
        }
        WayPointDefs.debug = b;
        WayPointDefs.plot_debug = b;
    }

    void saveProps() {
        if (!this.createPropFile && !this.savePropsMI.getState()) {
            return;
        }
        this.ourProps.put("GPSBrand", this.gpsBrand);
        this.ourProps.put("SerialPort", this.serialPort);
        this.ourProps.put("AllowUpLoad", this.allowUpLoad);
        this.ourProps.put("BaudRate", this.baudRate);
        this.ourProps.put("Owner", this.owner);
        this.ourProps.put("ShowMsgsOnLog", this.showMsgsOnLogV);
        this.ourProps.put("TimeOutMS", this.timeOutMSV);
        if (!this.wpFileDir.equals("")) {
            this.ourProps.put("WaypointsDir", this.wpFileDir);
        }
        try {
            FileOutputStream sf = new FileOutputStream("GPSDeviceCommunicator.ini");
            this.ourProps.store(sf, "GPS Device Communicator parms:");
        }
        catch (Exception ex) {
            System.err.println("Error saving props in GPSDeviceCommunicator.ini \n" + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.openMI) {
            if (this.filePos != null && this.ckWptsFileOpen(this.filePos)) {
                return;
            }
            if (this.usingJVIEW) {
                GetInput gi = new GetInput((Frame)this, "Enter waypoints filename to read", "Read file");
                this.wpFileName = gi.getResponse();
            } else {
                FileDialog fd = new FileDialog((Frame)this, "Choose a Waypoints file to open", 0);
                fd.setFile("*.wps;*.GPSU;*.NMEA;*.DAT;*.NTEC;*.WPT");
                fd.setDirectory(this.wpFileDir);
                fd.show();
                fd.setVisible(false);
                fd.dispose();
                this.wpFileDir = fd.getDirectory();
                this.wpFileName = fd.getFile();
            }
            if (this.wpFileName == null || this.wpFileName.equals("")) {
                return;
            }
            new RunGPSJob(){

                public void run() {
                    GPSDeviceCommunicator.this.readWPSFile();
                }
            };
            return;
        }
        if (src == this.newMI) {
            if (this.filePos != null && this.ckWptsFileOpen(this.filePos)) {
                return;
            }
            this.wpfr = this.createWptsFile();
            if (this.wpfr == null) {
                return;
            }
            try {
                this.filePos = new Positions(this.wpfr);
            }
            catch (Exception ex) {
                new ErrDialog((Frame)this, "Error creating new: " + ex.getMessage());
                return;
            }
            GPSDeviceCommunicator ex = this;
            synchronized (ex) {
                ShowPositions showPos = new ShowPositions(this.loginRec, this, true);
                showPos.allowDescUpdate(true);
                showPos.setColor(this.FILE_WPTS_COLOR);
                showPos.setIcon(this.getImage("FileWptsIcon.jpg"));
                String title = this.filePos.description;
                if (title.equals("")) {
                    title = "No description given for this file";
                }
                showPos.showList("New file: " + title, this.filePos);
                showPos.setSaveButton(true);
                this.addOpenWindow(showPos, this.filePos, this.wpfr);
            }
            this.saveAsMI.setEnabled(true);
            return;
        }
        if (src == this.crtWorkMI) {
            if (WayPointDefs.workSP != null) {
                ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(WayPointDefs.workSP.getFrame(), "Do you want to replace current Work display?");
                if (!cyn.isYes()) {
                    return;
                }
                WayPointDefs.workSP.closeFrame();
                this.removeWindow(WayPointDefs.workSP);
            }
            WayPointDefs.workSP = new ShowPositions(this.loginRec, this, true);
            this.wpfr = new WPFileRecs();
            try {
                this.workPos = new Positions(this.wpfr);
            }
            catch (Exception ex) {
                new ErrDialog((Frame)this, "Error creating work: " + ex.getMessage());
                return;
            }
            this.workPos.description = "Select and copy waypoints from other lists to this one using the CopyToWork button.";
            WayPointDefs.workSP.allowDescUpdate(true);
            WayPointDefs.workSP.showList("Waypoint 'Work' window. Use 'CopyToWork' to add waypoints.", this.workPos);
            this.addOpenWindow(WayPointDefs.workSP, this.workPos, this.wpfr);
            this.saveAsMI.setEnabled(true);
            return;
        }
        if (src == this.selectActWindMI) {
            ShowListBox slb = new ShowListBox("Select active window", this.openWindows.elements(), 4, (Frame)this);
            String windNm = slb.getSelection();
            if (windNm.equals("")) {
                return;
            }
            int i = 0;
            while (i < this.openWindows.size()) {
                if (windNm.equals(this.openWindows.elementAt(i).toString())) {
                    this.activeWindow = (ShowPositionWindow)this.openWindows.elementAt(i);
                    this.activeWindow.toFront();
                    return;
                }
                ++i;
            }
            System.err.println(">!>!>!>!> Window name: '" + windNm + "' not found!");
            return;
        }
        if (src == this.saveAsMI) {
            if (!this.setSaveAsFilename(this.activeWindow.getPositions(), this)) {
                return;
            }
            this.activeWindow.getShowPositions().setSaveButton(true);
            this.activeWindow.toFront();
            new ShowMsgBox("Warning - Waypoints NOT saved yet", "Need to press 'SAVE' button now to save in file", this.errMsgFrm, false);
            return;
        }
        if (src == this.editNotesMI) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"Notepad", "ReminderNotes.txt"});
                return;
            }
            catch (Exception ex) {}
            return;
        }
        if (src == this.exitMI) {
            this.exitProgram();
            return;
        }
        if (src == this.openGPSMI) {
            try {
                this.theLog.append("Opening: ");
                this.gpsIF.openGPS(this, "COM" + this.serialPort, this.baudRate);
                this.theLog.append(this.gpsBrand + " GPS at serial port COM" + this.serialPort + ", opened OK\n");
                String str1 = this.gpsIF.getProductData();
                if (str1.length() > 2) {
                    this.theLog.append(str1 + "\n");
                }
                this.downLoadWptsMI.setEnabled(true);
                this.downLoadRteMI.setEnabled(true);
                this.readTrackMI.setEnabled(true);
                this.closeGPSMI.setEnabled(true);
                this.abortXferMI.setEnabled(true);
                this.openGPSMI.setEnabled(false);
                this.displayNMEAMI.setEnabled(false);
                return;
            }
            catch (Exception ex) {
                this.theLog.append("Error opening the GPS connection. Check and retry\n");
                System.err.println("openGPS() returned ex: " + ex);
                this.gpsIF.closeGPS();
            }
            return;
        }
        if (src == this.displayNMEAMI) {
            if (this.debug) {
                this.appendLogNL("Entering NMEA code");
            }
            try {
                try {
                    final DisplayNMEA dn = new DisplayNMEA("COM" + this.serialPort, this.baudRate);
                    dn.setDebug(this.debug);
                    new RunGPSJob(){

                        public void run() {
                            GPSDeviceCommunicator.this.saveGPSMI();
                            try {
                                while (dn.displaying) {
                                    String rec = dn.getNextRecord();
                                    try {
                                        Thread.sleep(30L);
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    if (rec == null) continue;
                                    dn.displayRecord(rec);
                                }
                            }
                            catch (Exception ex) {
                                System.err.println("Error in displayRecord: " + ex.getMessage());
                            }
                            dn.closeGPS();
                            GPSDeviceCommunicator.this.restoreGPSMI();
                        }
                    };
                }
                catch (SerialCommException sce) {
                    this.appendLogNL(sce.getMessage());
                    Object var8_48 = null;
                    if (!this.debug) return;
                    this.appendLogNL("Back from NMEA code");
                    return;
                }
                catch (Exception ex) {
                    this.appendLogNL(ex.getMessage());
                    ex.printStackTrace();
                    Object var8_49 = null;
                    if (!this.debug) return;
                    this.appendLogNL("Back from NMEA code");
                    return;
                }
                Object var8_47 = null;
                if (!this.debug) return;
                this.appendLogNL("Back from NMEA code");
                return;
            }
            catch (Throwable throwable) {
                Object var8_50 = null;
                if (!this.debug) throw throwable;
                this.appendLogNL("Back from NMEA code");
                throw throwable;
            }
        }
        if (src == this.downLoadWptsMI) {
            new RunGPSJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    GPSDeviceCommunicator.this.saveGPSMI();
                    try {
                        GPSDeviceCommunicator.this.theLog.append("Reading waypoints from GPS...\n");
                        GPSDeviceCommunicator.this.gpsWpts = GPSDeviceCommunicator.this.gpsIF.downLoadWpts(GPSDeviceCommunicator.this);
                        GPSDeviceCommunicator.this.gpsWpts.writeableToGPS = false;
                    }
                    catch (Exception ex) {
                        System.err.println("DownLoadWpts returned ex: " + ex);
                        ex.printStackTrace();
                    }
                    GPSDeviceCommunicator.this.restoreGPSMI();
                    if (GPSDeviceCommunicator.this.gpsWpts == null || GPSDeviceCommunicator.this.gpsWpts.size() == 0) {
                        GPSDeviceCommunicator.this.appendLogNL("No waypoints returned from GPS?");
                        return;
                    }
                    GPSDeviceCommunicator.this.appendLogNL("Read " + GPSDeviceCommunicator.this.gpsWpts.size() + " waypoints from GPS");
                    GPSDeviceCommunicator gPSDeviceCommunicator = GPSDeviceCommunicator.this;
                    synchronized (gPSDeviceCommunicator) {
                        GPSDeviceCommunicator.this.showWPPos = new ShowPositions(GPSDeviceCommunicator.this.loginRec, GPSDeviceCommunicator.this, true);
                        GPSDeviceCommunicator.this.showWPPos.setColor(GPSDeviceCommunicator.this.GPS_WPTS_COLOR);
                        GPSDeviceCommunicator.this.showWPPos.setIcon(GPSDeviceCommunicator.this.getImage("GPSWptsIcon.jpg"));
                        GPSDeviceCommunicator.this.showWPPos.showList(GPSDeviceCommunicator.this.gpsWpts.description, GPSDeviceCommunicator.this.gpsWpts);
                        GPSDeviceCommunicator.this.showWPPos.setSaveButton(true);
                        GPSDeviceCommunicator.this.showWPPos.setLock(true);
                        GPSDeviceCommunicator.this.showWPPos.setReasonForLock("\nUsed to check before writing to GPS");
                        GPSDeviceCommunicator.this.addOpenWindow(GPSDeviceCommunicator.this.showWPPos, GPSDeviceCommunicator.this.gpsWpts, new WPFileRecs());
                    }
                    GPSDeviceCommunicator.this.upLoadWptsMI.setEnabled(true);
                    GPSDeviceCommunicator.this.enableGPSWriteable(1, true);
                    GPSDeviceCommunicator.this.displayWptsMI.setEnabled(true);
                    GPSDeviceCommunicator.this.saveAsMI.setEnabled(true);
                }
            };
            return;
        }
        if (src == this.displayWptsMI) {
            if (this.showWPPos != null) {
                this.showWPPos.toFront();
                return;
            }
            GPSDeviceCommunicator sce = this;
            synchronized (sce) {
                this.showWPPos = new ShowPositions(this.loginRec, this, true);
                this.showWPPos.setColor(this.GPS_WPTS_COLOR);
                this.showWPPos.setIcon(this.getImage("GPSWptsIcon.jpg"));
                this.showWPPos.showList(this.gpsWpts.description, this.gpsWpts);
                this.showWPPos.setSaveButton(true);
                return;
            }
        }
        if (src == this.downLoadRteMI) {
            new RunGPSJob(){

                public void run() {
                    GPSDeviceCommunicator.this.saveGPSMI();
                    GPSDeviceCommunicator.this.theLog.append("Reading routes ...\n");
                    try {
                        GPSDeviceCommunicator.this.gpsRtes = GPSDeviceCommunicator.this.gpsIF.downLoadRtes(GPSDeviceCommunicator.this);
                        GPSDeviceCommunicator.this.appendLogNL("Read " + (GPSDeviceCommunicator.this.gpsRtes == null ? "0" : "" + GPSDeviceCommunicator.this.gpsRtes.size()) + " routes. " + (GPSDeviceCommunicator.this.gpsRtes == null ? "" : "Use GPS|Display Routes... to display one."));
                        GPSDeviceCommunicator.this.restoreGPSMI();
                        if (GPSDeviceCommunicator.this.gpsRtes != null) {
                            GPSDeviceCommunicator.this.upLoadRteMI.setEnabled(true);
                            GPSDeviceCommunicator.this.displayRteMI.setEnabled(true);
                            GPSDeviceCommunicator.this.enableGPSWriteable(2, true);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("DownLoadRtes returned ex: " + ex);
                        GPSDeviceCommunicator.this.theLog.append("Error reading the routes\n");
                        GPSDeviceCommunicator.this.restoreGPSMI();
                    }
                }
            };
            return;
        }
        if (src == this.displayRteMI) {
            if (this.gpsRtes == null || this.gpsRtes.isEmpty()) {
                String msg = "No GPS routes found to display. Read Routes from GPS.";
                if (this.showMsgsOnLog) {
                    this.appendLogNL(msg);
                    return;
                } else {
                    new ShowMsgBox("GPS Routes status", msg, this.errMsgFrm, false);
                }
                return;
            }
            this.showRoute(this.gpsRtes);
            return;
        }
        if (src == this.displayRte2MI) {
            if (this.gpsuRtes == null && this.nmeaRtes == null && this.cmapRtes == null || this.filePos == null) {
                String msg = "No routes found to display. You must read a file.";
                if (this.showMsgsOnLog) {
                    this.appendLogNL(msg);
                    return;
                } else {
                    new ShowMsgBox("Routes status", msg, this.errMsgFrm, false);
                }
                return;
            }
            Hashtable htRtes = this.gpsuRtes;
            if (htRtes == null) {
                htRtes = this.nmeaRtes;
            }
            if (htRtes == null) {
                htRtes = this.cmapRtes;
            }
            if (htRtes.get("*Converted*") != null) {
                htRtes.remove("*Converted*");
                Enumeration en = htRtes.keys();
                while (en.hasMoreElements()) {
                    Positions pos = (Positions)htRtes.get(en.nextElement());
                    int i = 0;
                    while (i < pos.size()) {
                        String wpName = (String)pos.elementAt(i);
                        Position p = this.filePos.getPosition(wpName);
                        if (p == null) {
                            System.err.println("No position found for >" + wpName + "<");
                        } else {
                            pos.set((Position)p.clone(), i);
                        }
                        ++i;
                    }
                }
            }
            this.showRoute(htRtes);
            return;
        }
        if (src == this.displayRte3MI) {
            this.showRoute(this.nbltecRtes);
            return;
        }
        if (src == this.displayTrkMI) {
            this.showRoute(this.nbltecTrks);
            return;
        }
        if (src == this.findTrkMI) {
            if (this.fndRtes == null) {
                this.fndRtes = this.findTracks(this.nbltecTrks);
                return;
            } else {
                this.showRoute(this.fndRtes);
            }
            return;
        }
        if (src == this.clearFndRtesMI) {
            this.fndRtes = null;
            return;
        }
        if (src == this.readTrackMI) {
            new RunGPSJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    GPSDeviceCommunicator.this.saveGPSMI();
                    try {
                        GPSDeviceCommunicator.this.theLog.append("Reading track log ...\n");
                        GPSDeviceCommunicator.this.trackLog = GPSDeviceCommunicator.this.gpsIF.readTrackLog(GPSDeviceCommunicator.this);
                        GPSDeviceCommunicator.this.trackLog.writeableToGPS = false;
                    }
                    catch (Exception ex) {
                        System.err.println("readTrackLog() returned ex: " + ex);
                    }
                    GPSDeviceCommunicator.this.restoreGPSMI();
                    if (GPSDeviceCommunicator.this.trackLog == null) {
                        return;
                    }
                    GPSDeviceCommunicator.this.theLog.append("Read " + GPSDeviceCommunicator.this.trackLog.size() + " waypoints from GPS\n");
                    GPSDeviceCommunicator gPSDeviceCommunicator = GPSDeviceCommunicator.this;
                    synchronized (gPSDeviceCommunicator) {
                        ShowPositions showPos = new ShowPositions(GPSDeviceCommunicator.this.loginRec, GPSDeviceCommunicator.this, true);
                        showPos.setColor(GPSDeviceCommunicator.this.GPS_WPTS_COLOR);
                        showPos.setIcon(GPSDeviceCommunicator.this.getImage("GPSWptsIcon.jpg"));
                        showPos.showList(GPSDeviceCommunicator.this.trackLog.description, GPSDeviceCommunicator.this.trackLog);
                        showPos.setSaveButton(true);
                        GPSDeviceCommunicator.this.writeTrackMI.setEnabled(true);
                        GPSDeviceCommunicator.this.addOpenWindow(showPos, GPSDeviceCommunicator.this.trackLog, new WPFileRecs());
                    }
                }
            };
            return;
        }
        if (src == this.upLoadWptsMI) {
            if (this.gpsWpts == null && !this.Testing) {
                new ErrDialog((Frame)this, "Must read GPS waypoints (to allow checks) before writing.");
                return;
            }
            Positions wkPos = this.activeWindow.getPositions();
            if (!wkPos.writeableToGPS) {
                new ErrDialog((Frame)this, "Select waypoints to write using\n'File|Select Active window...'.");
                return;
            }
            this.writeWayPoints(wkPos);
            return;
        }
        if (src == this.upLoadRteMI) {
            if (this.gpsRtes == null && !this.Testing) {
                new ErrDialog((Frame)this, "Must read GPS routes (to allow checks) before writing.");
                return;
            }
            if (this.gpsWpts == null && !this.Testing) {
                new ErrDialog((Frame)this, "Must read GPS waypoints (to allow checks) before writing.");
                return;
            }
            Positions wkPos = this.activeWindow.getPositions();
            if (wkPos == null) {
                new ErrDialog((Frame)this, "No waypoints found loaded to write.\nOpen a waypoints file and retry.");
                return;
            }
            this.writeARoute(wkPos);
            return;
        }
        if (src == this.writeTrackMI) {
            final Positions wkPos = this.activeWindow.getPositions();
            if (wkPos == null) {
                new ErrDialog((Frame)this, "No waypoints found loaded for write.\nOpen a waypoints file and retry.");
                return;
            }
            if (this.allowWriteMI.getState()) {
                this.writeTrackMI.setEnabled(false);
                new RunGPSJob(){

                    public void run() {
                        GPSDeviceCommunicator.this.saveGPSMI();
                        GPSDeviceCommunicator.this.doingUpLoad = true;
                        try {
                            GPSDeviceCommunicator.this.appendLogNL("Starting write of " + wkPos.size() + " waypoints to tracklog");
                            GPSDeviceCommunicator.this.gpsIF.setTimeOut(GPSDeviceCommunicator.this.timeOutms * 4);
                            GPSDeviceCommunicator.this.gpsIF.writeTrackLog(GPSDeviceCommunicator.this, wkPos);
                            GPSDeviceCommunicator.this.gpsIF.setTimeOut(GPSDeviceCommunicator.this.timeOutms);
                            GPSDeviceCommunicator.this.appendLogNL("Write of tracklog completed");
                        }
                        catch (Exception ex) {
                            System.err.println("upLoadWpts returned ex: " + ex);
                            GPSDeviceCommunicator.this.theLog.append("Error writing tracklog - Check valid data\n");
                        }
                        GPSDeviceCommunicator.this.restoreGPSMI();
                        GPSDeviceCommunicator.this.doingUpLoad = false;
                    }
                };
                return;
            } else {
                String msg = "Write to GPS is disabled.  Use Options|Allow Write to enable.";
                if (this.showMsgsOnLog) {
                    this.appendLogNL(msg);
                    return;
                } else {
                    new ShowMsgBox("Write not enabled", msg, this, true);
                }
            }
            return;
        }
        if (src == this.closeGPSMI) {
            try {
                this.gpsIF.closeGPS();
                this.appendLogNL("serial port closed");
                this.openGPSMI.setEnabled(true);
                this.downLoadWptsMI.setEnabled(false);
                this.downLoadRteMI.setEnabled(false);
                this.readTrackMI.setEnabled(false);
                this.writeTrackMI.setEnabled(false);
                this.upLoadWptsMI.setEnabled(false);
                this.upLoadRteMI.setEnabled(false);
                this.enableGPSWriteable(3, false);
                this.closeGPSMI.setEnabled(false);
                this.displayNMEAMI.setEnabled(true);
                return;
            }
            catch (Exception ex) {
                System.err.println("closeGPS returned: " + ex);
            }
            return;
        }
        if (src == this.abortXferMI) {
            ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo((Frame)this, "Are you sure you want to Abort the transfer?");
            if (!cyn.isYes()) {
                return;
            }
            if (this.gpsIF == null) return;
            this.gpsIF.abortTransfer();
            this.appendLogNL("*** Transfer aborted ***");
            return;
        }
        if (src == this.setTypeMI) {
            if (!this.openGPSMI.isEnabled()) {
                new ErrDialog((Frame)this, "GPS is currently open. Close and try again.");
                return;
            }
            String[] gpsNms = GPSDeviceFactory.getSupportedGPSs();
            ShowListBox slb = new ShowListBox("Select GPS brand", gpsNms, 4, (Frame)this);
            String gpsNm = slb.getSelection();
            if (gpsNm.equals("")) {
                return;
            }
            this.gpsIF = GPSDeviceFactory.getDeviceIF(gpsNm);
            if (this.gpsIF == null) {
                System.err.println("No GPS interface found for " + gpsNm);
                return;
            }
            this.gpsIF.setDebug(this.debug);
            this.gpsIF.setOwner(this.owner);
            this.gpsIF.setTimeOut(this.timeOutms);
            this.gpsIF.setInterface(this);
            this.gpsBrand = gpsNm;
            WayPointDefs.GPS_Type = gpsNm;
            this.appendLogNL("GPS device changed to " + gpsNm);
            if (this.deviceM != null) {
                this.mb.remove(this.deviceM);
            }
            this.deviceM = this.gpsIF.addMenu();
            if (this.deviceM == null) return;
            this.mb.add(this.deviceM);
            return;
        }
        if (src == this.setCOMMMI) {
            if (!this.openGPSMI.isEnabled()) {
                new ErrDialog((Frame)this, "GPS is currently open. Close and try again.");
                return;
            }
            ShowListBox slb = new ShowListBox("Select comm port", this.SerialPorts, 4, (Frame)this);
            String cPort = slb.getSelection();
            if (cPort.equals("")) {
                return;
            }
            this.appendLogNL("Serial Port changed from: " + this.serialPort + " to " + cPort);
            this.serialPort = cPort;
            return;
        }
        if (src == this.setBaudMI) {
            if (!this.openGPSMI.isEnabled()) {
                new ErrDialog((Frame)this, "GPS is currently open. Close and try again.");
                return;
            }
            ShowListBox slb = new ShowListBox("Select baud rate", this.BaudRates, 4, (Frame)this);
            String bdRt = slb.getSelection();
            if (bdRt.equals("")) {
                return;
            }
            this.appendLogNL("Baud rate changed from " + this.baudRate + " to " + bdRt);
            this.baudRate = bdRt;
            return;
        }
        if (src == this.setTimeoutMI) {
            GetInput gi = new GetInput("Enter timeout value in ms", (Frame)this, "Set Timeout", "" + this.timeOutms);
            String TOV = gi.getResponse();
            if (TOV.equals("")) {
                return;
            }
            try {
                int tovI = Integer.parseInt(TOV);
                if (tovI < 1000) {
                    new ErrDialog((Frame)this, "Timeout value less than 1 second! " + tovI);
                    return;
                }
                this.appendLogNL("Timeout value changed from " + this.timeOutms + " to " + tovI);
                this.timeOutms = tovI;
                this.timeOutMSV = TOV;
                return;
            }
            catch (Exception ex) {
                System.out.println("Invalid timeoutMS value; " + TOV);
            }
            return;
        }
        if (src == this.clearLogMI) {
            this.theLog.setText("");
            return;
        } else if (src == this.aboutMI) {
            new ShowMsgBox("About GPSCommunicator", "Norm's GPS Communicator  Version 1.15  23 May 2004\n written by Norm Radder\n Email:  radder@hotmail.com", this, true);
            return;
        } else if (src == this.helpMI) {
            try {
                new ShowDocument(this.helpFN);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                new ShowMsgBox("Error message", "Error getting help file: " + this.helpFN + "\n" + ex.getMessage(), this, true);
            }
            return;
        } else {
            System.out.println("aP.. unknown object: " + src);
        }
    }

    public boolean setSaveAsFilename(Positions poss, Frame aFrm) {
        String newFN = "";
        String newDir = "";
        CheckboxGroup cbg = new CheckboxGroup();
        Checkbox wpsExt = new Checkbox("Norm's waypoints (.wps)", true, cbg);
        Checkbox wptExt = new Checkbox("MaxSea          (.wpt)", false, cbg);
        Checkbox nmeaExt = new Checkbox("NMEA            (.NMEA)", false, cbg);
        Checkbox ntecRtExt = new Checkbox("Nobeltec route (.NTEC)", false, cbg);
        Checkbox ntecTLExt = new Checkbox("Nobeltec track (.NTEC)", false, cbg);
        Checkbox[] ckboxes = new Checkbox[]{wpsExt, wptExt, nmeaExt, ntecRtExt, ntecTLExt};
        ShowOptions so = new ShowOptions(aFrm, ckboxes, "Select output file data type");
        if (so.cancelled()) {
            return false;
        }
        String showFN = this.wpFileName;
        if (showFN == null || showFN.equals("")) {
            showFN = "*";
        } else {
            int ix = showFN.lastIndexOf(".");
            if (ix > 0 && showFN.length() - ix <= 5) {
                showFN = showFN.substring(0, ix);
            }
        }
        if (wpsExt.getState()) {
            showFN = showFN + ".wps";
        } else if (nmeaExt.getState()) {
            showFN = showFN + ".NMEA";
        } else if (wptExt.getState()) {
            showFN = showFN + ".WPT";
        } else if (ntecRtExt.getState()) {
            showFN = showFN + ".NTEC";
            Nobeltec.type = "RT";
        } else if (ntecTLExt.getState()) {
            showFN = showFN + ".NTEC";
            Nobeltec.type = "TR";
        } else {
            System.err.println("ERROR unknown file type?");
            return false;
        }
        if (this.usingJVIEW) {
            newDir = this.wpFileDir;
            GetInput gi = new GetInput((Frame)this, "Enter new waypoints filename (xxx.wps)");
            newFN = gi.getResponse();
        } else {
            FileDialog fd = new FileDialog(aFrm, "Enter new Waypoints filename for " + this.activeWindow.getTitle(), 1);
            fd.setDirectory(this.wpFileDir);
            fd.setFile(showFN);
            fd.show();
            fd.setVisible(false);
            fd.dispose();
            newDir = fd.getDirectory();
            newFN = fd.getFile();
        }
        if (newFN == null || newFN.equals("")) {
            return false;
        }
        if (newFN.toUpperCase().endsWith(".NMEA")) {
            new ShowMsgBox("Warning for NMEA files", "NMEA files do not contain GPS names, etc", this.errMsgFrm, false);
        }
        poss.fileName = newDir + newFN;
        return true;
    }

    public void writeWayPoints(final Positions wkPos) {
        boolean res = true;
        try {
            res = this.gpsIF.checkWpts(wkPos, this);
        }
        catch (InvalidDataException ide) {
            new ErrDialog((Frame)this, "Error: " + ide.getMessage());
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Frame f = this.getFrame(wkPos);
        ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(f == null ? this : f, (res ? " No errors found. \n" : "Errors found. See log>>>\n") + " Do you want to Write these " + wkPos.size() + " waypoints?");
        if (!cyn.isYes()) {
            return;
        }
        if (this.allowWriteMI.getState()) {
            new RunGPSJob(){

                public void run() {
                    GPSDeviceCommunicator.this.saveGPSMI();
                    GPSDeviceCommunicator.this.doingUpLoad = true;
                    try {
                        GPSDeviceCommunicator.this.appendLogNL("Starting write of " + wkPos.size() + " waypoints...");
                        GPSDeviceCommunicator.this.gpsIF.upLoadWpts(GPSDeviceCommunicator.this, wkPos);
                        GPSDeviceCommunicator.this.appendLogNL("Write of waypoints completed");
                    }
                    catch (Exception ex) {
                        System.err.println("upLoadWpts returned ex: " + ex);
                        GPSDeviceCommunicator.this.theLog.append("Error writing the Waypoints\n");
                    }
                    GPSDeviceCommunicator.this.restoreGPSMI();
                    GPSDeviceCommunicator.this.doingUpLoad = false;
                }
            };
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {}
        } else {
            String msg = "Write to GPS is disabled.  Use Options|Allow Write to enable.";
            if (this.showMsgsOnLog) {
                this.appendLogNL(msg);
            } else {
                new ShowMsgBox("Write not enabled", msg, this, true);
            }
        }
    }

    public void writeARoute(final Positions wkPos) {
        this.rtNm = this.gpsIF.getARouteNm(this);
        if (this.rtNm.equals("")) {
            return;
        }
        if (this.gpsIF.getMaxWPperRoute() < wkPos.size()) {
            new ErrDialog((Frame)this, "Current route has too many waypoints: " + wkPos.size() + " vs max of " + this.gpsIF.getMaxWPperRoute());
            return;
        }
        this.appendLogNL("Starting check of route " + this.rtNm + " waypoints...");
        boolean res = true;
        try {
            res = this.gpsIF.checkRoute(this.rtNm, wkPos, this);
        }
        catch (InvalidDataException ide) {
            new ErrDialog((Frame)this, "Error: " + ide.getMessage());
            return;
        }
        catch (Exception ex) {
            this.appendLogNL("Error in checkRoute() " + ex.getMessage());
            ex.printStackTrace();
            return;
        }
        Frame f = this.getFrame(wkPos);
        ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(f == null ? this : f, (res ? " No errors found. \n" : "Errors found. See log>>>\n") + " Do you want to Write route " + this.rtNm + "?");
        if (!cyn.isYes()) {
            return;
        }
        if (this.allowWriteMI.getState()) {
            new RunGPSJob(){

                public void run() {
                    GPSDeviceCommunicator.this.doingUpLoad = true;
                    GPSDeviceCommunicator.this.saveGPSMI();
                    try {
                        GPSDeviceCommunicator.this.appendLogNL("Starting write of route " + GPSDeviceCommunicator.this.rtNm + " ...");
                        GPSDeviceCommunicator.this.gpsIF.upLoadRte(GPSDeviceCommunicator.this, wkPos, GPSDeviceCommunicator.this.rtNm);
                        GPSDeviceCommunicator.this.appendLogNL("End of write of route " + GPSDeviceCommunicator.this.rtNm + ".");
                    }
                    catch (Exception ex) {
                        System.err.println("upLoadRte returned ex: " + ex);
                        GPSDeviceCommunicator.this.theLog.append("Error writing route " + GPSDeviceCommunicator.this.rtNm + "\n");
                    }
                    GPSDeviceCommunicator.this.restoreGPSMI();
                    GPSDeviceCommunicator.this.doingUpLoad = false;
                }
            };
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {}
        } else {
            String msg = "Write to GPS is disabled.  Use Options|Allow Write to enable.";
            if (this.showMsgsOnLog) {
                this.appendLogNL(msg);
            } else {
                new ShowMsgBox("Write not enabled", msg, this, true);
            }
        }
    }

    public void addGPSWriteableListener(ShowPositions sp) {
        this.GPSWriteableListeners.add(sp);
        int sel = (this.upLoadWptsMI.isEnabled() ? 1 : 0) + (this.upLoadRteMI.isEnabled() ? 2 : 0);
        this.enableGPSWriteable(sel, true);
    }

    public void removeGPSWriteableListener(ShowPositions sp) {
        this.GPSWriteableListeners.remove(sp);
    }

    private void enableGPSWriteable(int select, boolean b) {
        int i = 0;
        while (i < this.GPSWriteableListeners.size()) {
            ((ShowPositions)this.GPSWriteableListeners.elementAt(i)).setGPSWriteable(select, b);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showRoute(Hashtable rtes) {
        Object obj;
        String rtNm = null;
        Enumeration en = rtes.keys();
        if (rtes.size() > 1) {
            int size = Math.min(rtes.size(), 25);
            ShowListBox slb = new ShowListBox("Select route to display", en, size, (Frame)this);
            rtNm = slb.getSelection();
            if (rtNm.equals("")) {
                return;
            }
        } else {
            rtNm = (String)en.nextElement();
        }
        if (this.aRtePos != null) {
            Frame f = this.getFrame(this.aRtePos);
            f.dispose();
            this.removeWindow(this.aRtePos);
        }
        if ((obj = rtes.get(rtNm)) instanceof WPFileRecs) {
            try {
                this.aRtePos = new Positions((WPFileRecs)obj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        } else {
            this.aRtePos = (Positions)((Positions)rtes.get(rtNm)).clone();
        }
        if (this.aRtePos == null) {
            System.err.println("No position found for route '" + rtNm + "'");
            return;
        }
        GPSDeviceCommunicator gPSDeviceCommunicator = this;
        synchronized (gPSDeviceCommunicator) {
            ShowPositions showPos = new ShowPositions(this.loginRec, this, true);
            showPos.allowDescUpdate(true);
            showPos.setColor(this.GPS_RTE_COLOR);
            showPos.setIcon(this.getImage("GPSRteIcon.jpg"));
            showPos.showList("Route " + rtNm + ": " + this.aRtePos.description, this.aRtePos);
            showPos.setSaveButton(true);
            this.addOpenWindow(showPos, this.aRtePos, new WPFileRecs());
        }
    }

    private Hashtable findTracks(Hashtable rtes) {
        SearchFor sf = new SearchFor(new NobeltecEval(rtes), rtes, this.nbrBest);
        if (sf.cancelled()) {
            return null;
        }
        Object[] rtNms = sf.getValues();
        if (rtNms == null) {
            new ShowMsgBox("Search results:", "No matching Tracks found.", this.errMsgFrm, false);
            return null;
        }
        Hashtable sfRtes = new Hashtable();
        int i = 0;
        while (i < rtNms.length) {
            Object trks = rtes.get((String)rtNms[i]);
            sfRtes.put(rtNms[i], trks);
            ++i;
        }
        this.showRoute(sfRtes);
        return sfRtes;
    }

    private Image getImage(String ifn) {
        Image img = this.getToolkit().getImage(ifn);
        if (img == null) {
            System.err.println("getImage() null image for " + ifn);
            return null;
        }
        if (this.debug) {
            System.out.println("getImage() got image: " + img);
        }
        return img;
    }

    private boolean ckWptsFileOpen(Positions ps) {
        if (ps != null && !this.allowMultOpen) {
            this.toFront(ps);
            ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(this.errMsgFrm, "Do you want to replace current WayPoint display?");
            if (!cyn.isYes()) {
                return true;
            }
            Frame pf = this.getFrame(ps);
            if (pf != null) {
                pf.dispose();
                pf.setVisible(false);
            }
            this.removeWindow(ps);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWPSFile() {
        this.wpfr = this.getWptsFmFile(this.wpFileDir + this.wpFileName);
        try {
            this.filePos = new Positions(this.wpfr);
            Position.resetParseMode();
        }
        catch (Exception ex) {
            new ErrDialog((Frame)this, "Error reading waypoints from file: " + ex.getMessage());
            ex.printStackTrace();
        }
        if (this.autoCrMI.getState()) {
            if (this.debug) {
                System.out.println(">>> NOTE: opening file and assigning GPSNames.");
            }
            this.createGPSNames(this.filePos);
        }
        GPSDeviceCommunicator gPSDeviceCommunicator = this;
        synchronized (gPSDeviceCommunicator) {
            ShowPositions showPos = new ShowPositions(this.loginRec, this, true);
            showPos.allowDescUpdate(true);
            showPos.setChanged(false);
            showPos.setColor(this.FILE_WPTS_COLOR);
            showPos.setIcon(this.getImage("FileWptsIcon.jpg"));
            String title = this.filePos.description;
            if (title.equals("")) {
                title = "No description given for this file";
            }
            showPos.showList(title, this.filePos);
            this.addOpenWindow(showPos, this.filePos, this.wpfr);
        }
        this.ckWptsUploadable(this.filePos);
        this.saveAsMI.setEnabled(true);
        this.displayRte2MI.setEnabled(true);
        this.displayMI.setEnabled(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void itemStateChanged(ItemEvent ie) {
        Object src = ie.getSource();
        if (src == this.autoCrMI) {
            if (this.activeWindow == null) {
                return;
            }
            Positions wkPos = this.activeWindow.getPositions();
            ShowPositions showPos = this.activeWindow.getShowPositions();
            if (this.autoCrMI.getState() && wkPos != null) {
                this.createGPSNames(wkPos);
                String title = this.wpfr.description;
                if (title.equals("")) {
                    title = "No description given for this file";
                }
                showPos.showList(title, wkPos);
                showPos.setSaveButton(true);
                showPos.setChanged(true);
                return;
            } else {
                if (!this.autoCrMI.getState() || this.workPos == null) return;
                this.createGPSNames(this.workPos);
                showPos.showList("Waypoint 'Work' window. Use 'CopyToWork' to add waypoints.", this.workPos);
            }
            return;
        } else if (src == this.allowWriteMI) {
            this.appendLogNL("Write to GPS now " + (this.allowWriteMI.getState() ? "enabled." : "disabled."));
            return;
        } else if (src == this.debugMI) {
            this.setDebug(this.debugMI.getState());
            this.appendLogNL("Debug tracing turned " + (this.debugMI.getState() ? "ON" : "OFF"));
            return;
        } else if (src == this.setSaveConsMI) {
            if (this.setSaveConsMI.getState()) {
                try {
                    System.out.println("Starting write of console to log file.");
                    SaveStdOutput.start("GPSDeviceCommunicator.log");
                    return;
                }
                catch (Exception ex) {}
                return;
            } else {
                System.out.println("Stoping write of console to log file.");
                SaveStdOutput.stop();
            }
            return;
        } else if (src == this.allowMultOpenCB) {
            this.allowMultOpen = this.allowMultOpenCB.getState();
            return;
        } else {
            System.out.println("iSC.. unknown object: " + src);
        }
    }

    private void saveGPSMI() {
        int i = 0;
        while (i < this.savedGPSMI.length) {
            this.savedGPSMI[i] = this.gpsJobs[i].isEnabled();
            this.gpsJobs[i].setEnabled(false);
            ++i;
        }
    }

    private void restoreGPSMI() {
        int i = 0;
        while (i < this.savedGPSMI.length) {
            this.gpsJobs[i].setEnabled(this.savedGPSMI[i]);
            ++i;
        }
    }

    private boolean ckWptsUploadable(Positions posx) {
        if (posx == null) {
            System.err.println("ckWptsUploadable() called with null Positions");
            return false;
        }
        if (posx.size() == 0) {
            return false;
        }
        boolean fndEOL = false;
        boolean mtGPSName = false;
        boolean dupFound = false;
        class SavePositions {
            Position pos;
            int lineNbr;
            private final /* synthetic */ GPSDeviceCommunicator this$0;

            SavePositions(GPSDeviceCommunicator this$0, Position p, int ln) {
                this.this$0 = this$0;
                this.pos = p;
                this.lineNbr = ln;
            }
        }
        Hashtable<String, SavePositions> usedNms = new Hashtable<String, SavePositions>(posx.size());
        int i = 0;
        while (i < posx.size()) {
            Position pos = posx.get(i);
            if (pos.isEndOfLeg()) {
                fndEOL = true;
            } else if (!pos.hasGPSName()) {
                mtGPSName = true;
            } else {
                String gpsNm = pos.getGPSName();
                if (usedNms.containsKey(gpsNm)) {
                    SavePositions sp = (SavePositions)usedNms.get(gpsNm);
                    if (!pos.samePosition(sp.pos) || pos.getIdxNbr() != sp.pos.getIdxNbr() || !pos.getGPSName().equals(sp.pos.getGPSName())) {
                        dupFound = true;
                        this.appendLogNL(">>> You have a duplicate name: " + gpsNm + " at " + (i + 1) + ". Matches line " + (((SavePositions)usedNms.get((Object)gpsNm)).lineNbr + 1));
                    }
                } else {
                    usedNms.put(gpsNm, new SavePositions(this, pos, i));
                }
            }
            ++i;
        }
        if (fndEOL || mtGPSName || dupFound) {
            this.upLoadWptsMI.setEnabled(false);
            this.enableGPSWriteable(1, false);
            String msg = "Waypoint file " + posx.fileName + " not writeable to GPS." + (fndEOL ? "\n Contains End of Leg record." : "") + (mtGPSName ? "\n Not all GPS names set." : "") + (dupFound ? "\n Duplicate names found. See log >>>" : "");
            if (this.showMsgsOnLog) {
                this.appendLogNL(msg);
            } else {
                new ShowMsgBox("Waypoint file status", msg, this.errMsgFrm, false);
            }
            return false;
        }
        boolean cond = this.gpsWpts != null && this.gpsWpts.size() > 0 || this.Testing;
        this.upLoadWptsMI.setEnabled(cond);
        this.enableGPSWriteable(1, cond);
        return true;
    }

    public void appendLogNL(String s) {
        this.theLog.append(s + "\n");
    }

    private void createGPSNames(Positions pss) {
        if (this.debug) {
            System.out.println("createGPSNames() for " + pss.size() + " waypoints.");
        }
        Hashtable<String, MutableInteger> ht = new Hashtable<String, MutableInteger>();
        int i = 0;
        while (i < pss.size()) {
            Position pos = pss.get(i);
            if (pos.hasGPSName()) {
                String gnm = pos.getGPSName();
                if (Character.isDigit(gnm.charAt(gnm.length() - 1))) {
                    int x = Integer.parseInt(gnm.substring(gnm.length() - 1));
                    ht.put(gnm, new MutableInteger(i));
                } else {
                    ht.put(gnm, new MutableInteger(0));
                }
            } else {
                String newNm = this.gpsIF.buildGPSName(pos.getName()).trim();
                if (ht.containsKey(newNm)) {
                    if (this.debug) {
                        System.out.println("Got duplicate GPSName: " + newNm);
                    }
                    MutableInteger mi = (MutableInteger)ht.get(newNm);
                    int x = mi.bumpValue();
                    newNm = newNm.substring(0, newNm.length() - 1) + x;
                } else {
                    ht.put(newNm, new MutableInteger(0));
                }
                pos.setGPSName(newNm);
            }
            ++i;
        }
    }

    WPFileRecs createWptsFile() {
        WPFileRecs lines = new WPFileRecs();
        if (this.usingJVIEW) {
            GetInput gi = new GetInput((Frame)this, "Enter new Waypoints filename", "Create file");
            if (gi.getResponse().equals("")) {
                return null;
            }
            this.wpFileName = gi.getResponse();
        } else {
            ChoiceOfYesOrNo cyn;
            FileDialog fd = new FileDialog((Frame)this, "Enter new Waypoints filename", 1);
            fd.setFile("*.wps");
            fd.setDirectory(this.wpFileDir);
            fd.show();
            fd.setVisible(false);
            fd.dispose();
            String newFN = fd.getFile();
            if (newFN == null || newFN.equals("")) {
                return null;
            }
            if (!newFN.endsWith(".wps") && !(cyn = new ChoiceOfYesOrNo((Frame)this, "New filename without standard extension of .wps.\nDo you want to use it?")).isYes()) {
                return null;
            }
            this.wpFileName = newFN;
            this.wpFileDir = fd.getDirectory();
        }
        lines.filename = this.wpFileDir + this.wpFileName;
        lines.isNew = true;
        if (this.debug) {
            System.out.println("new filename is >" + this.wpFileName + "<");
        }
        this.setFileOwner(lines);
        return lines;
    }

    /*
     * WARNING - void declaration
     */
    WPFileRecs getWptsFmFile(String fn) {
        WPFileRecs lines = new WPFileRecs();
        lines.filename = fn;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fn));
            this.mb.remove(this.routesM);
            this.nbltecTrks = null;
            this.nbltecRtes = null;
            this.cmapRtes = null;
            this.nmeaRtes = null;
            this.gpsuRtes = null;
            if (fn.toUpperCase().endsWith(".GPSU")) {
                this.readGPSUFile(in, lines);
                int ix = fn.lastIndexOf(File.separator);
                lines.description = ix < 1 ? fn : fn.substring(ix + 1);
                this.gpsM = new Menu("GPSU");
                this.routesM.add(this.displayRte2MI);
                this.mb.add(this.routesM);
            } else if (fn.toUpperCase().endsWith(".NMEA")) {
                this.readNMEAFile(in, lines);
                int ix = fn.lastIndexOf(File.separator);
                int iy = fn.lastIndexOf(".");
                if (iy < 0) {
                    iy = fn.length() - 1;
                }
                String string = lines.description = ix < 1 ? fn.substring(0, iy) : fn.substring(ix + 1, iy);
                if (this.nmeaRtes != null && this.nmeaRtes.size() > 0) {
                    this.routesM = new Menu("NMEA");
                    this.routesM.add(this.displayRte2MI);
                    this.mb.add(this.routesM);
                }
            } else if (fn.toUpperCase().endsWith(".DAT")) {
                lines.setPositionFactory(new CMAPPositionFactory());
                this.readCMAPFile(in, lines);
                int ix = fn.lastIndexOf(File.separator);
                lines.description = "Waypoints read from " + (ix < 1 ? fn : fn.substring(ix + 1));
                if (this.cmapRtes != null && this.cmapRtes.size() > 0) {
                    this.routesM = new Menu("CMAP");
                    this.routesM.add(this.displayRte2MI);
                    this.mb.add(this.routesM);
                }
            } else if (fn.toUpperCase().endsWith(".WPT")) {
                lines.setPositionFactory(new MaxSeaPositionFactory());
                MaxSea.readMaxSea(fn, lines);
            } else if (fn.toUpperCase().endsWith(".NTEC")) {
                lines.setPositionFactory(new NobeltecPositionFactory());
                int ix = fn.lastIndexOf(File.separator);
                lines.description = "Waypoints read from " + (ix < 1 ? fn : fn.substring(ix + 1));
                this.nbltecTrks = null;
                this.nbltecRtes = null;
                Nobeltec.readNobeltec(in, lines);
                this.nbltecRtes = Nobeltec.nbltecRtes;
                this.nbltecTrks = Nobeltec.nbltecTrks;
                if (this.nbltecRtes != null && this.nbltecRtes.size() > 0 || this.nbltecTrks != null && this.nbltecTrks.size() > 0) {
                    this.routesM = new Menu("Nobeltec");
                    if (this.nbltecRtes != null) {
                        this.routesM.add(this.displayRte3MI);
                    }
                    if (this.nbltecTrks != null) {
                        this.routesM.add(this.displayTrkMI);
                        this.routesM.add(this.findTrkMI);
                        this.routesM.add(this.clearFndRtesMI);
                    }
                    this.mb.add(this.routesM);
                }
            } else {
                String inputLine;
                in = new BufferedReader(new FileReader(fn));
                while ((inputLine = in.readLine()) != null) {
                    void ix;
                    if (this.debug) {
                        System.out.println("getWptsFmFile(): input >" + (String)ix + "<");
                    }
                    if (ix.startsWith("#")) {
                        if (ix.startsWith("# Owner=")) {
                            lines.owner = ix.substring("# Owner=".length());
                            continue;
                        }
                        if (!ix.startsWith("# Description=")) continue;
                        lines.description = ix.substring("# Description=".length());
                        continue;
                    }
                    if (ix.trim().equals("End Of Leg")) {
                        lines.addElement(WayPointDefs.END_LEG_REC);
                        continue;
                    }
                    if (ix.trim().length() > 15) {
                        lines.addElement(ix);
                        continue;
                    }
                    if (!this.debug) continue;
                    System.out.println("getFile() skipping record >" + (String)ix + "<");
                }
                in.close();
            }
        }
        catch (IOException ioe) {
            new ErrDialog((Frame)this, "There was an IO Error getting the file: " + fn + " from disk.");
            System.err.println("IO Error getting " + fn + "\n" + ioe);
            lines.isNew = true;
        }
        catch (Exception ex) {
            System.err.println("getFile Ex " + ex);
            ex.printStackTrace();
            lines.isNew = true;
        }
        this.appendLogNL("Read " + lines.size() + " records from " + fn);
        if (this.gpsuRtes != null) {
            this.appendLogNL("Read " + (this.gpsuRtes.size() - 1) + " routes.");
        }
        if (this.nmeaRtes != null) {
            this.appendLogNL("Read " + (this.nmeaRtes.size() - 1) + " routes.");
        }
        if (this.cmapRtes != null) {
            this.appendLogNL("Read " + (this.cmapRtes.size() - 1) + " routes.");
        }
        this.setFileOwner(lines);
        return lines;
    }

    /*
     * WARNING - void declaration
     */
    private void readNMEAFile(BufferedReader in, WPFileRecs lines) throws IOException {
        int ix;
        String inputLine;
        while ((inputLine = in.readLine()) != null) {
            void var3_3;
            if (this.debug) {
                System.out.println("readNMEAFile(): input >" + (String)var3_3 + "<");
            }
            if (!var3_3.startsWith("$") || var3_3.indexOf("WPL") != 3) break;
            ix = var3_3.indexOf(42);
            if (ix > 0) {
                inputLine = var3_3.substring(0, ix);
            }
            lines.addElement(inputLine);
        }
        this.nmeaRtes = new Hashtable();
        this.nmeaRtes.put("*Converted*", "*Converted*");
        while (inputLine != null) {
            if (inputLine.startsWith("$GPRTE")) {
                StringTokenizer st;
                if (this.debug || WayPointDefs.debug) {
                    System.out.println("Route rec: " + inputLine);
                }
                if ((st = new StringTokenizer((ix = inputLine.indexOf(42)) > 0 ? inputLine.substring(0, ix) : inputLine, SepCharS)).countTokens() < 6) {
                    System.err.println("too few tokens on route record:" + inputLine);
                    continue;
                }
                String tok = st.nextToken();
                tok = st.nextToken();
                tok = st.nextToken();
                tok = st.nextToken();
                if (!tok.equalsIgnoreCase("c")) {
                    System.err.println("unknown flag on route record:" + inputLine);
                    continue;
                }
                String rtNbr = st.nextToken();
                Positions rtWps = (Positions)this.nmeaRtes.get(rtNbr);
                if (rtWps == null) {
                    rtWps = new Positions(50);
                    rtWps.description = this.rtNm;
                    rtWps.fileName = "NMEARoute" + rtNbr + ".wps";
                    rtWps.owner = this.owner;
                }
                while (st.hasMoreTokens()) {
                    tok = st.nextToken();
                    rtWps.addElement(tok);
                }
                this.nmeaRtes.put(rtNbr, rtWps);
            }
            inputLine = in.readLine();
        }
        if (this.debug) {
            System.out.println("NMEA Routes " + this.nmeaRtes);
        }
        in.close();
    }

    /*
     * WARNING - void declaration
     */
    private void readCMAPFile(BufferedReader in, WPFileRecs lines) throws IOException {
        String inputLine;
        int nbrRtes = 0;
        int nbrWPs = 0;
        int wpNbr = 1;
        int rteNbr = 0;
        String rtName = "";
        this.cmapRtes = new Hashtable();
        this.cmapRtes.put("*Converted*", "*Converted*");
        Positions rtWps = null;
        while ((inputLine = in.readLine()) != null) {
            void var9_9;
            if (this.debug) {
                System.out.println("readCMAPFile(): input >" + (String)var9_9 + "<");
            }
            if ((inputLine = var9_9.trim()).startsWith("ROUTES PLANNING") || inputLine.equals("{") || inputLine.equals("}")) continue;
            if (inputLine.startsWith("#RT=")) {
                nbrRtes = Integer.parseInt(inputLine.substring("#RT=".length()));
                continue;
            }
            if (inputLine.startsWith("#NM=")) {
                if (rtWps != null) {
                    this.cmapRtes.put(rtName, rtWps);
                }
                rtName = inputLine.substring("#NM=".length());
                rtWps = new Positions(50);
                rtWps.description = rtName;
                rtWps.fileName = "CMAPRoute_" + rtName + ".wps";
                rtWps.owner = this.owner;
                ++rteNbr;
                wpNbr = 1;
                continue;
            }
            if (inputLine.startsWith("#WP=")) {
                nbrWPs = Integer.parseInt(inputLine.substring("#WP=".length()));
                continue;
            }
            if (!inputLine.startsWith("x")) continue;
            int ix = inputLine.indexOf("|#");
            if (ix < 6) {
                System.err.println("Invalid CMAP waypoint record: " + inputLine);
                continue;
            }
            int iy = inputLine.indexOf("|", ix + 1);
            String wpNm = "";
            if (iy - ix == 2) {
                wpNm = "WP_" + rteNbr + "_" + wpNbr;
                inputLine = inputLine.substring(0, ix + 2) + wpNm + inputLine.substring(iy);
            } else {
                wpNm = inputLine.substring(ix + 2, iy);
            }
            ++wpNbr;
            lines.addElement(inputLine);
            rtWps.addElement(wpNm);
        }
        if (rtWps != null) {
            this.cmapRtes.put(rtName, rtWps);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readGPSUFile(BufferedReader in, WPFileRecs lines) throws IOException {
        String inputLine;
        boolean fndFRec = false;
        while ((inputLine = in.readLine()) != null) {
            void var3_4;
            if (this.debug) {
                System.out.println("readGPSUFile(): input >" + (String)var3_4 + "<");
            }
            if (!fndFRec) {
                if (!var3_4.startsWith("F")) continue;
                fndFRec = true;
                Position.parseGPSU_F_Rec((String)var3_4);
                continue;
            }
            if (!var3_4.startsWith("W")) break;
            lines.addElement(var3_4);
        }
        this.gpsuRtes = new Hashtable();
        this.gpsuRtes.put("*Converted*", "*Converted*");
        while (inputLine != null) {
            if (inputLine.startsWith("R")) {
                StringTokenizer st = new StringTokenizer(inputLine, " ,");
                st.nextToken();
                String rtNbr = st.nextToken();
                String rtNm = st.nextToken();
                while (st.hasMoreTokens()) {
                    rtNm = rtNm + " " + st.nextToken();
                }
                inputLine = in.readLine();
                if (inputLine.startsWith("F")) {
                    inputLine = in.readLine();
                }
                Positions wpNames = null;
                try {
                    wpNames = new Positions(new WPFileRecs());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                wpNames.description = rtNm;
                wpNames.fileName = this.wpFileDir + "GPSU_Route" + rtNbr + ".wps";
                wpNames.owner = this.owner;
                while (inputLine != null) {
                    if (inputLine.trim().equals("")) break;
                    if (inputLine.startsWith("W")) {
                        st = new StringTokenizer(inputLine, " ,");
                        st.nextToken();
                        String wpn = st.nextToken();
                        wpNames.addElement(wpn);
                    }
                    inputLine = in.readLine();
                }
                this.gpsuRtes.put(rtNbr, wpNames);
                if (this.debug) {
                    System.out.println("GPSU rte: " + rtNbr + " has " + wpNames);
                }
            }
            inputLine = in.readLine();
        }
        in.close();
    }

    private void setFileOwner(WPFileRecs lines) {
        GetInput gi;
        if (this.owner.equals("")) {
            if (lines.owner.equals("")) {
                gi = new GetInput("Please enter owner name for this file", (Frame)this, 20, "Set owner");
                lines.owner = gi.getResponse();
            }
        } else {
            lines.owner = this.owner;
        }
        if (lines.description.equals("")) {
            gi = new GetInput("Please enter a description for this file", (Frame)this, 20, "Set description");
            lines.description = gi.getResponse();
        }
    }

    private void addOpenWindow(ShowPositions sp, Positions ps, WPFileRecs wpfr) {
        ShowPositionWindow spw;
        this.activeWindow = spw = new ShowPositionWindow(sp, ps, wpfr);
        this.openWindows.addElement(spw);
        this.enableSelectWindow();
    }

    private void enableSelectWindow() {
        this.selectActWindMI.setEnabled(this.openWindows.size() > 1);
    }

    private Positions getActiveWindow() {
        return this.activeWindow.getPositions();
    }

    private void removeWindow(ShowPositions sp) {
        int i = 0;
        while (i < this.openWindows.size()) {
            if (((ShowPositionWindow)this.openWindows.elementAt(i)).thisOne(sp)) {
                this.removeWindowElement(i);
                return;
            }
            ++i;
        }
        System.out.println("removeWindow: didn't find ShowPositions: " + sp.getFrame().getTitle());
    }

    private void removeWindow(Positions px) {
        int i = 0;
        while (i < this.openWindows.size()) {
            if (((ShowPositionWindow)this.openWindows.elementAt(i)).thisOne(px)) {
                this.removeWindowElement(i);
                return;
            }
            ++i;
        }
        if (px != this.gpsWpts) {
            System.out.println("removeWindow: didn't find Positions: " + px.description);
        }
    }

    private void removeWindowElement(int i) {
        boolean removedActive = this.openWindows.elementAt(i) == this.activeWindow;
        this.openWindows.removeElementAt(i);
        this.enableSelectWindow();
        if (removedActive && this.openWindows.size() > 0) {
            this.activeWindow = (ShowPositionWindow)this.openWindows.elementAt(0);
        } else if (WayPointDefs.workSP == null) {
            if (this.openWindows.size() == 0) {
                this.activeWindow = null;
                this.upLoadWptsMI.setEnabled(false);
                this.upLoadRteMI.setEnabled(false);
                this.enableGPSWriteable(3, false);
            } else {
                System.out.println("removeWindowElement(): " + this.activeWindow.getTitle() + ",  #openWins=" + this.openWindows.size());
            }
        }
    }

    private void toFront(Positions px) {
        int i = 0;
        while (i < this.openWindows.size()) {
            if (((ShowPositionWindow)this.openWindows.elementAt(i)).thisOne(px)) {
                ((ShowPositionWindow)this.openWindows.elementAt(i)).toFront();
                return;
            }
            ++i;
        }
        System.err.println("toFront(): didn't find Positions:" + px.description);
    }

    private Frame getFrame(Positions px) {
        int i = 0;
        while (i < this.openWindows.size()) {
            if (((ShowPositionWindow)this.openWindows.elementAt(i)).thisOne(px)) {
                return ((ShowPositionWindow)this.openWindows.elementAt(i)).getFrame();
            }
            ++i;
        }
        System.err.println("getFrame(): didn't find Positions:" + px.description);
        return null;
    }

    public void doUpLoad(Positions pos) {
        if (pos.fileName.toUpperCase().endsWith("WPT")) {
            MaxSea.writeFile(pos);
        } else if (pos.fileName.toUpperCase().endsWith("NTEC")) {
            Nobeltec.writeFile(pos);
        } else {
            System.err.println("doUpLoad() - wrong file extension: " + pos.fileName);
        }
    }

    public void doUpLoad(String fn, String recs) {
        if (fn.equals("")) {
            if (this.usingJVIEW) {
                GetInput gi = new GetInput((Frame)this, "Enter GPS waypoints filename");
                fn = gi.getResponse();
            } else {
                FileDialog fd = new FileDialog((Frame)this, "Enter GPS Waypoints filename", 1);
                fd.setDirectory(this.wpFileDir);
                fd.setFile(this.wpFileName.equals("") ? "GPSWaypoints.wps" : this.wpFileName);
                fd.show();
                fd.setVisible(false);
                fd.dispose();
                fn = fd.getDirectory() + fd.getFile();
            }
        }
        if (this.debug) {
            System.out.println("doUpLoad to " + fn + "\n" + recs);
        }
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(fn));
            pw.print(recs);
            pw.close();
        }
        catch (Exception ex) {
            new ErrDialog(this.errMsgFrm, "Error writing file: " + ex.getMessage());
        }
    }

    public void logMsg(String msg) {
        this.theLog.append(msg);
    }

    public void toBrowser(String fn) {
    }

    public boolean checkFileOwner(String fn, String name) {
        System.out.println("checkFileOwner: fn=" + fn + " owner=" + name);
        return true;
    }

    public String getImportedData() {
        return "";
    }

    public void clearImportedData() {
    }

    public void closingWindow(Positions px) {
        if (this.debug) {
            System.out.println("closingWindow() for " + px + "\n  cW:  filePos=" + this.filePos + "\n  cW:  openWindows=" + this.openWindows);
        }
        this.removeWindow(px);
        if (px == this.filePos) {
            this.filePos = null;
            this.displayRte2MI.setEnabled(false);
            this.mb.remove(this.routesM);
            if (WayPointDefs.workSP == null) {
                this.saveAsMI.setEnabled(false);
            }
        } else if (px == this.gpsWpts) {
            this.gpsWpts = null;
            this.showWPPos = null;
            this.displayWptsMI.setEnabled(false);
        } else if (px == this.aRtePos) {
            this.aRtePos = null;
        }
    }

    public Positions getPositions() {
        if (this.activeWindow == null) {
            return null;
        }
        return this.activeWindow.getPositions();
    }

    public static void main(String[] args) {
        GPSDeviceCommunicator gPSDeviceCommunicator = new GPSDeviceCommunicator(args);
    }

    class ShowPositionWindow {
        Positions thePos;
        ShowPositions showPosx;
        WPFileRecs wpFileRecs;

        ShowPositionWindow(ShowPositions sp, Positions p, WPFileRecs wpfr) {
            this.thePos = p;
            this.showPosx = sp;
            this.wpFileRecs = wpfr;
        }

        public Positions getPositions() {
            return this.thePos;
        }

        public ShowPositions getShowPositions() {
            return this.showPosx;
        }

        public void toFront() {
            this.showPosx.toFront();
        }

        public Frame getFrame() {
            return this.showPosx.getFrame();
        }

        public String getTitle() {
            Frame f = this.showPosx.getFrame();
            if (f != null) {
                return f.getTitle();
            }
            return "";
        }

        public String toString() {
            return this.getTitle();
        }

        public boolean thisOne(Positions p) {
            return this.thePos == p;
        }

        public boolean thisOne(ShowPositions sp) {
            return this.showPosx == sp;
        }
    }

    class RunGPSJob
    implements Runnable {
        RunGPSJob() {
            new Thread(this).start();
        }

        public void run() {
            GPSDeviceCommunicator.this.saveGPSMI();
            GPSDeviceCommunicator.this.restoreGPSMI();
        }
    }

    class MutableInteger {
        int value = 0;

        MutableInteger() {
        }

        MutableInteger(int i) {
            this.value = i;
        }

        int intValue() {
            return this.value;
        }

        int bumpValue() {
            return ++this.value;
        }
    }
}

