/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps.GPSDevices;

import NormsTools.ArrayUtil;
import SerialComm.SerialConnection;
import SerialComm.SerialConnectionException;
import SerialComm.SerialParameters;
import WayPointApps.GPSDevices.SerialCommException;
import WayPointApps.WayPointDefs;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class DisplayNMEA
extends Frame
implements ActionListener,
ItemListener {
    final int waitTime = 200;
    final int timeOutms = 2000;
    final double FeetPerMeter = 3.28084;
    static final byte StartChar = 36;
    static final byte CkSumChar = 42;
    static final byte CRChar = 13;
    static final byte LFChar = 10;
    static final String NMEAGPSRecHeader = "$";
    static final String NMEAPropHeader = "$P";
    static final String EmptyField = "N/A";
    private SerialParameters parameters = new SerialParameters();
    private SerialConnection connection;
    DecimalFormat decForm;
    public boolean displaying = true;
    MenuBar mb = new MenuBar();
    Menu optionsM = new Menu("Options");
    final String HaltDisplay = "Halt display";
    final String StartDisplay = "Start display";
    MenuItem stopMI = new MenuItem("Halt display");
    final String MagneticC = "Magnetic";
    final String TrueC = "True";
    MenuItem courseType = new MenuItem("Magnetic");
    final String FeetC = "Feet";
    final String MetersC = "Meters";
    MenuItem distanceMI = new MenuItem("Feet");
    MenuItem clearMI = new MenuItem("Clear display");
    CheckboxMenuItem debugMI = new CheckboxMenuItem("Debug");
    TextArea ta = new TextArea();
    final Color PositColor = new Color(180, 230, 255);
    Label position = new Label("Position:  Lat:");
    Label latit = new Label();
    Label longLabel = new Label("Long:");
    Label longit = new Label();
    Label altLabel = new Label("Altitude:");
    Label altDA = new Label();
    Label dateLbl = new Label("Date:");
    Label dateDA = new Label();
    Label timeLbl = new Label("Time:");
    Label timehh = new Label();
    Label timemm = new Label();
    Label timess = new Label();
    Label qualityLbl = new Label("Q:");
    Label quality = new Label();
    final int Row1Height = 15;
    Object[] row1 = new Object[]{this.position, new Rectangle(1, 1, 75, 15), this.latit, new Rectangle(3, 1, 74, 15), this.longLabel, new Rectangle(5, 1, 37, 15), this.longit, new Rectangle(0, 1, 84, 15), this.altLabel, new Rectangle(10, 1, 48, 15), this.altDA, new Rectangle(0, 1, 60, 15), this.dateLbl, new Rectangle(5, 1, 30, 15), this.dateDA, new Rectangle(0, 1, 50, 15), this.timeLbl, new Rectangle(2, 1, 35, 15), this.timehh, new Rectangle(0, 1, 16, 15), this.timemm, new Rectangle(0, 1, 16, 15), this.timess, new Rectangle(0, 1, 16, 15), this.qualityLbl, new Rectangle(5, 1, 15, 15), this.quality, new Rectangle(0, 1, 10, 15)};
    Label SpeedLbl = new Label("Ground speed:");
    Label speedDA = new Label();
    Label CourseLbl = new Label("CMG:");
    Label courseDA = new Label();
    Label MagVarLbl = new Label("Mag var:");
    Label magVarDA = new Label();
    final int Row2Y = 20;
    final int Row2Height = 15;
    Object[] row2 = new Object[]{this.SpeedLbl, new Rectangle(1, 20, 85, 15), this.speedDA, new Rectangle(0, 20, 50, 15), this.CourseLbl, new Rectangle(6, 20, 35, 15), this.courseDA, new Rectangle(0, 20, 45, 15), this.MagVarLbl, new Rectangle(5, 20, 50, 15), this.magVarDA, new Rectangle(0, 20, 40, 15)};
    Label FmLbl = new Label("Leg Fm:");
    Label fromDA = new Label();
    Label ToLbl = new Label("To:");
    Label toDA = new Label();
    Label RangeLbl = new Label("Range:");
    Label rangeDA = new Label();
    Label BearingLbl = new Label("Bearing:");
    Label bearingDA = new Label();
    Label XTELbl = new Label("xte:");
    Label xteDA = new Label();
    Label VelLbl = new Label("Vel:");
    Label velDA = new Label();
    final int Row3Y = 36;
    final int Row3Height = 15;
    Object[] row3 = new Object[]{this.FmLbl, new Rectangle(9, 36, 50, 15), this.fromDA, new Rectangle(1, 36, 55, 15), this.ToLbl, new Rectangle(1, 36, 20, 15), this.toDA, new Rectangle(1, 36, 55, 15), this.RangeLbl, new Rectangle(5, 36, 40, 15), this.rangeDA, new Rectangle(1, 36, 40, 15), this.BearingLbl, new Rectangle(1, 36, 50, 15), this.bearingDA, new Rectangle(1, 36, 50, 15), this.XTELbl, new Rectangle(5, 36, 25, 15), this.xteDA, new Rectangle(1, 36, 35, 15), this.VelLbl, new Rectangle(5, 36, 30, 15), this.velDA, new Rectangle(1, 36, 50, 15)};
    private final int PanelHt = 52;
    private int totalCnt = 0;
    private int GGACnt = 0;
    private int GLLCnt = 0;
    private int RMCCnt = 0;
    private int RMBCnt = 0;
    private double magVar = 0.0;
    private String magVarDir = "E";
    private boolean showAsMag = false;
    private boolean showAsMeters = true;
    public boolean debug = false;
    private final boolean Testing = false;
    private final String TestDataFN = "WayPointApps\\GPSDevices\\Garmin\\GPS_COM1_Communications\\Sample_Com1_input.txt";
    private boolean oneTime = false;
    private FileReader NMEA_Data;
    private BufferedReader br;
    private byte[] readBytes = new byte[4000];
    private int wrtPtr = 0;
    private int rdPtr = 0;
    final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    static char[] hexValue = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public DisplayNMEA(String portNm, String baudRt) throws Exception {
        super("Display GPS data from NMEA records");
        this.setLayout(new BorderLayout());
        Panel p1 = new Panel();
        p1.setLayout(null);
        p1.setBounds(0, 0, 600, 52);
        this.stopMI.addActionListener(this);
        this.optionsM.add(this.stopMI);
        this.clearMI.addActionListener(this);
        this.optionsM.add(this.clearMI);
        this.optionsM.addSeparator();
        this.optionsM.add(this.courseType);
        this.courseType.addActionListener(this);
        this.optionsM.add(this.distanceMI);
        this.distanceMI.addActionListener(this);
        this.optionsM.addSeparator();
        this.optionsM.add(this.debugMI);
        this.debugMI.setState(this.debug);
        this.debugMI.addActionListener(this);
        this.debugMI.addItemListener(this);
        this.mb.add(this.optionsM);
        this.setMenuBar(this.mb);
        this.placeLabels(p1, this.row1);
        this.latit.setBackground(Color.white);
        this.longit.setBackground(Color.white);
        this.altDA.setBackground(Color.white);
        this.placeLabels(p1, this.row2);
        this.placeLabels(p1, this.row3);
        p1.setBackground(this.PositColor);
        this.add((Component)p1, "North");
        this.add((Component)this.ta, "Center");
        this.ta.setEditable(false);
        this.decForm = (DecimalFormat)NumberFormat.getNumberInstance();
        this.decForm.setMaximumFractionDigits(2);
        Cursor[] crs = null;
        try {
            crs = this.setWaitCursor(this);
            this.openGPS(this, portNm, baudRt);
            Object var7_5 = null;
            this.resetCursor(this, crs);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.resetCursor(this, crs);
            throw throwable;
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                DisplayNMEA.this.displaying = false;
                DisplayNMEA.this.dispose();
            }
        });
        this.setSize(605, 300);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((ss.width - this.getBounds().width) / 2, (ss.height - this.getBounds().height) / 2);
        this.setResizable(false);
        this.show();
    }

    public void setDebug(boolean b) {
        this.debug = b;
        this.debugMI.setState(b);
    }

    private void placeLabels(Panel p, Object[] lblData) {
        int iX = 0;
        int i = 0;
        while (i < lblData.length) {
            Component c = (Component)lblData[i];
            Rectangle r = (Rectangle)lblData[i + 1];
            r.x += iX;
            iX = r.x + r.width;
            p.add(c);
            c.setBounds(r);
            i += 2;
        }
    }

    private void openGPS(Frame f, String portNm, String baudRt) throws SerialCommException {
        if (this.debug || WayPointDefs.debug) {
            System.out.println("trying to open GPS at: " + portNm + " at " + baudRt);
        }
        this.parameters.setPortName(portNm);
        this.parameters.setBaudRate(baudRt);
        this.connection = new SerialConnection(f, this.parameters);
        try {
            this.connection.openConnection();
        }
        catch (SerialConnectionException ex) {
            System.err.println("Open port error: " + ex + "\n on port: " + this.parameters.getPortName());
            this.connection.closeConnection();
            throw new SerialCommException("openGPS: open port error, " + ex);
        }
        int lpCnt = 0;
        while (lpCnt++ < 4) {
            String rec = this.getNextRecord();
            if (this.debug || WayPointDefs.debug) {
                System.out.println("openGPS recvd: >" + rec + "<");
            }
            if (rec != null && (rec.startsWith(NMEAGPSRecHeader) || rec.startsWith(NMEAPropHeader))) {
                return;
            }
            if (!this.debug && !WayPointDefs.debug) continue;
            System.out.println("Skipping record: " + rec);
        }
        this.connection.closeConnection();
        throw new SerialCommException("openGPS: Unable to find valid NMEA record");
    }

    public void displayRecord(String rec) {
        String[] flds;
        if (this.stopMI.getLabel().equals("Halt display")) {
            this.ta.append(rec + "\n");
        }
        if (this.debug) {
            System.out.println("displaying >>>>" + rec + "<<<<");
        }
        if ((flds = this.parseFields(rec)) == null) {
            return;
        }
        ++this.totalCnt;
        if (flds[0].equals("GGA")) {
            ++this.GGACnt;
            this.showLat(this.latit, flds[2], flds[3]);
            this.showLong(this.longit, flds[4], flds[5]);
            if (!flds[9].equals(EmptyField)) {
                this.altDA.setText(this.showHeight(flds[9], flds[10]));
            }
            this.showTime(flds[1]);
            this.quality.setText(flds[6]);
        } else if (flds[0].equals("GLL")) {
            ++this.GLLCnt;
            this.showLat(this.latit, flds[1], flds[2]);
            this.showLong(this.longit, flds[3], flds[4]);
            this.showTime(flds[5]);
        } else if (flds[0].equals("RMC")) {
            ++this.RMCCnt;
            this.showLat(this.latit, flds[3], flds[4]);
            this.showLong(this.longit, flds[5], flds[6]);
            this.showTime(flds[1]);
            this.showDate(flds[9]);
            this.speedDA.setText(flds[7]);
            if (!flds[10].equals(EmptyField)) {
                this.magVarDA.setText(flds[10] + flds[11]);
                this.magVar = Double.valueOf(flds[10]);
                this.magVarDir = flds[11];
                if (this.magVarDir.equals("E")) {
                    this.magVar *= -1.0;
                }
            }
            if (!flds[8].equals(EmptyField)) {
                this.courseDA.setText(this.getBearing(flds[8]));
            }
        } else if (flds[0].equals("RMB")) {
            ++this.RMBCnt;
            this.fromDA.setText(flds[4]);
            this.toDA.setText(flds[5]);
            this.rangeDA.setText(this.showDistance(flds[10]));
            if (!flds[11].equals(EmptyField)) {
                this.bearingDA.setText(this.getBearing(flds[11]));
            }
            if (!flds[2].equals(EmptyField)) {
                this.xteDA.setText(flds[2] + flds[3]);
            }
            if (flds[2].equals("9.99")) {
                this.xteDA.setBackground(Color.red);
            } else {
                this.xteDA.setBackground(this.xteDA.getParent().getBackground());
            }
            this.velDA.setText(flds[12]);
        }
    }

    private void showLat(Label field, String degmin, String NS) {
        if (degmin.equals(EmptyField)) {
            field.setText(EmptyField);
        } else {
            String deg = degmin.substring(0, 2);
            String min = degmin.substring(2);
            field.setText(deg + "\u00b0" + " " + min + "'" + NS);
        }
    }

    private void showLong(Label field, String degmin, String EW) {
        if (degmin.equals(EmptyField)) {
            field.setText(EmptyField);
        } else {
            String deg = degmin.substring(0, 3);
            String min = degmin.substring(3);
            field.setText(deg + "\u00b0" + " " + min + "'" + EW + " ");
        }
    }

    private void showTime(String hhmmss) {
        this.timehh.setText(hhmmss.substring(0, 2));
        this.timemm.setText(hhmmss.substring(2, 4));
        this.timess.setText(hhmmss.substring(4));
    }

    private void showDate(String ddmmyy) {
        if (ddmmyy.equals(EmptyField)) {
            this.dateDA.setText("");
        } else {
            String date = ddmmyy.substring(2, 4) + "/" + ddmmyy.substring(0, 2) + "/" + ddmmyy.substring(4);
            this.dateDA.setText(date);
        }
    }

    private String getBearing(String bearing) {
        if (!this.showAsMag) {
            return bearing + "T";
        }
        double degD = Double.valueOf(bearing);
        return degD + this.magVar + "M";
    }

    private String showDistance(String dist) {
        return dist;
    }

    private String showHeight(String ht, String units) {
        if (this.showAsMeters && units.equals("M")) {
            return ht + units;
        }
        double htD = Double.valueOf(ht);
        return this.decForm.format(htD * 3.28084) + "ft";
    }

    String[] parseFields(String rec) {
        if (!rec.startsWith(NMEAGPSRecHeader) || rec.length() < 10) {
            return null;
        }
        String[] flds = new String[50];
        flds[0] = rec.substring(3, 6);
        StringTokenizer st = new StringTokenizer(rec.substring(7), ",*", true);
        int ix = 1;
        while (st.hasMoreTokens()) {
            String nt = st.nextToken();
            if (nt.equals(",") || nt.equals("*")) {
                flds[ix++] = EmptyField;
            } else {
                flds[ix++] = nt;
                if (st.hasMoreTokens()) {
                    nt = st.nextToken();
                }
            }
            if (nt.equals("*")) break;
        }
        String[] rs = new String[ix];
        System.arraycopy(flds, 0, rs, 0, ix);
        if (this.debug) {
            System.out.println("Parsed record: " + rec + "/n to " + ArrayUtil.toString(rs));
        }
        return rs;
    }

    public void actionPerformed(ActionEvent ae) {
        Object obj = ae.getSource();
        if (obj == this.stopMI) {
            if (this.stopMI.getLabel().equals("Halt display")) {
                this.stopMI.setLabel("Start display");
            } else {
                this.stopMI.setLabel("Halt display");
            }
        } else if (obj == this.clearMI) {
            this.ta.setText("");
        } else if (obj == this.courseType) {
            if (this.courseType.getLabel().equals("Magnetic")) {
                this.showAsMag = true;
                this.courseType.setLabel("True");
            } else {
                this.showAsMag = false;
                this.courseType.setLabel("Magnetic");
            }
        } else if (obj == this.distanceMI) {
            if (this.distanceMI.getLabel().equals("Meters")) {
                this.showAsMeters = true;
                this.distanceMI.setLabel("Feet");
            } else {
                this.showAsMeters = false;
                this.distanceMI.setLabel("Meters");
            }
        } else {
            System.err.println("unknown AE:" + ae);
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        Object src = ie.getSource();
        if (src == this.debugMI) {
            this.debug = this.debugMI.getState();
        } else {
            System.err.println("unknown IE:" + ie);
        }
    }

    public void closeGPS() {
        this.connection.closeConnection();
    }

    int getNbrBytes() {
        return this.connection.getNbrBytes() + this.wrtPtr - this.rdPtr;
    }

    public String getNextRecord() {
        int ix = -1;
        int iy = -1;
        byte[] rec = null;
        try {
            block20: {
                if (this.rdPtr >= this.wrtPtr) {
                    int svPtr = this.wrtPtr;
                    int lpCnt = 0;
                    do {
                        this.wrtPtr = this.connection.getBytes(this.readBytes, this.wrtPtr);
                        if (svPtr < this.wrtPtr) break block20;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    } while (lpCnt++ * 200 <= 2000);
                    System.err.println("getNextRecord(): no data after " + lpCnt * 200 + "ms,  rd= " + this.rdPtr + ", svPtr=" + svPtr + ", wrtPtr=" + this.wrtPtr);
                    return null;
                }
            }
            if (this.debug) {
                System.out.println("getNxtRec() ptrs: rd=" + this.rdPtr + " wrt=" + this.wrtPtr);
                System.out.println("  readBytes: " + new String(this.readBytes, this.rdPtr, this.wrtPtr - this.rdPtr) + "\n>>" + DisplayNMEA.showBytes(this.readBytes, this.wrtPtr - this.rdPtr + 1));
            }
            boolean found = false;
            ix = this.rdPtr;
            while (ix < this.wrtPtr) {
                if (this.readBytes[ix] == 36) {
                    found = true;
                    break;
                }
                ++ix;
            }
            if (found) {
                found = false;
                iy = ix + 1;
                while (iy < this.wrtPtr) {
                    if (this.readBytes[iy] == 13 && this.readBytes[iy + 1] == 10) {
                        found = true;
                        break;
                    }
                    ++iy;
                }
                if (found) {
                    if (this.debug) {
                        System.out.println("getNxtRec(): ix= " + ix + " iy=" + iy);
                    }
                    rec = new byte[iy - ix];
                    long ckSum = 0L;
                    int i = 0;
                    while (i < rec.length) {
                        rec[i] = this.readBytes[ix + i];
                        if (rec[i] == 42) {
                            // empty if block
                        }
                        ckSum += (long)rec[i];
                        ++i;
                    }
                    this.rdPtr = iy + 2;
                    if (this.rdPtr >= this.wrtPtr) {
                        this.wrtPtr = 0;
                        this.rdPtr = 0;
                    } else {
                        try {
                            System.arraycopy(this.readBytes, this.rdPtr, this.readBytes, 0, this.wrtPtr - this.rdPtr);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.out.println("  arraycopy rd=" + this.rdPtr + ", wrt=" + this.wrtPtr + ", length=" + (this.wrtPtr - this.rdPtr));
                        }
                        this.wrtPtr -= this.rdPtr;
                        this.rdPtr = 0;
                    }
                    return new String(rec);
                }
                System.err.println("getNxtRec: no (CR|LF) found. wrt=" + this.wrtPtr);
                this.wrtPtr = this.connection.getBytes(this.readBytes, this.wrtPtr);
                return null;
            }
            System.err.println("getNxtRec: no leading $ found. wrt=" + this.wrtPtr);
            this.wrtPtr = this.connection.getBytes(this.readBytes, this.wrtPtr);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("getNxtRec() ex  wrt=" + this.wrtPtr + " rd=" + this.rdPtr + (rec == null ? " null" : " " + DisplayNMEA.showBytes(this.readBytes, this.wrtPtr - this.rdPtr + 1)) + " ix=" + ix + " iy=" + iy + "\n  ex:" + ex);
            return null;
        }
    }

    private final Cursor[] setWaitCursor(Frame f) {
        Component[] cmpts = f.getComponents();
        Cursor[] csrs = new Cursor[cmpts.length + 1];
        csrs[0] = f.getCursor();
        int i = 1;
        while (i < csrs.length) {
            csrs[i] = cmpts[i - 1].getCursor();
            cmpts[i - 1].setCursor(this.waitCursor);
            ++i;
        }
        f.setCursor(this.waitCursor);
        return csrs;
    }

    private final void resetCursor(Frame f, Cursor[] crsrs) {
        f.setCursor(crsrs[0]);
        Component[] cmpts = f.getComponents();
        int i = 1;
        while (i < crsrs.length) {
            cmpts[i - 1].setCursor(crsrs[i]);
            ++i;
        }
    }

    public static String showBytes(byte[] rec, int length) {
        if (rec == null) {
            System.out.println("showBytes called with null record");
            return "";
        }
        StringBuffer sb = new StringBuffer(length * 2 + length / 4);
        sb.setLength(length * 2 + length / 4);
        int j = 0;
        try {
            int i = 0;
            while (i < length) {
                int ix = rec[i] & 0xFF;
                sb.setCharAt(j++, hexValue[ix >> 4]);
                sb.setCharAt(j++, hexValue[ix & 0xF]);
                if (i % 4 == 3) {
                    sb.setCharAt(j++, ' ');
                }
                ++i;
            }
        }
        catch (Exception ex) {
            System.err.println("showBytes() Error " + ex + "\n j=" + j + " " + sb.length() + ",  rec.length=" + rec.length + ", length=" + length);
            ex.printStackTrace();
        }
        return sb.toString();
    }
}

