/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import NormsTools.ErrDialog;
import NormsTools.ShowMsgBox;
import WayPointApps.EditWPUpdateListener;
import WayPointApps.IndexFileRec;
import WayPointApps.LoginRecord;
import WayPointApps.WPUpdateEvent;
import WayPointApps.WayPointsInterface;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class EditWayPointIndex
extends Frame
implements ActionListener,
KeyListener {
    public static final int ADD_INDEX = 1;
    public static final int EDIT_INDEX = 2;
    private static final int IDX_INDEX = 1;
    private static final int WPS_INDEX = 2;
    static final String fldSep = ";";
    TextField aRoute;
    TextField fileName;
    Choice fileExt;
    Button bSave;
    Button bClear;
    Button bCancel;
    IndexFileRec svIdx;
    private int mode;
    EditWPUpdateListener ewpul;
    LoginRecord logInRec;
    WayPointsInterface wpI;

    public EditWayPointIndex(int n, LoginRecord loginRecord, WayPointsInterface wayPointsInterface) {
        this.mode = n;
        this.logInRec = loginRecord;
        this.wpI = wayPointsInterface;
        this.setLayout(new BorderLayout());
        if (n == 2) {
            this.setTitle("Edit Waypoint Index record");
            this.setBackground(Color.yellow);
        } else if (n == 1) {
            this.setTitle("Add new Waypoint Index record");
            this.setBackground(Color.green);
        } else {
            System.err.println("EditWPI: unknown mode: " + n);
        }
        Panel panel = new Panel();
        Label label = new Label("Route Description:");
        panel.add(label);
        this.aRoute = new TextField(40);
        panel.add(this.aRoute);
        this.add((Component)panel, "North");
        Panel panel2 = new Panel();
        Label label2 = new Label("FileName:");
        panel2.add(label2);
        this.fileName = new TextField(20);
        panel2.add(this.fileName);
        Label label3 = new Label("File type:");
        panel2.add(label3);
        this.fileExt = new Choice();
        this.fileExt.add(" ");
        this.fileExt.add("Index");
        this.fileExt.add("Waypoints");
        panel2.add(this.fileExt);
        this.add((Component)panel2, "Center");
        Panel panel3 = new Panel();
        this.bSave = new Button("Save");
        panel3.add(this.bSave);
        this.bSave.addActionListener(this);
        this.bSave.addKeyListener(this);
        this.bClear = new Button("Clear");
        panel3.add(this.bClear);
        this.bClear.addActionListener(this);
        this.bClear.addKeyListener(this);
        this.bCancel = new Button("Cancel");
        panel3.add(this.bCancel);
        this.bCancel.addActionListener(this);
        this.bCancel.addKeyListener(this);
        this.add((Component)panel3, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EditWayPointIndex.this.dispose();
                if (EditWayPointIndex.this.logInRec == null) {
                    System.exit(0);
                }
            }
        });
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2);
        this.setVisible(true);
    }

    public void setRoute(String string) {
        this.aRoute.setText(string);
    }

    public void setIndexRec(IndexFileRec indexFileRec) {
        this.svIdx = indexFileRec;
        this.aRoute.setText(indexFileRec.getDescription());
        String string = indexFileRec.getFileName().trim();
        int n = string.indexOf(".");
        if (string.endsWith(".idx")) {
            this.fileExt.select(1);
        } else if (string.endsWith(".wps")) {
            this.fileExt.select(2);
        } else if (string.endsWith(".TOP")) {
            this.fileExt.select(1);
            this.fileExt.setEnabled(false);
        } else {
            this.fileExt.select(1);
            if (n > 0) {
                System.err.println("Invalid file extension for: " + string);
            }
        }
        if (n > 0) {
            string = string.substring(0, n);
        }
        this.fileName.setText(string);
    }

    public void addEditWPUpdateListener(EditWPUpdateListener editWPUpdateListener) {
        this.ewpul = editWPUpdateListener;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            Object object = keyEvent.getSource();
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new ActionEvent(object, 1001, "Enter"));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block13: {
            Object object = actionEvent.getSource();
            try {
                if (object == this.bSave) {
                    if (this.aRoute.getText().trim().equals("") || this.aRoute.getText().startsWith("<") || this.aRoute.getText().endsWith(">")) {
                        new ErrDialog((Frame)this, "Route description missing");
                        this.aRoute.requestFocus();
                        return;
                    }
                    String string = this.fileName.getText().trim();
                    if (string.equals("")) {
                        new ErrDialog((Frame)this, "Filename missing");
                        this.fileName.requestFocus();
                        return;
                    }
                    String string2 = " /\\\"',;:!#%^&*()+|{}[]<>?.";
                    int n = 0;
                    while (n < string2.length()) {
                        if (string.indexOf(string2.charAt(n)) != -1) {
                            new ErrDialog((Frame)this, "Filename contains invalid character");
                            this.fileName.requestFocus();
                            return;
                        }
                        ++n;
                    }
                    if (string.length() < 8) {
                        new ShowMsgBox((Frame)this, "Please use at least 8 characters in Filename");
                        this.fileName.requestFocus();
                        return;
                    }
                    int n2 = this.fileExt.getSelectedIndex();
                    if (n2 < 1 || n2 > 2) {
                        new ErrDialog((Frame)this, "You must select a file type.");
                        this.fileExt.requestFocus();
                        return;
                    }
                    if (!this.wpI.checkFileOwner(string = string + (n2 == 1 ? ".idx" : ".wps"), this.logInRec.userid)) {
                        new ErrDialog((Frame)this, "Sorry, you're not the owner of the existing file: " + string + " Try a new filename.");
                        this.fileName.requestFocus();
                        return;
                    }
                    String string3 = this.aRoute.getText().trim().replace(';', '/') + fldSep + string + fldSep + this.svIdx.getOwner();
                    IndexFileRec indexFileRec = new IndexFileRec(string3);
                    if (this.ewpul != null) {
                        this.ewpul.wpChanged(new WPUpdateEvent(this, this.mode, indexFileRec));
                    }
                    this.dispose();
                    if (this.ewpul == null || this.mode != 1) break block13;
                    new ShowMsgBox("Instructions for a new index", "Now Read \"" + indexFileRec.getDescription() + "\" and " + "add new routes/waypoints to it." + "\nWrite it when done.", this, true);
                    break block13;
                }
                if (object == this.bClear) {
                    this.aRoute.setText("");
                    this.fileName.setText("");
                    break block13;
                }
                if (object == this.bCancel) {
                    this.dispose();
                    return;
                }
                System.err.println("EWPI: Unknown action: " + actionEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

