/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import NormsTools.ErrDialog;
import WayPointApps.BadPositionException;
import WayPointApps.DegInputField;
import WayPointApps.EditWPUpdateListener;
import WayPointApps.MinInputField;
import WayPointApps.Position;
import WayPointApps.WPUpdateEvent;
import WayPointApps.WayPointDefs;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class EditWayPoint
extends Frame
implements ActionListener,
KeyListener {
    public static final int ADD_POSITION = 1;
    public static final int EDIT_POSITION = 2;
    public static final int MaxGPSNameLen = 8;
    static final String fldSep = ";";
    MenuBar mb;
    MenuItem fmo;
    MenuItem fme;
    MenuItem emv;
    TextField aRoute;
    TextField wpName;
    TextField gpsName;
    TextField wpNbr;
    DegInputField degLat;
    MinInputField minLat;
    TextField dirLat;
    DegInputField degLong;
    MinInputField minLong;
    TextField dirLong;
    Checkbox PtOfInt = new Checkbox("POI", false);
    Button bSave;
    Button bClear;
    Button bCancel;
    DecimalFormat decForm;
    private int mode;
    Position svPos;
    EditWPUpdateListener ewpul;

    public EditWayPoint(int mode) {
        this.mode = mode;
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        if (mode == 2) {
            this.setBackground(Color.yellow);
            this.setTitle("Edit Way point");
        } else if (mode == 1) {
            this.setBackground(Color.green);
            this.setTitle("Enter new Way point");
        } else {
            System.err.println("EditWP: unknown mode: " + mode);
        }
        this.mb = new MenuBar();
        Menu fm = new Menu("File");
        this.fmo = new MenuItem("Open...");
        this.fmo.addActionListener(this);
        fm.add(this.fmo);
        this.fme = new MenuItem("Exit");
        this.fme.addActionListener(this);
        fm.add(this.fme);
        this.mb.add(fm);
        Menu em = new Menu("View");
        this.emv = new MenuItem("List...");
        this.emv.addActionListener(this);
        em.add(this.emv);
        this.mb.add(em);
        Panel p1 = new Panel();
        Label l1 = WayPointDefs.GPS_Type == null ? new Label("Area/Route:") : new Label("Description:");
        p1.add(l1);
        this.aRoute = new TextField(40);
        p1.add(this.aRoute);
        this.add((Component)p1, "North");
        Panel p2 = new Panel();
        Label l2 = new Label("Name:");
        p2.add(l2);
        this.wpName = new TextField(25);
        p2.add(this.wpName);
        Label l3 = new Label("Latitude:");
        p2.add(l3);
        this.degLat = new DegInputField(this, 2);
        this.degLat.setMinMax(0, 90);
        p2.add(this.degLat);
        this.minLat = new MinInputField(this, 6);
        p2.add(this.minLat);
        this.dirLat = new TextField("N", 1);
        p2.add(this.dirLat);
        Label l4 = new Label("Longitude:");
        p2.add(l4);
        this.degLong = new DegInputField(this, 3);
        this.degLong.setMinMax(0, 180);
        p2.add(this.degLong);
        this.minLong = new MinInputField(this, 6);
        p2.add(this.minLong);
        this.dirLong = new TextField("W", 1);
        p2.add(this.dirLong);
        p2.add(this.PtOfInt);
        this.add((Component)p2, "Center");
        Panel p3 = new Panel();
        if (WayPointDefs.GPS_Type != null) {
            p3.setLayout(new FlowLayout(0));
            p3.add(new Label("GPS name:"));
            this.gpsName = new TextField(8);
            p3.add(this.gpsName);
            if (WayPointDefs.GPS_Type.equals("Micrologic")) {
                p3.add(new Label("Waypoint nbr:"));
                this.wpNbr = new TextField(2);
                p3.add(this.wpNbr);
            } else {
                p3.add(new Label("                      "));
            }
        }
        this.bSave = new Button("Save");
        p3.add(this.bSave);
        this.bSave.addActionListener(this);
        this.bSave.addKeyListener(this);
        this.bClear = new Button("Clear");
        p3.add(this.bClear);
        this.bClear.addActionListener(this);
        this.bClear.addKeyListener(this);
        this.bCancel = new Button("Cancel");
        p3.add(this.bCancel);
        this.bCancel.addActionListener(this);
        this.bCancel.addKeyListener(this);
        this.add((Component)p3, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                EditWayPoint.this.dispose();
            }
        });
        this.pack();
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((ss.width - this.getBounds().width) / 2, (ss.height - this.getBounds().height) / 2);
        this.setVisible(true);
        this.decForm = (DecimalFormat)NumberFormat.getNumberInstance();
        this.decForm.setMaximumFractionDigits(2);
    }

    public void setRoute(String nm) {
        this.aRoute.setText(nm);
    }

    public void setPosition(Position pos) {
        this.svPos = pos;
        if (pos == null) {
            return;
        }
        this.aRoute.setText(pos.getRoute());
        String theName = pos.getName();
        if (WayPointDefs.GPS_Type != null) {
            if (pos.hasGPSName()) {
                this.gpsName.setText(pos.getGPSName());
            }
            if (WayPointDefs.GPS_Type.equals("Micrologic") && pos.hasWpNbr()) {
                this.wpNbr.setText("" + pos.getIdxNbr());
            }
        }
        this.wpName.setText(theName);
        this.degLat.setText(pos.getDegLat());
        this.minLat.setText(pos.getMinLat());
        this.dirLat.setText(pos.getDirLat());
        this.degLong.setText(pos.getDegLong());
        this.minLong.setText(pos.getMinLong());
        this.dirLong.setText(pos.getDirLong());
        this.PtOfInt.setState(pos.isPOI());
    }

    public void addEditWPUpdateListener(EditWPUpdateListener l) {
        this.ewpul = l;
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            Object src = ke.getSource();
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new ActionEvent(src, 1001, "Enter"));
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.bSave) {
            if (this.aRoute.getText().trim().equals("")) {
                new ErrDialog((Frame)this, "Area/Route name missing");
                this.aRoute.requestFocus();
                return;
            }
            if (this.wpName.getText().trim().equals("")) {
                new ErrDialog((Frame)this, "WayPoint name missing");
                this.wpName.requestFocus();
                return;
            }
            if (WayPointDefs.GPS_Type != null) {
                if (this.gpsName.getText().trim().equals("")) {
                    String tempNm = this.wpName.getText().trim();
                    if (tempNm.length() <= 8) {
                        this.gpsName.setText(tempNm.toUpperCase());
                    } else {
                        int ix = tempNm.indexOf(" ");
                        if (ix > 0 && ix < 8) {
                            this.gpsName.setText(tempNm.substring(0, ix).toUpperCase());
                        }
                    }
                    new ErrDialog((Frame)this, "WayPoint GPS name missing");
                    this.gpsName.requestFocus();
                    return;
                }
                this.gpsName.setText(this.gpsName.getText().toUpperCase());
                if (WayPointDefs.GPS_Type.equals("Micrologic") && !this.wpNbr.getText().equals("")) {
                    try {
                        int idx = Integer.parseInt(this.wpNbr.getText());
                        if (idx < 0 || idx > 999) {
                            throw new Exception("Invalid waypoint number");
                        }
                    }
                    catch (Exception ex) {
                        new ErrDialog((Frame)this, "Invalid waypoint number. Must be numeric.");
                        this.wpNbr.requestFocus();
                        return;
                    }
                }
            }
            if (this.degLat.ckValid() && this.minLat.ckValid() && this.ckDir(this.dirLat, "NSns") && this.degLong.ckValid() && this.minLong.ckValid() && this.ckDir(this.dirLong, "EWew")) {
                if (this.mode == 1) {
                    String outRec = this.getCkName(this.aRoute) + fldSep + this.getCkName(this.wpName) + fldSep + this.degLat.getValue() + fldSep + this.minLat.getValue() + fldSep + this.dirLat.getText().trim().toUpperCase() + fldSep + this.degLong.getValue() + fldSep + this.minLong.getValue() + fldSep + this.dirLong.getText().trim().toUpperCase() + (this.PtOfInt.getState() ? ";POI" : "");
                    if (WayPointDefs.debug) {
                        System.out.println("Adding Rec: " + outRec);
                    }
                    Position pr = null;
                    try {
                        pr = new Position(outRec);
                        this.doGPSUpdate(pr);
                        if (this.ewpul != null) {
                            this.ewpul.wpChanged(new WPUpdateEvent(this, this.mode, pr));
                        }
                    }
                    catch (BadPositionException bpe) {
                        System.err.println("    Bad position record " + bpe.getMessage());
                        new ErrDialog((Frame)this, "Invalid position record. " + bpe.getMessage());
                        return;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return;
                    }
                    this.wpName.setText("");
                    this.minLat.setText("");
                    this.minLong.setText("");
                    this.gpsName.setText("");
                    this.wpName.requestFocus();
                } else {
                    if (this.mode == 2) {
                        if (this.svPos != null) {
                            try {
                                this.svPos.setRoute(this.getCkName(this.aRoute));
                                this.svPos.setName(this.getCkName(this.wpName));
                                this.svPos.setPOI(this.PtOfInt.getState());
                                this.svPos.setPosition(this.degLat.getValue(), this.minLat.getValue(), this.dirLat.getText().trim(), this.degLong.getValue(), this.minLong.getValue(), this.dirLong.getText().trim());
                                this.doGPSUpdate(this.svPos);
                                if (this.ewpul != null) {
                                    this.ewpul.wpChanged(new WPUpdateEvent(this, this.mode, null));
                                }
                            }
                            catch (BadPositionException bpe) {
                                System.err.println("Bad position:" + bpe.getMessage());
                                new ErrDialog((Frame)this, "Error found:" + bpe.getMessage());
                                return;
                            }
                            this.svPos = null;
                        } else {
                            System.err.println("ERROR: 'Save' without having a position");
                        }
                        this.dispose();
                        return;
                    }
                    System.err.println("Unknown mode: " + this.mode);
                }
            }
        } else if (src == this.bClear) {
            this.aRoute.setText("");
            if (this.gpsName != null) {
                this.gpsName.setText("");
            }
            if (this.wpNbr != null) {
                this.wpNbr.setText("");
            }
            this.wpName.setText("");
            this.degLat.setText("");
            this.minLat.setText("");
            this.dirLat.setText("");
            this.degLong.setText("");
            this.minLong.setText("");
            this.dirLong.setText("");
            this.PtOfInt.setState(false);
        } else {
            if (src == this.bCancel) {
                this.dispose();
                return;
            }
            if (src == this.fme) {
                return;
            }
            System.err.println("Unknown action: " + ae);
        }
    }

    boolean ckDir(TextField tf, String choices) {
        String dir = tf.getText().trim();
        if (dir.length() != 1) {
            new ErrDialog((Frame)this, "Missing/invalid direction value: " + dir);
            tf.requestFocus();
            return false;
        }
        if (choices.indexOf(dir) < 0) {
            new ErrDialog((Frame)this, "Invalid direction value: " + dir);
            tf.requestFocus();
            return false;
        }
        return true;
    }

    String getCkName(TextField tf) {
        return tf.getText().trim().replace(';', '/');
    }

    private void doGPSUpdate(Position pr) {
        if (WayPointDefs.GPS_Type != null) {
            pr.setGPSName(this.gpsName.getText());
            if (this.wpNbr != null && !this.wpNbr.getText().equals("")) {
                pr.setIdxNbr(Integer.parseInt(this.wpNbr.getText()));
            }
        }
    }
}

