/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import NormsTools.ErrDialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public final class DegInputField
extends TextField
implements FocusListener,
TextListener {
    final boolean Testing = false;
    static final String blanks = "                    ";
    static final String nines = "9999999999999";
    Frame errF = null;
    Font font;
    FontMetrics fm;
    int value;
    int nbrChar;
    int lastPos;
    int minValue = 0;
    int maxValue = 90;
    boolean haveWarned = false;

    public DegInputField(Frame frame, int n) {
        super(blanks.substring(0, n), n + 1);
        this.errF = frame;
        this.nbrChar = n;
        this.font = new Font("Monospaced", 0, 12);
        this.setFont(this.font);
        Graphics graphics = frame.getGraphics();
        if (graphics != null) {
            this.fm = graphics.getFontMetrics(this.font);
        }
        this.addFocusListener(this);
        this.addTextListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                DegInputField.this.haveWarned = false;
                if (('0' > c || c > '9') && !Character.isISOControl(c) || DegInputField.this.getText().trim().length() >= DegInputField.this.nbrChar && !Character.isISOControl(c)) {
                    System.out.println("Consuming " + c + " " + c);
                    keyEvent.consume();
                } else {
                    DegInputField.this.lastPos = DegInputField.this.getCaretPosition();
                }
            }
        });
        this.value = 0;
    }

    public void paint(Graphics graphics) {
        this.fm = graphics.getFontMetrics(this.font);
    }

    public Dimension getXPreferredSize() {
        if (this.fm != null) {
            return new Dimension(this.fm.stringWidth(nines.substring(0, this.nbrChar)), this.fm.getHeight() + 2);
        }
        return super.getPreferredSize(this.nbrChar);
    }

    public int getValue() {
        this.checkValue();
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
        super.setText("" + n);
    }

    public void setMinMax(int n, int n2) {
        this.minValue = n;
        this.maxValue = n2;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public void setText(String string) {
        super.setText(string);
        this.value = string.equals("") ? 0 : Integer.parseInt(string);
    }

    public void setErrFrame(Frame frame) {
        this.errF = frame;
    }

    public void setHaveWarned(boolean bl) {
        this.haveWarned = bl;
    }

    public void textValueChanged(TextEvent textEvent) {
        this.checkValue();
    }

    public boolean ckValid() {
        if (this.getText().trim().equals("")) {
            if (this.errF != null) {
                new ErrDialog(this.errF, "missing Degree value", false);
            } else {
                System.err.println("missing Degree value");
            }
            this.requestFocus();
            return false;
        }
        return this.checkValue();
    }

    private boolean checkValue() {
        if (this.getText().trim().equals("")) {
            return true;
        }
        try {
            int n = Integer.parseInt(this.getText().trim());
            if (n > this.maxValue || n < this.minValue) {
                if (this.errF != null) {
                    new ErrDialog(this.errF, n + " Deg out of range: " + this.minValue + ":" + this.maxValue, false);
                } else {
                    System.err.println(n + " Deg  out of range: " + this.minValue + ":" + this.maxValue);
                }
                this.requestFocus();
                return false;
            }
            this.value = n;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.setText("" + this.value);
            this.setCaretPosition(this.lastPos);
            return false;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        if (focusEvent.getComponent() == this) {
            if (this.getText().trim().equals("") && !this.haveWarned) {
                this.haveWarned = true;
                if (this.errF != null) {
                    new ErrDialog(this.errF, "missing Degree value", false);
                } else {
                    System.err.println("missing Degree value");
                }
                this.requestFocus();
            } else if (!this.haveWarned && !this.checkValue()) {
                this.haveWarned = true;
                this.requestFocus();
            }
        } else {
            System.err.println("Unknown focusLost: " + focusEvent);
        }
    }
}

