/*
 * Decompiled with CFR 0.152.
 */
package WayPointApps;

import WayPointApps.Position;
import WayPointApps.WayPointDefs;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class CandD {
    private static final double MinDistForRhumbLn = 600.0;
    private static final double ShortDistanceFor3Places = 0.1;
    public double courseT;
    public double courseM;
    public double distance;
    public String direction;
    private DecimalFormat decForm;
    private DecimalFormat decForm2;
    private DecimalFormat decForm3;

    public String toString() {
        if (this.decForm == null) {
            this.decForm = new DecimalFormat("000");
            this.decForm2 = (DecimalFormat)NumberFormat.getNumberInstance();
            ((NumberFormat)this.decForm2).setMaximumFractionDigits(2);
            this.decForm3 = (DecimalFormat)NumberFormat.getNumberInstance();
            ((NumberFormat)this.decForm3).setMaximumFractionDigits(3);
        }
        String string = null;
        string = this.distance < 0.1 ? this.decForm3.format(this.distance) : this.decForm2.format(this.distance);
        return "Course: " + this.decForm.format(this.courseT) + "\u00b0" + "T" + ", Distance: " + string + " nm" + "   " + this.direction;
    }

    public CandD(double d, double d2, double d3, String string) {
        this.courseT = d;
        this.courseM = d2;
        this.distance = d3;
        this.direction = string;
    }

    public CandD(Position position, Position position2) {
        CandD.compGreatCircle(position, position2);
    }

    static String oppositeLat(String string) {
        if (string.equals("N")) {
            return "S";
        }
        return "N";
    }

    public static CandD compGreatCircle(Position position, Position position2) {
        double d = 0.0;
        if (position.getDirLong().equals(position2.getDirLong())) {
            d = Math.abs(position.decDegLong() - position2.decDegLong());
        } else {
            d = position.decDegLong() + position2.decDegLong();
            if (d > 180.0) {
                d = 360.0 - d;
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (position.getDirLat().equals(position2.getDirLat())) {
            d2 = Math.abs(position.decDegLat() - position2.decDegLat());
            d3 = (position.decDegLat() + position2.decDegLat()) / 2.0;
        } else {
            d2 = position.decDegLat() + position2.decDegLat();
            d3 = Math.abs(position.decDegLat() - position2.decDegLat()) / 2.0;
        }
        double d4 = 1.0;
        if (!position.getDirLat().equals(position2.getDirLat())) {
            d4 = -1.0;
        }
        d3 *= Math.PI / 180;
        double d5 = Math.acos(Math.sin(position.radDegLat()) * Math.sin(d4 * position2.radDegLat()) + Math.cos(position.radDegLat()) * Math.cos(d4 * position2.radDegLat()) * Math.cos(d *= Math.PI / 180)) * 3437.7467707849396;
        double d6 = Math.atan(Math.sin(d) / (Math.cos(position.radDegLat()) * Math.tan(position2.radDegLat()) - Math.sin(position.radDegLat()) * Math.cos(d))) * 57.29577951308232;
        double d7 = 90.0;
        if ((d2 *= Math.PI / 180) != 0.0) {
            d7 = Math.atan(Math.cos(d3) * d / d2) * 57.29577951308232;
        }
        if (WayPointDefs.debug) {
            System.out.println("compGreatCircle: (Before) Course(Bowditch): " + d6 + ",  Course2(rhumb): " + d7);
        }
        d6 = Math.abs(d6);
        String string = !position.getDirLat().equals(position2.getDirLat()) ? position2.getDirLat() : (position.decDegLat() > position2.decDegLat() ? CandD.oppositeLat(position2.getDirLat()) : position.getDirLat());
        String string2 = position.getDirLong().equals(position2.getDirLong()) ? (position2.decDegLong() > position.decDegLong() ? position.getDirLong() : CandD.oppositeLong(position.getDirLong())) : (position.decDegLong() + position2.decDegLong() < 180.0 ? position2.getDirLong() : CandD.oppositeLong(position2.getDirLong()));
        if (string.equals("S")) {
            if (string2.equals("E")) {
                d6 = 180.0 - d6;
                d7 = 180.0 - d7;
            } else {
                d6 = 180.0 + d6;
                d7 = 180.0 + d7;
            }
        } else if (string2.equals("W")) {
            d6 = 360.0 - d6;
            d7 = 360.0 - d7;
        }
        if (WayPointDefs.debug) {
            System.out.println("compGreatCircle: (After) Course(Bowditch): " + d6 + ",  Course2(rhumb): " + d7);
        }
        if (d5 < 600.0) {
            d6 = d7;
        }
        return new CandD(d6, d6 + position.getVariation(), d5, string + string2);
    }

    static String oppositeLong(String string) {
        if (string.equals("E")) {
            return "W";
        }
        return "E";
    }
}

