/*
 * Decompiled with CFR 0.152.
 */
package SerialComm;

public class SerialParameters {
    private String portName;
    private int baudRate;
    private int flowControlIn;
    private int flowControlOut;
    private int databits;
    private int stopbits;
    private int parity;

    public String getPortName() {
        return this.portName;
    }

    public String getDatabitsString() {
        switch (this.databits) {
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
        }
        return "8";
    }

    public SerialParameters() {
        this("COM1", 9600, 0, 0, 8, 1, 0);
    }

    public SerialParameters(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.portName = string;
        this.baudRate = n;
        this.flowControlIn = n2;
        this.flowControlOut = n3;
        this.databits = n4;
        this.stopbits = n5;
        this.parity = n6;
    }

    public String getParityString() {
        switch (this.parity) {
            case 0: {
                return "None";
            }
            case 2: {
                return "Even";
            }
            case 1: {
                return "Odd";
            }
        }
        return "None";
    }

    public String getFlowControlInString() {
        return this.flowToString(this.flowControlIn);
    }

    public String getStopbitsString() {
        switch (this.stopbits) {
            case 1: {
                return "1";
            }
            case 3: {
                return "1.5";
            }
            case 2: {
                return "2";
            }
        }
        return "1";
    }

    String flowToString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 8: {
                return "Xon/Xoff Out";
            }
            case 4: {
                return "Xon/Xoff In";
            }
            case 1: {
                return "RTS/CTS In";
            }
            case 2: {
                return "RTS/CTS Out";
            }
        }
        return "None";
    }

    public void setDatabits(int n) {
        this.databits = n;
    }

    public void setDatabits(String string) {
        if (string.equals("5")) {
            this.databits = 5;
        }
        if (string.equals("6")) {
            this.databits = 6;
        }
        if (string.equals("7")) {
            this.databits = 7;
        }
        if (string.equals("8")) {
            this.databits = 8;
        }
    }

    public int getDatabits() {
        return this.databits;
    }

    public void setFlowControlOut(int n) {
        this.flowControlOut = n;
    }

    public void setBaudRate(int n) {
        this.baudRate = n;
    }

    public void setBaudRate(String string) {
        this.baudRate = Integer.parseInt(string);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setFlowControlOut(String string) {
        this.flowControlOut = this.stringToFlow(string);
    }

    public int getFlowControlOut() {
        return this.flowControlOut;
    }

    public String getFlowControlOutString() {
        return this.flowToString(this.flowControlOut);
    }

    public void setFlowControlIn(int n) {
        this.flowControlIn = n;
    }

    public void setFlowControlIn(String string) {
        this.flowControlIn = this.stringToFlow(string);
    }

    public int getFlowControlIn() {
        return this.flowControlIn;
    }

    public void setStopbits(int n) {
        this.stopbits = n;
    }

    public void setStopbits(String string) {
        if (string.equals("1")) {
            this.stopbits = 1;
        }
        if (string.equals("1.5")) {
            this.stopbits = 3;
        }
        if (string.equals("2")) {
            this.stopbits = 2;
        }
    }

    public int getStopbits() {
        return this.stopbits;
    }

    private int stringToFlow(String string) {
        if (string.equals("None")) {
            return 0;
        }
        if (string.equals("Xon/Xoff Out")) {
            return 8;
        }
        if (string.equals("Xon/Xoff In")) {
            return 4;
        }
        if (string.equals("RTS/CTS In")) {
            return 1;
        }
        if (string.equals("RTS/CTS Out")) {
            return 2;
        }
        return 0;
    }

    public void setParity(int n) {
        this.parity = n;
    }

    public void setParity(String string) {
        if (string.equals("None")) {
            this.parity = 0;
        }
        if (string.equals("Even")) {
            this.parity = 2;
        }
        if (string.equals("Odd")) {
            this.parity = 1;
        }
    }

    public int getParity() {
        return this.parity;
    }

    public String getBaudRateString() {
        return Integer.toString(this.baudRate);
    }

    public void setPortName(String string) {
        this.portName = string;
    }
}

