/*
 * Decompiled with CFR 0.152.
 */
package SerialComm;

import SerialComm.PortRequestedDialog;
import SerialComm.SerialConnectionException;
import SerialComm.SerialParameters;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SerialConnection
implements SerialPortEventListener,
CommPortOwnershipListener {
    public final int BufferSize = 4000;
    private boolean debug = false;
    private Frame pFrame;
    private SerialParameters parameters;
    private OutputStream os;
    private InputStream is;
    private CommPortIdentifier portId;
    private SerialPort sPort;
    private boolean open;
    private byte[] svBfr = new byte[4000];
    private int bPtr = 0;
    static char[] hexValue = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public SerialConnection(Frame frame, SerialParameters serialParameters) {
        this.parameters = serialParameters;
        this.pFrame = frame;
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void writeBytes(byte[] byArray) throws SerialConnectionException {
        if (!this.open) {
            System.err.println("writeBytes to closed port");
            throw new SerialConnectionException("write to closed port");
        }
        try {
            this.os.write(byArray);
            this.os.flush();
            if (this.debug) {
                System.out.println("writeBytes() wrote " + byArray.length + " bytes >" + SerialConnection.showBytes(byArray));
            }
        }
        catch (Exception exception) {
            System.err.println("writeBytes() OutputStream error: " + exception);
        }
    }

    public void ownershipChange(int n) {
        if (n == 3) {
            new PortRequestedDialog(this.pFrame);
        }
    }

    public void closeConnection() {
        if (!this.open) {
            return;
        }
        if (this.sPort != null) {
            try {
                this.os.close();
                this.is.close();
            }
            catch (IOException iOException) {
                System.err.println("Error closing " + iOException);
            }
            this.sPort.close();
            this.portId.removePortOwnershipListener(this);
        }
        this.open = false;
        if (this.debug) {
            System.out.println("Serial port closed");
        }
    }

    public int getNbrBytes() {
        return this.bPtr;
    }

    public void openConnection() throws SerialConnectionException {
        try {
            this.portId = CommPortIdentifier.getPortIdentifier(this.parameters.getPortName());
            if (this.debug) {
                System.out.println("Got portId " + this.portId.getName());
            }
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new SerialConnectionException(noSuchPortException.getMessage());
        }
        try {
            this.sPort = (SerialPort)this.portId.open("SerialConnection", 30000);
        }
        catch (PortInUseException portInUseException) {
            throw new SerialConnectionException(portInUseException.getMessage());
        }
        try {
            this.setConnectionParameters();
        }
        catch (SerialConnectionException serialConnectionException) {
            this.sPort.close();
            throw serialConnectionException;
        }
        try {
            this.os = this.sPort.getOutputStream();
            this.is = this.sPort.getInputStream();
        }
        catch (IOException iOException) {
            this.sPort.close();
            throw new SerialConnectionException("Error opening i/o streams");
        }
        try {
            this.sPort.addEventListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            this.sPort.close();
            throw new SerialConnectionException("too many listeners added");
        }
        this.sPort.notifyOnDataAvailable(true);
        this.sPort.notifyOnBreakInterrupt(true);
        try {
            this.sPort.enableReceiveTimeout(30);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {}
        this.portId.addPortOwnershipListener(this);
        this.open = true;
    }

    private synchronized void saveBytes(byte[] byArray, int n) {
        if (this.debug) {
            System.out.println("saveBytes " + n);
        }
        int n2 = -1;
        try {
            n2 = 0;
            while (n2 < n) {
                this.svBfr[this.bPtr++] = byArray[n2];
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("saveBytes ex, bPtr=" + this.bPtr + " ba.length=" + byArray.length + " nbr=" + n + " i=" + n2 + "\n " + exception);
        }
    }

    public synchronized int getBytes(byte[] byArray, int n) {
        int n2 = -1;
        try {
            n2 = 0;
            while (n2 < this.bPtr) {
                byArray[n++] = this.svBfr[n2];
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("getBytes ex bPtr=" + this.bPtr + " i=" + n2 + " os=" + n + "\n " + exception);
        }
        this.bPtr = 0;
        return n;
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        byte[] byArray = new byte[4000];
        int n = 0;
        int n2 = 0;
        switch (serialPortEvent.getEventType()) {
            case 1: {
                if (this.debug) {
                    System.out.print("SerialConnection DATA AVAIABLE: >");
                }
                while (n != -1) {
                    try {
                        n = this.is.read();
                        if (n == -1) break;
                        byArray[n2++] = (byte)n;
                        if (!this.debug) continue;
                        System.out.print((n < 16 ? "0" : "") + Integer.toHexString(n) + " ");
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                        return;
                    }
                }
                this.saveBytes(byArray, n2);
                if (!this.debug) break;
                System.out.println("< nbr=" + n2 + ", bPtr= " + this.bPtr);
                break;
            }
            case 10: {
                System.out.println("Got BREAK");
                break;
            }
            default: {
                System.out.println("serialEvent: " + serialPortEvent);
            }
        }
    }

    public static String showBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2 + byArray.length / 4);
        stringBuffer.setLength(byArray.length * 2 + byArray.length / 4);
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = byArray[n2] & 0xFF;
                stringBuffer.setCharAt(n++, hexValue[n3 >> 4]);
                stringBuffer.setCharAt(n++, hexValue[n3 & 0xF]);
                if (n2 % 4 == 3) {
                    stringBuffer.setCharAt(n++, ' ');
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("showBytes() Error " + exception + "\n j=" + n + " " + stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setConnectionParameters() throws SerialConnectionException {
        int n = this.sPort.getBaudRate();
        int n2 = this.sPort.getDataBits();
        int n3 = this.sPort.getStopBits();
        int n4 = this.sPort.getParity();
        this.sPort.getFlowControlMode();
        try {
            this.sPort.setSerialPortParams(this.parameters.getBaudRate(), this.parameters.getDatabits(), this.parameters.getStopbits(), this.parameters.getParity());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            this.parameters.setBaudRate(n);
            this.parameters.setDatabits(n2);
            this.parameters.setStopbits(n3);
            this.parameters.setParity(n4);
            throw new SerialConnectionException("Unsupported parameter");
        }
        try {
            this.sPort.setFlowControlMode(this.parameters.getFlowControlIn() | this.parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new SerialConnectionException("Unsupported flow control");
        }
        if (this.debug) {
            System.out.println("Connection parms set to: " + this.parameters.getPortName() + " " + this.parameters.getBaudRateString() + " " + this.parameters.getDatabitsString() + " " + this.parameters.getStopbitsString() + " " + this.parameters.getParityString());
        }
    }

    public void sendBreak() {
        this.sPort.sendBreak(1000);
    }
}

