/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ShowCounters
extends Frame {
    String title;
    String[] desc;
    int[] sizes;
    Rectangle[] cntrsLoc;
    int[] values;
    boolean[] changed;
    Font nbrFont = new Font("Monospaced", 0, 12);
    FontMetrics nbrFM;
    Color BkGrndClr = Color.lightGray;
    Color cntrClr = Color.white;
    final int DESC_START_X = 10;
    final int LINE_HEIGHT = 35;
    final int CNTR_PAD = 5;
    int longestLine = 0;
    int cntrHt = 10;
    int windWidth;
    Rectangle cntrSpace;
    boolean userClosed = false;
    private boolean needDesc = true;

    public ShowCounters(String string, String[] stringArray, int[] nArray) {
        super(string);
        int n;
        this.title = string;
        this.desc = stringArray;
        this.sizes = nArray;
        if (stringArray.length != nArray.length) {
            throw new Error("Array sizes not equal");
        }
        this.cntrsLoc = new Rectangle[nArray.length];
        this.values = new int[nArray.length];
        this.changed = new boolean[nArray.length];
        this.addNotify();
        Graphics graphics = this.getGraphics();
        this.nbrFM = graphics.getFontMetrics(this.nbrFont);
        int n2 = this.nbrFM.stringWidth(" ");
        this.cntrHt = this.nbrFM.getHeight();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n3 = 0;
        while (n3 < nArray.length) {
            n = fontMetrics.stringWidth(stringArray[n3]) + n2 * nArray[n3];
            if (n > this.longestLine) {
                this.longestLine = n;
            }
            ++n3;
        }
        this.windWidth = this.longestLine + 20;
        this.cntrSpace = new Rectangle(0, this.getInsets().top, this.windWidth, nArray.length * 35 + (35 - this.cntrHt) / 2);
        n = this.cntrSpace.y + (35 - this.cntrHt) / 2;
        int n4 = 0;
        while (n4 < this.cntrsLoc.length) {
            this.cntrsLoc[n4] = new Rectangle(this.windWidth - (nArray[n4] * n2 + 5), n, nArray[n4] * n2, this.cntrHt);
            n += 35;
            ++n4;
        }
        this.setBackground(this.BkGrndClr);
        this.setResizable(false);
        this.setSize(this.windWidth, this.getInsets().top + this.cntrSpace.height + this.getInsets().bottom);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ShowCounters.this.userClosed = true;
                ShowCounters.this.dispose();
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                ShowCounters.this.needDesc = true;
                int n = 0;
                while (n < ShowCounters.this.changed.length) {
                    ShowCounters.this.changed[n] = true;
                    ++n;
                }
                ShowCounters.this.repaint();
            }

            public void windowActivated(WindowEvent windowEvent) {
                this.windowDeiconified(windowEvent);
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2);
    }

    public void setValue(int n, int n2) {
        this.values[n] = n2;
        this.changed[n] = true;
        if (this.userClosed) {
            return;
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.repaint();
    }

    public void incrValue(int n) {
        int n2 = n;
        this.values[n2] = this.values[n2] + 1;
        this.changed[n] = true;
        if (this.userClosed) {
            return;
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.repaint();
    }

    public void setTimeOut(final int n) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ShowCounters.this.dispose();
            }
        }).start();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        Rectangle rectangle = graphics.getClipBounds();
        if (this.needDesc || rectangle.x > 0) {
            this.needDesc = false;
            graphics.setColor(this.cntrClr);
            n = 0;
            while (n < this.sizes.length) {
                Rectangle rectangle2 = this.cntrsLoc[n];
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                ++n;
            }
            int n2 = this.cntrsLoc[0].y + this.cntrsLoc[0].height;
            graphics.setColor(Color.black);
            int n3 = 0;
            while (n3 < this.desc.length) {
                graphics.drawString(this.desc[n3], 10, n2);
                n2 += 35;
                ++n3;
            }
        }
        graphics.setFont(this.nbrFont);
        n = 0;
        while (n < this.values.length) {
            if (this.changed[n] || rectangle.x != 0) {
                this.changed[n] = false;
                graphics.setColor(this.cntrClr);
                Rectangle rectangle3 = this.cntrsLoc[n];
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                graphics.setColor(Color.black);
                graphics.drawString(this.RMC("               " + this.values[n], this.sizes[n]), rectangle3.x, rectangle3.y + this.cntrHt - 1);
            }
            ++n;
        }
    }

    private String RMC(String string, int n) {
        return string.substring(string.length() - n);
    }
}

