/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;

public class SaveStdOutput
extends PrintStream {
    static final boolean debug = false;
    static OutputStream logfile;
    static PrintStream oldStdout;
    static PrintStream oldStderr;
    private boolean echoOutput = true;

    private SaveStdOutput(PrintStream printStream, boolean bl) {
        super(printStream);
        this.echoOutput = bl;
    }

    public static void start(String string) throws IOException {
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(string, true)));
        SaveStdOutput.doCommon(printStream, true);
    }

    public static void start(OutputStream outputStream) {
        SaveStdOutput.doCommon(outputStream, true);
    }

    public static void start(OutputStream outputStream, boolean bl) {
        SaveStdOutput.doCommon(outputStream, bl);
    }

    private static void doCommon(OutputStream outputStream, boolean bl) {
        if (oldStdout != null) {
            return;
        }
        logfile = outputStream;
        oldStdout = System.out;
        oldStderr = System.err;
        System.setOut(new SaveStdOutput(System.out, bl));
        System.setErr(new SaveStdOutput(System.err, bl));
    }

    public static void stop() {
        if (oldStdout == null) {
            return;
        }
        System.setOut(oldStdout);
        oldStdout = null;
        System.setErr(oldStderr);
        try {
            logfile.close();
        }
        catch (Exception exception) {
            System.err.println("SaveStdOutput stop() ex " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void write(int n) {
        try {
            logfile.write(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setError();
        }
        if (this.echoOutput) {
            super.write(n);
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            logfile.write(byArray, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setError();
        }
        if (this.echoOutput) {
            super.write(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        block4: {
            try {
                try {
                    SaveStdOutput.start("log.txt");
                    System.out.println("Here's is some stuff to stdout." + new Date());
                    System.err.println("Here's is some stuff to stderr.");
                    System.out.println("Let's throw an exception...");
                    new Exception().printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var3_2 = null;
                    SaveStdOutput.stop();
                    break block4;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                SaveStdOutput.stop();
                throw throwable;
            }
            SaveStdOutput.stop();
        }
        System.out.println("This should be to console only!");
    }

    static {
        oldStdout = null;
        oldStderr = null;
    }
}

