/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public class MessageArea
extends Component {
    private boolean testing = false;
    private static final int MIN_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width / 3;
    private final int ExtraLines = 100;
    String msg;
    Font font;
    FontMetrics fm;
    int strLen;
    int maxWordLen = 0;
    int userWidth = 0;
    int resizeWidth = -1;
    int hFM;
    int YPAD = 3;
    Dimension pSize;
    private String[] lines;
    private int idx = 0;
    private int nbrLines = 0;

    public MessageArea(String string) {
        this.msg = string;
    }

    public void setTesting(boolean bl) {
        this.testing = bl;
    }

    public void paint(Graphics graphics) {
        if (this.testing) {
            System.out.println("MA: paint");
        }
        if (this.pSize == null) {
            this.getSpecs();
        }
        int n = 0;
        try {
            int n2 = 0;
            int n3 = this.fm.getAscent();
            n = 0;
            while (n < this.nbrLines) {
                graphics.drawString(this.lines[n], n2, n3);
                n3 += this.hFM;
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("paint ex " + exception + "\n i=" + n + ", nbrLines =" + this.nbrLines);
        }
    }

    private synchronized void getSpecs() {
        if (this.testing) {
            System.out.println("MA: getSpecs " + this.getFont() + "\n   super size=" + super.getSize());
        }
        this.fm = this.getFontMetrics(this.getFont());
        this.hFM = this.fm.getHeight();
        this.strLen = this.fm.stringWidth(this.msg);
        int n = this.userWidth;
        if (n == 0) {
            n = this.resizeWidth > 0 ? this.resizeWidth : MIN_WIDTH;
            if (this.testing) {
                System.out.println("MA.getSpecs() width=0, set to " + n);
            }
        }
        this.nbrLines = (this.strLen + n - 1) / n;
        this.lines = new String[this.nbrLines + 100];
        this.idx = 0;
        if (this.msg.indexOf("\n") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.msg, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                int n2 = this.fm.stringWidth(string);
                if (this.userWidth == 0 && this.resizeWidth <= 0) {
                    n = Math.max(n, n2);
                    if (this.testing) {
                        System.out.println("MA new lineLen: " + n);
                    }
                }
                if (n2 <= n) {
                    this.lines[this.idx++] = string;
                    continue;
                }
                this.foldString(string, n);
                ++this.idx;
            }
            --this.idx;
        } else {
            this.foldString(this.msg, n);
        }
        this.nbrLines = this.idx + 1;
        this.pSize = new Dimension(Math.max(n, this.maxWordLen), this.nbrLines * (this.hFM + this.YPAD) - this.YPAD);
        if (this.testing) {
            System.out.println("MA.getSpecs(): new size: " + this.pSize + "\n   maxWL=" + this.maxWordLen + ", lL=" + n + ", nbrL=" + this.nbrLines + ", hFM=" + this.hFM);
        }
    }

    private void foldString(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.lines[this.idx] = stringTokenizer.nextToken();
        this.maxWordLen = this.fm.stringWidth(this.lines[this.idx]);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = this.fm.stringWidth(string2);
            int n3 = this.maxWordLen = n2 > this.maxWordLen ? n2 : this.maxWordLen;
            if (this.fm.stringWidth(this.lines[this.idx] + " " + string2) > n) {
                ++this.idx;
                this.lines[this.idx] = string2;
                continue;
            }
            int n4 = this.idx;
            this.lines[n4] = this.lines[n4] + " " + string2;
        }
    }

    public void invalidate() {
        this.pSize = null;
        if (this.testing) {
            System.out.println("MA: invalidate");
        }
        super.invalidate();
    }

    public void setSize(Dimension dimension) {
        if (this.testing) {
            System.out.println("MA: setSize() to: " + dimension);
        }
        this.pSize = dimension;
        this.userWidth = dimension.width;
    }

    public void setSize(int n, int n2) {
        if (this.testing) {
            System.out.println("MA: setSize() to: " + n + "x" + n2);
        }
        this.resizeWidth = this.resizeWidth < 0 ? 0 : n;
        super.setSize(n, n2);
    }

    public void setBoundsXXX(Rectangle rectangle) {
        if (this.testing) {
            System.out.println("MA: setBounds() to: " + rectangle);
        }
        super.setBounds(rectangle);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.testing) {
            System.out.println("MA: setBounds() to: " + n + "," + n2 + "  " + n3 + "x" + n4);
        }
        super.setBounds(n, n2, n3, n4);
    }

    public Dimension getSize() {
        if (this.testing) {
            System.out.println("MA: getSize(): " + this.pSize + ", super:" + super.getSize());
        }
        if (this.pSize == null) {
            this.getSpecs();
        }
        return this.pSize;
    }

    public Dimension getMinimumSize() {
        if (this.testing) {
            System.out.println("MA: getMinimumSize: " + this.pSize + ",   super:" + super.getSize());
        }
        if (this.pSize == null) {
            this.getSpecs();
        }
        if (this.testing) {
            System.out.println("MA: getMinimumSize " + this.pSize);
        }
        return this.pSize;
    }

    public Dimension getPreferredSize() {
        if (this.pSize == null) {
            this.getSpecs();
        }
        if (this.testing) {
            System.out.println("MA: getPreferredSize " + this.pSize);
        }
        return this.pSize;
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

