/*
 * Decompiled with CFR 0.152.
 */
package NormsTools.DocumentViewer;

import NormsTools.DocumentViewer.Document;
import NormsTools.DocumentViewer.DocumentWindowImpl;
import NormsTools.Sorter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ShowDocument
extends Frame
implements ActionListener,
ItemListener {
    private final int FrameWidth = 400;
    private final int FrameHeight = 500;
    private static String ShowDocumentDefault = "ShowDocument.html";
    Panel topPnl = new Panel();
    Button returnB = new Button("Go back");
    Panel chsPnl = new Panel();
    Label choseLbl = new Label("Go to topic:");
    Choice indexCh = new Choice();
    ScrollPane sp = new ScrollPane();
    DocumentWindowImpl dw;
    Document doc;
    private boolean writeNPH = false;
    static boolean exitPgmOnClosing = false;

    protected void loadChoices(Document document) {
        this.indexCh.removeAll();
        document.setAnchors();
        String[] stringArray = document.getLocNames();
        if (stringArray.length > 0) {
            Sorter.sort(stringArray);
            int n = 0;
            while (n < stringArray.length) {
                this.indexCh.add(stringArray[n]);
                ++n;
            }
            this.topPnl.add(this.chsPnl);
            this.topPnl.invalidate();
        } else {
            this.topPnl.remove(this.chsPnl);
            this.topPnl.invalidate();
        }
    }

    protected void setGoBack(boolean bl) {
        this.returnB.setEnabled(bl);
    }

    public ShowDocument() throws Exception {
        this(ShowDocumentDefault);
        System.out.println("ShowDocument Constructor without parms");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.indexCh) {
            String string = this.indexCh.getSelectedItem();
            Point point = this.doc.getAnchorLoc(string);
            if (point != null) {
                this.dw.goToLocation(point);
            }
        } else {
            System.err.println("itemStateChanged unknown ie " + itemEvent);
        }
    }

    public ShowDocument(String[] stringArray) throws Exception {
        int n;
        String string = "";
        if (stringArray.length > 0) {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase("-wrtNPH")) {
                    this.writeNPH = true;
                } else if (stringArray[n].startsWith("-")) {
                    System.err.println("ShowDocument ignoring: " + stringArray[n]);
                } else {
                    string = stringArray[n];
                }
                ++n;
            }
        }
        this.doc = Document.getDocument(string);
        this.finishIt();
        if (this.writeNPH) {
            n = string.indexOf(".");
            String string2 = string;
            if (n > 1) {
                string2 = string.substring(0, n);
            }
            this.doc.serialize(string2 + ".nph");
        }
    }

    public ShowDocument(String string) throws Exception {
        this.doc = Document.getDocument(string);
        this.finishIt();
    }

    public ShowDocument(Document document) {
        this.doc = document;
        this.finishIt();
    }

    protected Point getDocLocation() {
        return this.sp.getScrollPosition();
    }

    public static void main(String[] stringArray) {
        exitPgmOnClosing = true;
        try {
            if (stringArray.length > 0) {
                new ShowDocument(stringArray);
            } else {
                System.out.println("Must give a document filename as arg.");
                new ShowDocument();
            }
        }
        catch (Exception exception) {
            System.err.println("ShowDocument() got ex : " + exception);
            exception.printStackTrace();
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception2) {}
            System.exit(0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.returnB) {
            this.dw.goBack();
        } else {
            System.out.println("a..P.. unknown ae " + actionEvent);
        }
    }

    private void finishIt() {
        this.addWindowListener(new WindowAdapter(){
            {
                ShowDocument.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                ShowDocument.this.dispose();
                ((Component)ShowDocument.this).setVisible(false);
                if (exitPgmOnClosing) {
                    System.exit(0);
                }
            }
        });
        this.setLayout(new BorderLayout());
        if (this.doc == null || this.doc.title.equals("")) {
            this.setTitle("Norm's Document Viewer");
        } else {
            this.setTitle(this.doc.title);
        }
        this.topPnl.add(this.returnB);
        this.returnB.addActionListener(this);
        this.returnB.setEnabled(false);
        this.chsPnl.add(this.choseLbl);
        this.indexCh.addItemListener(this);
        this.chsPnl.add(this.indexCh);
        this.topPnl.add(this.chsPnl);
        this.loadChoices(this.doc);
        this.topPnl.setBackground(new Color(123, 123, 123));
        this.add((Component)this.topPnl, "North");
        this.dw = new DocumentWindowImpl(this.doc, this);
        this.sp.add(this.dw);
        this.sp.getVAdjustable().setUnitIncrement(18);
        this.add((Component)this.sp, "Center");
        ((Component)this).setSize(400, 500);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width - this.getBounds().width, 0);
        ((Component)this).setVisible(true);
    }

    void setExitOnClose(boolean bl) {
        exitPgmOnClosing = bl;
    }

    protected void showLocation(Point point) {
        this.sp.setScrollPosition(point);
    }
}

