/*
 * Decompiled with CFR 0.152.
 */
package NormsTools.DocumentViewer;

import NormsTools.DocumentViewer.DocumentElement;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Document
implements Serializable {
    static final boolean debug = false;
    public static final String NPHExt = ".nph";
    protected String fileName;
    protected String title = "";
    protected DocumentElement[] des;
    private Hashtable anchorLocs = new Hashtable();
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class class$NormsTools$DocumentViewer$Document;

    protected void setAnchors() {
        int n = 0;
        while (n < this.des.length) {
            if (this.des[n].getType() == 10) {
                this.anchorLocs.put(this.des[n].getName(), new Integer(n));
            }
            ++n;
        }
    }

    public Document() {
    }

    public Document(DocumentElement[] documentElementArray) {
        this.des = documentElementArray;
        this.setAnchors();
    }

    public static Document getDocument(String string) throws Exception {
        Document document = null;
        if (string.toLowerCase().endsWith(NPHExt)) {
            document = Document.getSerialized(string, true);
        } else {
            Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Document.class$("java.lang.String"))};
            Class<?> clazz = Class.forName("NormsTools.DocumentViewer.HTMLParser");
            Object obj = clazz.newInstance();
            Method method = null;
            try {
                method = clazz.getMethod("parseHTMLFile", classArray);
            }
            catch (Exception exception) {
                System.err.println("getDocument() didn't find method:parseHTMLFile()");
                throw exception;
            }
            try {
                document = (Document)method.invoke(obj, string);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("getDocument() got ite: " + invocationTargetException.getMessage());
                throw invocationTargetException;
            }
            catch (Exception exception) {
                System.err.println("getDocument() got ex:" + exception.getMessage());
                throw exception;
            }
        }
        return document;
    }

    public Point getAnchorLoc(String string) {
        if (this.anchorLocs.containsKey(string)) {
            return (Point)this.anchorLocs.get(string);
        }
        return null;
    }

    protected void setAnchor(String string, Point point) {
        this.anchorLocs.put(string, point);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DocumentElement[] getDocumentElements() {
        return this.des;
    }

    public void serialize(String string) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("serialize ex " + exception);
        }
    }

    protected String[] getLocNames() {
        Enumeration enumeration = this.anchorLocs.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Document getSerialized(String string, boolean bl) throws Exception {
        InputStream inputStream = null;
        try {
            Object object;
            if (bl) {
                object = (class$NormsTools$DocumentViewer$Document != null ? class$NormsTools$DocumentViewer$Document : (class$NormsTools$DocumentViewer$Document = Document.class$("NormsTools.DocumentViewer.Document"))).getResource("/" + string);
                if (object == null) {
                    System.err.println("getSer(): Error getting file: >" + string + "<");
                } else {
                    System.out.println("getSer(): URL is " + object);
                    inputStream = ((URL)object).openStream();
                }
            }
            if (inputStream == null) {
                inputStream = new FileInputStream(string);
            }
            object = new ObjectInputStream(inputStream);
            Document document = (Document)((ObjectInputStream)object).readObject();
            ((ObjectInputStream)object).close();
            return document;
        }
        catch (Exception exception) {
            if (inputStream != null) {
                inputStream.close();
            }
            System.err.println("getSerialized ex " + exception);
            return null;
        }
    }

    protected void setFileName(String string) {
        this.fileName = string;
    }
}

